#include "extend.api"
#include "fm.api"

/*
 *  Listing 1
 *
 *  CLIP.C--
 *
 *     Examples of using C with Clipper.
 *
 *     SUM (nVal1, ..., nValn) --> nTotal
 *       Return the sum of n integers.
 *
 *     REVERSE (cString) --> cString
 *       Reverse a string.
 *
 *     PEEK (nSeg, nOff) --> nValue
 *       Return the byte at address nSeg:nOff.
 *
 *     POKE (nSeg, nOff, nValue) --> nOrigValue
 *       Set the byte at nSeg:nOff to nValue.
 *
 *     LRC (cString) --> nLRC
 *       Simple Longitudinal Redundancy Checksum
 *       of a string which may contain embedded NULLs.
 *
 *
 *     Mark W. Schumann, September 1993
 *     Use freely.
 */

/*
 *
 *   SUM (nVal1, ..., nValn) --> nTotal
 *
 */

CLIPPER sum (void)

{

int pcount = _parinfo (0);
int sum = 0;
int i;

   for (i = 1; i <= pcount; i++)
   {
      sum += _parni (i);
   }

   _retni (sum);

}

/*
 *
 *   REVERSE (cString) --> NIL
 *
 *   Returns string argument, reversed.
 *
 */

CLIPPER reverse (void)

{

char *oldstring;
char *newstring;
int len;
int i;

   len = _parclen (1);
   oldstring = _parc (1);
   newstring = _xgrab (len);

   for (i = 0; i < len; i++)
   {
      newstring [i] = oldstring [len-i-1];
   }

   _retclen (newstring, len);
   _xfree (newstring);

}


/*
 *
 *   PEEK (nSeg, nOff) --> nValue
 *
 *   Returns the byte at nSeg:nOff
 *    without modifying it.
 *
 */

CLIPPER peek (void)

{

unsigned seg;
unsigned off;
unsigned char *p;

    seg = _parni (1);
    off = _parni (2);

    p = (((unsigned long) seg) << 16)
     | ((unsigned long) off);

    _retni ((int) *p);

}


/*
 *
 *   POKE (nSeg, nOff, nValue) --> nOldValue
 *
 *   Sets the byte at nSeg:nOff to nValue,
 *    and returns the previous value.
 *
 */

CLIPPER poke (void)

{

unsigned seg;
unsigned off;
unsigned char newvalue;
unsigned char oldvalue;
unsigned char *p;

    seg = _parni (1);
    off = _parni (2);
    value = _parni (3);

    p = (((unsigned long) seg) << 16)
     | ((unsigned long) off);
    oldvalue = *p;
    *p = newvalue;

    _retni ((int) oldvalue);

}


/*
 *
 *   LRC (cString) --> nLRC
 *
 *   Returns the cumulative XOR of a string parameter.
 *
 */

CLIPPER lrc (void)

{

int len = _parclen (1);
unsigned char *s = _parc (1);
unsigned char sum = 0;

    while (len > 0)
    {
        sum ^= *s++;  /* XOR each byte into */
        len--;        /* the checksum.      */
    }

    _retni ((int) sum);  /* Possibly non-portable  */
                         /* on non-Intel platforms */

}
