/*                               COMP.C
**
** compress.c - File compression a la HUFFMAN
** using Huffman "lists".
*/

#include <bios.h>
#include <stdio.h>
#include <string.h>   /* strrchr() */
#include <errno.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>

#include "config.h"
#include "proto.h"  /* prototypes and #defines */

unsigned int output_fsize;  /* extern in BITS.C */


/********** compress() *************************/

int compress(long file_length) {

	unsigned char c;
	unsigned long i,j;
	unsigned int byte_count, character_count;
	extern signed int user_byte;
	/*  the original byte, global in COMP.C, LIST.C */

	output_fsize = 0;
	byte_count = 0;
	character_count = 0;
	j = 1000;
	i = 0;
	init_bits();
	init_list();


	fwrite(&file_length,sizeof(file_length),1,stdout);
	while ((user_byte = getc(stdin)) != EOF) {

		encode_byte(0, character_count+1, byte_count+1);
		update_list(&byte_count, &character_count);

		i++;
		if (i >=j) {
			fprintf(stderr, "Processed %6lu bytes, "
			  "output filesize is %5u,%3lu %%\n",
			  i,output_fsize,(100LU * output_fsize)/i);
			j+= 1000;
		}
	} /*while */

	flush_bits(); /* send off pending bits */
	fflush(stdout);
	if (ferror(stdout))
	return WRITE_ERR;

	fprintf(stderr,"file size is %5lu\n\n",file_length);
	fprintf(stderr,"output size  %5u\n",output_fsize);
	return 0;
} /*compress()*/

