/*                          BITS.C
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include "config.h"
#include "proto.h"  /* prototypes and #defines */


static unsigned char bit_mask = 0;
static unsigned bit_buffer;
#define BIT_COUNT 8


#ifdef COMPRESS

write_byte (unsigned char c) {
char i;
			for (i= 0; i< BIT_COUNT; i++) {
				write_bit( c > 127 );
				c = c << 1;
			}
}


/****** write_bit(): write bit to file **********/

extern unsigned int output_fsize;

flush_bits() {
char i;
	if (!bit_mask)  write_bit(0);
	/* send off pending full byte */
	else;
	for (i=0; i<BIT_COUNT; i++) write_bit(0);
	/* transmit pending partial byte*/
}

void write_bit (unsigned char bit) {
	if (!bit_mask) {
		putc(bit_buffer,stdout);
		bit_mask = 0x80;
		bit_buffer = 0;
		output_fsize++;
	} else;
	if (bit) bit_buffer |= bit_mask;
	else;
	bit_mask >>= 1;
} /*write_bit */

#else COMPRESS

signed int read_byte (signed int bit) {
signed int byte;
unsigned char i;
int c;
	byte = bit; /* the first bit of ASCII literal */
     /*pick up the remaining 7 bits */
	for (i=1; i<BIT_COUNT; i++)	{
		c = read_bit();
		byte = byte << 1;
		byte = byte | c;
	}
return byte;
}


/******** read_bit():  read bit from file *********/

static int ch = 0;
int read_bit () {
	bit_mask >>= 1 ;
	if (!bit_mask) {
		ch = getc(stdin);
		if (ch == EOF) return EOF;
		else bit_mask = 0x80;
	}
	return ( (ch & bit_mask) > 0);
}


#endif COMPRESS

/************** init_bits() ********************/

init_bits() {
#ifdef COMPRESS
	bit_mask = 0x80;  /* binary 1000 0000*/
#else
	bit_mask = 0;
	ch = 0;  /* getc returns signed int */
#endif
	bit_buffer = 0;
}
