/*
** Astrolog (Version 4.00) File: xdata.c
**
** IMPORTANT NOTICE: the graphics database and chart display routines
** used in this program are Copyright (C) 1991-1993 by Walter D. Pullen
** (cruiser1@stein.u.washington.edu). Permission is granted to freely
** use and distribute these routines provided one doesn't sell,
** restrict, or profit from them in any way. Modification is allowed
** provided these notices remain with any altered or edited versions of
** the program.
**
** The main planetary calculation routines used in this program have
** been Copyrighted and the core of this program is basically a
** conversion to C of the routines created by James Neely as listed in
** Michael Erlewine's 'Manual of Computer Programming for Astrologers',
** available from Matrix Software. The copyright gives us permission to
** use the routines for personal use but not to sell them or profit from
** them in any way.
**
** The PostScript code within the core graphics routines are programmed
** and Copyright (C) 1992-1993 by Brian D. Willoughby
** (brianw@sounds.wa.com). Conditions are identical to those above.
**
** The extended accurate ephemeris databases and formulas are from the
** calculation routines in the program "Placalc" and are programmed and
** Copyright (C) 1989,1991,1993 by Astrodienst AG and Alois Treindl
** (alois@azur.ch). The use of that source code is subject to
** regulations made by Astrodienst Zurich, and the code is not in the
** public domain. This copyright notice must not be changed or removed
** by any user of this program.
**
** Initial programming 8/28,30, 9/10,13,16,20,23, 10/3,6,7, 11/7,10,21/1991.
** X Window graphics initially programmed 10/23-29/1991.
** PostScript graphics initially programmed 11/29-30/1992.
** Last code change made 12/31/1993.
*/

#include "astrolog.h"

#ifdef GRAPH

/*
******************************************************************************
** Graphics Global Variables.
******************************************************************************
*/

bitmap bm;                     /* Pointer to allocated memory.               */
int bitmaprow;                 /* Horizontal size of bitmap array in memory. */
word PTR metacur;              /* Current mem position when making metafile. */
char modex = MODEv;            /* Current type of chart to create.   */
char bitmapmode = BITMAPMODE;  /* Current bitmap file type (-Xb).    */
char *outputfile = NULL;       /* Current name of bitmap file (-Xo). */
char *dispname = NULL;         /* Current X11 display name (-Xd).    */
circlestruct PTR circ = NULL;  /* Table of sine and cosine values.   */

int xfile;
#ifdef ISG
int xbitmap = FALSE;   /* Are we creating a bitmap file (-Xb set). */
#else
int xbitmap = TRUE;
#endif
int psfile   = FALSE;  /* Are we generating a PostScript file (-Xp set).   */
int metafile = FALSE;  /* Are we generating a metafile graphic (-XM set).  */
int xmono    = FALSE;  /* Is this a monochrome monitor.                    */
int xcolor   = TRUE;   /* Are we drawing a color chart (-Xm not set).      */
int xreverse = FALSE;  /* Are we drawing in reverse video (-Xr set).       */
int xroot    = FALSE;  /* Are we drawing on the X11 background (-XB set).  */
int xtext    = TRUE;   /* Are we printing chart info on chart (-XT set).   */
int xfont    = TRUE;   /* Are we simulating fonts in charts (-XM0 set).    */
int xbonus   = FALSE;  /* Are we drawing in alternate mode (-Xi set).      */
int xlabel   = TRUE;   /* Are we labeling objects in charts (-Xl not set). */
int xborder  = TRUE;   /* Are we drawing borders around charts.            */

int xnow = 0;                  /* Current animation mode. (-Xn).            */
int xeast = 0;                 /* Current object to place on Asc (-X1).     */
int scale = 200;               /* Current character scale factor (-Xs).     */
int textrows = 0;              /* Numb. of rows to set text screen to (-V). */
int gridobjects = OBJECTS;     /* Number of cells in -g graphic grids.      */
int metawid = 10;              /* Pen width to use when creating metafiles. */
int offsetx = 0, offsety = 0;  /* Viewport origin.                          */
int turtlex = 0, turtley = 0;  /* Current coordinates of pen.               */
int chartx = DEFAULTX, charty = DEFAULTY; /* Current size of graphic chart. */
int degree = 0;                /* Current rotation of globe.                */
real tilt = 0.0;               /* Current vertical tilt of rotating globe.  */
int scalet;                    /* Relative scale to draw chart text at.     */

/* Color tables for Astrolog's graphic palette. */

colrgb rgbbmp[] = {
  0x000000, 0x00007F, 0x007F00, 0x007F7F,
  0x7F0000, 0x7F007F, 0x7F7F00, 0xBFBFBF,
  0x7F7F7F, 0x0000FF, 0x00FF00, 0x00FFFF,
  0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF};
#ifdef MSG
colrgb rgb[] = {
  _BLACK, _RED, _GREEN, _BROWN,
  _BLUE, _MAGENTA, _CYAN, _WHITE,
  _GRAY, _LIGHTRED, _LIGHTGREEN, _YELLOW,
  _LIGHTBLUE, _LIGHTMAGENTA, _LIGHTCYAN, _BRIGHTWHITE};
#endif
#ifdef X11
char *rgbname[] = {
  "black", "orangered3", "green4", "darkorange2",
  "blue4", "violet", "cyan4", "grey65",
  "grey35", "orangered1", "green1", "yellow1",
  "blue1", "pink", "cyan1", "white"};
colrgb rgbind[16];
#endif

/* These are the actual color arrays and variables used by the program.      */
/* Technically, Astrolog always assumes we are drawning on a color terminal; */
/* for B/W graphics, all the values below are filled with black or white.    */

colrgb fg, bg;
colpal colcur = -1, metafillcol = -1, on, off, hilite, gray,
  maincolor[6+1], rainbowcolor[7+1],
  elemcolor[4], aspectcolor[ASPECTS+1], objectcolor[TOTAL+1];

/* A bunch of physical X window variables dealing with the window itself. */

#ifdef X11
Colormap cmap;
Display *disp;
GC gc, pmgc;
KeySym key;
Pixmap pixmap, icon;
Window window, root;
XSizeHints hint;
#if FALSE
XWMHints *wmhint;
#endif
int screen, depth;
char xkey[10];
#endif


/*
******************************************************************************
** Astrolog Icon.
******************************************************************************
*/

#ifdef X11
/* This information used to define Astrolog's X icon (Rainbow over Third */
/* Eye) is identical to the output format used by the bitmap program.    */
/* You could extract this section and run xsetroot -bitmap on it.        */

#define icon_width 63
#define icon_height 32
/*static*/ char icon_bits[] = {
 0x00,0x00,0x00,0xa8,0x0a,0x00,0x00,0x00,0x00,0x00,0x40,0x55,0x55,0x01,0x00,
 0x00,0x00,0x00,0xa8,0xaa,0xaa,0x0a,0x00,0x00,0x00,0x00,0x54,0xf5,0x57,0x15,
 0x00,0x00,0x00,0x80,0xaa,0xaa,0xaa,0xaa,0x00,0x00,0x00,0x40,0xd5,0xff,0xff,
 0x55,0x01,0x00,0x00,0xa0,0xaa,0xaa,0xaa,0xaa,0x02,0x00,0x00,0x50,0xfd,0xff,
 0xff,0x5f,0x05,0x00,0x00,0xa8,0xaa,0x2a,0xaa,0xaa,0x0a,0x00,0x00,0xd4,0xff,
 0xaf,0xfa,0xff,0x15,0x00,0x00,0xaa,0x2a,0x00,0x00,0xaa,0x2a,0x00,0x00,0xf5,
 0xbf,0xaa,0xaa,0xfe,0x57,0x00,0x80,0xaa,0x02,0x00,0x00,0xa0,0xaa,0x00,0x40,
 0xfd,0xab,0xfa,0xaf,0xea,0x5f,0x01,0xa0,0xaa,0x80,0xff,0xff,0x80,0xaa,0x02,
 0x50,0xff,0xea,0xff,0xff,0xab,0x7f,0x05,0xa0,0x2a,0xf0,0xff,0xff,0x07,0xaa,
 0x02,0xd0,0xbf,0xfa,0x0f,0xf8,0xaf,0x7e,0x05,0xa8,0x0a,0xfc,0x01,0xc0,0x1f,
 0xa8,0x0a,0xd4,0xaf,0x7e,0x00,0x00,0xbf,0xfa,0x15,0xa8,0x0a,0x3f,0x00,0x00,
 0x7e,0xa8,0x0a,0xf4,0xaf,0x1f,0xe0,0x03,0xfc,0xfa,0x15,0xaa,0x82,0x0f,0xdc,
 0x1d,0xf8,0xa0,0x2a,0xf4,0xab,0x07,0x23,0x62,0xf0,0xea,0x17,0xaa,0xc2,0x87,
 0x91,0xc4,0xf0,0xa1,0x2a,0xf4,0xeb,0xc3,0xd0,0x85,0xe1,0xeb,0x17,0xaa,0xe0,
 0x83,0x91,0xc4,0xe0,0x83,0x2a,0xf5,0xeb,0x03,0x23,0x62,0xe0,0xeb,0x57,0xaa,
 0xe0,0x01,0xdc,0x1d,0xc0,0x83,0x2a,0xf5,0xeb,0x01,0xe0,0x03,0xc0,0xeb,0x57,
 0xaa,0xe0,0x01,0x00,0x00,0xc0,0x83,0x2a,0xfd,0xeb,0x01,0x00,0x00,0xc0,0xeb,
 0x5f};
#endif


/*
******************************************************************************
** Graphics Table Data.
******************************************************************************
*/

char *signdraw[] = {"",
  "ND4HU2HLGDFBR6EUHLGD2G",                /* Aries       */
  "BL3D2F2R2E2U2H2NE2L2NH2G2",             /* Taurus      */
  "BLU3LHBR7GLNL3D6NL3RFBL7ERU3",          /* Gemini      */
  "BGNDHLGDFRNEFR2EREBU3NHDGLHUENRHL2GLG", /* Cancer      */
  "BF4H2UEU2H2L2G2D2FDGH",                 /* Leo         */
  "BF4BLHNGNHEU5GHND5HGND6HGND6H",         /* Virgo       */
  "BGNL3HUER2FDGR3BD2L8",                  /* Libra       */
  "BH4FND6EFND6EFD6FREU",                  /* Scorpio     */
  "BG4E3NH2NF2E5NL2D2",                    /* Sagittarius */
  "BH3NLNUD3FND2EU2ENF2UFERFDGLF2D2G",     /* Capricorn   */
  "BG4EUEDFDEUEDFDEUEBU5GDGUHUGDGUHUGDG",  /* Aquarius    */
  "NL4NR4BH4F2D4G2BR8H2U4E2"};             /* Pisces      */

char *objectdraw[] = {
  "ND4NL4NR4U4LGLDGD2FDRFR2ERUEU2HULHL",    /* Earth   */
  "U0BH3DGD2FDRFR2ERUEU2HULHL2GL",          /* Sun     */
  "BG3E2U2H2ER2FRDFD2GDLGL2H",              /* Moon    */
  "BD4UNL2NR2U2REU2HNEL2NHGD2FR",           /* Mercury */
  "LHU2ER2FD2GLD2NL2NR2D2",                 /* Venus   */
  "HLG2DF2RE2UHE4ND2L2",                    /* Mars    */
  "BH3RFDGDGDR5NDNR2U6E",                   /* Jupiter */
  "BH3R2NUNR2D3ND3RERFDGDF",                /* Saturn  */
  "BD4NEHURBFULU3NUNR2L2NU2DGBU5NFBR6GD3F", /* Uranus  */
  "BD4U2NL2NR2U5NUNRLBL2NUNLDF2R2E2UNRU",   /* Neptune */
  "D2NL2NR2D2BU8GFEHBL3D2F2R2E2U2",         /* Pluto   */
  "BG2LDFEULU3NURFRFBU5GLGLU2",             /* Chiron          */
  "BD4UNL3NR3U2RE2UH2L2G",                  /* Ceres           */
  "BD4UNL3NR3UE2HUHNUGDGF2",                /* Pallas Athena   */
  "BD4UNL2NR2U4NL4NR4NE3NF3NG3NH3U3",       /* Juno            */
  "BU4DBG3NLFDF2E2UERBH2GDGHUH",            /* Vesta           */
  "BG2LGFEU2HU2E2R2F2D2GD2FEHL",            /* North Node      */
  "NE2NF2NG2H2GD2F2R2E2U2H2L2G",            /* Part of Fortune */
  "BG4U8F2ND6E2D8BR4NUL2U5R2D",             /* Midheaven */
  "BG4U4NR2U3EFD7BR2NURU2HU2RDBR3ULD5RU",   /* Ascendant */
  "U2NHNEBD4NGNFU2L2NHNGR4NEF",             /* Vertex    */
  "BH3ED8NLRBR2RNRU8G",                     /* 11th Cusp */
  "BG4RNRU8GBR4ER2FD2GLG2D2R4",             /* 12th Cusp */
  "BH3ER4FD2GLGLG2DR6",                     /* 2nd Cusp  */
  "BH3ER4FD2GNL3FD2GL4H",                   /* 3rd Cusp  */
  "BH4BRFDG2DR8BG3UNL2NR2U5LUEFDL",         /* Cupido    */
  "BENUNL2NR2D3ND2NR2L2H2U2E2R4",           /* Hades     */
  "BU4NG2NF2D7NDBLHLBR6LGL2GLBR6LHL",       /* Zeus      */
  "BU2D3ND3NR2L2BH2UE2R4F2D",               /* Kronos    */
  "U3NLR2NRD3NL2NR2D4NRL2NLU4L4UEUH",       /* Apollon   */
  "BUNU2NL2NR2D2ND3LHU2ENHR2NEFD2GL",       /* Admetos   */
  "G2DGR6HUH2U4NG2F2",                      /* Vulcanus  */
  "ND4U4BL3DF2R2E2UBD8UH2L2G2D"};           /* Poseidon  */

char *housedraw[] = {"",
  "BD2NLNRU4L", "BHBUR2D2L2D2R2", "BHBUR2D2NL2D2L2",
  "BHBUD2R2NU2D2", "BEBUL2D2R2D2L2", "NLRD2L2U4R2",
  "BHBUR2DG2D", "NRLU2R2D4L2U2", "NRLU2R2D4L2",
  "BH2NLD4NLRBR2U4R2D4L2", "BH2NLD4NLRBR2RNRU4L", "BH2NLD4NLRBR2NR2U2R2U2L2"};

char *aspectdraw[] = {"",
  "HLG2DF2RE2UHE4",              /* Conjunction      */
  "BGL2GDFREU2E2U2ERFDGL2",      /* Opposition       */
  "BH4R8D8L8U8",                 /* Square           */
  "BU4GDGDGDGDR8UHUHUHUH",       /* Trine            */
  "BLNH3NG3RNU4ND4RNE3F3",       /* Sextile          */
  "BG4EUEUEUEUNL4NR4BDFDFDFDF",  /* Inconjunct       */
  "BH4FDFDFDFDNL4NR4BUEUEUEUE",  /* Semisextile      */
  "BE4G8R8",                     /* Semisquare       */
  "BD2L3U6R6D6L3D2R2",           /* Sesquiquadrature */
  "F4BU3U2HULHL2GLDGD2FDRFR2E3", /* Quintile         */
  "BD2U3NR3NU3L3BD5R6",          /* Biquintile       */
  "BU2D3NR3ND3L3BU5R6",          /* Semiquintile     */
  "BH3R6G6",                               /* Septile      */
  "BR3L5HUER4FD4GL4H",                     /* Novile       */
  "BF2UHL2GFR3DGL3BE6LNLU2NRLBL4LNLD2NLR", /* Binovile     */
  "BL2R4G4BE6LNLU2NRLBL4LNLD2NLR",         /* Biseptile    */
  "BL2R4G4BE6L7NLU2NLR3ND2R3ND2R",         /* Triseptile   */
  "BF2UHL2GFR3DGL3BU6LNLU2NLRBR2F2E2"};    /* Quatronovile */

char *asciidraw[] = {"",
  "BR2D4BD2D0", "BRD2BR2U2", "BD2R4BD2L4BFU4BR2D4", "BR2D6BENL3EHL2HER3",
  "RDLNUBR4G4BR4DLUR", "BD2NF4UEFDG2DFRE2", "BR2DG", "BR3G2D2F2", "BRF2D2G2",
  "BD2FNGRNU2ND2RNEF", "BD3R2NU2ND2R2", "BD5BR2DG", "BD3R4", "BD6BRRULD",
  "BD5E4", /* Special Characters */

  "BDD4NE4FR2EU4HL2G", "BFED6NLR", "BDER2FDG4R4", "BDER2FDGNLFDGL2H",
  "D3R3NU3ND3R", "NR4D3R3FDGL2H", "BR3NFL2GD4FR2EUHL3", "R4DG4D",
  "BDDFNR2GDFR2EUHEUHL2G", "BD5FR2EU4HL2GDFR3", /* Numbers */

  "BR2BD2D0BD2D0", "BR2BD2D0BD2G", "BR3G3F3", "BD2R4BD2L4", "BRF3G3",
  "BDER2FDGLDBD2D0", "BF2DFEU2HL2GD4FR2", /* Special Characters */

  "BD6U4E2F2D2NL4D2", "D6R3EUHNL3EUHL3", "BR3NFL2GD4FR2E", "D6R2E2U2H2L2",
  "NR4D3NR3D3R4", "NR4D3NR3D3", "BR3NFL2GD4FR2EU2L2", "D3ND3R4NU3D3",
  "BRRNRD6NLR", "BD4DFR2EU5", "D3ND3RNE3F3", "D6R4", "ND6F2NDE2D6",
  "ND6F4ND2U4", "BDD4FR2EU4HL2G", "R3FDGL3NU3D3", "BDD4FRENHNFEU3HL2G",
  "ND6R3FDGL2NLF3", "BR3NFL2GDFR2FDGL2H", "R2NR2D6", "D5FR2EU5",
  "D2FDFNDEUEU2", "D6E2NUF2U6", "DF4DBL4UE4U", "D2FRND3REU2",
  "R4DG4DR4", /* Upper Case Letters */

  "BR3L2D6R2", "BDF4", "BRR2D6L2", "BD2E2F2", "BD6R4", "BR2DF", /* Symbols */
  "BF4G2LHU2ER2FD3", "D5NDFR2EU2HL2G", "BF4BUHL2GD2FR2E", "BR4D5NDGL2HU2ER2F",
  "BF4NL4UHL2GD2FR3", "BD3RNR3ND3U2ERF", "BD8R3EU4HL2GD2FR2E", "D3ND3ER2FD3",
  "BR2D0BD2D4", "BR2D0BD2D5GLH", "D4ND2REREBD4HLH", "BR2D6", "BD2DND3EFNDEFD3",
  "BD2DND3ER2FD3", "BD3D2FR2EU2HL2G", "BD2DND5ER2FD2GL2H",
  "BR4BD8U5HL2GD2FR2E", "BD2DND3ER2F", "BD6R3EHL2HER3", "BR2D2NL2NR2D4",
  "BD2D3FRE2NU2D2", "BD2DFDFEUEU", "BD2D3FENUFEU3", "BD2F2NG2NE2F2",
  "BD2D3FR2ENU3D2GL3", "BD2R4G4R4", /* Lower Case Letters */

  "BR3GDGFDF", "BR2D2BD2D2", "BRFDFGDG", "BFEFE", "BD6R4"}; /* Symbols */

char *worlddata[] = {
"-031+70",
"LLRRHLLLLDULLGLLLDULGLLLGLRREDEGGLGGLGLGLLGDRLDRLFFRRERFDFRRREUEEHLUERERUERRF\
GLGLDDFRRRRREFRLGLLLLLGEFDLHGDDLGHLGLLHGLHURDLRRELLLRHUGLDFDLGLLFHGGLGLLLDLLLD\
RRFFDDGLLLLLLGDFGDDRRFRERREEUEREUEFRRERRFFFRFRDDLLLLRFRUREURULHLHHHEF",
"5EUROPE",
"+006+50", "RRERRRRUELLUHHLLREULLELLDGHDUFDEGRDRRLFDLLRGRRGGL", "5ENGLAND",
"+008+55", "GLFGRRREUULL", "5IRELAND",
"+023+64", "RRFRERRREHLLLLLGHLLRFLLRFL", "5ICELAND",
"-011+80", "DDURFRERLGRRLLFRRREEFRRRLHGELLLHRRFRRRRERLLLLLLLLLLLDHGULLL",
"5SVALBARD",
"-014+45",
"FRFRFDDFRDRRLLFRURFHHUERRRRRHUUEERRRRGRDERRLHLRRERRGGRFRFFGLLLLHLLLLGLLDLLLFG\
RFFRERFRERDDDGDGLLDFFEUDDFFDFFDDFFFDFDDDRRERRERRRUERRERURUEEHHLHUGGLLLUUGUHUHU\
RRFFRFRRRDRRFRRRRRRRF",
"5MIDDLE EAST",
"-009+41", "DDRUULEUGD", "5SARDINIA",
"-024+35", "RRLL", "5CRETE",
"-032+35", "RRLL", "5CYPRUS",
"-052+37", "LLHUURHUHUHERERRRDDLLLFFDDURFLLDFDDL", "0CASPAIN SEA",
"-060+44", "LLUEERDFLDL", "0ARAL SEA",
"-068+24",
"FRGFRREDDDDDFDFDDFDDFERUEUUUUEEEEEREURRREFDFRDDDDRREFDDFDDGDDRFDDFDFFRUHUUHHH\
ULUEUUURDRFDFRDEEREUUUHHHUUEERRDDEURRERREREEEUEULLREUHUHLEERRHLGLULUREERDLDRER\
RFGRFDGRRREUHHUREUE",
"6ASIA S",
"-140+36",
"DEUUEUHURREREEGLLHHDDGLDRGDDGGLGLLLGGLDLRDFEUHRRGEERDLLRGLRERRERRE",
"6JAPAN",
"-121+25", "GDFUEUL", "6TAIWAN",
"-080+10", "DDDDREUHH", "6SRI LANKA",
"-121+18", "LDDDRDDRHRRFFDDDLLEHDULRHDFDDGERDDREUUULUUHHLHEUUL",
"2PHILIPPINES",
"-131+43",
"EFREEREEEUUUEUHLLUDLULEERERERRRRRRERRFLRRRRLUERERRRDRERURRGDLGLGLGLGGDDFDFEUR\
RUERUURULEEREDERRFRERERRRERRHLHLRRRREURDRRFRFRUURRHLLLDHHLLHLLHLLLLLLLDLLHRLLL\
LLLLGHULLLLLLLLLLULLLGL",
"6SIBERIA",
"-145+71",
"RELLRHLLLLGDHGHLLLLGLLHUHLLLLLDLLLLHLLLLLDULUDLGLLLLRRERERRRELHLLLLLLLELLLLGD\
LLLLLUDLLLLLGLLLDLLLLLLLDFRDDHELLLLLLDRRLLHUDLGFGRRRRFRLHLLDGLGLLHRRREUHUUULLG\
GLDRFGHLLLHLLLLRFGHLGLLLULGLLLGLLHRHLDDDLLLLDLLLFLLHUHLRRFRRRREHLLHLLLHLL",
"6RUSSIA",
"-143+54", "GDDDDDDDEDUUURUUHUU", "6SAKHALIN",
"-180+72", "GRRRRULLL", "6WRANGEL I.",
"-137+76", "DRRRRRRRELLLLLLLL", "6SIBERIAN I.",
"-091+80", "FERDRRRRRRULLLLLRRULLLLGL", "6SEVERNAYA",
"-101+79", "GRRRRELLLL", "6ZEMLYA",
"-068+77", "LLGLLLLLLGLLGGLGLRFRRRRLHERERERRRERRRREL", "6NOVAYA",
"+123+49",
"FGULLFDDDGFDDDFFDFRFRFDFFFDLFFRDFFEHHHHUHHUFRDFFFRDFFFDFGFRFRFRRFRRRRFFRRFRFF\
DRFFRFEUUGLHHUUEUHLLLLLEUUEULLLGDLLGLHHUHUUUEHEERERRFRRHRREFRRFDFDFEUUHUUUEERE\
RUUUHFDEUHFEURRRELUERRE",
"4NORTH AMERICA S",
"+113+42", "FH", "0SALT LAKE",
"+156+20", "DRULHLHL", "4HAWAII",
"+085+22", "RERFRRFRGRRRRHLHLHLLLLLG", "4CUBA",
"+070+18", "RRHHLLLFLLLFRRRRRR", "4HAITI",
"+078+18", "RRHLLF", "4JAMAICA",
"+066+18", "ELLDR", "4PUERTO RICO",
"+078+24", "UD", "4NASSAU",
"+067+45",
"REFLGDERERREHDLLLHUELLLGLGLREEERRRRRRREERRGGDGRRRFEFUUHLLLEUUHHGLRELLHHUHHHDG\
LGHHULLHLLLLLDFGFDDGLLFDDGHHUULLLLHLLHLLLUHUUEREEREERRRREUUHLLLDDGHULLLHLUHLGD\
RFGGULLLLLLLLLHLLGFLHLLLLLRHLLLLLHLLLLLLHGLLLLGUGLLLHLL",
"4CANADA",
"+088+49",
"LGLGRRRRRRRFLLLGRGDDREUURUFRGRFGFERERREEREERLGGLGLLLGRLLGLEUERHLLLHULHL",
"0GREAT LAKES",
"+117+61", "REHRFRRERGLGLLLL", "0SLAVE LAKE",
"+125+66", "RRERRRGREDLFHGLLLERLLLL", "0BEAR LAKE",
"+097+50", "UULHURFDFG", "0LAKE WINNIPEG",
"+090+72",
"FRRLLFRRRRRRRRRRFRRGLLGRREEFRFLGLFLLLLFRERFRFRRFRRHLHFRRRUHLHRRFRURELLHLLLHRR\
HLHLHGHLHLLGLLEHFRRRHLLLLLLGLDFHLUELLGG",
"4BAFFIN I.",
"+125+72",
"RFRREERRRLLGFFRRRRRLLLLLFRRRRRRRREFRRRRHRRLHLHHLRRULGLFLHLDLLULLLLHLLLLLLLDG",
"4VICTORIA I.",
"+141+70",
"LLLLLLLLHGLHLLLHGLLGLLGLLDRRFRRDLLLULGLLFRRRRRRDLGLLGFDRRRDRRRRRGGGLLGLLGGLLR\
RERERRRERREERRELEERRRLLGDRERRURRFRRRRRFRRFUDRUDDHFDURDURLURDDLFRULURDHFFRGFEGR\
FFRFRFLHLHLFFRFE",
"4ALASKA",
"+045+60",
"REUEREUERRRRERERRRERRRRERLLLLLLHRRRGERHFRRRRHLUDLLHLRERFRERLEUHRRHLEERLLURRRR\
RRRRELLLLLLLLLLGLLLRERHGLRELLLLLLLELLLLLLLLLLGLLLLLLGLLLLLLGLULLLLLLLFRLLLLLGL\
RRRGLLLLLLLGRRRRRRRGLLLLRRFRRRRRRRRRRFDFDLFREFRDLLLDERRFGLLGFFDRFFFRRRF",
"4GREENLAND",
"+080+10",
"DRFDFDDGGGDDGRDGDDFFDFDFFDFFRFFFDDDDDDGDDDDGDDDDGDGFGDDDEUDDDGUDDLDRGDDDFDFRF\
RRFERRLHLUHUURUEELHEREURULURREURREREUHUUDFRREEEEEUEUUEERERRREUEUEUUUUUEEEEUUUH\
LHLHLLLLHLHLGEHLGEUHUUHLHLLLHHLHULEDLLELLGHLLHLGDDHUELLGLGDGHHL",
"3SOUTH AMERICA",
"+060-51", "LDRRELL", "3FALKLAND ISLANDS",
"+092+00", "FUL", "3GALAPAGOS I.",
"-032+32",
"LLGLHLLLLHLGDGHLLHHLLHLEUULLLLLLLLLGLGLLLLHDGLGDGDGGLDGGGDGDFDDDDGDDFFFFDFRFF\
RRRRRRRRERERRFFRRFFDDDGDFFFDFDDDFDGDGDDDFDFDFDDDFDFDFDDFFERRRRREEEEEEEUUEREUUH\
UEEEREEUUUUHUUUHUEUEEEEEREEUEUEEUUULLLLGLLHUHHLHUHHUUHHUUHUHHUU",
"1AFRICA",
"-049-12", "DGGGLGDDDDGDDFFREUEUEUUUEUUUUH", "1MADAGASCAR",
"-032+00", "DDDREUELLL", "0LAKE VICTORIA",
"-014+14", "LRFLU", "0LAKE CHAD",
"-124-16",
"LGDGGLGLLGLDDDGFDDFDFDGFRRRERRRRURERRRRRRRFFFEEDDRFDFRFREFRERRUUEUEEUUUUUUUHH\
HHHHHUUHHHUULDDDDGDGHLHLHEUELLLHLFLLULDRGDDLLHLGG",
"2AUSTRALIA",
"-173-35", "FFDGFDREURULHHHL", "2NEW ZEALAND N",
"-174-41", "LLDGLGLGGRFREEUREEU", "2NEW ZEALAND S",
"-145-41", "DFRRUUUDLLL", "2TASMANIA",
"-178-17", "GRRURUGDH", "2FIJI",
"-130+00", "FRFRLGFEFRFRFDGRRFRRUERFFFRRRLHHHHRHLHHLHLLHGGLHUHLGH",
"2NEW GUINEA",
"-115-04", "RUUEEURHUUEHHGGGGLLDDHLDDFDDRRDERF", "2BORNEO",
"-095+06", "DFFFFFFDFFFFRUUUHFRHLHLUHHHHHLLH", "2SUMATRA",
"-106-06", "GRFRRRRRRFRRHLHLLLLLHL", "2JAVA",
"-120+00", "DGDDRDFHUEDFRHUHREFHLGHURRRRELLLLG", "2CELEBES",
"+000-70",
"ULDLLLLLLLLGLLGLLLGLLGLLLLGLGLLGLLLLGLLLLLHLGLLLLLHLLLLLHLLLLHLLUERLEUUUUUUEE\
RRRULLGLLLLGLGGLLLDRUDRDLGHLLGLLFGRRFLLLLLLLDHLLLLHLLLLLGLLLLHLLLLLLLGRFDLLLUL\
LLGHLLLLLLLLLLHGHLLGLLLLLLLGLLLLLLLLLLLGLLLGLLLLLLLLGLLLLLLLLLLLLLLLLLLLLL",
"7ANTARCTICA W",
"+180-78",
"LLLLLLLHLLGHLLGHLUEERRERREHLLLLHLLLLLLHLLLLLLLLLLLHLHLLLLLHLLULDLLLLLDLLHLLLL\
GHFLLLLLHLLLLLLGLHLLHLGLLLLHLGLLGLLLULLLGLLHDFLLLGLGLLLELLLLHLLLLLLLLLLHLLLHLL\
LLGGHGHGLLLGLDLLLLHLLGHGLLLLLLLLLLLLLLHLGLLLLLLLLLLLLLL",
"7ANTARCTICA E",
"", "", ""};
#endif /* GRAPH */

/* xdata.c */
