* A procedure that uses the browse object to set the file pointer on
* a selected record
* nT=Top of browse box, nL=Left edge of browse box, nB=bottom of browse
* box, aFields=an array of fields to include in the browse, cCol=color
* string

PROCEDURE ObjLook(nT,nL,nB,aFields,cPrompt,cCol)  //A scrollable search using TBrowse

  // Declare some variables
  LOCAL nKey,oCol,oB,cScrn,nR2,cField,i,nR,cOCol
  LOCAL lCont:=.T.
  LOCAL cSearch:=' '

  //Set some default values
  //Clipper 5.0 does not have the DEFAULT command so SetVal is my
  //equivelant, so for you I comment this section out However, it works
  //very much like an IF()
*  nT=SetVal(nT,10)  //Setval() is in REC.LIB ie. my own library
*  nL=SetVal(nL,nT)
*  nB=SetVal(nB,20)
*  aFields=SetVal(aFields,FldSet())
*  cPrompt=SetVal(cPrompt,'Enter the search value:')
*  cCol=SetVal(cCol,SetColor())

  //Define the right edge of the browse box
  nR:=nL+2
  FOR i=1 TO Len(aFields)
    cField=aFields[i]
    nR=nR+Max(Len(&cField),Len(cField)) //Make nR far enough over to handle all fields
  NEXT
  nR2=Max(nR+2,nL+Len(cPrompt)+10)  //Set right margin to greater of prompt or fields
  nR2=IF(nR2>77,77,nR2) //But don't let it go off the screen

  // Save the screen and set the colors
  cOCol=SetColor(cCol)
  cScrn=SaveScreen(nT-2,nL-1,nB+1,nR2)
  @nT-2,nL-1 CLEAR TO nB+1,nR2
  WinShade(nT-1,nL-1,nB+1,nR2,'ON')

  //Create browse objects
  oB:=TBrowseDB(nT,nL,nB,nR)
  FOR i=1 TO Len(aFields)
    oCol:=TBColumnNew(aFields[i],FieldBlock(aFields[i]))
    oB:addColumn(oCol)
  NEXT

  //Draw screen and browse objects
  @nT-2,nL SAY cPrompt
  @nT-2,nL+Len(cPrompt) SAY Space(Len(aFields[1])) COLOR 'W/W'
  DO WHILE lCont
    nKey := 0
    DO WHILE nKey==0.AND..NOT.oB:stable
      oB:stabilize()
      nKey:=InKey()
    ENDDO
    IF oB:stable
      IF oB:hitTop.OR.oB:hitBottom
        Tone(125,0)
      ENDIF
      nKey=InKey(0)
    ENDIF
    IF nKey==K_ESC
      cSearch=' '
      lCont=.F.

    //Key control case for browse
    ELSE
      DO CASE
        CASE nKey==K_DOWN
          oB:down()
        CASE nKey==K_PGDN
          oB:pagedown()
        CASE nKey==K_UP
          oB:up()
        CASE nKey==K_PGUP
          oB:pageUp()
        CASE nKey==K_RIGHT
          oB:right()
        CASE nKey==K_LEFT
          oB:left()
        CASE nKey==K_HOME
          oB:home()
        CASE nKey==K_END
          oB:end()
        CASE nKey==K_RETURN
          cSearch=' '
          lCont=.F.
        //Input alpha characters
        CASE(nKey>64.AND.nKey<91).OR.(nKey>96.AND.nKey<123).OR.(nKey>47.AND.nKey<58).OR.(nKey==32)
          IF Len(cSearch)<nR2-(nL+Len(cPrompt))
            cSearch=cSearch+Chr(nKey)
            @nT-2,nL+Len(cPrompt) SAY cSearch COLOR 'N/W'
            Seek Right(cSearch,Len(cSearch)-1)
            oB:refreshAll()
          ENDIF
        //Backspace over alpha character input
        CASE nKey==K_BS
          IF Len(cSearch)>1
            cSearch=Left(cSearch,Len(cSearch)-1)
            IF Len(cSearch)>1
              @nT-2,nL+Len(cPrompt) SAY cSearch COLOR 'N/W'
              Seek Right(cSearch,Len(cSearch)-1)
            ELSE
              GO TOP
            ENDIF
          ENDIF
          @nT-2,nL+Len(cPrompt) SAY Space(Len(cSearch)+1) COLOR 'W/W'
          @nT-2,nL+Len(cPrompt) SAY cSearch COLOR 'N/W'
          oB:refreshAll()
      ENDCASE
    ENDIF
  ENDDO
  Winshade(nT-1,nL-1,nB+1,nR2,'OFF')
  RestScreen(nT-2,nL-1,nB+1,nR2,cScrn)
RETURN