'---------------------------------------------------------------------------
' Global variables

Global MDM$, STK$, UID$, PWD$, PHO$, CNS$
Global DYS As Integer
Global PortID As Integer
Global PortName As String
Global NL As String
Const QUO = """"

'---------------------------------------------------------------------------
' Global constants (will be replaced with arguments)

Const FIL = "C:\STOX.TXT"     ' Output file for session if debugging
Const DBG = 0                 ' 0 = just run, 1 = write to file

'---------------------------------------------------------------------------
' DCB definition

Type dcb
    Id As String * 1
    baudrate As Integer
    bytesize As String * 1
    Parity As String * 1
    stopbits As String * 1
    rlstimeout As Integer
    ctstimeout As Integer
    dsrtimeout As Integer

    bits1 As String * 1 ' The fifteen actual DCB bit-sized data fields
    bits2 As String * 1 ' within these two bytes can be manipulated by
              ' bitwise logical And/Or operations.  Refer to
              ' SDKWIN.HLP for location/meaning of specific bits

    XonChar As String * 1
    XoffChar As String * 1
    XonLim As Integer
    XoffLim As Integer
    PeChar As String * 1
    EofChar As String * 1
    EvtChar As String * 1
    TxDelay As Integer
End Type

Type COMSTAT
    Bits As String * 1
    cbInQue As Integer
    cbOutQue As Integer
End Type

'---------------------------------------------------------------------------
' EscapeCommFunction constants

Const SETXOFF = 1
Const SETXON = 2
Const SETRTS = 3
Const CLRRTS = 4
Const SETDTR = 5
Const CLRDTR = 6

'---------------------------------------------------------------------------
' Error flags

Const CE_RXOVER = &h1    '  Receive Queue overflow
Const CE_OVERRUN = &h2   '  Receive Overrun Error
Const CE_RXPARITY = &h4  '  Receive Parity Error
Const CE_FRAME = &h8     '  Receive Framing error
Const CE_BREAK = &h10    '  Break Detected
Const CE_CTSTO = &h20    '  CTS Timeout
Const CE_DSRTO = &h40    '  DSR Timeout
Const CE_RLSDTO = &h80   '  RLSD Timeout
Const CE_TXFULL = &h100  '  TX Queue is full
Const CE_PTO = &h200     '  LPTx Timeout
Const CE_IOE = &h400     '  LPTx I/O Error
Const CE_DNS = &h800     '  LPTx Device not selected
Const CE_OOP = &h1000    '  LPTx Out-Of-Paper
Const CE_MODE = &h8000   '  Requested mode unsupported

Const IE_BADID = (-1)    '  Invalid or unsupported id
Const IE_OPEN = (-2)     '  Device Already Open
Const IE_NOPEN = (-3)    '  Device Not Open
Const IE_MEMORY = (-4)   '  Unable to allocate queues
Const IE_DEFAULT = (-5)  '  Error in default parameters
Const IE_HARDWARE = (-10)        '  Hardware Not Present
Const IE_BYTESIZE = (-11)        '  Illegal Byte Size
Const IE_BAUDRATE = (-12)        '  Unsupported BaudRate

'----------------------------------------------------------------------------
' Win 3.1 API Declarations

Declare Function OpenComm Lib "USER" (ByVal lpComName As String, ByVal wInQueue As Integer, ByVal wOutQueue As Integer) As Integer
Declare Function CloseComm Lib "USER" (ByVal nCid As Integer) As Integer

Declare Function SetCommState Lib "USER" (lpdcb As dcb) As Integer
Declare Function GetCommState Lib "USER" (ByVal nCid As Integer, lpdcb As dcb) As Integer

Declare Function ReadComm Lib "USER" (ByVal nCid As Integer, ByVal lpBuf As String, ByVal nSize As Integer) As Integer
Declare Function WriteComm Lib "USER" (ByVal nCid As Integer, ByVal lpBuf As String, ByVal nSize As Integer) As Integer
Declare Function FlushComm Lib "USER" (ByVal nCid As Integer, ByVal nQueue As Integer) As Integer

Declare Function SetCommEventMask Lib "USER" (ByVal nCid As Integer, nEvtMask As Integer) As Long
Declare Function GetCommEventMask Lib "USER" (ByVal nCid As Integer, ByVal nEvtMask As Integer) As Integer

Declare Function BuildCommDCB Lib "USER" (ByVal lpDef As String, lpdcb As dcb) As Integer
Declare Function EscapeCommFunction Lib "USER" (ByVal nCid As Integer, ByVal nFunc As Integer) As Integer
Declare Function GetCommError Lib "USER" (ByVal nCid As Integer, lpStat As COMSTAT) As Integer

'----------------------------------------------------------------------------
' SerialClose flushes and closes the indicated serial port

Function SerialClose(ComPort As Integer) As Integer
    x% = FlushComm(ComPort, 0)
    x% = FlushComm(ComPort, 1)
    x% = EscapeCommFunction(ComPort, CLRDTR)
    x% = CloseComm(ComPort)
    
    If (x% < 0) Then
        SerialClose = x%
    Else
        SerialClose = 0
    End If
End Function

'----------------------------------------------------------------------------
' SerialConfig builds a CommDCB and sets the comm port

Function SerialConfig(MdmStr As String) As Integer

    Dim lpdcb As dcb
    
    i% = BuildCommDCB(MdmStr, lpdcb)
    
    rc = SetCommState(lpdcb)
    If (rc < 0) Then
        SerialConfig = rc
    Else
        SerialConfig = 0
    End If
End Function

'----------------------------------------------------------------------------
' SerialOpen sets the comm port's DTR on, and opens the port

Function SerialOpen(ComPort As Integer) As Integer
    x% = EscapeCommFunction(ComPort, SETDTR)
    PortID = OpenComm(PortName, 2048, 128)
    If (PortID < 0) Then
        SerialOpen = PortID
    Else
        SerialOpen = 0
    End If
End Function

'----------------------------------------------------------------------------
' SerialWrite sends a string to the current comm port (PortID)

Function SerialWrite(t$) As Integer
    Dim st As COMSTAT
    
    Status% = GetCommError(PortID, st)
    Status% = WriteComm(PortID, t$, Len(t$))
    
    If (Status% < 0) Then
        Status% = GetCommError(PortID, st)
    End If
    
    SerialWrite = Status%
End Function

'----------------------------------------------------------------------------
' SerialWait waits for a number of seconds (Wait%) for a user-indicated string
' of characters (waitstr$). It then stuffs the comm buffer into buf$ and returns
' TRUE if it finds the string, or FALSE otherwise.

Function SerialWait(buf$, Wait%, waitstr$) As Integer
    Dim b As String * 4096 ' This SHOULD be enough space, but you never know.....
    
    totchars% = 0
    
    Start = Timer   ' Set start time.

    buf$ = ""
    
    Do While (Timer - Start < Wait%)
        b = Space$(4096)
        curchars% = ReadComm(PortID, b, 4096)
        totchars% = totchars% + curchars%
        buf$ = buf$ & Left$(b, curchars%)
        If (InStr(buf$, waitstr$) > 0) Then Exit Do
        If (InStr(b, waitstr$) > 0) Then Exit Do
    Loop

    If (InStr(buf$, waitstr$) = 0) Then
        SerialWait = 0
    Else
        SerialWait = 1
    End If
End Function

'----------------------------------------------------------------------------
' PageWait waits for a string, but also recognizes page-by-page input.
' Every time the string pagestr$ is encountered, PageWait writes a newline
' to the comm port. When endstr$ is received, the entire comm input is saved
' to buf$ and returned.

Function PageWait(buf$, Wait%, pagestr$, endstr$) As Integer
    Dim b As String * 4096
    Dim lastpg, curpg As Integer

    totchars% = 0

    Start = Timer   ' Set start time.

    buf$ = ""
    lastpg = 1
    Do While (Timer - Start < Wait%)
        b = Space$(4096)
        Pause (2)
        curchars% = ReadComm(PortID, b, 4096)
        totchars% = totchars% + curchars%
        buf$ = buf$ & Left$(b, curchars%)
        
        ' Keep looping as long as you get more characters
        If (curchars% > 0) Then Start = Timer
        
        If (InStr(b, pagestr$) > 0) And (InStr(b, endstr$) = 0) Then
            SerialWrite (NL)
            Start = Timer
        End If
        
        ' curpg = InStr(Right$(buf$, Len(buf$) - lastpg), pagestr$)
        ' Looking at the entire appended buffer avoids pagestr$ split!
        'If (curpg > 0) And (InStr(buf$, endstr$) = 0) Then
        '    lastpg = curpg
        '    SerialWrite (NL)
        '    Start = Timer
        'End If
        
        If (InStr(buf$, endstr$) > 0) Then
            Exit Do
        End If
    Loop

    If (InStr(buf$, endstr$) = 0) Then
        PageWait = 0
    Else
        PageWait = 1
    End If
End Function

'----------------------------------------------------------------------------
' Pause simply waits for Secs% number of seconds

Sub Pause(Secs%)
    Start = Timer
    Do While (Timer - Start < Secs%)
    Loop
End Sub

'----------------------------------------------------------------------------
' FracCvt converts a text string like "3/8" to a double value like 0.375

Function FracCvt(Frac$) As Double

    sl = InStr(Frac$, "/")

    If sl = 0 Then
        FracCvt = 0#
        Exit Function
    End If

    lfrac = Left(Frac$, sl - 1)
    rfrac = Right(Frac$, Len(Frac$) - sl)

    FracCvt = CDbl(lfrac) / CDbl(rfrac)
End Function

'----------------------------------------------------------------------------
' Mr. Main Program

Sub MSJCallCIS()
    Dim lft, rgt As Integer
    
    DialogSheets("Settings").EditBoxes(4).Text = ""
    
    While Len(DialogSheets("Settings").EditBoxes("edtPassword").Text) = 0
        q% = DialogSheets("Settings").Show
        If (q% = False) Then Exit Sub
    Wend

' Retrieve the settings from the Settings dialog box

    STK$ = DialogSheets("Settings").EditBoxes("edtStock").Text
    DYS = Val(DialogSheets("Settings").EditBoxes("edtDays").Text)
    UID$ = DialogSheets("Settings").EditBoxes("edtUID").Text
    PWD$ = DialogSheets("Settings").EditBoxes("edtPassword").Text
    PHO$ = DialogSheets("Settings").EditBoxes("edtPhone").Text
    CNS$ = DialogSheets("Settings").EditBoxes("edtConnect").Text
    
' Clear the password field
    DialogSheets("Settings").EditBoxes("edtPassword").Text = ""

    For L% = 6 To 9 ' Easier than testing each button; get the port
        If DialogSheets("Settings").OptionButtons(L%).Value = 1 Then
            MDM$ = DialogSheets("Settings").OptionButtons(L%).Caption
        End If
    Next L%
    
    For L% = 1 To 5 ' Get the speed
        If DialogSheets("Settings").OptionButtons(L%).Value = 1 Then
            MDM$ = MDM$ & DialogSheets("Settings").OptionButtons(L%).Caption
        End If
    Next L%
    
    For L% = 10 To 11 ' Get the E71/N81 state
        If DialogSheets("Settings").OptionButtons(L%).Value = 1 Then
            MDM$ = MDM$ & "," & DialogSheets("Settings").OptionButtons(L%).Caption
        End If
    Next L%
        
' First, initialize these globals and open the debug output file

    NL = Chr$(13) + Chr$(10)

    PortID = Val(Mid(MDM$, 4, 1)) - 1
    PortName = Left(MDM$, 4)
    
    If (DBG = 1) Then
        ff = FreeFile()
        Open FIL For Append As #ff
    End If

' Open and configure the modem
    
    q% = SerialOpen(PortID)
    
    If (q% < 0) Then GoTo GetOut
    
    q% = SerialConfig(MDM$)

    If (q% < 0) Then GoTo GetOut

    q% = SerialWrite("ATZ0" & NL)
    Pause (2)
    q% = SerialWait(bufst$, 5, "OK")
    
    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

    q% = SerialWrite("ATM0" & NL)
    Pause (2)
    q% = SerialWait(bufst$, 5, "OK")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

' Dial up your friendly local CIS port

    q% = SerialWrite("ATDT " & PHO$ & NL)
    Pause (2)
    q% = SerialWait(bufst$, 30, CNS$)
    
    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

' On connect, log on with the parms you set above

    q% = SerialWrite(NL)
    Pause (1)
    q% = SerialWrite(NL)
    Pause (1)
    q% = SerialWrite(NL)
    
' CIS prompts you with "Host Name". You want to say "CIS"
    
    q% = SerialWait(bufst$, 15, "Host Name:")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

    q% = SerialWrite("CIS" & NL)
    
' Now you need to input your user id. The macro will do this for you!
    Pause (2)
    q% = SerialWait(bufst$, 5, "User ID:")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

    q% = SerialWrite(UID$ & NL)
    
' And your extra-secret, super password.
    
    Pause (2)
    q% = SerialWait(bufst$, 5, "Password:")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut


    q% = SerialWrite(PWD$ & NL)
    
' Now you're on! (If you did everything right.) Ignore the useless
' opening menu stuff (don't you always do that anyway?) Wait for the
' ! input prompt.
    
    Pause (2)
    q% = SerialWait(bufst$, 30, "!")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

' When you get the ! prompt, go to the historical stock quote area
' There the program will answer all the questions automatically

    q% = SerialWrite("GO PRICES" & NL)
    
' After some garbage about the PRICES forum, you are prompted for the
' stock name you want to search, with "Issue:" Answer with the stock you
' entered in the Settings window
    
    Pause (2)
    q% = SerialWait(bufst$, 30, "Issue:")

    If (DBG = 1) Then Print #ff, bufst$

    q% = SerialWrite(STK$ & NL)

' You'll be asked:
' "(D)aily, (W)eekly, (M)onthly? :"
' Answer D for daily

    Pause (2)
    q% = SerialWait(bufst$, 15, "(M)onthly? :")

    If (DBG = 1) Then Print #ff, bufst$

    q% = SerialWrite("D" & NL)
    
' Next, the macro has to tell CIS how many periods it wants when it sees:
' "Starting date or number of"
' "periods from last pricing date?"
    
    Pause (2)
    q% = SerialWait(bufst$, 15, "pricing date?")

    If (DBG = 1) Then Print #ff, bufst$

' The PageWait function reads page after page and appends to the buffer
' until a second string is reached. In the lines below, the macro will
' respond with an <enter> every time it gets the string "Press <CR> for more"
' And will see "Last page !" as the terminating string for the data.
    
    q% = SerialWrite(Format$(DYS, "#") & NL)
    Pause (2)
    q% = PageWait(bufst$, 20, "Press <CR> for more", "Last page !")

    If (DBG = 1) Then Print #ff, bufst$

' Save the actual data part for use in the chart

    out$ = bufst$

' You're now at the "Last Page !" prompt. You can say BYE at any ! prompt, so
' This is as good a place as any. Log off and drop DTR and stuff like that.
    
    q% = SerialWrite("BYE" & NL & NL)
    Pause (2)
    q% = SerialWait(bufst$, 30, "Host Name")

    If (DBG = 1) Then Print #ff, bufst$

    If (q% = 0) Then GoTo GetOut

    q% = SerialWrite("BYE" & NL & NL)
    Pause (2)
    q% = SerialWait(bufst$, 30, "NO CARRIER")

    If (DBG = 1) Then Print #ff, bufst$

' Parse out the data part only. The data starts after a string of dashes
' and a newline (each page has a "Date  Volume..." heading with underlines)

    lft = InStr(out$, "----" & NL)
    rgt = InStr(out$, "Prices")
    
    Data$ = Right(out$, Len(out$) - lft - 5)
    D$ = Data$
    
    Row% = 5
    
' Clear previous data from columns, nuke old chart

    ActiveSheet.ChartObjects.Delete

    Columns("E:H").Select
    Selection.ClearContents
    Range("E4").Select
    ActiveCell.FormulaR1C1 = "Date"
    Range("F4").Select
    ActiveCell.FormulaR1C1 = "Hi"
    Range("G4").Select
    ActiveCell.FormulaR1C1 = "Lo"
    Range("H4").Select
    ActiveCell.FormulaR1C1 = "Close"
    Range("H5").Select

'Write new data in columns

    Do While Len(D$) > 0 And InStr(D$, NL) > 0
        z% = InStr(D$, NL)
        If Val(D$) = 0 Then GoTo NextLn
        SDate = Left(D$, 8)
        SHi = Val(Mid(D$, 25, 4)) + FracCvt(Mid(D$, 30, 3))
        SLo = Val(Mid(D$, 37, 4)) + FracCvt(Mid(D$, 42, 3))
        SLast = Val(Mid(D$, 49, 4)) + FracCvt(Mid(D$, 54, 3))

        If SHi <> 0 Then
            Cells(Row%, 5).Value = SDate
            Cells(Row%, 6).Value = SHi
            Cells(Row%, 7).Value = SLo
            Cells(Row%, 8).Value = SLast
            Row% = Row% + 1
        Else
            DYS = DYS - 1  ' In case of a holiday (HOL), etc, you have one fewer day to show
        End If
        
NextLn:
        D$ = Right$(D$, Len(D$) - z%)
        Do While ((Asc(Left(D$, 1)) = 10) Or (Asc(Left(D$, 1)) = 13)) And Len(D$) > 0
            D$ = Right(D$, Len(D$) - 1)
        Loop 'While Asc(Left...
    Loop 'While Len(D$) > 0
    
    DrawGraph ("MSJStox Stock History Chart")
    
GetOut:  ' Whenever exiting, close the serial port so it can be reused later!
    q% = SerialClose(PortID)
    If (DBG = 1) Then Close #ff
End Sub

'----------------------------------------------------------------------------
' All the graphing information is drawn in here.

Sub DrawGraph(Ttl As String)
    Dim Rng As String
    Rng = "E4:H" & Format(DYS + 4, "#")
    
    ' If you don't put the If Count clause around this statement, you will
    ' erase the current cell!
        
    If (ActiveSheet.ChartObjects.Count > 0) Then
        ActiveSheet.ChartObjects.Delete
    End If
    
    Range(Rng).Select
    ActiveSheet.ChartObjects.Add(6, 64.5, 360, 189.75).Select
    Application.CutCopyMode = False
    ActiveChart.ChartWizard Source:=Range(Rng), Gallery:=xlLine, _
        Format:=8, PlotBy:=xlColumns, CategoryLabels:=1, SeriesLabels _
        :=1, HasLegend:=2, Title:=Ttl, _
        CategoryTitle:="Date", ValueTitle:="Value", ExtraTitle:=""
    ActiveSheet.ChartObjects(1).Activate
    ActiveChart.ChartArea.Select
    
' Remember, the "Selection" here is the active chart
    
    With Selection.Border
        .Weight = xlHairline
        .LineStyle = xlNone
    End With
    
    Selection.Shadow = False
    
    With Selection.Interior
        .ColorIndex = 24
        .Pattern = xlSolid
    End With
    
    ActiveChart.PlotArea.Select
    
    With Selection.Border
        .ColorIndex = 16
        .Weight = xlThin
        .LineStyle = xlContinuous
    End With
    
    With Selection.Interior
        .ColorIndex = 35
        .Pattern = xlSolid
    End With
End Sub


