#include <owl\applicat.h>
#include <owl\decmdifr.h>
#include <owl\statusba.h>
#include <owl\editview.h>
#include <owl\filedoc.h>
#include <owl\dialog.h>

#include "hexview.hpp"
#include "viewer.rc"

DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, THexView, HexTemplate);
DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, TEditView, EditTemplate);

EditTemplate a("Text viewer", "*.bat","C:\\", 0,
               dtAutoDelete | dtReadOnly);
HexTemplate  b("Hex viewer", "*.*","C:\\", 0,
               dtAutoDelete | dtReadOnly);

class TViewerApp : public TApplication {

  TMDIClient* Client;

public:

  void InitMainWindow();

  void CmEnableSave(TCommandEnabler& handler)
    { handler.Enable(FALSE); }

  void CmEnableSaveAs(TCommandEnabler& handler)
    { handler.Enable(FALSE); }

  void EvNewView(TView&);
  void EvCloseView(TView&);
  void CmHelpAbout();
  DECLARE_RESPONSE_TABLE(TViewerApp);
};

DEFINE_RESPONSE_TABLE1(TViewerApp, TApplication)
  EV_COMMAND_ENABLE(CM_FILESAVE, CmEnableSave),
  EV_COMMAND_ENABLE(CM_FILESAVEAS, CmEnableSaveAs),
  EV_OWLVIEW(dnCreate, EvNewView),
  EV_OWLVIEW(dnClose, EvCloseView),
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
END_RESPONSE_TABLE;

void TViewerApp::InitMainWindow()
{
  DocManager = new TDocManager(dmMDI | dmMenu);
  TDecoratedFrame* frame =
    new TDecoratedMDIFrame("ASCII / Hex file viewer", 0,
                           *(Client=new TMDIClient), TRUE);
  TStatusBar* sb = new TStatusBar(frame, TGadget::Recessed,
                                  TStatusBar::CapsLock |
                                  TStatusBar::NumLock |
                                  TStatusBar::Overtype);
  frame->Insert(*sb, TDecoratedFrame::Bottom);
  MainWindow = frame;
  MainWindow->SetMenuDescr(TMenuDescr(IDM_MAIN,1,0,1,0,1,1) );
}

void TViewerApp::EvNewView(TView& view)
{
  TMDIChild* child = new TMDIChild(*Client, 0, view.GetWindow() );
  child->SetMenuDescr(TMenuDescr(IDM_EDITVIEW,0,2,0,0,0,0) );
  child->Create();
}

void TViewerApp::EvCloseView(TView& view)
{
  TWindow* client = view.GetWindow();
  if (client) {
    TWindow* child = client->Parent;
    if (child) {
      client->SetParent(0);
      child->ShutDownWindow();
    }
  }
}

void TViewerApp::CmHelpAbout()
{
  TDialog(MainWindow, DIALOG_HELPABOUT).Execute();
}

int OwlMain(int, char**)
{
  return TViewerApp().Run();
}

