#include "hexview.hpp"
#include <strstrea.h>

THexView::THexView(TDocument& doc, TWindow* parent)
	: TEditView(doc, parent)
{
  fixedPitchFont = CreateFont(15, 0, 0, 0,
			      0, 0, 0, 0,
			      0, 0, 0, 0, FIXED_PITCH,
			      "Courier New");
}

THexView::~THexView()
{
  DeleteObject(fixedPitchFont);
}

BOOL THexView::Create(){
  if (!TEditView::Create() )
    return FALSE;

  char* data = LockBuffer();
  UnlockBuffer(data, FALSE);
  if (!data) return FALSE;

  // change the data from ASCII to Hex ASCII,
  // e.g. the byte value 0x24 is converted to 0x32 0x34 0x20,
  // so 0x24 would display as the string "24 "
  ostrstream newData;
  for (int charsOnLine = 0; *data; data++) {
    newData << HexToAscii(*data >> 4)
	    << HexToAscii(*data)
	    << ' ';

    // show only 16 bytes per line
    charsOnLine += 3;
    if (charsOnLine >= 48) {
      charsOnLine = 0;
      newData << "\r\n";
    }
  }

  newData << ends;

  // now empty the edit control and put the converted
  // data into it
  PostMessage(WM_SETFONT, (WPARAM) fixedPitchFont, 0);
  SetWindowText(newData.str() );
  newData.rdbuf()->freeze(0);
  return TRUE;
}

char THexView::HexToAscii(char c)
{
  static char value [] = {"0123456789ABCDEF"};
  return value [c & 0x0F];
}

