// TABS.H - The Resource include file for a property sheet dialog

FONTSHEET_START        1000
FONTSHEET_TYPEFACE     1000
FONTSHEET_POINTSIZE    1001
FONTSHEET_STYLE        1002
FONTSHEET_UNDERLINE    1003
FONTSHEET_SAMPLETEXT   1004

COLORSHEET_START       2000
COLORSHEET_RVALUE      2000
COLORSHEET_GVALUE      2001
COLORSHEET_BVALUE      2002
COLORSHEET_PREVIEW     2003

// SOMECODE.C - Using one dialog procedure for all sheets

#include <basedefs.h>  // BASEDEFS.H from NT Porting Beastie Article

DLGPROC SomeDlgProc_WM_COMMAND_Handler ( DIALOG_PARAMS )
{
  CRACKER_VARS
  CRACK_MESSAGEsc

  // First check for the "common" controls, these are controls
  // that live in every page, such as the OK and Cancel buttons

  if ( CRACKER_wID < FONTSHEET_START )
    return SomeDlgProc_Common_WM_COMMAND ( hDlg, 
                                           CRACKER_wID, 
                                           CRACKER_wNotification, 
                                           CRACKER_hWnd 
                                         );

  // Second, check each range, and call the appropriate
  // "mini-handler" for each page of the property sheet.

  if ( CRACKER_wID < COLORSHEET_START )
    return SomeDlgProc_FONTSHEET_WM_COMMAND ( hDlg, 
                                              CRACKER_wID, 
                                              CRACKER_wNotification, 
                                              CRACKER_hWnd 
                                            );

  return SomeDlgProc_COLORSHEET_WM_COMMAND  ( hDlg, 
                                              CRACKER_wID, 
                                              CRACKER_wNotification, 
                                              CRACKER_hWnd 
                                            );

}
