/************************************************************************

                                DISCLAIMER

	Consult your physician before using this program.  Batteries not
	included.  May cause drowsiness.  Must be over 17.  Not available
	in all states.  Not responsible for acts of God.  Prices subject to
	change without notice.  Proof of purchase required.  Read label
	before using.  Some assembly required.  Not responsible for
	typographical errors.  Some restrictions apply.  Subject to local
	regulation.  Warrantee period limited.  Close cover before
	striking.  No resemblance to any person, living or dead, is
	intended.  Subject to availability.  No COD's.  Sales tax not
	included.  Shipping and handling extra.  For external use only. 
	May cause excitability.  Avoid alcoholic beverages while using this
	software.  If symptoms persist, consult your physician.  Keep this
	and all software out of the reach of children.  Parental guidance
	suggested.  The buyer assumes all risks associated with using this
	product.  In case of irritation, flush eyes with cold water and
	consult your physician.  Not insured by the Federal Deposit
	Insurance Corporation.  Use with adequate ventilation.  Avoid
	repeated or prolonged contact with skin.  Contents under pressure;
	do not puncture or incinerate.  Store in original containers. 
	Harmful if swallowed.  Do not fold, bend, staple or mutilate. 
	PLEASE NOTE: Some quantum physics theories suggest that when the
	consumer is not directly observing this product, it may cease to
	exist or will exist only in a vague and undetermined state.

************************************************************************/

// SCRLLAYR.C - A Layer Between your app and the scrollbar control
//
// Current version(s) supported by this layer: Windows 2.1, 3.0, 3.1
//
// There is a *very tentative* interface implemeted for Windows 4.0,
// but this could change! Currently, the slider control is called
// a "trackbar", and the TBM_* messages are used to communicate
// with it.
//
// More daring programmers can change this layer to use their
// own interface instead of simply mimicking the 3.1 scrollbar 
// interface.
//
// Notice that along with the four Win 3.1 scrollbar API's,
// a new layer function SCRLLAYR_ScrollBarInitialize has been
// added. This function does nothing in Windows 3.1, but it
// leaves us a nice place to do any init work that may be required
// for Chicago's control. Make sure to call this function,
// even though it does nothing, that way when you move to Chicago,
// you can use the compiler to point out evey place you need to
// add initialization code by changing the parameter list and
// noting all the new compiler errors.
//
// For those concerned with speed issues, most compilers
// have nifty pragmas to change these into macros that seamlessly
// integrate these layers into your code.

int SCRLLAYR_SetScrollPos ( HWND hWnd,
                            int  fnBar,
                            int  nPos,
                            BOOL fRepaint
                          )
{
#ifdef WIN31ORLOWER
  return SetScrollPos ( hWnd, fnBar, nPos, fRepaint );
#else
  int  iOldPos = SCRLLAYR_GetScrollPos ( hWnd, fnBar );
  SendMessage ( hWnd, TBM_SETPOS, (WPARAM)TRUE, (LPARAM)nPos );
  return iOldPos;
#endif
}

int SCRLLAYR_GetScrollPos ( HWND hWnd,
                             int  fnBar
                           )
{
#ifdef WIN31ORLOWER
  return GetScrollPos ( hWnd, fnBar );
#else
  return SendMessage ( hWnd, TBM_GETPOS, 0, 0 );
#endif
}

void SCRLLAYR_SetScrollRange ( HWND  hWnd,
                               int   fnBar,
                               int   nMin,
                               int   nMax,
                               BOOL  fRedraw
                             )
{
#ifdef WIN31ORLOWER
  SetScrollRange ( hWnd, fnBar, nMin, nMax, fRedraw );
#else
  SendMessage ( hWnd, TBM_SETRANGE, (WPARAM)fRedraw, 
                (LPARAM) MAKELONG ( nMin, nMax )
              );
#endif
}

int SCRLLAYR_GetScrollRange ( HWND  hWnd,
                              int   fnBar,
                              LPINT lpnMinPos,
                              LPINT lpnMaxPos
                            )
{
#ifdef WIN31ORLOWER
  return GetScrollRange ( hWnd, fnBar, lpnMinPos, lpnMaxPos );
#else
  *lpnMinPos = SendMessage ( hWnd, TBM_GETRANGEMIN, 0, 0 )
  *lpnMaxPos = SendMessage ( hWnd, TBM_GETRANGEMAX, 0, 0 )
#endif
}

void SCRLLAYR_ScrollBarInitialize ( void )
{
  // Does nothing for Windows 3.1, nothing yet for 4.0
}
