/*************************************************************
Module name: DFSrcDem.C
Notices: Copyright (c) 1993 Jeffrey Richter
*************************************************************/


#include <windows.h>
#include <windowsx.h>
#include <tchar.h>
#include <stdio.h>

#include "DFSrc.h"

#define ARRAY_LEN(Array) (sizeof(Array) / sizeof(Array[0]))


//////////////////////////////////////////////////////////////


// Utility function that parses the list of selected files 
// returned by the File Open Common Dialog Box.
int GetSinglePathName (LPCTSTR szFileOpenStr, int nIndex,
        LPTSTR szPathName, int nMaxLen);


//////////////////////////////////////////////////////////////


HINSTANCE g_hInstance;
TCHAR g_szAppName[] = __TEXT("Drop File Source Application");
static TCHAR g_szAllFileNames[1000]  = { 0 };



//////////////////////////////////////////////////////////////


void Dlg_OnUpdateCaption (HWND hwnd, int nNumFiles) {
	TCHAR szBuf[100];
	// Update the window's caption to reflect  the number
	// of selected files available for dropping
	_stprintf(szBuf, __TEXT("%s - %d file(s) to drop"),
		g_szAppName, nNumFiles);
	SetWindowText(hwnd, szBuf);
}


//////////////////////////////////////////////////////////////


BOOL Dlg_OnInitDialog (HWND hwnd, HWND hwndFocus, 
	LPARAM lParam) {

   SetClassLong(hwnd, GCL_HICON, (LONG)
   	LoadIcon((HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE),
      	__TEXT("DFSrcDem")));

	Dlg_OnUpdateCaption (hwnd, 0);
	return(TRUE);
}


//////////////////////////////////////////////////////////////


void Dlg_OnCommand (HWND hwnd, int id, 
	HWND hwndCtl, UINT codeNotify) {

	OPENFILENAME ofn;
	int nNumFiles;

	switch (id) {
		case 100:	// "File Select!" menu item
			// Initialize structure for calling
			// the "Open File" common dialog
			memset(&ofn, 0, sizeof(ofn));
			ofn.lStructSize = sizeof(ofn);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFilter = __TEXT("All files\0*.*\0");
			ofn.Flags = OFN_ALLOWMULTISELECT | 
				OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

			// Set up the buffer to receive the selected file(s)
			g_szAllFileNames[0] = 0;
			ofn.lpstrFile = g_szAllFileNames;
			ofn.nMaxFile = ARRAY_LEN(g_szAllFileNames);

			if (GetOpenFileName(&ofn)) {
				nNumFiles = GetSinglePathName(g_szAllFileNames, 
					-1, NULL, 0);
			} else {
				nNumFiles = 0;
			}

			Dlg_OnUpdateCaption(hwnd, nNumFiles);
			break;

		case IDCANCEL:
			EndDialog(hwnd, id);
			break;
	}
}


//////////////////////////////////////////////////////////////


// Macro to ease source code readability.
#define WndAcceptsFiles(hwnd) \
	(GetWindowExStyle((hwnd)) & WS_EX_ACCEPTFILES)


void Dlg_OnLButtonDown (HWND hwnd, BOOL fDoubleClick, 
	int x, int y, UINT keyFlags) {

	int nNumFiles;
	HCURSOR hcurDrpNo, hcurDrpOk;
	POINT ptMousePos;
	HWND hwndSubject;
	HDROP hDrop, hDropT;
	BOOL fInNonClientArea, fOkToDrop;
	TCHAR szDropPathName[200];

	// User has initiated the "Drag and Drop" sequence

	// Make sure that there are some files to be dropped
	nNumFiles = 
		GetSinglePathName(g_szAllFileNames, -1, NULL, 0);
	if (nNumFiles == 0) {
		MessageBox(hwnd, __TEXT("No files to drop."),
			g_szAppName, MB_ICONINFORMATION | MB_OK);
		return;
	}

	// Get the handles to the cursors to show to the user.
	hcurDrpNo = LoadCursor(NULL, IDC_NO);
	hcurDrpOk = LoadCursor(g_hInstance,
		(nNumFiles > 1) ? __TEXT("DrpMany") : __TEXT("DrpOne"));


	// *** Loop for determining the drop-file client window ***
	SetCapture(hwnd);
	do {
		// Get cursor position & window under the cursor
		GetCursorPos(&ptMousePos);
		hwndSubject = WindowFromPoint(ptMousePos);

		// See if the subject window or any of its parent 
		// windows are prepared to accept dropped files.
		while (IsWindow(hwndSubject)) {
			if (WndAcceptsFiles(hwndSubject))
				break;
   	   hwndSubject = GetParent(hwndSubject);
		}

		fOkToDrop = IsWindow(hwndSubject) && 
			WndAcceptsFiles(hwndSubject);

		SetCursor(fOkToDrop ? hcurDrpOk : hcurDrpNo);

   	// Continue loop while the mouse button is pressed
	} while (GetAsyncKeyState(VK_LBUTTON) & 0x8000);
	ReleaseCapture();

	// Free the loaded cursor from memory
	DestroyCursor(hcurDrpOk);


	if (!fOkToDrop) 
		return;

	// Is the cursor in the window's non-client area?
	fInNonClientArea = (HTCLIENT != 
		FORWARD_WM_NCHITTEST(hwndSubject, 
			ptMousePos.x, ptMousePos.y, SendMessage));


	// Create drop-file memory block and initialize it
	ScreenToClient(hwndSubject, &ptMousePos);
#ifdef UNICODE
	hDrop = DragCreateFiles(&ptMousePos, 
		fInNonClientArea, TRUE);
#else
	hDrop = DragCreateFiles(&ptMousePos, 
		fInNonClientArea, FALSE);
#endif
	if (hDrop == NULL) {
		MessageBox(hwnd, 
			__TEXT("Insufficient memory to drop file(s)."),
			g_szAppName, MB_OK | MB_ICONSTOP);
      return;
	}


	// Append each pathname to the drop-file memory block
	for (x = 0; x < nNumFiles; x++) {
		// Get the full pathname to append
		GetSinglePathName(g_szAllFileNames, x, 
			szDropPathName, ARRAY_LEN(szDropPathName));

      // Append pathname to end of drop-file memory block
      hDropT = DragAppendFile(hDrop, (LPBYTE) szDropPathName);

		if (hDropT == NULL) {
			MessageBox(hwnd, 
				__TEXT("Insufficient memory to drop file(s)."),
				g_szAppName, MB_OK | MB_ICONSTOP);
         hDrop = GlobalFree(hDrop);
         break;  // Terminate the 'for' loop
	   } else {
			hDrop = hDropT;
      }
	}

	if (hDrop != NULL) {
		// All pathnames appended successfully, post the 
		// message to the drop-file client window
		FORWARD_WM_DROPFILES(hwndSubject, hDrop, PostMessage);

		// Clear our own state information.
		g_szAllFileNames[0] = 0;
		Dlg_OnUpdateCaption(hwnd, 0);

		// Don't free the memory, the Dropfile client will do it
	}
}


//////////////////////////////////////////////////////////////


// The normal HANDLE_MSG macro in WINDOWSX.H does not work
// properly for dialog boxes because DlgProc's return a BOOL
// instead of an LRESULT (like WndProcs).  This HANDLE_DLGMSG
// macro corrects the problem:
#define HANDLE_DLGMSG(hwnd, message, fn)    \
    case (message): return \
    	SetDlgMsgResult(hwnd, uMsg, \
    	HANDLE_##message((hwnd), (wParam), (lParam), (fn)))


BOOL CALLBACK Dlg_Proc (HWND hwnd, UINT uMsg, 
	WPARAM wParam, LPARAM lParam) {
   
   switch (uMsg) {
		HANDLE_DLGMSG(hwnd, WM_INITDIALOG, Dlg_OnInitDialog);
		HANDLE_DLGMSG(hwnd, WM_COMMAND, Dlg_OnCommand);
		HANDLE_DLGMSG(hwnd, WM_LBUTTONDOWN, Dlg_OnLButtonDown);
   }

   return(FALSE);
}


////////////////////////////////////////////////////////////


int APIENTRY WinMain (HINSTANCE hInstance, 
   HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow) {

	g_hInstance = hInstance;
   DialogBox(hInstance, __TEXT("DLG_DFSRCDEM"), NULL, Dlg_Proc);
   return(0);
}


////////////////////////////////////////////////////////////


// Utility function that parses the list of selected files 
// returned by the File Open Common Dialog Box.
int GetSinglePathName (LPCTSTR szFileOpenStr, int nIndex,
        LPTSTR szPathName, int nMaxLen) {

	int nNumFiles = 0, x, y;
	LPCTSTR p = szFileOpenStr, q;
	TCHAR szBuf[200];

	// Initialize the buffer by clearing it
	memset(szBuf, 0, sizeof(szBuf));

	// Calculate the number of files in szFileOpenStr
   while (*p) {
		if (*p == __TEXT(' ')) nNumFiles++;
      p++;
   }

   // If a single file was selected, there are no spaces 
   // but we  should return that one file exists
   if ((nNumFiles == 0) && (p != szFileOpenStr))
		nNumFiles = 1;

	// If the user only wants the number of files, return that
   if (nIndex == -1)
		return(nNumFiles);

	// User requested more files than exist
   if (nIndex > nNumFiles)
		return(0);

   // Construct the full pathname of the requested string
   if ((nIndex == 0) && (nNumFiles == 1)) {
		_tcsncpy(szBuf, szFileOpenStr, nMaxLen);
   } else {
		// Copy the path portion of string into a temp buffer
      x = ((p = _tcschr(szFileOpenStr, __TEXT(' '))) -
      	szFileOpenStr);
      _tcsncpy(szBuf, szFileOpenStr, x);

      // Append a backslash if necessary
      if (*(p - 1) != __TEXT('\\')) {
			szBuf[x] = __TEXT('\\');
         x++;
      }

      for (y = 0; y < nIndex; y++) {
			// Increment past any space so that 'p' 
			// points to a proper filename
			p++;    
         while (*p != __TEXT(' '))
         	p++;
      }
      p++;

      // Find the end of the filename
      q = _tcschr(p, __TEXT(' '));

      if (q != NULL) {
			// Copy the filename into the temp buffer
         _tcsncpy(&szBuf[x], p, (q - p));
      } else {
			// Copy the filename (remainder of string) 
			// into the temp buffer
         _tcscpy(&szBuf[x], p);
      }
   }

   if (szPathName != NULL) {
		// If the user passed an address, copy the string into 
		// its buffer and force a zero-termination.
      _tcsncpy(szPathName, szBuf, nMaxLen);
      szPathName[nMaxLen - 1] = 0;
   }

   return(_tcslen(szBuf)); // Returns length of string
}


//////////////////////// End Of File /////////////////////////
