/*************************************************************
Module name: DFSrc.C
Notices: Copyright (c) 1993 Jeffrey Richter
*************************************************************/


#include <windows.h>

#include "DFSrc.h"


//////////////////////////////////////////////////////////////


// The UNDOCUMENTED data structure necessary for creating
// a Win32 drop-file source application:

typedef struct {
	WORD  wSize;				// Size of data structure
	POINT ptMousePos;			// Position of mouse cursor
	BOOL  fInNonClientArea;	// Was the mouse in the
									// window's non-client area?
	BOOL fUnicode;				// Are the pathnames in Unicode?
} DROPFILESTRUCT, *LPDROPFILESTRUCT;


//////////////////////////////////////////////////////////////


HDROP DragCreateFiles (LPPOINT lpptMousePos, 
	BOOL fInNonClientArea, BOOL fUnicode) {

	HDROP hDrop;
   LPDROPFILESTRUCT lpDropFileStruct;

	// Allocate dynamic memory for the DROPFILESTRUCT data
	// structure and for the extra zero-character identifying
	// that there are no pathnames in the block yet.
	hDrop = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, 
   	sizeof(DROPFILESTRUCT) + 
   	(fUnicode ? sizeof(WCHAR) : sizeof(char)));

   // If unsuccessful, return NULL
   if (hDrop == NULL) 
   	return(hDrop);

   // Lock block and initialize the data members
   lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);
   lpDropFileStruct->wSize = sizeof(DROPFILESTRUCT);
   lpDropFileStruct->ptMousePos = *lpptMousePos;
   lpDropFileStruct->fInNonClientArea = fInNonClientArea;
   lpDropFileStruct->fUnicode = fUnicode;

	// Unlock the block and return its handle.
   GlobalUnlock(hDrop);
   return(hDrop);
}


//////////////////////////////////////////////////////////////


HDROP DragAppendFile (HDROP hDrop, LPBYTE lpbPathname) {
	LPDROPFILESTRUCT lpDropFileStruct;
   LPSTR szPathA;
   LPWSTR szPathW;
	int nOffsetOfNewPathname, nPathSize;

   lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);

   // Point to first pathname in list
   szPathW = (LPWSTR) 
   	(szPathA = (LPSTR) (&lpDropFileStruct[1]));

	if (lpDropFileStruct->fUnicode) {

	   // Search for a pathname where 1st char is a zero-char
	   while (*szPathW) {	// While the 1st char is non-zero
			while (*szPathW)	// Find end of current path
				szPathW++;
	      szPathW++;			// Skip over the zero-char
   	}

		// Get the offset from the beginning of the block 
		// where the new pathname should go
		nOffsetOfNewPathname = 
			((LPBYTE) szPathW - (LPBYTE) lpDropFileStruct);

		// Get the number of bytes needed for the new pathname,
		// it's terminating zero-char, and the zero-length 
		// pathname that marks the end of the list of pathnames
		nPathSize = sizeof(WCHAR) * 
			(wcslen((LPCWSTR) lpbPathname) + 2);
	} else {
	   // Search for a pathname where 1st char is a zero-char
	   while (*szPathA) {	// While the 1st char is non-zero
			while (*szPathA)	// Find end of current path
				szPathA++;
	      szPathA++;			// Skip over the zero-char
   	}

		// Get the offset from the beginning of the block 
		// where the new pathname should go
		nOffsetOfNewPathname = 
			((LPBYTE) szPathA - (LPBYTE) lpDropFileStruct);

		// Get the number of bytes needed for the new pathname,
		// it's terminating zero-char, and the zero-length 
		// pathname that marks the end of the list of pathnames
		nPathSize = sizeof(char) * (strlen(lpbPathname) + 2);
	}

   GlobalUnlock(hDrop);

   // Increase block size to accommodate new pathname
   hDrop = GlobalReAlloc(hDrop, 
   	nPathSize + nOffsetOfNewPathname, 
   	GMEM_MOVEABLE | GMEM_ZEROINIT);

   // Return NULL if insufficient memory
   if (hDrop == NULL) 
   	return(hDrop);

   lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);

   // Append the pathname to the end of the block
	if (lpDropFileStruct->fUnicode) {
	   wcscpy((LPWSTR) 
	   	((LPSTR) lpDropFileStruct + nOffsetOfNewPathname), 
	   	(LPCWSTR) lpbPathname);
	} else {
	   strcpy((LPSTR)  
	   	((LPSTR) lpDropFileStruct + nOffsetOfNewPathname), 
	   	lpbPathname);
	}

   GlobalUnlock(hDrop);
   return(hDrop);  // Return the new handle to the block
}


//////////////////////// End Of File /////////////////////////
