//////////////////
// Sample MFC application showing how to set the 
// background color for MDI child windows
// 

#include <afxwin.h> 
#include <afxext.h>
#include "mdicolor.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////
// Document and main frame classes are trivial
//
IMPLEMENT_DYNCREATE(CRedDoc, CDocument)
IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)


////////////////////////////////////////////////////////////////
// Application class
//
BEGIN_MESSAGE_MAP(CRedApp, CWinApp)
   ON_COMMAND(ID_FILE_NEW_VIEW, OnNewView)
   ON_COMMAND(ID_FILE_NEW_FORM, OnNewForm)
END_MESSAGE_MAP()

CRedApp NEAR theApp;

BOOL CRedApp::InitInstance()
{
   // Create template for ordinary view window
   m_pViewTemplate = new CMultiDocTemplate(IDR_VIEWTYPE,
      RUNTIME_CLASS(CRedDoc),
      RUNTIME_CLASS(CMDIChildWnd),
      RUNTIME_CLASS(CRedView));
   AddDocTemplate(m_pViewTemplate);

   // Create template for form view
   m_pFormTemplate = new CMultiDocTemplate(IDR_FORMTYPE,
      RUNTIME_CLASS(CRedDoc),
      RUNTIME_CLASS(CMDIChildWnd),
      RUNTIME_CLASS(CRedFormView));
   AddDocTemplate(m_pFormTemplate);

   // Create main MDI Frame window
   CMainFrame* pMainFrame = new CMainFrame;
   if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
      return FALSE;
   pMainFrame->ShowWindow(m_nCmdShow);
   pMainFrame->UpdateWindow();
   m_pMainWnd = pMainFrame;

   return TRUE;
}

void CRedApp::OnNewView()
{
   m_pViewTemplate->OpenDocumentFile(NULL);  
}

void CRedApp::OnNewForm()
{
   m_pFormTemplate->OpenDocumentFile(NULL);  
}

////////////////////////////////////////////////////////////////
// View class sets the background color 
// by registering a new window class
//
IMPLEMENT_DYNCREATE(CRedView, CView)

CString CRedView::sClassName;

//////////////////
// If the window class is not yet registered, register it.
//
BOOL CRedView::PreCreateWindow(CREATESTRUCT& cs)
{
   if (sClassName.IsEmpty())
      sClassName = AfxRegisterWndClass(CS_DBLCLKS, 0, theApp.GetRedBrush());
   cs.lpszClass = sClassName;
   return CView::PreCreateWindow(cs);
}

//////////////////
// Form view class sets the background color via WM_CTLCOLOR message
//
IMPLEMENT_DYNCREATE(CRedFormView, CFormView)

BEGIN_MESSAGE_MAP(CRedFormView, CFormView)
   ON_WM_CTLCOLOR()
END_MESSAGE_MAP()

CRedFormView::CRedFormView() : CFormView(IDD_DIALOG1)
{

}

HBRUSH CRedFormView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nWhich)
{
#ifdef _DEBUG
   static const char* CTLCOLORNAMES[] = {
      "CTLCOLOR_MSGBOX",   "CTLCOLOR_EDIT",  "CTLCOLOR_LISTBOX",
      "CTLCOLOR_BTN",      "CTLCOLOR_DLG",   "CTLCOLOR_SCROLLBAR",
      "CTLCOLOR_STATIC",
   };
   TRACE("CRedFormView::OnCtlColor: nWhich=%s\n", CTLCOLORNAMES[nWhich]);
#endif

   return (nWhich==CTLCOLOR_DLG) ? theApp.GetRedBrush() 
      : CFormView::OnCtlColor(pDC, pWnd, nWhich);
}

