 * File......: MOUSE.CH
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 6/23/93
 * Revision..: V2.0
 * Log file..: 
 * 
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.

 * Modification History:
 *
 * V1.01   12/30/92   Added restore option to CoolButton and WarmButton
 * V1.02    2/25/93   Made message an optional parameter
 * V1.02    3/23/93   Added inactive option
 * V2.0     6/23/93   Consistent version numbering

#define MREAD 1
#define MBROWSE 2
#define MMENU 3
#define MMEMOEDIT 4
#define MACHOICE 5
#define MGENERAL 6

/*  $DOC$
 *  $COMMANDNAME$
 *     BUTTON
 *  $CATEGORY$
 *     GENERAL
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     BUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presses.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If .F. the serviving routine will not wait for
 *              the button to be released. If =NIL then the default is 
 *              used (see MDefRelease())
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the GENERAL mouse 
 *      subsystem Hot Spot pool. This general pool is tested by all mouse
 *      subsystems prior to each system's specific pool of hot spots.
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     Button 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     Button() RemoveButton() ButtonCool() ButtonWarm() ngget.ngo:READBUTTON ngbrows.ngo:BROWSEBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

#xCommand BUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive: INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MGENERAL, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>,!<.lInactive.>)

/*  $DOC$
 *  $COMMANDNAME$
 *     READBUTTON
 *  $CATEGORY$
 *     GET/READ
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     READBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *              to be release before proceeding.
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the GET/READ mouse 
 *      subsystem Hot Spot pool. 
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     READButton 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     nggenrl.ngo:Button() nggenrl.ngo:RemoveButton() nggenrl.ngo:ButtonCool() nggenrl.ngo:ButtonWarm() nggenrl.ngo:BUTTON ngbrows.ngo:BROWSEBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

#xCommand READBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive:INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MREAD, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>, !<.lInactive.>)

/*  $DOC$
 *  $COMMANDNAME$
 *     BROWSEBUTTON
 *  $CATEGORY$
 *     BROWSE
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     BROWSEBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *              to be release before proceeding.
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the BROWSE mouse 
 *      subsystem Hot Spot pool. 
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     BROWSEButton 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     nggenrl.ngo:Button() nggenrl.ngo:RemoveButton() nggenrl.ngo:ButtonCool() nggenrl.ngo:ButtonWarm() nggenrl.ngo:BUTTON ngget.ngo:READBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

#xCommand BROWSEBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive:INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MBROWSE, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>, !<.lInactive.>)
/*  $DOC$
 *  $COMMANDNAME$
 *     ACHOICEBUTTON
 *  $CATEGORY$
 *     ACHOICE
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     ACHOICEBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *              to be release before proceeding.
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the GET/READ mouse 
 *      subsystem Hot Spot pool. 
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     ACHOICEButton 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     nggenrl.ngo:Button() nggenrl.ngo:RemoveButton() nggenrl.ngo:ButtonCool() nggenrl.ngo:ButtonWarm() nggenrl.ngo:BUTTON ngmenu.ngo:MENUBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

#xCommand ACHOICEBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive: INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MACHOICE, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>, !<.lInactive.>)

/*  $DOC$
 *  $COMMANDNAME$
 *     MENUBUTTON
 *  $CATEGORY$
 *     MENU TO
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     MENUBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *              to be release before proceeding.
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the MENU TO mouse 
 *      subsystem Hot Spot pool. 
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     MENUButton 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     nggenrl.ngo:Button() nggenrl.ngo:RemoveButton() nggenrl.ngo:ButtonCool() nggenrl.ngo:ButtonWarm() nggenrl.ngo:BUTTON ngachoic.ngo:ACHOICEBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/


#xCommand MENUBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive: INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MMENU, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>, !<.lInactive.>)

/*  $DOC$
 *  $COMMANDNAME$
 *     MEMOBUTTON
 *  $CATEGORY$
 *     MEMOEDIT
 *  $ONELINER$
 *     Command to make a mouse button on screen calling Button()
 *  $SYNTAX$
 *     MEMOBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
 *             ACTION <bAction> [MESSAGE <xString>] ;
 *             [KEY <nFunctionKey>] [MBUTTON <nButton>] ;
 *             [SLEEP <nSleep>] [RELEASE <lRelease>] ;
 *             [COLOR <cColor>] [INACTIVE]
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> -  Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *              to be release before proceeding.
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     INACTIVE indicates that the button is initially inactive and will
 *              not be displayed. The button can be displayed and activated
 *              with the WARMBUTTON command.
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action in the MEMOEDIT mouse 
 *      subsystem Hot Spot pool. 
 *
 *      The screen area behind the button is saved and can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     MEMOButton 0,0,0,6 TO aId1 STRING "Help" KEY K_F1 ACTION {|| MyHelp()}
 *           COLOR "W/N" SLEEP 0.1 RELEASE .T. MBUTTON 1
 *  $SEEALSO$
 *     nggenrl.ngo:Button() nggenrl.ngo:RemoveButton() nggenrl.ngo:ButtonCool() nggenrl.ngo:ButtonWarm() nggenrl.ngo:BUTTON ngbrows.ngo:BROWSEBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/


#xCommand MEMOBUTTON <nTop>, <nLeft>, <nBottom>, <nRight> TO <aId>;
			ACTION <bAction> [MESSAGE <xString>] ;
			[KEY <nFunctionKey>] [MBUTTON <nButton>] ;
			[SLEEP <nSleep>] [RELEASE <lRelease>] ;
			[COLOR <cColor>] [<lInactive:INACTIVE>];
		=> <aId> := Button(<nTop>, <nLeft>, <nBottom>, <nRight>, ;
			<xString>, <nFunctionKey>, <bAction>, MMEMOEDIT, ;
			<nButton>, <nSleep>, <lRelease>, <cColor>, !<.lInactive.>)

/*  $DOC$
 *  $COMMANDNAME$
 *     REMBUTTON
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Command to remove a mouse button on screen 
 *  $SYNTAX$
 *     REMBUTTON <aId> [RESTORE]
 *  $ARGUMENTS$
 *     <aId> which is a unique identifier of the button given by one of
 *           the button creation commands.
 *     [RESTORE] which if present, the area used by the button will be restored
 *  $DESCRIPTION$
 *      This routine provides a simple method of removing a screen button
 *
 *      The screen area behind the button can be restored when
 *      removing the hot spot.
 *  $EXAMPLES$
 *     REMButton aId1 RESTORE
 *  $SEEALSO$
 *     Button() RemoveButton() ButtonCool() ButtonWarm() nggenrl.ngo:BUTTON ngbrows.ngo:BROWSEBUTTON ngget.ngo:READBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

# xCommand REMBUTTON <aId> [<lRestore: RESTORE>] ;
		=> RemoveButton(<aId>, <.lRestore.>)


/*  $DOC$
 *  $COMMANDNAME$
 *     COOLBUTTON
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Command to suspend a mouse screen button
 *  $SYNTAX$
 *     COOLBUTTON <aId> [RESTORE]
 *  $ARGUMENTS$
 *     <aId> which is a unique identifier of the button given by one of
 *           the button creation commands.
 *     [RESTORE] if set the screen will be restored to the original under
 *           the button
 *  $DESCRIPTION$
 *      This routine provides a simple method of suspending the operation
 *      of a screen button while processing in being done for example.
 *  $EXAMPLES$
 *     COOLButton aId1 
 *  $SEEALSO$
 *     RemoveButton() ButtonCool() ButtonWarm() BUTTON ngbrows.ngo:BROWSEBUTTON WARMBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

# xCommand COOLBUTTON <aId> [<lRestore: RESTORE>] ;
		=> ButtonCool(<aId>, <.lRestore.>)


/*  $DOC$
 *  $COMMANDNAME$
 *     WARMBUTTON
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Command to reactivate a mouse screen button
 *  $SYNTAX$
 *     WARMBUTTON <aId> [RESTORE]
 *  $ARGUMENTS$
 *     <aId> which is a unique identifier of the button given by one of
 *           the button creation commands.
 *     [RESTORE] if set the button will be redrawn
 *  $DESCRIPTION$
 *      This routine provides a simple method of reactivating a screen button
 *      after it has been suspended by COOLBUTTON.
 *  $EXAMPLES$
 *     WARMButton aId1 
 *  $SEEALSO$
 *     RemoveButton() ButtonCool() ButtonWarm() BUTTON ngbrows.ngo:BROWSEBUTTON COOLBUTTON
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/

# xCommand WARMBUTTON <aId> [<lRestore: RESTORE>] ;
		=> ButtonWarm(<aId>, <.lRestore.>)
