 * File......: ATPROMPT.PRG
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 06/23/93
 * Revision..: V2.0          // Update to Clipper 5.2 release
 *
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.

#include "set.ch"
#include "Inkey.ch"
#include "setcurs.ch"

#define PRROW    1
#define PRCOL    2
#define PRCOLEND 3
#define PRPROMPT 4
#define PRMSG    5
#define PRMSGLEN 6
#define SHOWSELECT(cC, nP) SETCOLOR(cC); @aAllMenu[nCurMenu,nP,PRROW],;
                     aAllMenu[nCurMenu,nP,PRCOL];
                     SAY aAllMenu[nCurMenu,nP,PRPROMPT]; SETCOLOR(cOldColor)

#define SHOWMSG(nP)  IF aAllMenu[nCurMenu,nP,PRMSGLEN]<>0; @nMessage,;
                     IIF(lMCenter,INT((MAXCOL()-aAllMenu[nCurMenu,nP,PRMSGLEN]);
                     /2),0) SAY aAllMenu[nCurMenu,nP,PRMSG]; ENDIF

#define CLEARMSG(nP) IF aAllMenu[nCurMenu,nP,PRMSGLEN]<>0; nColl:= ;
                       IIF(lMCenter,INT((MAXCOL();
                       -aAllMenu[nCurMenu,nP,PRMSGLEN])/2),0); Scroll( ;
                     nMessage, nColl, nMessage, ;
                     nColl+aAllMenu[nCurMenu,nP,PRMSGLEN];
                     ) ; SetPos( nMessage, nColl ) ; ENDIF


STATIC aCurMenu:={}       // Structured as [Prompt#, PromptInfo]
STATIC aAllMenu:={}       // Structured as [Menu#, Prompt#, PromptInfo]
STATIC nCurMenu:=0
STATIC lMenuActive:=.F.   // Currently building a menu
STATIC lIgnoreMouse:=.F.  // Global ignore mouse
STATIC lUseMouse:=.F.
STATIC cNorm:=""
STATIC cSelected:=""
STATIC cOldColor:=""
STATIC nMessage:=0
STATIC lMCenter:=.F.
STATIC aMMouseSpot:={}
STATIC nMFree_spot:=0
STATIC cSaveDev

*+
FUNCTION __AtPrompt(nRow, nCol, cPrompt, cMsg)
 *
 * This routine and all accompaning database structures are 
 * Copyright (C) 1991 Leo J. Letendre. All rights reserved.
 *
 * Modification History:
 *        Version    Date      Who       Notes
 *         V1.00     12/22/91  LJL       Initial Version
 *
/*  $DOC$
 *  $FUNCNAME$
 *     @...PROMPT
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     @...PROMPT with mouse support
 *  $SYNTAX$
 *     In Standard Clipper:
 *        @<nRow>,<nCol> PROMPT <cPrompt> [MESSAGE <cMsg>]
 *
 *     Called as a seperate function
 *        __AtPrompt(<nRow>, <nCol>, <cPrompt>, <cMsg>)
 *  $ARGUMENTS$
 *      <nRow> - The row for the prompt
 *      <nCol> - The column for the prompt
 *      <cPrompt> - The prompt to use
 *      <cMsg> - The corresponding message
 *      
 *  $RETURNS$
 *       NIL
 *  $DESCRIPTION$
 *       This routine replaces the Clipper 5.0 __AtPrompt which is used
 *       to implement the @...PROMPT command. It operates transparently
 *       with or without the mouse. Additional Mouse Hot Spots can be 
 *       defined for interactions which do not cause the menu to terminate.
 *
 *      This routine is not limited to the 32 prompts that the CLIPPER
 *      documentation claims as its limit.
 *  $EXAMPLES$
 *      @ 1,1 PROMPT "Print" MESSAGE "Print Menu"
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
* LOCAL variables: 

*
* Entry Point
*
* If we are not currently building a menu then add to the array to store 
* another menu

IF .NOT. lMenuActive
	AADD(aAllMenu,{})
	nCurMenu++
	lMenuActive=.T.
ENDIF

* Now add the actual element - Note the order of the elements must reflect
* That of the defined constants above

AADD(aAllMenu[nCurMenu],;
	{nRow, nCol, nCol+LEN(cPrompt)-1, cPrompt, cMsg,;
	 IIF(EMPTY(cMsg),0,LEN(cMsg))})

* Now printout the menu item

cSaveDev=SET(_SET_DEVICE,"SCREEN")

@ nRow, nCol SAY cPrompt

SET(_SET_DEVICE, cSaveDev)

RETURN  NIL


* End of __AtPrompt

 *+
FUNCTION __MenuTo(bSetBlock, cVarName)
 *
 * This routine and all accompaning database structures are 
 * Copyright (C) 1991 Leo J. Letendre. All rights reserved.
 *
 * Purpose: Run the menu system adding mouse support
 *
 * Modification History:
 *        Version    Date      Who       Notes
 *         V1.00     12/22/91  LJL       Initial Version
 *         V1.01      2/5/92   LJL       Fixed calls to function keys
 *                                       so they pass the correct proc
 *                                       name, line and variable name.
 *         V1.02      3/11/92  LJL       Fixed bugs for nChoice being too
 *                                       large or <1, zero length messages
 *                                       messing up screen and spaces in
 *                                       front of prompts not being ignored.
 *
 *         V1.03      5/31/92  LJL       Changed order of testing keys so that
 *                                       redefined navigation keys are really
 *                                       redefined. This mimics Clipper 
 *                                       behavior.
/*  $DOC$
 *  $FUNCNAME$
 *     MENU TO
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     Replaces MENU TO while adding Mouse Support
 *  $SYNTAX$
 *     Standard Clipper command:
 *       MENU TO <nChoice>
 *     Called as a function:
 *       __MenuTo( <bSetBlock>, <cVarName>)
 *  $ARGUMENTS$
 *      <bSetBlock> - a Code Block which allows retrevial and
 *                  setting of the return to variable (See STD.CH)
 *      <cVarName> - Name of the variable to receive the returned
 *                 value
 *      
 *  $RETURNS$
 *      0 For abort, otherwise the number of the selected item
 *  $DESCRIPTION$
 *      This routine provides MENU TO support with mouse support.
 *      If a mouse is not present it operates as the original does.
 *
 *      This routine also provides function key support and it
 *      assumes that the full color compliment is defined
 *  $EXAMPLES$
 *      MENU TO nChoice       // Standard Command mode
 *
 *      __MenuTo({|a| IIF(a==NIL,nChoice,nChoice:=a)},"nChoice") //Function
 *                                                               // Mode
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
 *-

* LOCAL variables: 
LOCAL nStart
LOCAL lProcessing, nKey, nMouseKey, nTime, nMouseRow, nMouseCol
LOCAL nCurPrompt
LOCAL lWrap:=SET(_SET_WRAP)
LOCAL nCursor:=SETCURSOR(SC_NONE)
LOCAL lSaveMouse:=lUseMouse
LOCAL cSaveNorm:=cNorm
LOCAL cSaveSelected:=cSelected
LOCAL cSaveColor:=cOldColor
LOCAL nSaveMessage:=nMessage
LOCAL nSavelMCenter:=lMCenter

*
* Entry Point
*
* Set the menu building flag to .F.
*
lMenuActive=.F.
cVarName=UPPER(cVarName)

* Now parse the color string - Note assumes at least two colors in the
* color string

cOldColor=SETCOLOR()
cNorm=LEFT(cOldColor, (nStart:=AT(",",cOldColor))-1)
cSelected=SUBSTR(cOldColor,nStart+1)
cSelected=LEFT(cSelected,AT(",",cSelected)-1)

* Get other global  settings

lMCenter:=SET(_SET_MCENTER)
nMessage:=SET(_SET_MESSAGE)

* Find out if there is a current value of the return variable. If not then = 1

nCurPrompt=EVAL(bSetBlock)
IF EMPTY(nCurPrompt).OR.nCurPrompt<1
	nCurPrompt=1
ELSEIF nCurPrompt>LEN(aAllMenu[nCurMenu])
	nCurPrompt=LEN(aAllMenu[nCurMenu])
ENDIF

* Now set up the mouse
IF !lIgnoreMouse
	lUseMouse=FT_MINIT()
ELSE
	lUseMouse=.F.
ENDIF

* now show the current selected string and message

ChangePrompts(,nCurPrompt)

* Now go into the input processing loop

lProcessing=.T.

DO WHILE lProcessing


* Put the current value of the prompt into the return value

	EVAL(bSetBlock,nCurPrompt)

* everything's done; just wait for a key or mouse input
* Show and hide the cursor so that others won't have to worry
* about writing over it.

	IF lUseMouse
		FT_MSHOWCRS()

		nKey=0
		nMouseKey=0
* clear all relase counts

		FT_MBUTREL(0)
		FT_MBUTREL(1)
		FT_MBUTREL(2)

		DO WHILE (nKey=0).AND.(nMouseKey=0)
			nMousekey=FT_MGETPOS(@nMouseRow,@nMouseCol)
			nKey=INKEY()
		ENDDO

* if we have input from the mouse then convert the mouse coordinates
* Get time so we can time a double click if necessary

		IF  nMouseKey>0
			nTime=SECOND()
		ENDIF

	ELSE
		nMouseKey=0
		nKey=INKEY(0)
	ENDIF

 /* process input */

	DO CASE
		CASE nKey == K_ESC
 /* Exit so do it */
			lProcessing = .F.
			nCurPrompt=0

 /* Mouse input */
		CASE nMouseKey>0

			lProcessing = MouseFunc(nMouseKey,nMouseRow,nMouseCol,;
						nTime,@nCurPrompt)

 /* Normal Key input */

		CASE nKey != 0
			lProcessing = ApplyKey(nKey,@nCurPrompt,cVarName)

	ENDCASE

ENDDO  // for WHILE (lProcessing)


* Turn off mouse if necessary

IF lUseMouse
	FT_MHIDECRS()
ENDIF


* Restore color settings and other settings

cNorm=cSaveNorm
cSelected=cSaveSelected
cOldColor=cSaveColor
nMessage= nSaveMessage
lMCenter= nSavelMCenter
lUseMouse=lSaveMouse

SETCURSOR(nCursor)

* Decrement the active menu value and remove old menu

nCurMenu--
ASIZE(aAllMenu,nCurMenu)

* Return to caller

RETURN nCurPrompt

* End of __MenuTO


*****
*
* ApplyKey
*
* This routine handles the appropriate action for each key entered
*
* Calling parameters: nKey - the inkey code of the pressed key
*                     nCurPrompt - The current prompt number
*                     cVarName - The current input variable
*
* Returns: .T. if the MENU should continue, .F. if it should not. 
*
STATIC FUNCTION ApplyKey(nKey, nCurPrompt, cVarName)

* Local variables

LOCAL lMore:=.T.  && signal to continue menu - default is yes
LOCAL nNewPrompt, nChoice
LOCAL bKeyBlock, nKey1
LOCAL lTestFuncKeys:=.T.

* Now handle any function keys specified by caller

IF ((bKeyBlock:=SetKey(nKey)) <> NIL)
	IF lUseMouse
		FT_MHIDECRS()
	ENDIF

	cSaveDev=SET(_SET_DEVICE,"SCREEN")

	EVAL(bKeyBlock,PROCNAME(2), PROCLINE(2), cVarName)

	SET(_SET_DEVICE, cSaveDev)

	IF lUseMouse
		FT_MSHOWCRS()
	ENDIF
	lTestFuncKeys=.F.

ELSE

* Scan for the first occurance of any letter input

	nKey1=UPPER(CHR(nKey))

	nChoice=ASCAN(aAllMenu[nCurMenu],;
			{|a| nKey1==UPPER(LEFT(lTrim(a[PRPROMPT]),1))})

* If the key matches then move

	IF nChoice>0

		ChangePrompts(nCurPrompt,nChoice)
		lMore=.F.
		nCurPrompt=nChoice
		lTestFuncKeys=.F.
	ENDIF
ENDIF

* handle the movement keys

IF lTestFuncKeys

  DO CASE
     CASE ( nKey == K_DOWN .OR. nKey == K_RIGHT)
        nNewPrompt=nCurPrompt+1
        IF nNewPrompt>LEN(aAllMenu[nCurMenu])
		IF SET(_SET_WRAP)
			nNewPrompt=1
		ELSE
			nNewPrompt=nCurPrompt
		ENDIF
        ENDIF
		IF nCurPrompt<>nNewPrompt

			ChangePrompts(nCurPrompt,nNewPrompt)
			nCurPrompt=nNewPrompt
		ENDIF

     CASE ( nKey == K_UP .OR. nKey == K_LEFT)
        nNewPrompt=nCurPrompt-1
        IF nNewPrompt=0
		IF SET(_SET_WRAP)
			nNewPrompt=LEN(aAllMenu[nCurMenu])
		ELSE
			nNewPrompt=nCurPrompt
		ENDIF
        ENDIF
		IF nCurPrompt<>nNewPrompt

			ChangePrompts(nCurPrompt,nNewPrompt)
			nCurPrompt=nNewPrompt
		ENDIF
     CASE ( nKey == K_PGDN .OR. nKey == K_PGUP )
        lMore=.F.

     CASE ( nKey == K_HOME )
         nNewPrompt=1
		IF nCurPrompt<>nNewPrompt

			ChangePrompts(nCurPrompt,nNewPrompt)
			nCurPrompt=nNewPrompt
		ENDIF

     CASE ( nKey == K_END )
		nNewPrompt=LEN(aAllMenu[nCurMenu])
		IF nCurPrompt<>nNewPrompt

			ChangePrompts(nCurPrompt,nNewPrompt)
			nCurPrompt=nNewPrompt
		ENDIF

     CASE ( nKey == K_RETURN )
		lMore=.F.

     ENDCASE

ENDIF

* Done so return

RETURN lMore

* End of ApplyKey

*+
STATIC FUNCTION ChangePrompts(nCurPrompt, nNewPrompt)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: Switch prompts
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     12/22/91   LJL       Initial Version
*
* Calling parameters: nCurPrompt - The current highlighted prompt
*                     nNewPrompt - The new highlighted prompt
*
* Returns: NIL
*
* Notes: 
*-
* LOCAL variables: 
LOCAL nColl

*
* Entry Point
*
* Change prompt back to the unselected color
*

IF lUseMouse
* Turn off cursor
	FT_MHIDECRS()
ENDIF

cSaveDev=SET(_SET_DEVICE,"SCREEN")

IF nCurPrompt<>NIL
	SHOWSELECT(cNorm, nCurPrompt)

* Clear message

	CLEARMSG(nCurPrompt)

ENDIF


IF nNewPrompt<>NIL
* Now put up the new prompt and message

	SHOWSELECT(cSelected, nNewPrompt)

	SHOWMSG(nNewPrompt)
ENDIF

SET(_SET_DEVICE, cSaveDev)

IF lUseMouse

* Turn off cursor
	FT_MSHOWCRS()

ENDIF

RETURN NIL

* End of ChangePrompt

*****
*
* MouseFunc()
*
* This function determines if the mouse is in the menu area and if it is then
* action needs to be taken. 
* Additionally this routine processes any screen "hot spots" which are selected
* by the user. 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     12/22/91  LJ Letendre   Initial Version
*
* Calling Parameters:
*                    nButton - Button which was hit - reserved for future
*                    nRow - Row coordinate of mouse pointer when button hit
*                    nCol - Col coordinate of mouse pointer
*                    nTime - The system time that the button was clicked
*                    nCurPrompt - The currently selected prompt
*
* Returns: .F. is an item was selected otherwise .T.
*
* Notes: The processing of "Hot Spots" occurs prior to checking for the
* cursor being in the Menu. Therefore, the code block will be executed
* without the check for moving the cursor to another portion of the Menu.
*
*

STATIC FUNCTION MouseFunc(nButton, nRow, nCol, nTime, nCurPrompt)

*
* Local variables:
*
LOCAL j, working, done, i, lResult:=.T.
LOCAL nRel:=0, nSelect, nColl

* if we have input from the mouse then convert the mouse coordinates

nRow=INT(nRow/8)
nCol=INT(nCol/8)

* Set flag to denote completion

cSaveDev=SET(_SET_DEVICE,"SCREEN")

* Check the general hot spots first

FT_MHIDECRS()
working=GeneralSpot(nButton, nRow, nCol, nTime)
FT_MSHOWCRS()

* First check to see if any action hot spots were clicked on

j=LEN(aMMouseSpot)
DO WHILE (j>=1.AND.working)

* Check coordinates
	working=.NOT.(aMMouseSpot[j,9].AND.;
				nRow>=aMMouseSpot[j,1].AND.nRow<=aMMouseSpot[j,3].AND.;
				nCol>=aMMouseSpot[j,2].AND.nCol<=aMMouseSpot[j,4].AND.;
				(aMMouseSpot[j,8]=0.OR.aMMouseSpot[j,8]=nButton))

* If we have a match then execute the code block

	IF .NOT.working

* do the request

		FT_MHIDECRS()
		EVAL(aMMouseSpot[j,5],nButton,nRow,nCol,nTime,j)
		FT_MSHOWCRS()

* Wait for release if requested
		IF aMMouseSpot[j,7]
			DO WHILE FT_MBUTREL(0)=0
			ENDDO
		ENDIF

* Pause for the minimum amount of time
		IF aMMouseSpot[j,6]>0
			sleep(aMMouseSpot[j,6],nTime)
		ENDIF

	ENDIF
* increment counter
	j--

ENDDO

* Now look to see if the mouse cursor is on a prompt

IF working .AND. nButton=1

	DO WHILE nRel=0

		nSelect=ASCAN(aAllMenu[nCurMenu],;
			{|a| nRow=a[PRROW].AND.nCol>=a[PRCOL].AND.nCOl<=a[PRCOLEND]})

		IF nSelect>0 

* If we are on a prompt move to it

			IF nSelect<> nCurPrompt
				FT_MHIDECRS()
				SHOWSELECT(cNorm,nCurPrompt)

				CLEARMSG(nCurPrompt)

* Now put up the new

				nCurPrompt=nSelect
				SHOWSELECT(cSelected,nCurPrompt)
				SHOWMSG(nCurPrompt)
				FT_MSHOWCRS()
			ENDIF
			lResult=.F.
		ELSE
			lResult=.T.

		ENDIF

		FT_MBUTREL(0,@nRel)

* Need to do this since mouse driver returns the row and col of the last
* release 

		FT_MGETPOS(@nRow,@nCol)
		nRow=INT(nRow/8)
		nCol=INT(nCol/8)

	ENDDO
* Pause for button release for cases of a bouncing mouse

	DO WHILE FT_MBUTPRS()<>0
	ENDDO

ENDIF

* reset device

SET(_SET_DEVICE, cSaveDev)

* Now return

RETURN lResult

* End of  MouseFunc

******
*
* MHotSpot()
*
* This function allows the caller to define a location on the screen which
* if clicked on with the mouse will cause an action to take place.
*
* Modification History:
*        Version    Date      Who         Notes
*         V1.00     12/22/91  LJL         Initial Version
* 
/*  $DOC$
 *  $FUNCNAME$
 *     MHOTSPOT()
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     Defines Mouse Hot spots for @PROMPT/MENU TO
 *  $SYNTAX$
 *     MHotSpot( <nTopRow>, <nLeftCol>, <nBotRow>, <nRightCol>, <bAction>, ;
 *                <nButton>, <nSleep>, <lRelease>) -> nId
 *
 *  $ARGUMENTS$
 *     <nTopRow> - the top row of the area 
 *     <nLeftCol> - the left column of the area
 *     <nBotRow> - the bottom row of the area
 *     <nRightCol> - the right column of the area 
 *     <bAction> - Code block which will be executed when
 *              mouse is clicked in the area
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on 
 *              clicking anybutton (the code block can decide 
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presses. 
 *              Prevents routine from operating too quickly and 
 *              reading the press of a button multiple times 
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> - Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *     
 *  $RETURNS$
 *     nId which is an ID to be used to remove the area with a call
 *              to MRemHotSpot(nId)
 *  $DESCRIPTION$
 *     This routine defines a hot spot for @PROMPT/MENU TO, which will be 
 *     activated it the user clicks the mouse in the defined area. The 
 *     action which is executed is defined by the code block bAction 
 *     which is called with four arguments:
 *
 *                 nButNum: the number of the button pressed with
 *                          1=left, 2=right, 4=middle(?).
 *                 nRow: The row that the mouse cursor was in when it
 *                       was clicked
 *                 nCol: The column that the mouse cursor was in when it
 *                       was clicked
 *                 nTime: The time returned by SECOND() shortly after the
 *                       button was clicked.
 *                 nId:   The hot spot Id number.
 *
 *        Thus the code block should have a form similar to the following
 *        if one wishes to use the button/cursor information:
 *
 *      {|nButNum, nRow, nCol, nTime, nId| MyFunc(NButNum,nRow,nCol,nTime,nId)}
 *
 *  $EXAMPLES$
 *      MHotSpot(1,10,1,20,{|| ShowHelp()},1,,.T.) // hot spot shows help
 *  $SEEALSO$
 *      MCOOLSPOT() MWARMSPOT() MREMHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION MHotSpot( nTopRow, nLeftCol, nBotRow, nRightCol, bAction, nButton,;
				 nSleep, lRelease)
*
* Local variables
*

* Entry point

* Now add the coordinates

RETURN AddHotSpot(aMMouseSpot,@nMfree_spot,;
                 {nTopRow, nLeftCol, nBotRow, nRightCol, bAction,;
                  IIF(nSleep=NIL,MDefSleep(),nSleep),;
                  IIF(lRelease=NIL,MDefRelease(),lRelease),;
                  IIF(nButton=NIL,0,nButton),.T.})

* End of MAddHotSpot

******
*
* MRemHotSpot()
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     12/22/91  LJL           Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MREMHOTSPOT()
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     This subroutine clears the specified @PROMPT/MENU TOHotspot 
 *  $SYNTAX$
 *     MRemHotSpot( <nId> ) -> NIL
 *  $ARGUMENTS$
 *     <nID> - the ID number of the region to remove from active duty. 
 *             It is given by MHotSpot.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine removes a mouse hot spot from the @PROMPT/MENU TO
 *      list of active hot spots.
 *  $EXAMPLES$
 *      MRemHotSpot(nHelpId)
 *  $SEEALSO$
 *      MHOTSPOT() MCOOLSPOT() MWARMSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION MRemHotSpot(nID)
*
* Local variables
*

* Call service routine

nMFree_Spot=RemHotSpot(nId, aMMouseSpot, nMFree_Spot)

RETURN NIL

* End of MRemHotSpot

******
*
* MCoolSpot()
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     12/22/91  LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MCOOLSPOT()
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     This subroutine deactivates the specified MENU TO Hot Spot
 *  $SYNTAX$
 *     MCOOLSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the @PROMPT/MENU TO Hot Spot to remove 
 *           from active duty. It is given by MHotSpot.
 *
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine deactivates the specified hot spot without removing it
 *      from the list of hot spots. It can later be reactivated with
 *      MWarmSpot()
 *
 *  $EXAMPLES$
 *      MCoolSpot(nHelpId)   // Cool off the help hot spot
 *
 *  $SEEALSO$
 *      MWARMSPOT() MREMHOTSPOT() MHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
*
FUNCTION MCoolSpot(nID)
*
* Local variables
*

aMMouseSpot[nid,9]=.F.

RETURN NIL

* End of MCoolSpot

******
*
* MWarmSpot()
*
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     12/22/91   LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MWARMSPOT()
 *  $CATEGORY$
 *     Menu To
 *  $ONELINER$
 *     This subroutine reactivates the specified MENU TO Hot Spot
 *  $SYNTAX$
 *     MWARMSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the @PROMPT/MENU TO Hot Spot to return to 
 *           active duty. It is given by MHotSpot and should have been 
 *           deactivated by MCoolSpot()
 *
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine reactivates the specified @PROMPT/MENU TO hot spot 
 *      after having been deactivated by MCoolSpot(). 
 *
 *  $EXAMPLES$
 *      MWarmSpot(nHelpId)   // Turn the help hot spot back on
 *
 *  $SEEALSO$
 *      MCOOLSPOT() MREMHOTSPOT() MHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION MWarmSpot(nID)
*
* Local variables
*

aMMouseSpot[nId,9]=.T.

RETURN NIL

* End of MWarmSpot

*****
*
* function MIgnoreMouse()
*
* Purpose: force the routines to ignore the mouse and perform the overhead
*          necessary for mouse support
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     12/22/91  LJL       Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MIGNOREMOUSE()
 *  $CATEGORY$
 *      Menu To
 *  $ONELINER$
 *     Ignore the mouse if present when executing @PROMPT/MENU TO
 *  $SYNTAX$
 *     MIGNOREMOUSE( <lIgnore> ) -> lCurrent
 *  $ARGUMENTS$
 *     <lIgnore> - logical for ignoring mouse .T. = act as if mouse
 *               is not present. If absent just returns current setting
 *
 *  $RETURNS$
 *     Setting in effect prior to call as a logical.
 *  $DESCRIPTION$
 *     This routine causes the MENU TO routine to ignore the mouse if present
 *     based upon the passed parameter. the current (prior to the call) 
 *     value is returned. If not parameter is passed, only the current setting
 *     is returned.
 *  $EXAMPLES$
 *     lOldSetting := MIgnoreMouse(.T.)
 *  $SEEALSO$
 *     "MENU TO"
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION MIgnoreMouse(lIgnore)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=lIgnoreMouse

IF lIgnore!=NIL
	lIgnoreMouse=lIgnore
ENDIF

RETURN oldsetting

* End of MIgnoreMouse
