//.............................................................................
//
//   Program Name: NTXPOS.C          Copyright: RCM Software Pty. Ltd.                                   
//   Date Created: 27/04/91           Language: Microsoft C 5.1                                         
//   Time Created: 17:49:22             Author: Graham D. McKechnie                       
//
//   Modified 9/25/92 7:00 pm
//   by Brian Marasca
//   Use index handle rather than file name.
//   IndexOrd() is now passed as parameter 1.
// 
//   Returns index record number
//   eg. nNtxPos := NtxPos( IndexOrd(), RECNO() )
//.............................................................................
        
#include "extend.h"
#include "stdio.h"

#define open  _topen                // Use Clipper's internals
#define close _tclose               // Don't have to link LLIBCA
#define lseek _tlseek
#define read  _tread

extern int  _topen( char*, int);
extern int  _tclose( int );
extern long _tlseek( int, long, int);
extern int  _tread( int, char*, int);

#define BUFF_SIZE   1024
#define ERROR       -1
#define MAX_KEY     256
#define O_RDONLY    0x0000  // open for reading only 
#define O_BINARY    0x8000  // file mode is binary (untranslated) 


// Index structures 
typedef struct
{
   unsigned  uSign;
   unsigned  uVersion;
   long      lRoot;
   long      lNextPage;
   unsigned  uItemSize;
   unsigned  uKeySize;
   unsigned  uKeyDec;
   unsigned  uMaxItem;
   unsigned  uHalfPage;
   char      cKeyExpr[MAX_KEY];
   Boolean   bUnique;
} NTXHEADER;


typedef struct
{
   long lPage;
   long lRecNo;
   char cKey;
} ITEM;


typedef struct
{
   unsigned uCount;
   unsigned uRef;
} BUFFER;



static Boolean bError = FALSE;
static Boolean bFound = FALSE;

static long lRetVal;            // Return value
static long lNtxPos;            // Index position
static int  nNtxHandle;         // Index file handle


CLIPPER ntxpos()
{
   long lRecNo;
   int nNtxOrd;
   long nNtxPtr;

   NTXHEADER NtxHeader;

   // Check the parameters passed from Clipper
   if ( PCOUNT != 2 )
   {
      _retni(-1);
      return;
   }

   if ( ! (ISNUM(1) && ISNUM(2) ) )
   {
      _retni(-1);
      return;
   }

   nNtxOrd  = _parni(1);    // indexord() to go by
   lRecNo   = _parnl(2);    // RECNO() we are looking for

   lRetVal  = 0L;           // Set these each time
   lNtxPos  = 0L;
   bFound   = FALSE;

   if ( ( nNtxHandle = getNtxHandle ( nNtxOrd ) ) != -1 )
   {
        /* save the ntx file position and reset it to the top */
        nNtxPtr = _tlseek( nNtxHandle, 0L, SEEK_CUR );
        _tlseek( nNtxHandle, 0L, SEEK_SET );

        /* read the header */
        if ( read ( nNtxHandle, (char *) &NtxHeader, sizeof(NtxHeader) )
                       != sizeof(NtxHeader) )
        goto ERROR_EXIT; 

        /* start the traversal from root */
        DumpPage( NtxHeader.lRoot, lRecNo );

        if (bError)
        {
             ERROR_EXIT:
             bError = TRUE;
        }

        /* restore the ntx file position */
        _tlseek( nNtxHandle, nNtxPtr, SEEK_SET );
   }

   _retnl( lRetVal );

}



DumpPage(long lPageOffSet, long lRecNo)

{
   char     *cPage;
   ITEM     *item;
   BUFFER   *buffer;
   unsigned i;
   unsigned *uItemRef;

   /* allocate page */
   cPage = _xalloc(BUFF_SIZE);

   /* move to this position in the file */
   if( lseek( nNtxHandle, lPageOffSet, 0 ) != (long)lPageOffSet )
      goto DUMP_EXIT;

   /* read the page */
   if( read( nNtxHandle, cPage, BUFF_SIZE) != BUFF_SIZE )
      goto DUMP_EXIT;


   buffer   = (BUFFER *) cPage;
   uItemRef = &buffer -> uRef;


   for (i = 0; i < buffer -> uCount; i++)
   {
      item = (ITEM *) &cPage[ uItemRef[ i ] ];

      if ( ! bFound )
      {
         if ( item -> lPage )
            DumpPage( item -> lPage, lRecNo );

         if (bFound)
         {
            _xfree( cPage );
            return;
         }  
         lNtxPos++;
      }

      if ( item->lRecNo == lRecNo )
      {
         lRetVal = lNtxPos;
         bFound = TRUE;
         break;
      }
   }

   /* handle extra right pointer */
   item = (ITEM *) &cPage[ uItemRef[ buffer -> uCount ] ];    
   if (item -> lPage)
      DumpPage(item -> lPage, lRecNo );

   _xfree( cPage );

   if ( bError )
   {
      DUMP_EXIT:
      _xfree( cPage );
      bError = TRUE;
   }
}

/**************************************************************************
   FUNCTION: getNtxHandle ( n )
   Returns the index handle for the current workarea, or -1 if error.
   Brian Marasca 9/25/92
**************************************************************************/

static int getNtxHandle ( n )
int n ;
{
     extern char **_workareas ;
     int **hp, han = -1 ;

     if(n > 0 && n <= 15)
     {
          hp = (int **) ((*_workareas) + 0x98 + ((n-1) * sizeof (char *))) ;
          han = *hp ? **hp : -1 ;
     }

     return han ;
}

