#include "INKEY.CH"
#include "BOX.CH"
#include "mbrowse.ch"
#include "setcurs.ch"
#include "mouse.ch"

#include "cswimfld.ch"
#include "cntryfld.ch"

#define FREE 4
#define BACK 1
#define BREAST 2
#define FLY 3
#define IM 5
#define MAXHEATS 6

MEMVAR getlist


STATIC lane_1, lane_2, lane_3, displayage, agegroup
STATIC nMaxHeats
STATIC event_sex
STATIC mouseupdate   // Keeps track of updating a get using the mouse functions
STATIC lUseMouse

* nScrollNum is the total number of records in the scroll array
* scrolstart is the line begining the scrolling area
* scrolbot is the bottom of the scrolling area

STATIC scrolstart, nScrollNum, scrolbot
STATIC scrolswim:={}, scrolname:={}
STATIC nErrorLine:=24, lErrorSet:=.F.

STATIC aEvent[5,3*MAXHEATS]
STATIC aSave[5,3*MAXHEATS]
STATIC aNumber[5,3*MAXHEATS]
STATIC aTime[5,3*MAXHEATS]
STATIC aEtimes[5,100,2]

STATIC start_age, end_age  // For scrolling below entry
STATIC oBrowse

* the following is a hot spot function for the Get system which in turn
* performs work on the TBROWSE object

STATIC bBrowseSpot:=    {|nB,nX,nY,nTime,cSaveC,nSaveCur| cSaveC:=SETCOLOR(),;
						SETCURSOR(SC_NONE),;
						BRMouseFunc(oBrowse,nB,nX,nY,nTime),;
						oBrowse:ForceStable(),;
						BRUpdateScroll(oBrowse),;
						SETCOLOR(cSaveC),;
						SETCURSOR(SC_NORMAL)}


STATIC aChangeAge, aPreSeed, aCancelSeed, aSaveSeed

*+
FUNCTION seed_meet
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: enter actual seeding information
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL       Demo Version
*
* Calling parameters: none
*
* Notes: limited to three heats per event per age group
*-
* Private variables: 
LOCAL savescr, saveclr, redo, choice
LOCAL savedbf, bad_list:={}
LOCAL iSaveErrorLine
LOCAL cSaveGlobalColor:=SETCOLOR("W/B,W/N,,,B/W")

LOCAL nRecNumber
*
* Entry Point
*
* See if mouse is present
lUseMouse=FT_MINIT()

SAVE SCREEN TO savescr
CLEAR SCREEN

savedbf=SELECT()

* Put up the screen

nMaxHeats=2   // VAL(meet_file->mt_maxheat)

iSaveErrorLine=SETERRORLINE(4*nMaxHeats)


* Get working age group

event_sex=" "
agegroup=6
agegroup=age_menu(@event_sex,agegroup)
displayage=agegroup
redo=.F.
mouseupdate=.F.

* Change the number of lines in the screen

IF nMaxHeats>2
	IF !SETMODE(43,80)
		SETMODE(40,80)
	ENDIF
ENDIF

CLEAR SCREEN
* Put up the events to be filled in

putevents()

DO WHILE agegroup>5

* load up fields for screen

	IF .NOT.redo
		saveclr=SETCOLOR("W/N")
		@ 0,0 SAY event_sex+" "+STR(agegroup,2,0)+"&U"
		SETCOLOR(saveclr)

		loadevents()
		nRecNumber=showswimrs()

	ENDIF

	SELECT cool_swim
	SET ORDER TO 3		&& age group index_number
	GOTO nRecNumber

	DO getevents

	SET ORDER TO 1
	SELECT meet_entry
	bad_list={}
	IF LASTKEY()<>K_ESC
		IF UPDATED().OR.mouseupdate
			SELECT meet_entry
			bad_list=saveevents()
			mouseupdate=.F.
		ENDIF
		IF LEN(bad_list)=0
			choice:=ALERT("Enter choice for next action",;
					{"Next", "Previous", "Select", "Redo", "Exit"},,12)
			redo=.F.
		ELSE
			IF .NOT.showbad(bad_list)
				choice=4   // Redo
			ELSE
				choice:=ALERT("Enter choice for next action",;
					{"Next", "Previous", "Select", "Redo", "Exit"},,12)
				redo=.F.
			ENDIF
				
		ENDIF
		DO CASE
			CASE choice=1 // Next
				IF agegroup=18.AND.event_sex="M"
					agegroup=0
				ELSEIF event_sex=="F"
					event_sex="M"
				ELSE
					event_sex="F"
					agegroup=age_group(agegroup+2)
				ENDIF
				displayage=agegroup
			CASE choice=2   // Previous
				IF agegroup=6.AND.event_sex="F"
					agegroup=0
				ELSEIF event_sex=="M"
					event_sex="F"
				ELSE
					event_sex="M"
					agegroup=IIF(agegroup=18,14,age_group(agegroup-2))
				ENDIF
				displayage=agegroup
			CASE choice=3  // Select
				agegroup=age_menu(@event_sex,agegroup)
				displayage=agegroup
			CASE choice=4  // Redo
				redo=.T.
			CASE choice=5.OR.choice=0  // Exit
				agegroup=0
		ENDCASE

	ELSE
		agegroup=0
	ENDIF

ENDDO

COMMIT

* restore screen

SETMODE(25,80)
RESTORE SCREEN FROM savescr

SELECT cool_swim
SET FILTER TO
SELECT(savedbf)
SetErrorLine(iSaveErrorLine)

SETCOLOR(cSaveGlobalColor)

RETURN NIL

* End of seed_meet


*+
FUNCTION showswimrs
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: set up and display a list of swimmers in this age/sex combination
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* returns current record number
*
* Notes: none
*-
* Private variables: 
LOCAL i, olddbf, times, saveclr, doit
LOCAL fields:={}, nSaveRec, cSeekString
*
* Entry Point
*
* Set up databases in the right way

SELECT meet_entry
SET ORDER TO 2		&& swim number index_number
SELECT cool_swim
SET ORDER TO 3		&& availability age group index_number
GOTO TOP

* Normal relays and individual events

cSeekString=event_sex+STR(displayage,2,0)
start_age:=end_age:=displayage

SET SOFTSEEK ON
SEEK cSeekString
SET SOFTSEEK OFF
nSaveRec=RECNO()

* Fill the scrolling array up

scrolswim={}
scrolname={}
i=1
DO WHILE .NOT.EOF().AND.(sw_age_grp>=start_age).AND.;
	(sw_age_grp<=end_age).AND.(sw_sex==event_sex).AND.sw_availbl

* If called by relays then use only those entered in the meet

* Now load up those that should be present

	aEtimes[IM,i]={IIF(sw_event1>0,sw_event1,999),i}
	IF displayage<11
		aEtimes[FREE,i]  ={IIF(sw_event2>0,sw_event2,999),i}
		aEtimes[BREAST,i]={IIF(sw_event3>0,sw_event3,999),i}
		aEtimes[BACK,i]  ={IIF(sw_event4>0,sw_event4,999),i}
		aEtimes[FLY,i]   ={IIF(sw_event5>0,sw_event5,999),i}
	ELSE
		aEtimes[FREE,i]  ={IIF(sw_event6>0,sw_event6,999),i}
		aEtimes[BREAST,i]={IIF(sw_event7>0,sw_event7,999),i}
		aEtimes[BACK,i]  ={IIF(sw_event8>0,sw_event8,999),i}
		aEtimes[FLY,i]   ={IIF(sw_event9>0,sw_event9,999),i}
	ENDIF

	AADD(scrolswim,sw_number)
	AADD(scrolname,short_name(sw_last,sw_first))

	i=i+1
	SKIP
ENDDO

* Number of swimmers in scroll

NScrollNum=i-1

* Scroll area coordinates

scrolstart=2+4*nMaxHeats
scrolbot=MAXROW()-2
@ scrolstart,0 CLEAR TO scrolbot+1,MAXCOL()


IF NScrollNum=0

	@ scrolStart,2 SAY " No swimmers in age group"
ELSE

* Sort relay times if necessary
	FOR i=1 TO 5

		ASORT(aEtimes[i],1,NScrollNum,{|a,b| a[1]<b[1]})

	NEXT


* Put up screen


	AADD(fields,{"# Name",;
		{|| STR(ASCAN(scrolswim,sw_number),2,0)+" ";
			+PAD(rev_name(sw_first,"",sw_last),22)},,,,,;
			{|| IIF(sw_worker,{7,8},{1,2})}})
	IF displayage<11

		AADD(fields,{" Free",  {|| IIF(sw_event2>0,time_str(sw_event2,7),"       ")}})
		AADD(fields,{"Breast",{|| IIF(sw_event3>0,time_str(sw_event3,7),"       ")}})
		AADD(fields,{" Back",  {|| IIF(sw_event4>0,time_str(sw_event4,7),"       ")}})
		AADD(fields,{"  Fly",   {|| IIF(sw_event5>0,time_str(sw_event5,7),"       ")}})
	ELSE
		AADD(fields,{" Free",  {|| IIF(sw_event6>0,time_str(sw_event6,7),"       ")}})
		AADD(fields,{"Breast",{|| IIF(sw_event7>0,time_str(sw_event7,7),"       ")}})
		AADD(fields,{" Back",  {|| IIF(sw_event8>0,time_str(sw_event8,7),"       ")}})
		AADD(fields,{"  Fly",   {|| IIF(sw_event9>0,time_str(sw_event9,7),"       ")}})
	ENDIF
	AADD(fields,{"  IM",   {|| IIF(sw_event1>0,time_str(sw_event1,7),"       ")}})

	GOTO nSaveRec

// Here we build a browse without executing it so that it can be run during the
// READ. We use the alternate reader to initiate a transfer to the get system
// because it is the easiest way to get a double click to work.

	BUILDBROWSE fields,scrolstart,1,scrolbot,maxcol()-1 TO oBrowse;
		WHILE {|| (sw_age_grp>=start_age.AND.sw_age_grp<=end_age.AND.sw_sex==event_sex;
			.AND.sw_availbl)} ;
		KEY cSeekString ;
		READINIT DOUBLE_CLICK_GET ;
		ALTREAD {|| mouseadd()} ;
		RECORDTOTAL {|| nScrollNum} ;
		COLORS "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, R/BG";
		RECORDNUM {|| ASCAN(scrolswim,sw_number)}

	oBrowse:ForceStable()


	saveclr=SETCOLOR("W/N")
	@ MAXROW()-1,1 SAY "F9,F10 to scroll swimmers. F7,F8 move down,up event. F6 change list age group"
ENDIF

* Reset colors since things are so complicated

SETCOLOR(saveclr)

RETURN nSaveRec

* End of showswimrs

*+
FUNCTION getevents
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Get the event entries
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: 
*-
* Private variables: 
LOCAL pic, i, cColorString, sp, nId3
LOCAL j, k
LOCAL cString:="Enter swimmer's name or number. Hit Esc to exit without saving."
*
* Entry Point
*
pic="@K XXXXXXXXXXXXXX"
sp= "              "

@ MAXROW(), Center(cString) SAY cString

FOR k=2 TO 5
	j=1
	FOR i=1 TO 3*nMaxHeats
		@ j, (15*k-27) GET aEvent[k,i] PICTURE pic VALID fillname()
		j+=IIF(INT(i/3)*3=(i),2,1)
	NEXT
NEXT

j=1
FOR i=1 TO 3*nMaxHeats 
	IF agegroup>9.AND..NOT.agegroup=14
		@ j,63 GET aEvent[1,i] PICTURE pic VALID fillname()
	ELSE
		@ j,63 SAY sp
	ENDIF
	j+=IIF(INT(i/3)*3=(i),2,1)
NEXT



SET KEY K_F9 TO scrollup
SET KEY K_F10 TO scrolldown

* Now put up mouse hot spots buttons. These control the options available
* by both keyboard and mouse click.

cColorString="W+/R,N/W,,,N/N"

BUTTON scrolstart-1, 25, scrolstart-1, 36 TO aPreSeed ACTION {|| Pre_seed()} ;
	MESSAGE "Top Swimmers" KEY K_F5 RELEASE .T. COLOR cColorString
BUTTON scrolstart-1, 38, scrolstart-1, 46 TO aChangeAge ACTION {|| Change_Age()} ;
	MESSAGE "Age Group" KEY K_F6 RELEASE .T. COLOR cColorString
BUTTON scrolstart-1, 65, scrolstart-1, 70 TO aCancelSeed ACTION ;
	{|| __Keyboard(CHR(K_ESC))} MESSAGE "Cancel" RELEASE .T. COLOR cColorString
BUTTON scrolstart-1,72,scrolstart-1,75 TO aSaveSeed ACTION ;
	{|| __Keyboard(CHR(K_PGDN))} MESSAGE "Save" RELEASE .T. COLOR cColorString

* Build a hot spot over the entire TBROWSE portion of the screen

IF NScrollNum>0
	nId3=RDHotSpot(scrolstart,0,scrolbot,MAXCOL()-1,bBrowseSpot)
ENDIF

READ

* Reset the scrolling keys and the Mouse hot spot

IF NScrollNum>0
	RDRemHotSpot(nId3)
ENDIF

REMBUTTON aChangeAge
REMBUTTON aPreSeed
REMBUTTON aCancelSeed
REMBUTTON aSaveSeed 

SET KEY K_F9 TO
SET KEY K_F10 TO

RETURN NIL

* End of getevents

*+
FUNCTION pre_seed()
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: show a list of the six fastest swimmers in each event for selection
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Returns : NIL
*
* Notes: 
*-
* LOCAL variables: 
#define SAVE_TOPROW   16
#define SAVE_TOPCOL   66
#define SAVE_BOTROW   21
#define SAVE_BOTCOL   75
#define CAN_TOPROW    16
#define CAN_TOPCOL     4
#define CAN_BOTROW    21
#define CAN_BOTCOL    12

LOCAL i, j, savescr, savecolor
LOCAL event_order:={FREE, BREAST, BACK, FLY, IM}
LOCAL event, inited_mouse:=.F.
LOCAL select_swims[5,6], orig_get, event_num, max_event
LOCAL num_swimers:={0,0,0,0,0}
LOCAL base_row, base_col, done, nKey, mouse_key, nTime, mouse_row
LOCAL mouse_col, click_event, click_swim, insert_count, col
LOCAL swimmer, g

*
* Entry Point
*
* save the screen
savescr=SAVESCREEN(7,0,24,79)

* Fill selected swimmers list
AFILL(select_swims[1],.F.)
AFILL(select_swims[2],.F.)
AFILL(select_swims[3],.F.)
AFILL(select_swims[4],.F.)
AFILL(select_swims[5],.F.)

* change colors

COOLBUTTON aPreSeed

savecolor=SETCOLOR("W+/R,N/W,,,N/N")

* Clear my part of the world

@ 7,3 CLEAR TO 24, 76

* Now put up some boxes

@ 7,5,14,75 BOX B_SINGLE
@ 7,16 SAY "Free"
@ 7,38 SAY "Breast"
@ 7,61 SAY "Back"

IF agegroup>9
	@ 14,16,21,64 BOX B_SINGLE
	@ 14,16 SAY CHR(194)
	@ 14,64 SAY CHR(194)
	@ 14,50 SAY "IM"
ELSE
	@ 14,16,21,40 BOX B_SINGLE
	@ 14,16 SAY CHR(194)
	@ 14,40 SAY CHR(194)
ENDIF
@ 14,27 SAY "Fly"

* Now put up the swimmers

base_row=7
base_col=6
FOR i=1 TO IIF(agegroup>9,5,4)
	event=event_order[i]
	col=base_col+(i-1)*23

* Maximum of six swimmers

	FOR j=1 TO MIN(6,nScrollNum)
		IF aEtimes[event,j,1]<990
			@ base_row+j,col SAY scrolname[aEtimes[event,j,2]]+" ";
					+time_str(aEtimes[event,j,1],7)
			num_swimers[i]++
		ENDIF
	NEXT
	IF i=3
		base_row=14
		base_col=-52
	ENDIF
NEXT

* Instructions and buttons

@ SAVE_TOPROW, SAVE_TOPCOL, SAVE_BOTROW, SAVE_BOTCOL BOX B_DOUBLE
@ SAVE_TOPROW+2, SAVE_TOPCOL+2 SAY "Save"
@ CAN_TOPROW, CAN_TOPCOL, CAN_BOTROW, CAN_BOTCOL BOX B_DOUBLE
@ CAN_TOPROW+2, CAN_TOPCOL+1 SAY "Cancel"

@ 23, 9 SAY "Click to toggle swimmers - highlighted are selected. Save or"
@ 24, 15 SAY "page down to select. Cancel or ESC to abort"

* Now go into input loop - to exit without saving use ESC  or click on cancel
* page down saves selection as well as hitting save button

IF lUseMouse

* put mouse cursor back up if it has been hidden

	done=.F.
	DO WHILE .NOT.done

* Set up input mechanism
		nKey=0
		mouse_key=0

		FT_MSHOWCRS()
		DO WHILE nKey=0.AND.mouse_key=0
			nKey=INKEY()
			mouse_key=FT_MGETPOS(@mouse_row,@mouse_col)
			IF mouse_key>0
				nTime=SECOND()
				IF mouse_key%2=1 && left button 
					FT_MBUTPRS(0)
				ENDIF
				IF (INT(mouse_key/2)%2)=1 && right button
					FT_MBUTPRS(1)
				ENDIF
				IF (mouse_key>=4) && middle button
					FT_MBUTPRS(2)
				ENDIF
				mouse_row=INT(mouse_row/8)
				mouse_col=INT(mouse_col/8)
			ENDIF
		ENDDO
		FT_MHIDECRS()

* Mouse input do it first since we can fake the save and cancel by changing
* nkey to the correct value

		IF mouse_key>0

			IF mouse_col>=SAVE_TOPCOL.AND.mouse_col<=SAVE_BOTCOL;
					    .AND.mouse_row>=SAVE_TOPROW;
					    .AND.mouse_row<=SAVE_BOTROW
				nKey=K_PGDN
			ELSEIF mouse_col>=CAN_TOPCOL.AND.mouse_col<=CAN_BOTCOL;
					    .AND.mouse_row>=CAN_TOPROW;
					    .AND.mouse_row<=CAN_BOTROW
				nKey=K_ESC
			ELSE
* Signal null key input
				nKey=0

* Now see if clicked in active area by calculating the event number and swimmer
* number. If they make sense then use then

				click_event=1+INT((mouse_col-IIF(mouse_row<15,6,-52))/23)
				click_swim=mouse_row-IIF(click_event>3,14,7)
				IF click_event>0.AND.click_event<=IIF(agegroup>9,5,4);
					.AND.click_swim>0;
					.AND.click_swim<=num_swimers[click_event]
* hit in the area so toggle the swimmer - need to set

					IF .NOT.select_swims[click_event,click_swim]
						SETCOLOR("W/N")
					ENDIF
					IF click_event>3
						base_row=14
						base_col=-75
					ELSE
						base_row=7
						base_col=-17
					ENDIF

* Now output the new line

					event=event_order[click_event]
					@ base_row+click_swim,base_col+click_event*23 SAY;
						 scrolname[aetimes[event,click_swim,2]];
						+" "+time_str(aEtimes[event,click_swim,1],7)
					SETCOLOR("W+/R,N/W,,,N/N")

					select_swims[click_event,click_swim]=;
						.NOT.select_swims[click_event,click_swim]
				ENDIF

			ENDIF
* Wait for button release

			sleep(0.2)
			DO WHILE .NOT.FT_MBUTREL()=0
			ENDDO
		ENDIF
* Key input check it out

		IF nKey=K_ESC
			done=.T.
		ELSEIF nKey=K_PGDN
			done=.T.
* Save things
			orig_get=getactive()
			getactive():killfocus()
			max_event=IIF(agegroup>9,5,4)
			FOR i = 1 TO max_event
				insert_count=0
				event_num=IIF(i>4,1,i+1)
				FOR j = 1 TO 6
					IF select_swims[i,j]
						swimmer=aEtimes[event_order[i],j,2]
						insert_count++
* Save all of the information in the background

						aSave[event_num,insert_count]:=;
						aEvent[event_num,insert_count]:=scrolname[swimmer]
						aNumber[event_num,insert_count]=scrolswim[swimmer]
						mouseupdate=.T.

* Change to the correct get so we can change the buffer

						getactive(GetList[(i-1)*3*nMaxHeats+insert_count])
						g=getactive()
						g:setfocus()
						g:updatebuffer()
						g:killfocus()
					ENDIF
				NEXT
			NEXT
			getactive(orig_get)
			getactive():setfocus()
		ELSEIF nKey<>0
* bad key
			TONE(100,3)
		ENDIF					
	ENDDO

ELSE
	ALERT("This routine needs mouse support",{"Continue"})
ENDIF

* Restore things to the way they were
IF inited_mouse
	FT_MHIDECRS()
ENDIF

SETCOLOR(savecolor)
RESTSCREEN(7,0,24,79,savescr)

* Restore the screen button and hot key

WARMBUTTON aPreSeed

RETURN NIL

* End of pre_seed

*+
FUNCTION mouseadd
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: if double click occured put person in the current get
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: None
*
* Returns: .T.
*-
* LOCAL variables: 
LOCAL ScrollPerson, i, j, curget
LOCAL cSaveColor:=SETCOLOR()
*
* Entry Point
*
* Back calculate to find person

ScrollPerson=ASCAN(scrolswim,sw_number)

* now add the person to the screen

curget=GetActive()
curget:varput(scrolname[ScrollPerson])
i=curget:subscript[1]
j=curget:subscript[2]
aEvent[i,j]=scrolname[ScrollPerson]
aNumber[i,j]=scrolswim[ScrollPerson]
mouseupdate=.T.
KEYBOARD CHR(K_DOWN)

SETCOLOR(cSaveColor)

RETURN .T.

* End of mouseadd

******************************************************************************
* Beyond here are just the supporting routines for the interesting stuff above
******************************************************************************
*+
FUNCTION fillname
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: checks input to see if event entered by name or number and
* puts the correct name in the field if a number was given
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: eventnum which is the event number
*                     swimnum which is the swimmer number 1= a-1 2=a-2 etc.
*
* Returns:  .T. if a valid swimmer was identified by name or number
*		  .F. if the name is not present or not unique
*
* Notes: 
*-
* Private variables: 
LOCAL result, strng, savedbf, ind, sea_strng, eventnum, swimnum
LOCAL saveclr, ind2, i, check_num, tmp, new_len
LOCAL g, cLastName, cFirstName
LOCAL error_line:=SetErrorLine()
LOCAL nRecord
LOCAL cSaveColor
LOCAL cString:="More than one swimmer by that name."
LOCAL cString2:="No Swimmer with that name."
LOCAL cString3:="Swimmer is too old for this age group"
*
* Entry Point
*
* Get the active field information

g:=GetActive()
eventnum=g:subscript[1]
swimnum=g:subscript[2]

@ error_line,0 CLEAR TO error_line,79

strng=aEvent[eventnum,swimnum]
ind=LEN(strng)
strng=PAD(TRIM(strng),ind)
result=.F.
check_num=0

* Old equals current so do nothing

IF strng==aSave[eventnum,swimnum]
	result=.T.

* Entry deleted so remove saved

ELSEIF EMPTY(strng)
	aSave[eventnum,swimnum]="              "
	aNumber[eventnum,swimnum]=0
	result=.T.

* Entered a name or number so check it out


ELSE
	strng=ALLTRIM(strng)
	IF ISALPHA(LEFT(strng,1))
		SET SOFTSEEK ON
		SELECT cool_swim
		nRecord=RECNO()
		SET ORDER TO 1		&& Swimmers name index_number

* figure out user's input. Get any delimiter

		ind=AT(" ",strng)
		IF ind=0
			ind=LEN(strng)+1
		ENDIF
			
		ind2=AT(",",strng)
		IF ind2=0
			ind2=LEN(strng)+1
		ENDIF
		ind=MIN(ind2,ind)-1
		cLastName=UPPER(LEFT(strng,ind))
		SEEK cLastName

* If we found something close then use it

		IF .NOT.EOF().AND.AT(cLastName,UPPER(sw_last))=1

* see if there is another match

			SKIP

			IF AT(cLastName,UPPER(sw_last))=1

* Yes there is. See if user gave more information

				new_len=LEN(strng)-LEN(cLastName)-1

				IF new_len>0
						cFirstName=UPPER(RIGHT(strng,new_len))
* Yes there is more so use it

						SKIP -1
						SEEK UPPER(sw_last+cFirstName)
* found a match
					IF .NOT.EOF().AND.AT(cFirstName,UPPER(sw_first))=1

						SKIP
* Is it unique?
						IF AT(cFirstName,UPPER(sw_first))=1.AND.;
							AT(cLastName,UPPER(sw_last))=1
* No
							cSaveColor=SETCOLOR("W*/N")
							@ error_line, CENTER(cString) SAY cString
							SETCOLOR(cSaveColor)
							result=.F.
						ELSE
* yes
							SKIP -1
							result=.T.
						ENDIF
					ELSE
						cSaveColor=SETCOLOR("W*/N")
						@ error_line, CENTER(cString2) SAY cString2
						SETCOLOR(cSaveColor)
						result=.F.
					ENDIF
				ELSE

					cSaveColor=SETCOLOR("W*/N")
					@ error_line, CENTER(cString) SAY cString
					SETCOLOR(cSaveColor)
					result=.F.
				ENDIF
			ELSE
				SKIP -1
				result=.T.
			ENDIF
		ELSE
			cSaveColor=SETCOLOR("W*/N")
			@ error_line, CENTER(cString2) SAY cString2
			SETCOLOR(cSaveColor)
			result=.F.
		ENDIF		

* check age and sex

		IF sw_age>agegroup.AND.result
			cSaveColor=SETCOLOR("W*/N")
			@ error_line, CENTER(cString3) SAY cString3
			SETCOLOR(cSaveColor)
			result=.F.
		ENDIF
		IF sw_sex<>event_sex.AND.result
			cSaveColor=SETCOLOR("W*/N")
			@ error_line, CENTER("Swimmer is of the incorrect gender.");
				 SAY "Swimmer is of the incorrect gender."
			SETCOLOR(cSaveColor)
		ENDIF
		IF result
			tmp=short_name(sw_last,sw_first)
			check_num=sw_number	
		ENDIF

		SET SOFTSEEK OFF
		SET ORDER TO 3    // Availability-age index_number
* Return to previously active record

		GOTO nRecord

* User entered swim number

	ELSE

* User entered the scroll line number

		ind=VAL(ALLTRIM(strng))
		IF ind>=1.AND.ind<=nScrollNum
			tmp=scrolname[ind]
			check_num=scrolswim[ind]
			result=.T.
		ELSE
			cSaveColor=SETCOLOR("W*/N")
			@ error_line, CENTER("Swimmer number out of range.") ;
				SAY "Swimmer number out of range."
			SETCOLOR(cSaveColor)
			result=.F.
		ENDIF

	ENDIF

* Check to see if swimmer already entered

	i=1
	DO WHILE i<=3*nMaxHeats.AND.result
		IF i<>swimnum
			result=aNumber[eventnum,i]<>check_num
			IF .NOT.result
				cSaveColor=SETCOLOR("W*/N")
				@ error_line, CENTER("Swimmer already entered in this event.") ;
					SAY "Swimmer already entered in this event."
				SETCOLOR(cSaveColor)
			ENDIF
		ENDIF
		i++
	ENDDO
* If we are ok save the information

	IF result
		aSave[eventnum,swimnum]:=aEvent[eventnum,swimnum]:=tmp
		aNumber[eventnum,swimnum]=check_num
	ENDIF

ENDIF


RETURN result

* End of fillname

*+
FUNCTION saveevents
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: take events from screen and save them in the database
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: this checks to see if the entry already exists in the entry database
*        if there it overwrites it otherwise it adds a new record.
*-
* Private variables: 
LOCAL indx, olddbf, i, heat, lane, del, j
LOCAL entry_list:={}, bad_list:={}, cnt

*
* Entry Point
*
* Get correct database

olddbf=SELECT()
SET ORDER TO 1		&& individual entry seed string index_number
GOTO TOP
del=.F.

FOR j=IIF(agegroup>9,1,2) TO 5   && each event

	FOR i=1 TO 3*nMaxHeats  && each swimmer entry

		heat=INT(MAXHEATS-INT((i-1)/3))
		lane=INT(i-INT((i-1)/3)*3)

* For each event check out presence of entry

* See if we already have an entry

		indx=entry_indx(j,agegroup,event_sex,heat,lane)
		SEEK indx

* If the form contained an entry then process it

		IF .NOT.EMPTY(aEvent[j,i])

			IF FOUND()

* We already have an entry. If not the same replace it.

				IF aNumber[j,i]<>en_swimnum
					REPLACE en_swimnum WITH aNumber[j,i]
					REPLACE en_time WITH 0.0
				ENDIF

* Not already present so make a new record

			ELSE
				APPEND BLANK
				fillevent(j,i,heat,lane,indx)
			ENDIF

* Add swimmer number to list of swimmers in not already there

			IF ASCAN(entry_list,aNumber[j,i])=0
				AADD(entry_list,aNumber[j,i])
			ENDIF

* Otherwise we must delete it since the user deleted an entry

		ELSEIF FOUND()
			DELETE
			del=.T.
		ENDIF

* If we did not find an entry we must go back to the top, otherwise they should
* be in order
		IF .NOT.FOUND()
			GOTO TOP
		ENDIF

	NEXT && i
NEXT  && j

IF LEN(entry_list)>0

* Now check to see if any of the swimmers is in more than the 
* maximum number of events

	ASORT(entry_list)
	SET ORDER TO 2
	GOTO TOP

	FOR i = 1 TO LEN(entry_list)
		SEEK STR(entry_list[i],4,0)
		COUNT TO cnt WHILE en_swimnum=entry_list[i]
		IF cnt>3
			AADD(bad_list,entry_list[i])
		ENDIF
	NEXT
ENDIF

SET ORDER TO 1
SELECT(olddbf)

RETURN bad_list

* End of saveevents

*+
FUNCTION showbad(bad_list)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: show swimmers with more than three individual events
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: bad_list - which is the list of swimmers numbers
*
* Returns: NIL
*
* Notes: 
*-
* LOCAL variables: 
LOCAL savescr, saveclr, depth, i, line_cnt
LOCAL cString:=;
"The following swimmers have been entered; in more than 3 events:;"
LOCAL nChoice, nLeng, nIndex
LOCAL j, lDone
*
* Entry Point
*

nLeng=0
FOR i=1 TO LEN(bad_List)
	lDone=.F.
	j=0
	DO WHILE !lDone.AND. j<=LEN(aNumber)
		j++
		nIndex=ASCAN(aNumber[j],Bad_List[i])
		IF nIndex>0
			lDone=.T.
			nLeng+=LEN(aEvent[j,nindex])
			cString+=aEvent[j,nIndex]
		ENDIF
	END DO
	IF nLeng>40
		cString+=";"
		nLeng=0
	ENDIF
NEXT


nChoice=ALERT(cString,{"Ignore","Fix"})

RETURN nChoice==1

* End of showbad


*+
FUNCTION fillevent( eventnum, arrayind, heat, lane, indx)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: fill in a new entry in the event database
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: eventnum which is the event number to place in en_event
*                     arrayind which is the index into the number_&eventnum array
*
* Notes: none
*-
* Private variables: 

*
* Entry Point
*
REPLACE en_indxstr WITH indx
REPLACE en_age_grp WITH agegroup
REPLACE en_event WITH eventnum
REPLACE en_heet WITH heat
REPLACE en_lane WITH lane
REPLACE en_sex WITH event_sex
REPLACE en_swimnum WITH aNumber[eventnum,arrayind]
REPLACE en_time WITH 0.0

RETURN NIL

* End of fillevents



*+
FUNCTION age_menu(gender, agegrp, test_sex)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: let user choose the age group/sex for entry of swimmers
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/21/92    LJL      Demo Version
*
* Calling parameters: gender which returns the gender choice of the user
*                     agegrp which is the current age group for setting menu
*                         starting location
*                     test_sex which if true or missing the gender will be
*                         requested, otherwise no change
*
* Returns: the age group selection (6,8,10,12,14 or 18)
*
* Notes: gender should be passed by reference
*-
* Private variables: 
LOCAL savescr, selection, selection2, age_cur, sex_test, pcnt
LOCAL ages:={"6 and Under", "7-8        ", "9-10       ",;
			   "11-12      ", "13-14      ","15-18      "}
LOCAL sex:={"Female","Male  "}
LOCAL cSaveColor
*
* Entry Point
*
savescr=SAVESCREEN(9,30,19,50)

IF agegrp!=NIL
	age_cur=INT((agegrp-3)/2)
	IF age_cur>6
		age_cur=6
	ENDIF
ELSE
	age_cur=1
ENDIF

* Test to see if we wish to ask about gender

IF test_sex!=NIL
	sex_test=test_sex
ELSE
	sex_test=.T.
ENDIF

cSAveColor=SETCOLOR("W+/R,N/W,,,N/N")
@9,30 CLEAR TO 17,50
@9,30,17,50 BOX B_SINGLE
@10,32 SAY "Select Age Group"
selection=achoice(11,31,16,49,ages,.T.,,age_cur,,)

* Put up gender choices
IF selection>0.AND.sex_test
	
	RESTSCREEN(9,30,19,50,SaveScr)
	@9,33 CLEAR TO 13,47
	@9,33,13,47 BOX B_SINGLE
	@10,34 SAY "Select Gender"
	selection2=achoice(11,34,12,46,sex,.T.,,1,)
	IF selection2>0
		gender=LEFT(sex[selection2],1)
	ENDIF
ENDIF

* Restore the screen

SETCOLOR(cSaveColor)
RESTSCREEN(9,30,19,50,savescr)

RETURN IIF(selection>0,age_group(4+2*selection),0)

* End of age_menu

*+
FUNCTION entry_indx(event, age_grp, gender, heat, lane)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: create the individual entry index string
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: event  which is the event number
*                     age_grp which is the age group of the event
*                     gender which is the gender of the swimmer
*                     heat which is the heat number
*                     lane which is the lane number
*
* Returns: the indexing string of the form: 
*	STR(event,2,0)+STR(age_grp,2,0)+gender+STR(heat,1,0)+STR(lane,1,0)
*
* Notes: the first heat should be the "B" heat. Not all parameters need be
*        passed so this function can be used for a SEEK
*-
* Private variables: 
LOCAL tmp_str, pcnt

*
* Entry Point
*


tmp_str=STR(event,2,0)

IF age_grp!=NIL
	tmp_str=tmp_str+STR(age_grp,2,0)
ENDIF

IF gender!=NIL
	tmp_str=tmp_str+gender
ENDIF

IF heat!=NIL
	tmp_str=tmp_str+STR(heat,1,0)
ENDIF

IF lane!=NIL
	tmp_str=tmp_str+STR(lane,1,0)
ENDIF

RETURN PAD(tmp_str,7)

* End of entry_indx


*+
FUNCTION short_name(lastname, firstname)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: create a name string 14 characters long
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL       Demo Version
*
* Calling parameters: lastname  which is the person's last name
*                     firstname which is the person's first name
*
* Return: A string with the first 11 letters of the last name a space and
*         the at least the first two letters of the first name
*
* Notes: none
*-
* Private variables: 

RETURN PAD(ALLTRIM(LEFT(lastname,11))+","+ALLTRIM(firstname),14)

* End of short_name

*+
FUNCTION rev_name(firstname, mi, lastname, postfix)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Convert a firstname, middle initial, lastname postfix combo
* into one string in the order last, first mi post
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
*
 *  $SYNTAX$
 *     REV_NAME(<cFirstname>, <cMi>, <cLastname>, [<cPostfix>]) -> cName
 *  $ARGUMENTS$
 *     <cFirstname> is the first name of the person
 *     <cMi> is the middle inital
 *     <cLastname> is the last name of the person
 *     <cPostfix> is Jr., Sr., etc. This is optiona *     
 *  $RETURNS$
 *     <cName> which is the reverse order name.
*
*-
* Private variables: none

LOCAL strng

*
* Entry Point
*
strng=ALLTRIM(lastname)+", "
IF .NOT.EMPTY(firstname)
	strng=strng+ALLTRIM(firstname)+" "
ENDIF
IF .NOT.EMPTY(mi)
	strng=strng+mi+". "
ENDIF

IF .NOT.EMPTY(postfix)
	strng=strng+ALLTRIM(postfix)
ENDIF

RETURN SUBSTR(strng,1,len(strng)-1)

* End of Rev_NAME

*+
FUNCTION time_str(atime, length)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: convert a real number into a time string
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92   LJL       Demo Version
 *  $SYNTAX$
 *     TIME_STR(<nTime>, <nLength>) -> <cTime>
 *  $ARGUMENTS$
 *     <nTime>  is the time to be converted
 *     <nLength> is the length the output string
*-
* Private variables: 
LOCAL tmpstr, minutes, l, seconds, sec_str, hours, hour_str, size

*
* Entry Point
*
size=LEN(ALLTRIM(STR(atime,10,0)))

IF size>=5
	tmpstr=REPLICATE("9",size-4)+":99:99.99"
ELSEIF size>=3
	tmpstr=REPLICATE("9",size-2)+":99.99"
ELSE
	tmpstr=REPLICATE("9",size)+".99"
ENDIF

tmpstr=TRANSFORM(atime,tmpstr)

l=LEN(tmpstr)
IF l>length
	tmpstr=REPLICATE("*",length)
ELSEIF l<length
	tmpstr=SPACE(length-l)+tmpstr
ENDIF

RETURN tmpstr

* End of time_str

*+
FUNCTION SetErrorLine(nErrLine)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: set the internal value of the error line and return
*          current value
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92   LJL       Demo Version
*
 *  $SYNTAX$
 *     SetErrorLine( [ <nErrLine> ] ) -> <nCurLine>
 *  $ARGUMENTS$
 *     <nErrLine> - The line on the screen to show errors. If
 *                  no value given then just the current value is returned.
 *
 *  $RETURNS$
 *     <nCurLine> is the current setting for the error line
*-
* LOCAL variables: 
LOCAL nOldValue:=nErrorLine

*
* Entry Point
*
IF VALTYPE(nErrLine)="N"
	nErrorLine=nErrLine
	lErrorSet=.T.
ENDIF

RETURN nOldValue

* End of file SetErrLine

FUNCTION CENTER (string,length)
RETURN MAX(0,INT((IIF(length=NIL,MAXCOL()+1,length)-LEN(string))/2))

* End of file center
*+
FUNCTION loadevents(call_type)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: load events with either spaces or actual swimmers if available
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: None
*
* Notes: none
*-
* Private variables: 
LOCAL sea_string, i, heet, lane, sp14, do_res

*
* Entry Point
*

* set up databases to load swimmers

SELECT cool_swim
SET ORDER TO 2		&& swim number index_number

SELECT meet_entry
SET ORDER TO 1		&& event description index_number

SET RELATION TO STR(en_swimnum,4,0) INTO cool_swim

GOTO TOP
SET SOFTSEEK ON

* Clear working Arrays

sp14=SPACE(14)

FOR i = 1 TO 5
	AFILL(aevent[i],sp14)
	AFILL(asave[i],sp14)
	AFILL(anumber[i],0)
	AFILL(anumber[i],0)
NEXT	

* See if there are any events present for this age/sex combination

* Go through each event

FOR i=1 TO 5
	GOTO TOP
	sea_string=entry_indx(i,agegroup,event_sex)
	SEEK sea_string

	IF .NOT.EOF()
		DO WHILE .NOT.EOF().AND.en_age_grp==agegroup.AND.en_sex==event_sex;
			.AND.en_event==i

			IF .NOT.cool_swim->(EOF())
* We have some events present

				lane=en_lane
				heet=MAXHEATS-en_heet

* This should be faster than a macro expansion

				aEvent[i,3*heet+lane]:=aSave[i,3*heet+lane]:=;
					short_name(cool_swim->sw_last,cool_swim->sw_first)
				aNumber[i,3*heet+lane]=en_swimnum
			ENDIF
			SKIP
		ENDDO
	ENDIF
NEXT

* return things to normal

SET RELATION TO
SELECT cool_swim
SET ORDER TO 1		&& swimmer name index_number
SELECT meet_entry

RETURN NIL

* End of loadevents


*+
FUNCTION putevents
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Put up basic input screen for events
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: none
*-
* Private variables: 
LOCAL j,i,k

@  0,8 SAY"Free          Breast         Back           Fly              IM"
j=0
FOR i=1 TO nMaxHeats
	FOR k=1 TO 3
		j++
		@ j,0 SAY CHR(64+i)+STR(k,1,0)
	NEXT
	j++
NEXT

RETURN NIL

* End of putevents

*+
FUNCTION change_age
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: changes the swimmer in the scrolling area
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: called by hitting the F6 key
*-
* Private variables: 
LOCAL new_age,dummy

*
* Entry Point
*
COOLBUTTON aChangeAge

dummy=event_sex
new_age=age_menu(@dummy,displayage,.F.)
IF new_age>0
	displayage=new_age
	showswimrs()
ENDIF

WARMBUTTON aChangeAge

RETURN NIL

* End of change_age

*+
FUNCTION scrollup
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: scroll the list of swimmers up
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: 
*-
* Private variables: 
LOCAL saveclr:=SETCOLOR()

*
* Entry Point
*
* Shut off keys

SET KEY K_F9 TO
SET KEY K_F10 TO
* Move the browse

SETCURSOR(SC_NONE)
oBrowse:UP()
oBrowse:ForceStable()
BRUpdateScroll(oBrowse)
SETCURSOR(SC_NORMAL)

* turn on keys
SET KEY K_F9 To scrollup
SET KEY K_F10 TO scrolldown

SETCOLOR(saveclr)

RETURN NIL

* End of scrollup

*+
FUNCTION scrolldown
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: scroll the list of swimmers down
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: 
*-
* Private variables: 
LOCAL saveclr:=SETCOLOR()

*
* Entry Point
*
* Shut off keys

SET KEY K_F9 TO
SET KEY K_F10 TO

* Move Browse

SETCURSOR(SC_NONE)
OBrowse:Down()
oBrowse:ForceStable()
BRUpdateScroll(oBrowse)
SETCURSOR(SC_NORMAL)

* Reset Keys

SET KEY K_F9 To scrollup
SET KEY K_F10 TO scrolldown

SETCOLOR(saveclr)

RETURN NIL

* End of scrolldown

