 * File......: MBROWSE.CH
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 6/23/93
 * Revision..: V2.0            // Update to Clipper 5.2 release
 * Log file..: 
 * 
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.
 *
 * Modification History:
 *

#define NO_GET             0
#define GET_ON_RETURN      1
#define DOUBLE_CLICK_GET   4
#define DOUBLE_CLICK_EXIT  1024

#define REFRESH_NONE       0
#define REFRESH_CURRENT    1
#define REFRESH_ALL        2
#define REFRESH_EXIT       3

#define CHANGED_RECORD     1
#define PANNED_RECORD      2

#ifndef HORIZSCROLL
#define HORIZSCROLL       0         // Define which kind of scroll bar we are
#define VERTSCROLL        1         // using
#endif

/*  $DOC$
 *  $COMMANDNAME$
 *     BROWSE
 *  $CATEGORY$
 *     Browse
 *  $ONELINER$
 *     Browse command to activate browse with mouse
 *  $SYNTAX$
 *     BROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <nRecNum>;
 *            [WHILE <bWhile>];
 *            [KEY <cKey>];
 *            [FREEZE <nFreeze>];
 *            [<SAVESCREEN>];
 *            [COLORS <cColorList>];
 *            [SCREENINIT <bScreenInit>];
 *            [READINIT <nReadInit>];
 *            [ALTREAD <bAltReader>];
 *            [EXIT <nExitKey>];
 *            [<APPEND>];
 *            [APPREAD <bAppendReader>];
 *            [RECORDNUM <bRecordNum>];
 *            [RECORDTOTAL <bRecordTotal>];
 *            [MOVEDFUNCTION <bMovedFunction>];
 *            [DOUBLE_CLICK <xDoubleAction>];
 *            [KEYHANDLER <bKeyHandler>]
 *  $ARGUMENTS$
 *     <aFields> is multidimensional array of fields you want to display. 
 *               Each row contains up to nine members containing:
 *
 *        Index 1: Column heading
 *        Index 2: Code block for displaying information. Note: if you are
 *                 going to do an a read, this must code block must be written
 *                 so that if a parameter is passed, it will set the GET 
 *                 variable. For example: {|x| IIF(x=NIL,Last,Last:=x) }
 *                 can be used by both browse and the GET system.
 *        Index 3: Optional logical indicating if field can be edited if you
 *                 are allowing edits. By default, if you are allowing edits
 *                 (see below) it is .T., and, obviously, if you are not .F.
 *        Index 4: Optional Picture function for get on this column.
 *        Index 5: Optional Code block to be executed as a WHEN clause.
 *        Index 6: Optional Code block to be executed as a VALID clause.
 *        Index 7: Optional TBColumn:ColorBlock code block for this column
 *        Index 8: Optional Get code block. This code block allows one to 
 *                 format a column with the code block in index 2 and still
 *                 do an edit on the column in spite of your fancy formating.
 *                 The most obvious example is a value that gets formatted
 *                 to show the meaning of a logical yet you wish to edit that
 *                 field. If this is NIL and you wish to do an edit, the block
 *                 from index 2 will be used.
 *        Index 9: Optional column width.
 *
 *        The command BROWSECOLUMN is available to simplify creating this array
 *
 *        Example to set up last name and first name in array:
 *        aFields := {}
 *        AADD(aFields, {"Last Name", {||Names->Last}, .T., "!XXXXXXXXXXXXXX" })
 *        AADD(aFields, {"First Name", {||Names->First} } )
 *
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are the coordinates of
 *        the area to display the TBrowse in.  Defaults to 2, 2,
 *        MaxRow(), MaxCol() i.e. full screen.
 *
 *     <bWhile> is the limiting WHILE condition as a block.
 *        If cKey (below) is NIL. This is automatically set to {|| .T.}.
 *        If you will be allowing appends you will want to allow arguments to
 *        be passed so that you can use this while block on data entered by the
 *        user prior to adding it to the database. The third example below
 *        shows such a block (as does the example program above).
 *
 *        Example 1: { ||Names->Last == "JONES" }
 *        Example 2: { ||Names->Last == "JONES" .AND. Names->First == "A"  }
 *        Example 3: { |x| IIF(x=NIL, Names->Last = cKey, x = cKey)}
 *
 *     <cKey> is the key to find top condition of WHILE.  
 *        If NIL the entire database is browsed.
 *        cLast  := "JONES     "
 *        cFirst := "A"
 *        Example 1: cKey := cLast
 *        Example 2: cKey := cLast + cFirst
 *
 *     <nFreeze> is number of fields to freeze in TBrowse.  Defaults
 *        to 0 if not passed.
 *
 *     <SAVESCREEN> - If present the screen will be saved
 *
 *     <cColorList> is a list of colors for the TBrowse columns.
 *     The 1st color is used as SAY/TBrowse Background and the
 *     3rd and 4th colors are used as part of column:defColor := {3, 4}
 *     The 7th Color is used for the scroll bars if used.
 *
 *     Thus if you pass a cColorList, you MUST pass at least 4 colors.
 *     Defaults to "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R" if not passed.
 *
 *     <bInit> is a code block which calls a routine to initialize the
 *          screen after it has been cleared. You could place help or
 *          mouse hot spots on the screen with this routine. If not included
 *          then nothing happens.
 *
 *     <nReadInit> indicates how a read is initiated. The constants 
 *          GET_ON_RETURN and DOUBLE_CLICK_GET are defined in MBROWSE.CH. 
 *          GET_ON_RETURN indicates that a return will initiate a GET on 
 *          the current field. DOUBLE_CLICK_GET indicates that a mouse 
 *          double click will initiate a GET on the current field. Either 
 *          one or the sum of the two can be used to indicate how to initiate 
 *          a GET. Passing NO_GET or NIL will prevent any editing.
 *
 *          Example:
 *            GET_ON_RETURN+DOUBLE_CLICK_GET   will allow both the mouse and
 *                                             return initiated gets
 *
 *     <bAltReader> is a code block which is called in place of the internal
 *          reader when the user requests an edit. If not passed then the 
 *          internal one is called. This gives more flexibility in doing 
 *          reads and actually can be used for functions other than reads 
 *          (especially with the mouse). The alternate reader is passed the 
 *          browse object and is expected to return either a logical 
 *          indicating if the browse should continue or one of the 
 *          REFRESH_* constants defined in MBROWSE.CH.
 *
 *     <nExitKey> is a InKey code of a key which will exit the browse other
 *        than the escape key which is always active. By default is is set 
 *        to K_RETURN if GETS are not allowed and nothing if they are 
 *        allowed. This value may be added to DOUBLE_CLICK_EXIT to allow
 *        a double click to exit the browse. nExitKey is greater than or equal
 *        to DOUBLE_CLICK_EXIT, then this will take precedence over double click
 *        for GETs.
 *
 *     <APPEND> indicates if appends to the database are allowed.
 *
 *     <bAppendReader> is a code block which will perform a read and append
 *           when the user requests an append. The routine receives no 
 *           arguments but must return the number of records meeting the 
 *           current while condition that were appended to the database. 
 *           NOTE: if you are appending records under a while condition, do 
 *           not include records which you may have added but which do not 
 *           meet the criteria.
 *
 *     <bRecordNum> Is an optional code block which will return the
 *           sequence number of the current record within the current scope
 *           including the influence of any WHILE clause given to the browse.
 *           The value is used in presenting the scroll bar. It returns 
 *           the record number of the current record. Unless you are using 
 *           the natural order of the database, this value is NOT equal to 
 *           RECNO(). If the argument is not given, then the default routine 
 *           is used. One might use this routine if one knows, for example, 
 *           that only 1% of a very large database will be used for the 
 *           browse and you have a faster way of counting than the default 
 *           method.
 *
 *     <bRecordTotal> is an optional code block which returns the total number
 *           of records which fall under the scope of the browse. Note: if the
 *           database contains deleted records the value of LASTREC() is 
 *           incorrect if set deleted is on. If no value is given then the
 *           the default method is used when scroll bars are in use.
 *
 *     <bMovedFunction> is an optional code block which will be called whenever
 *        the browse is moved. It is passed two arguments, the browse object
 *        and either CHANGED_RECORD, PANNED_RECORD or their sum (defined in 
 *        MBROWSE.CH). These values indicate that the record has changed or the 
 *        column has changed, respectively. No test to see if the actual 
 *        change has occured. That is, if the user continues to attempt to 
 *        scroll off of the top, bMovedFunction will continue to be called
 *        with the appropriate value of CHANGED_RECORD. It is based upon 
 *        the user's request through either a key stroke or mouse click.
 *
 *     <bKeyHandler> is a code block which calls a routine for handling any
 *        keys which are not already defined (setkey(), arrows, pgup/dn, etc)
 *        This routine receives one argument which is the INKEY() value of the
 *        key. The routine should return REFRESH_NONE, REFRESH_CURRENT, 
 *        REFRESH_ALL, or REFRESH_EXIT which will make no changes to screen,
 *        refresh the current row, refresh the screen or exit the browse.
 *  $RETURNS$
 *     <nRecNum> is the number of the record selected by the <nExitKey> key.
 *           0 is returned if there are either no records matching the WHILE
 *           condition or an <Esc> is pressed instead of an <Enter> or the
 *           defined exit key.
 *     
 *  $DESCRIPTION$
 *     This is a command which simplifies calling MBROWSE(). For a full
 *     discussion see MBROWSE()
 *
 *  $EXAMPLES$
 *   #include "mbrowse.ch"
 *
 *   bWhile={|x| IIF(x=NIL,LEFT(TBNames->Last,1) == cKey, LEFT(x,1) == cKey)}
 *   BROWSE aFields, 3, 4, maxrow()-2, maxcol()-2 TO nRecSel WHILE bWhile ;
 *        KEY cKey SCREENINIT bScreeninit SAVESCREEN FREEZE nFreeze ;
 *        COLORS cColorList READINIT GET_ON_RETURN+DOUBLE_CLICK_GET ;
 *        EXIT K_ALT_E APPEND APPREAD {|| myReader()} 
 *     
 *  $SEEALSO$
 *     MBROWSE() BROWSECOLUMN CREATEBROWSE RUNBROWSE()
 *  $INCLUDE$
 *     MBROWSE.CH
 *  $END$
 */

#xcommand BROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <v>;
				[WHILE <bWhile>];
				[KEY <cKey>];
				[FREEZE <nFreeze>];
				[<lsave: SAVESCREEN>];
				[COLORS <cColorList>];
				[SCREENINIT <bScreenInit>];
				[READINIT <nReadInit>];
				[ALTREAD <bAltReader>];
				[EXIT <nExitKey>];
				[<lAppend:APPEND>];
				[APPREAD <bAppendReader>];
				[RECORDNUM <bRecordNum>];
				[RECORDTOTAL <bRecordTotal>];
				[MOVEDFUNCTION <bMovedFunction>];
				[DOUBLE_CLICK <xDoubleAction>];
				[KEYHANDLER <bKeyHandler>];
	=> <v> := mBrowse(<aFields>, <bWhile>, <cKey>, <nFreeze>, ;
					  <.lsave.>, <cColorList>, <nTop>, <nLeft>, ;
					  <nBottom>, <nRight>, <bScreenInit>, ;
					  <nReadInit>, <bAltReader>, <nExitKey>, ;
					  <.lAppend.>, <bAppendReader>, <bRecordNum>,;
					  <bRecordTotal>, <bMovedFunction>, <xDoubleAction>,;
					  <bKeyHandler>)

#xcommand BROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> ;
				[WHILE <bWhile>];
				[KEY <cKey>];
				[FREEZE <nFreeze>];
				[<lsave: SAVESCREEN>];
				[COLORS <cColorList>];
				[SCREENINIT <bScreenInit>];
				[READINIT <nReadInit>];
				[ALTREAD <bAltReader>];
				[EXIT <nExitKey>];
				[<lAppend:APPEND>];
				[APPREAD <bAppendReader>];
				[RECORDNUM <bRecordNum>];
				[RECORDTOTAL <bRecordTotal>];
				[MOVEDFUNCTION <bMovedFunction>];
				[DOUBLE_CLICK <xDoubleAction>];
				[KEYHANDLER <bKeyHandler>];
	=>      mBrowse(<aFields>, <bWhile>, <cKey>, <nFreeze>, ;
					  <.lsave.>, <cColorList>, <nTop>, <nLeft>, ;
					  <nBottom>, <nRight>, <bScreenInit>, ;
					  <nReadInit>, <bAltReader>, <nExitKey>, ;
					  <.lAppend.>, <bAppendReader>, <bRecordNum>,;
					  <bRecordTotal>, <bMovedFunction>, <xDoubleAction>,;
					  <bKeyHandler>)


/*  $DOC$
 *  $COMMANDNAME$
 *     BUILDBROWSE
 *  $CATEGORY$
 *     Browse
 *  $ONELINER$
 *     Build a database Browse with by a while condition with mouse
 *  $SYNTAX$
 *     BUILDBROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <oBrowse>;
 *            [WHILE <bWhile>];
 *            [KEY <cKey>];
 *            [FREEZE <nFreeze>];
 *            [<SAVESCREEN>];
 *            [COLORS <cColorList>];
 *            [READINIT <nReadInit>];
 *            [ALTREAD <bAltReader>];
 *            [EXIT <nExitKey>];
 *            [<APPEND>];
 *            [APPREAD <bAppendReader>];
 *            [RECORDNUM <bRecordNum>];
 *            [RECORDTOTAL <bRecordTotal>];
 *            [MOVEDFUNCTION <bMovedFunction>];
 *            [DOUBLE_CLICK <xDoubleAction>];
 *            [KEYHANDLER <bKeyHandler>]
 *
 *            (Note: the arguments are the same as BROWSE except that
 *             <bScreenInit> has been removed.)
 *  $ARGUMENTS$
 *     See Arguments for BROWSE. The [SCREENINIT <cScreenInit> argument is
 *         NOT applicable to BUILDBROWSE
 *
 *  $RETURNS$
 *     <oBrowse> is the TBROWSE object which is has been created. See
 *           MBROWSE.CH for contents of oBrowse:cargo
 *  $DESCRIPTION$
 *     This is a command which simplifies calling BUILDBROWSE(). For a full
 *     discussion see BUILDBROWSE()
 *
 *  $EXAMPLES$
 *
 *     USE TBNames INDEX TBNames NEW // indexed on Last + First
 *
 *     * Pass Heading as character and Field as Block including Alias
 *     * To eliminate the need to use FIELDWBLOCK() function in BROWSE()
 *     AADD(aFields, {"Last Name" , ;
 *          {|x| IIF(x=NIL,TBNames->Last, TBNames->Last:=x) },.T.  } )
 *     AADD(aFields, {"First Name", ;
 *          {|x| IIF(x=NIL, TBNames->First, TBNames->First:=x) },.T. } )
 *     AADD(aFields, {"City"      , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T. } )
 *     AADD(aFields, {"Zip Code"  , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T.,;
 *          "@R 99999-9999"})
 *
 *     oNewBrowse=BuildBrowse( aFields, bWhile, cKey, nFreeze, lSaveScrn, ;
 *       cColorList, 3, 6, MaxRow() - 2, MaxCol() - 6, ;
 *       nReadInit, bAltReader, nExitKey, lAppendMode, bAppendReader)
 *
 *  $SEEALSO$
 *     BuildBrowse() MBrowse() BRMouseFunc() BRHotSpot() BRSetScroll() BROWSE
 *  $END$
 */

#xcommand BUILDBROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <v>;
				[WHILE <bWhile>];
				[KEY <cKey>];
				[FREEZE <nFreeze>];
				[<lsave: SAVESCREEN>];
				[COLORS <cColorList>];
				[READINIT <nReadInit>];
				[ALTREAD <bAltReader>];
				[EXIT <nExitKey>];
				[<lAppend:APPEND>];
				[APPREAD <bAppendReader>];
				[RECORDNUM <bRecordNum>];
				[RECORDTOTAL <bRecordTotal>];
				[MOVEDFUNCTION <bMovedFunction>];
				[DOUBLE_CLICK <xDoubleAction>];
				[KEYHANDLER <bKeyHandler>];
	=> <v> := BuildBrowse(<aFields>, <bWhile>, <cKey>, <nFreeze>, ;
					  <.lsave.>, <cColorList>, <nTop>, <nLeft>, ;
					  <nBottom>, <nRight>, ;
					  <nReadInit>, <bAltReader>, <nExitKey>, ;
					  <.lAppend.>, <bAppendReader>, <bRecordNum>,;
					  <bRecordTotal>, <bMovedFunction>, <xDoubleAction>,;
					  <bKeyHandler>)


/*  $DOC$
 *  $COMMANDNAME$
 *     BROWSECOLUMN
 *  $CATEGORY$
 *     Browse
 *  $ONELINER$
 *     Builds a Column element to pass to MBROWSE
 *  $SYNTAX$
 *     BROWSECOLUMN TO <aField> [HEADING <cHeading>] [DISPLAY <bDisplay>] ;
 *			[ALLOWEDIT] [PICTURE <cPicture>] [WHEN <bWhen>] ;
 *			[VALID <bValid>] [WIDTH <nWidth>] [GETBLOCK <bGetBlock>] ;
 *			[COLORBLOCK <bColor>] ;
 *  $ARGUMENTS$
 *     <aField> is an array of fields you want to display. This command adds
 *              a new member to the array for each call and places all of the
 *              necessary information (detailed below) in the new element.
 *
 *     [HEADING <cHeading>] is the column heading
 *     [DISPLAY <bDisplay>] is a code block for displaying information. 
 *              Note: if you are going to do an a read and you do not use the
 *              optional GETBLOCK parameter, this must code block must be 
 *              written so that if a parameter is passed, it will set the GET 
 *              variable. For example: {|x| IIF(x=NIL,Last,Last:=x) }
 *              can be used by both browse and the GET system.
 *     [ALLOWEDIT] Which if present will allow edits if editing is allowed
 *              when the browse is called.
 *     [PICTURE <cPicture>] is an optional picture clause for any GET used in
 *              editing.
 *     [WHEN <bWhen>] is an optional when clause used for editing with a GET.
 *     [VALID <bValid>] is an optional valid clause used for editing with a GET.
 *     [GETBLOCK <bGetBlock>] which is an optional GET/SET block for any 
 *              editing. If editing is is used without a value for <bGetBlock>
 *              the code block <bDisplay> is used. It should be of the form
 *              {|x| IIF(x=NIL,cLast,cLast:=x) } if one were editing a value
 *              called cLast.
 *     [WIDTH <nWidth>] is an optional with for the column which overrides any
 *              value calculated by these routines.
 *     [COLORBLOCK <bColor>] is an optional color block which gets set into
 *              column:colorBlock.
 *     
 *  $DESCRIPTION$
 *     This is a command which simplifies calling building columns for 
 *     MBROWSE() and BUILDBROWSE().
 *  $EXAMPLES$
 *   #include "mbrowse.ch"
 *
 *   aField:={}
 *   BROWSECOLUMN TO aField HEADING "Last Name" ;
 *        DISPLAY {|| RTRIM(LastName,10)} ALLOWEDIT ;
 *        PICTURE "@S10 XXXXXXXXXXXXXXXXXXX" ;
 *        GETBLOCK {|n| IIF(n=NIL, LastName, LastName:=n)}
 *     
 *  $SEEALSO$
 *     MBROWSE()
 *  $INCLUDE$
 *     MBROWSE.CH
 *  $END$
 */

#xcommand BROWSECOLUMN TO <aField> [HEADING <cHeading>] [DISPLAY <bDisplay>] ;
				[<lEdit:ALLOWEDIT>] [PICTURE <cPicture>] [WHEN <bWhen>] ;
				[VALID <bValid>] [WIDTH <nWidth>] [GETBLOCK <bGetBlock>] ;
				[COLORBLOCK <bColor>] ;
		=> AADD(<aField>,{<cHeading>,<bDisplay>,<.lEdit.>,<cPicture>,;
				<bWhen>,<bValid>,<bColor>,<bGetBlock>,<nWidth>})



/*  $DOC$
 *  $COMMANDNAME$
 *     CREATEBROWSE
 *  $CATEGORY$
 *     Browse
 *  $ONELINER$
 *     Command to create a database Browse using CreateBrowse()
 *  $SYNTAX$
 * CREATEBROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <aBrowse>;
 *				[WHILE <bWhile>];
 *				[KEY <cKey>];
 *				[FREEZE <nFreeze>];
 *				[<lsave: SAVESCREEN>];
 *				[COLORS <cColorList>];
 *				[SCREENINIT <bScreenInit>];
 *				[READINIT <nReadInit>];
 *				[ALTREAD <bAltReader>];
 *				[EXIT <nExitKey>];
 *				[<lAppend:APPEND>];
 *				[APPREAD <bAppendReader>];
 *				[RECORDNUM <bRecordNum>];
 *				[RECORDTOTAL <bRecordTotal>];
 *				[MOVEDFUNCTION <bMovedFunction>];
 *				[DOUBLE_CLICK <xDoubleAction>]
 *                  [KEYHANDLER <bKeyHandler>]
 *
 *                (Note: the arguments are the same as MBROWSE() and BROWSE)
 *  $ARGUMENTS$
 *
 *     All arguments are the same as MBROWSE() and BROWSE.
 *
 *  $RETURNS$
 *     <aBrowse> is the an array which contains the TBROWSE object which 
 *           has been created along with other items needed to be passed
 *           to RUNBROWSE(). See MBROWSE.CH for contents of oBrowse:cargo
 *           and structure of this array.
 *  $DESCRIPTION$
 *     This sets up a browse which implements scoping using an indexed
 *     database and a WHILE condition. It can also work with an unindexed file
 *     if the entire database is being browsed. It also supplies mouse support 
 *     and active scroll bars which can be used with the mouse. Additionally, 
 *     the browse will support editing of current records and appending new 
 *     records.
 *
 *     It differs from MBROWSE() in that the TBROWSE object is set up brought
 *     to stabilization and then returned. This can be useful in cases when 
 *     you want to keep the browse object for an extended period of time
 *     but not necessarily on the screen all of the time. You can save the 
 *     information in a STATIC, return it to the screen at some later date
 *     and call RUNBROWSE to start it up again.
 *
 *     Note: it is the responsibility of the caller to cancel any mouse hot 
 *     spots included by the creation the scroll bars. They are returned
 *     by the "meta functions": VERT_SCROLL(oBrowse)[SB_MOUSEID] and
 *     HORIZ_SCROLL(oBrowse)[SB_MOUSEID] which are defined in mbrowse.ch.
 *
 *     For more details see MBROWSE()
 *
 *  $EXAMPLES$
 *
 *     USE TBNames INDEX TBNames NEW // indexed on Last + First
 *
 *     * Pass Heading as character and Field as Block including Alias
 *     * To eliminate the need to use FIELDWBLOCK() function in BROWSE()
 *     AADD(aFields, {"Last Name" , ;
 *          {|x| IIF(x=NIL,TBNames->Last, TBNames->Last:=x) },.T.  } )
 *     AADD(aFields, {"First Name", ;
 *          {|x| IIF(x=NIL, TBNames->First, TBNames->First:=x) },.T. } )
 *     AADD(aFields, {"City"      , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T. } )
 *     AADD(aFields, {"Zip Code"  , ;
 *          {|x| IIF(x=NIL, TBNames->City, TBNames->City:=x},.T.,;
 *          "@R 99999-9999"})
 *
 *     aNewBrowse=CreateBrowse( aFields, bWhile, cKey, nFreeze, lSaveScrn, ;
 *       cColorList, 3, 6, MaxRow() - 2, MaxCol() - 6, ;
 *       nReadInit, bAltReader, nExitKey, lAppendMode, bAppendReader)
 *
 *     RunBrowse(aNewBrowse,.F.)
 *
 *  $SEEALSO$
 *     BROWSE MBrowse() BRMouseFunc()  BRSetScroll() RunBrowse() DestroyBrowse()
 *  $END$
 */

#xcommand CREATEBROWSE <aFields>, <nTop>, <nLeft>, <nBottom>, <nRight> TO <v>;
				[WHILE <bWhile>];
				[KEY <cKey>];
				[FREEZE <nFreeze>];
				[<lsave: SAVESCREEN>];
				[COLORS <cColorList>];
				[SCREENINIT <bScreenInit>];
				[READINIT <nReadInit>];
				[ALTREAD <bAltReader>];
				[EXIT <nExitKey>];
				[<lAppend:APPEND>];
				[APPREAD <bAppendReader>];
				[RECORDNUM <bRecordNum>];
				[RECORDTOTAL <bRecordTotal>];
				[MOVEDFUNCTION <bMovedFunction>];
				[DOUBLE_CLICK <xDoubleAction>];
				[KEYHANDLER <bKeyHandler>];
	=> <v> := CreateBrowse(<aFields>, <bWhile>, <cKey>, <nFreeze>, ;
					  <.lsave.>, <cColorList>, <nTop>, <nLeft>, ;
					  <nBottom>, <nRight>, <bScreenInit>, ;
					  <nReadInit>, <bAltReader>, <nExitKey>, ;
					  <.lAppend.>, <bAppendReader>, <bRecordNum>,;
					  <bRecordTotal>, <bMovedFunction>, <xDoubleAction>,;
					  <bKeyHandler>)
