#include "mousbrow.ch"
#include "cswimfld.ch"
#include "cntryfld.ch"
FUNCTION MAIN

* main routine for seeding program demo

LOCAL cSaveColor:=SETCOLOR()


FT_MINIT()

CLEAR SCREEN
? "Note - Some things have been removed from this program and therefore"
? "all of it may not make sense. Also, some of this is very old and has not"
? "been updated to the latest and greatest way of doing things.  My intentions"
? "for this program is to demonstrate how to build and use a TBROWSE object"
? "while in a GET/READ and how to pass information from the browse to the"
? "read so one can use the mouse to fill in the GETs."
? " "
? "My wife uses this program to seed her summer swim league meets. She can"
? "now go through the entire process without using the keyboard which does"
? "speed things up quite a bit."
? " "
? "When one has both the Gets and the browse available, the mouse is active"
? "in both. Clicking on a Get will move one to that get. Clicking on the"
? 'Browse will move the "cursor" to that row. Double clicking on the browse'
? "will cause that person to be entered into the current get. You can click"
? "on the simple buttons such as TopSwimmers, Change Age, Cancel and Done"
? "to cause those actions to occur. Good luck and I hope this all makes enough"
? "sense that the demo is useful"
? " "
? "Hit any key or mouse button to continue"

MINKEY(0)

SET CONFIRM ON
SET SCOREBOARD OFF
SET BELL OFF
SET DELETED ON

IF ISCOLOR()

	SETCOLOR("W/B,W/N,,,B/W")
ELSE
	ALERT("Warning: Current demo is color only")
ENDIF


BRSetScroll(HORIZSCROLL, .F.)


open_bases()
Seed_meet()

CLOSE ALL
SETCOLOR(cSaveColor)

RETURN NIL

*+
FUNCTION open_bases
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: opens the auxilary databases incl. indiv. and relay entries and absents
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL       Demo Version
*
* Calling parameters: none
*
*-
* Private variables: 

SELECT 0
USE cl_swim ALIAS cool_swim
IF .NOT.FILE("cl_name.ntx")
	INDEX ON UPPER(sw_last+sw_first) TO cl_name
ENDIF
IF .NOT.FILE("cl_numbr.ntx")
	INDEX ON STR(sw_number,4,0) TO cl_numbr
ENDIF
IF .NOT.FILE("cl_group.ntx")
	INDEX ON sw_sex+STR(sw_age_grp,2,0)+UPPER(sw_last+sw_first) TO cl_group
ENDIF

SET INDEX TO cl_name, cl_numbr, cl_group

* Get the current meet

open_aux()

RETURN NIL


*+
FUNCTION open_aux
*
* This routine and all accompaning database structures are 
* Copyright (C) 1989 Leo J. Letendre. All rights reserved.
*
* Purpose: opens the auxilary databases incl. indiv. and relay entries and absents
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/20/92    LJL      Demo Version
*
* Calling parameters: none
*
* Notes: assumes that the correct root name is in meet_file->mt_filenm and
* that the files exist
*-
* Private variables: 
LOCAL file_name, file_len, savedbf, save_file, result:=.F.

*
* Entry Point
*

* Save original DBF infor


save_file:=file_name:="M9201"
file_len=LEN(file_name)

* Open meet entry

SELECT 0

IF FILE(file_name+".DBF")
	USE (file_name) ALIAS meet_entry

* If index exists use it otherwise make it

	IF .NOT.FILE(file_name+".ntx")
		INDEX ON en_indxstr TO (file_name)
	ENDIF

	IF .NOT.FILE(file_name+"s.ntx")
		INDEX ON STR(en_swimnum,4,0) TO (file_name+"s")
	ENDIF

	SET INDEX TO (file_name),(file_name+"s")

	result=.T.
* file not there so signal this fact
ELSE
	ALERT("Data for the requested meet not found.",{"Continue"})
ENDIF
* Go back to old DBF

SELECT (savedbf)

RETURN result

* End of open_aux

*+
FUNCTION age_group(nAge)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1989 Leo J. Letendre. All rights reserved.
*
* Purpose: calculate an age group for a given age
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/21/89   LJL       Initial Version
*
* Calling parameters: age which is the person's age
*
* Notes: legal age groups are 6, 8, 10, 12, 14 and 17 which represent the
*        highest ages in the age group
*-
* Private variables: 
LOCAL interm

*
* Entry Point
*
* get the next even age group if odd

interm=INT((nAge+1)/2)*2

* Adjust the top and bottom
IF interm>14
	interm=18
ELSEIF interm<6
	interm=6
ENDIF


RETURN interm

* End of age_group

