 * File......: MEMOFUNC.PRG
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 6/23/93
 * Revision..: V2.0           // Updated to Clipper 5.2 release
 * Log file..: 
 * 
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.
 *
 * Modification history:
 * --------------------
 * V1.01    4/4/92    Fixed recursive call problem
 *
 
#include "inkey.ch"

STATIC nTop:=0, nLeft:=0, nBottom:=0, nRight:=0 && Coordinates of memoedit area

STATIC aMMouseSpot:={}   && mouse hot spot storage
STATIC nMFree_spot:=0    && Next free spot for hot spots
STATIC lMouseUsed:=.F.   && Mouse Used logical
STATIC lIgnoreMouse:=.F. && Ignore any mouse if present



*+
FUNCTION mMemoEdit(cString,nTop1,nLeft1,nBottom1,nRight1,lEditmode,;
	cUserfunction,nLineLength,nTabSize,nTextBufRow, nTextBufCol,;
	nWindowRow,nWindowCol)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Initialize mouse and run memoedit
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     2/26/92   LJL       Initial Version
*         V1.01     4/4/92    LJL       Fixed recursive call problem with
*                                       Mouse cursor

/*  $DOC$
 *  $FUNCNAME$
 *     MMEMOEDIT()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     Memo edit with mouse support
 *  $SYNTAX$
 *     MMEMOEDIT([<cString>],
 *        [<nTop>], [<nLeft>],
 *        [<nBottom>], [<nRight>],
 *        [<lEditMode>],
 *        [<cUserFunction>],
 *        [<nLineLength>],
 *        [<nTabSize>],
 *        [<nTextBufferRow>],
 *        [<nTextBufferColumn>],
 *        [<nWindowRow>],
 *        [<nWindowColumn>]) --> cTextBuffer
 *     
 *  $ARGUMENTS$
 *     <cString> is the character string or memo field to copy to the
 *     MEMOEDIT() text buffer.  If not specified, the text buffer is empty.
 *
 *     <nTop>, <nLeft>, <nBottom>, and <nRight> are the upper
 *     left and lower right window coordinates.  Row values can range from
 *     zero to MAXROW(), and column positions can range from zero to
 *     MAXCOL().  If not specified, the default coordinates are 0, 0,
 *     MAXROW(), and MAXCOL().
 *
 *     <lEditMode> determines whether the text buffer can be edited or
 *     simply displayed.  Specifying true (.T.) allows the user to make
 *     changes to the text buffer, while specifying false (.F.) only allows
 *     the user to browse the text buffer.  If not specified, the default
 *     value is true (.T.).
 *
 *     <cUserFunction> is the name of a user-defined function that
 *     executes when the user presses a key not recognized by MEMOEDIT() and
 *     when no keys are pending in the keyboard buffer.  <cUserFunction> is
 *     specified as a character value without parentheses or arguments.
 *     Specifying false (.F.) for this argument displays <cString> and causes
 *     MEMOEDIT() to immediately terminate.  If this argument is specified,
 *     the automatic behavior of MEMOEDIT() changes.  
 *
 *     <nLineLength> determines the length of lines displayed in the
 *     MEMOEDIT() window.  If a line is greater than <nLineLength>, it is
 *     word-wrapped to the next line in the MEMOEDIT() window.  If
 *     <nLineLength> is greater than the number of columns in the MEMOEDIT()
 *     window, the window will scroll if the cursor moves past the window
 *     border.  If <nLineLength> is not specified, the default line length is
 *     (<nRight> - <nLeft>).
 *
 *     <nTabSize> determines the size of a tab character to insert when
 *     the user presses Tab.  If <nTabSize> is not specified, four spaces are
 *     inserted instead of a tab character.
 *
 *     <nTextBufferRow> and <nTextBufferColumn> define the display
 *     position of the cursor within the text buffer when MEMOEDIT() is
 *     invoked.  <nTextBufferRow> begins with one and <nTextBufferColumn>
 *     begins with zero.  If these arguments are not specified, the cursor is
 *     placed at row one and column zero of the MEMOEDIT() window.
 *
 *     <nWindowRow> and <nWindowColumn> define the initial position
 *     the cursor within the MEMOEDIT() window.  Row and column positions
 *     begin with zero.  If these arguments are not specified, the initial
 *     window position is row zero and the current cursor column position.
 *
 *  $RETURNS$
 *     MEMOEDIT() returns the text buffer if the user terminates editing with
 *     Ctrl-W or a copy of <cString> if user terminates with Esc.
 *     
 *  $DESCRIPTION$
 *     This routine captures information necessary to use the mouse within
 *     MEMOEDIT and then calls MEMOEDIT with the parameters passed to it.
 *
 *     In order to get mouse support, you must include a call to MouseMemoIdle()
 *     in your user function (<cUserFunction>) which will be called when
 *     the MEMOEDIT has gone to the idle state.
 *  $EXAMPLES$
 *     See MEMOEDIT in the Clipper documentation
 *  $SEEALSO$
 *     MOUSEMEMOIDLE()
 *  $INCLUDE$
 *     
 *  $END$
 */
*-
* LOCAL variables: 
LOCAL cResult
LOCAL nSaveTop, nSaveLeft, nSaveBottom, nSaveRight
*
* Entry Point
*

* Save old coordinates for recursive calling

nSaveTop=nTop
nSaveLeft=nLeft
nSaveBottom=nBottom
nSaveRight=nRight

* Store new coordinates
nTop=nTop1
nLeft=nleft1
nBottom=nBottom1
nRight=nRight1

* Set up the mouse

IF .NOT. lIgnoreMouse
	lMouseUsed= FT_MINIT()
	FT_MSHOWCRS()
ENDIF

cResult= MemoEdit(cString,nTop1,nLeft1,nBottom1,nRight1,lEditmode,;
	cUserfunction,nLineLength,nTabSize,nTextBufRow, nTextBufCol,;
	nWindowRow,nWindowCol)

IF lMouseUsed
	FT_MHIDECRS()
ENDIF

* Restore old coordinates

nTop=nSaveTop
nLeft=nSaveLeft
nBottom=nSaveBottom
nRight=nSaveRight

RETURN cResult


*+
FUNCTION MouseMemoIdle
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: function to provide some mouse support for memoedit
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     1/12/92   LJL       Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MOUSEMEMOIDLE()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     MemoEdit Mouse driver
 *  $SYNTAX$
 *     MOUSEMEMOIDLE() -> NIL
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This routine handles mouse input for MemoEdit(). It must be called in
 *     your <cUserFunction> when MemoEdit() indicates that it is in the idle
 *     state. It operates by polling the mouse and the keyboard (using 
 *     NEXTKEY()). If there is keyboard input control is returned to the 
 *     event handler <cUserFunction>. If mouse input is present then 
 *     this routine handles it.
 *
 *     Clicking the left button in the edit area caused the text cursor
 *     to move to that position. Clicking on a "hot spot" will cause the
 *     associated code block to be executed. The "Hot spots" are tested
 *     first so they can be in the memo edit area if you want them to be.
 *  $EXAMPLES$
 *     IF MemoEditState=ME_IDLE
 *        MouseMemoIdle()
 *     ELSEIF MemoEditState=...
 *     ENDIF
 *  $SEEALSO$
 *     MMEMOEDIT()
 *  $INCLUDE$
 *     
 *  $END$
 */


* Calling parameters: none
*
* Notes: 
*-
* LOCAL variables: 
LOCAL nMouseKey, nMouseRow, nMouseCol, nTime
LOCAL lCont:=.T.
LOCAL nKey
*
* Entry Point
*
DO WHILE lCont

	IF lMouseUsed

		nKey=0
		nMouseKey=0
		FT_MSHOWCRS()
* Loop for input
		DO WHILE (nKey=0).AND.(nMouseKey=0)
			nKey=NEXTKEY()
			nMousekey=FT_MGETPOS(@nMouseRow,@nMouseCol)
		ENDDO

* if we have input from the mouse then convert the mouse coordinates
* Get time so we can time a double click if necessary

		IF  nMouseKey>0
		   nTime=SECOND()
		ENDIF
* Clear any final release information for subsequent use

		FT_MBUTREL(0)
		FT_MHIDECRS()

	ELSE
		nMouseKey=0
		nKey=NEXTKEY(0)
	ENDIF

	IF nKey<>0
 /* Normal Key input */

		lCont=.F.

	ELSE
 /* Mouse input */

		lCont = MouseFunc(nMouseKey,nMouseRow,nMouseCol,nTime)

	ENDIF

ENDDO  // for WHILE lCont


RETURN 0

* End of file


*****
*
* MouseFunc()
*
* This function determines if the mouse is in the memoedit area and if it is 
* then action needs to be taken. 
* Additionally this routine processes any screen "hot spots" which are selected
* by the user. 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     1/17/91  LJ Letendre   Initial Version
*
* Calling Parameters:
*                    nButton - Button which was hit - reserved for future
*                    nRow - Row coordinate of mouse pointer when button hit
*                    nCol - Col coordinate of mouse pointer
*                    nTime - The system time that the button was clicked
*
* Returns: logical indicating if the input loop should be continued
*
* Notes: The processing of "Hot Spots" occurs prior to checking for the
* cursor being in the MemoEdit. Therefore, the code block will be executed
* without the check for moving the cursor to another portion of the MemoEdit.
*
*

STATIC FUNCTION MouseFunc(nButton, nRow, nCol, nTime)

*
* Local variables:
*
LOCAL j, working
LOCAL i, nButNum, nCursor
LOCAL cOutString:=""

LOCAL nRightScroll, nMoveRow, nMoveCol

* if we have input from the mouse then convert the mouse coordinates
* Clear button release counts so call can determine button is still down

IF nButton%2=1 && left button 
    FT_MBUTREL(0)
    nButNum=0
ENDIF
IF (INT(nButton/2)%2)=1 && right button
    FT_MBUTREL(1)
    nButNum=1
ENDIF
IF (nButton>=4) && middle button
    FT_MBUTREL(2)
    nButNum=2
ENDIF

nRow=INT(nRow/8)
nCol=INT(nCol/8)
nRightScroll:=nRight

* Check general hot spots

FT_MHIDECRS()
working=GeneralSpot(nButton, nRow, nCol, nTime)
FT_MSHOWCRS()

* First check to see if any action hot spots were clicked on

j=LEN(aMMouseSpot)
DO WHILE (j>=1.AND.working)

* Check coordinates
	working=.NOT.(aMMouseSpot[j,9].AND.;
				nRow>=aMMouseSpot[j,1].AND.nRow<=aMMouseSpot[j,3].AND.;
				nCol>=aMMouseSpot[j,2].AND.nCol<=aMMouseSpot[j,4].AND.;
				(aMMouseSpot[j,8]=0.OR.aMMouseSpot[j,8]=nButton))

* If we have a match then execute the code block

	IF .NOT.working

* do the request

		FT_MHIDECRS()
		EVAL(aMMouseSpot[j,5],nButton,nRow,nCol,nTime,j)
		FT_MSHOWCRS()

* Wait for release if requested
		IF aMMouseSpot[j,7]
			DO WHILE FT_MBUTREL(0)!=0
			ENDDO
		ENDIF

* Pause for the minimum amount of time
		IF aMMouseSpot[j,6]>0
			sleep(aMMouseSpot[j,6],nTime)
		ENDIF

	ENDIF
* decrement counter
	j--

ENDDO

* Look to see if the button was pressed and released inside of the area of 
* interest to indicate that the cursor must be moved.

IF working .AND. nButNum=0 .AND. ;
		(nRow>=nTop .AND. nRow<=nBottom .AND.;
		 nCol>=nLeft .AND. nCol<=nRightScroll)

* This is gross but it works

		nMoveRow=ROW()-nRow
		nMoveCol=COL()-nCol

		nCursor=SetCursor(0)
		IF nMoveRow>0
			cOutString+= REPLICATE(CHR(K_UP),nMoveRow)
		ELSEIF nMoveRow<0
			cOutString+= REPLICATE(CHR(K_DOWN),-nMoveRow)
		ENDIF

		IF nMoveCol>0
			cOutString+= REPLICATE(CHR(K_LEFT),nMoveCol)
		ELSEIF nMoveCol<0
			cOutString+= REPLICATE(CHR(K_RIGHT),-nMoveCol)
		ENDIF

		IF .NOT.EMPTY(cOutString)
			KEYBOARD cOutString
		ENDIF
		SetCursor(nCursor)
		working=.F.

ENDIF

* Now return

RETURN .T.

* End of  MouseFunc

******
*
* MEHotSpot()
*
* This function allows the caller to define a location on the screen which
* if clicked on with the mouse will cause an action to take place.
*
* Modification History:
*        Version    Date      Who         Notes
*         V1.00     2/29/92   LJL         Initial Version
* 
/*  $DOC$
 *  $FUNCNAME$
 *     MEHOTSPOT()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     Defines Mouse Hot spots for MemoEdit
 *  $SYNTAX$
 *     MEHotSpot( <nTopRow>, <nLeftCol>, <nBotRow>, <nRightCol>, <bAction>, ;
 *                <nButton>, <nSleep>, <lRelease>) -> nId
 *
 *  $ARGUMENTS$
 *     <nTopRow> - the top row of the area 
 *     <nLeftCol> - the left column of the area
 *     <nBotRow> - the bottom row of the area
 *     <nRightCol> - the right column of the area 
 *     <bAction> - Code block which will be executed when
 *              mouse is clicked in the area
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on 
 *              clicking anybutton (the code block can decide 
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presses. 
 *              Prevents routine from operating too quickly and 
 *              reading the press of a button multiple times 
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> - Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *     
 *  $RETURNS$
 *     nId which is an ID to be used to remove the area with a call
 *              to MERemHotSpot(nId)
 *  $DESCRIPTION$
 *     This routine defines a hot spot for MemoEdit, which will be activated 
 *     it the user clicks the mouse in the defined area. The action which is
 *     executed is defined by the code block bAction which is called with
 *     five arguments:
 *
 *                 nButNum: the number of the button pressed with
 *                          1=left, 2=right, 4=middle(?).
 *                 nRow: The row that the mouse cursor was in when it
 *                       was clicked
 *                 nCol: The column that the mouse cursor was in when it
 *                       was clicked
 *                 nTime: The time returned by SECOND() shortly after the
 *                       button was clicked.
 *                 nId:   The hot spot Id number.
 *
 *        Thus the code block should have a form similar to the following
 *        if one wishes to use the button/cursor information:
 *
 *      {|nButNum, nRow, nCol, nTime, nId| MyFunc(NButNum,nRow,nCol,nTime,nId)}
 *
 *  $EXAMPLES$
 *      MEHotSpot(1,10,1,20,{|| ShowHelp()},1,,.T.) // hot spot shows help
 *  $SEEALSO$
 *      MECOOLSPOT() MEWARMSPOT() MEREMHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*-

FUNCTION MEHotSpot( nTopRow, nLeftCol, nBotRow, nRightCol, bAction, nButton,;
				 nSleep, lRelease)
*
* Local variables
*

* Entry point

* Now add the coordinates

RETURN AddHotSpot(aMMouseSpot,@nMFree_spot,;
                 {nTopRow, nLeftCol, nBotRow, nRightCol, bAction,;
                  IIF(nSleep=NIL,MDefSleep(),nSleep),;
                  IIF(lRelease=NIL,MDefRelease(),lRelease),;
                  IIF(nButton=NIL,0,nButton),.T.})

* End of MEHotSpot

******
*
* MERemHotSpot()
*
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     2/28/92   LJL           Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MEREMHOTSPOT()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     This subroutine clears the specified Hotspot 
 *  $SYNTAX$
 *     MERemHotSpot( <nId> ) -> NIL
 *  $ARGUMENTS$
 *     <nID> - the ID number of the region to remove from active duty. 
 *             It is given by MEHotSpot.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine removes a mouse hot spot from the MemoEdit list of active 
 *      hot spots.
 *  $EXAMPLES$
 *      MERemHotSpot(nHelpId)
 *  $SEEALSO$
 *      MEHOTSPOT() MECOOLSPOT() MEWARMSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
* Returns: NIL
*
FUNCTION MERemHotSpot(nID)
*
* Local variables
*

* Call service routine

nMFree_Spot=RemHotSpot(nId, aMMouseSpot, nMFree_Spot)

RETURN NIL

* End of MERemHotSpot

******
*
* MECoolSpot()
*
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     2/29/92   LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MECOOLSPOT()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     This subroutine deactivates the specified MemoEdit HotSpot
 *  $SYNTAX$
 *     MECOOLSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the MemoEdit Hot Spot to remove from active 
 *           duty. It is given by MEHotSpot.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine deactivates the specified hot spot without removing it
 *      from the list of hot spots. It can later be reactivated with
 *      MEWarmSpot()
 *  $EXAMPLES$
 *      MECoolSpot(nHelpId)   // Cool off the help hot spot
 *  $SEEALSO$
 *      MEWARMSPOT() MEREMHOTSPOT() MEHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*-

FUNCTION MECoolSpot(nID)
*
* Local variables
*

aMMouseSpot[nid,9]=.F.

RETURN NIL

* End of MECoolSpot

******
*
* MEWarmSpot()
*
* This subroutine reactivates the specified HotSpot which was deactivated
* by MECoolSpot
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     2/29/92   LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MEWARMSPOT()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     This subroutine reactivates the specified MemoEdit Hot Spot
 *  $SYNTAX$
 *     MEWARMSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the MemoEdit Hot Spot to return to active 
 *           duty. It is given by MEHotSpot and should have been deactivated
 *           by MECoolSpot()
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine reactivates the specified MemoEdit hot spot after having 
 *      been deactivated by MECoolSpot(). 
 *  $EXAMPLES$
 *      MEWarmSpot(nHelpId)   // Turn the help hot spot back on
 *  $SEEALSO$
 *      MECOOLSPOT() MEREMHOTSPOT() MEHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION MEWarmSpot(nID)
*
* Local variables
*

aMMouseSpot[nId,9]=.T.

RETURN NIL

* End of MEWarmSpot

*****
*
* MEIgnoreMouse()
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     2/29/92   LJL       Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MEIGNOREMOUSE()
 *  $CATEGORY$
 *     MemoEdit
 *  $ONELINER$
 *     Ignore the mouse if present when executing MemoEdit
 *  $SYNTAX$
 *     MEIGNOREMOUSE( <lIgnore> ) -> lCurrent
 *  $ARGUMENTS$
 *     <lIgnore> - logical for ignoring mouse .T. = act as if mouse
 *               is not present. If absent just returns current setting
 *
 *  $RETURNS$
 *     Setting in effect prior to call as a logical.
 *  $DESCRIPTION$
 *     This routine causes the MemoEdit routine to ignore the mouse if present
 *     based upon the passed parameter. the current (prior to the call) 
 *     value is returned. If not parameter is passed, only the current setting
 *     is returned.
 *  $EXAMPLES$
 *     lOldSetting := MIgnoreMouse(.T.)
 *  $SEEALSO$
 *     
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION MEIgnoreMouse(lIgnore)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=lIgnoreMouse

IF lIgnore!=NIL
	lIgnoreMouse=lIgnore
ENDIF

RETURN oldsetting

* End of MEIgnoreMouse
