#include "mbrowse.ch"
#include "mousbrow.ch"
#include "inkey.ch"
#include "box.ch"
#INCLUDE "SETCURS.CH"
  /*
   *   THIS DEMO SHOWS TBNAMES.DBF CONSISTING OF LAST, FIRST, ADDR, CITY,
   *   STATE, ZIP WITH ACTIVE INDEX ON LAST + FIRST.  IT SHOWS LAST NAME,
   *   FIRST NAME, CITY ONLY FOR THOSE LAST NAMES THAT BEGIN WITH LETTER
   *   THAT YOU INPUT FOR THE CKEY GET.
   *
   *   TBNAMES.DBF/.NTX ARE AUTOMATICALLY CREATED BY THIS TEST PROGRAM
   */


FUNCTION MAIN(color_mode)
     LOCAL aFields := {}, cKey := "O", cOldColor
     LOCAL nFreeze := 1, lSaveScrn := .t., nRecSel
     LOCAL cColorList := "N/W, N/BG, B/W, B/BG, B/W, B/BG, R/W, B/R"
     LOCAL nId1, nId2, nId3, bScreenInit, cSaveClr
     LOCAL GetList:={}, bWhile
     FIELD last, first, addr, city, state, zip IN TBNames

	SET DELETED ON
	SET CONFIRM ON

	IF EMPTY(color_mode)
		color_mode=IIF(ISCOLOR(),"COLOR","MONO")
	ELSE
		color_mode=IIF(color_mode="M","MONO","COLOR")
	ENDIF

	IF color_mode="MONO"
		cColorList="N/W, N/W, N/W, W+/N,"
	ENDIF

     IF ! FILE( "TBNAMES.DBF" )
        MAKE_DBF()
     ENDIF

     USE TBNames ALIAS TBNames

     IF ! FILE( "TBNAMES.NTX" )
        INDEX ON last + first TO TBNAMES
     ENDIF

     SET INDEX TO TBNAMES

     * Pass Heading as character and Field as Block
     * To eliminate the need to use FIELDWBLOCK() function in MBROWSE()

     AADD(aFields,{"Last Name " ,{|x| IIF(x=NIL,Last,Last:=x) } } )
     AADD(aFields,{"First Name",{|x| IIF(x=NIL,First,First:=x) } } )
     AADD(aFields,{"Address"   ,{|x| IIF(x=NIL,Addr,Addr:=x) } } )
     AADD(aFields,{"City"      ,{|x| IIF(x=NIL,City,City:=x)}  } )
     AADD(aFields,{"State"     ,{|x| IIF(x=NIL,State,State:=x)},.T.,"!!",;
                  {||showhelp()},{||clearhelp()} } )
     AADD(aFields,{"Zip"       ,{|x| IIF(x=NIL,Zip,Zip:=x)},.T.,"@R 99999-9999" } )

     cOldColor := SetColor("N/BG")
     CLEAR SCREEN
     @ 6,10 SAY "Space looks at all names"
     @ 5,10 SAY "Enter First Letter Of Last Name:" GET cKey PICTURE "!"
     READ

     * TBNames->Last = cKey is the Conditional Block passed to this function
     * you can make it as complicated as you want, but you would then
     * have to modify TBWhileSet() to find first and last records
     * matching your key.
     IF EMPTY(cKey)
         GOTO TOP
         cKey=NIL
     ELSE
         SEEK cKey
     ENDIF
* Add a help mouse hot spot and a function key

     SET KEY K_F1 TO browse_help
#ifndef NO_MOUSE
     nId1:=BRHotSpot(1,7,1,13,{|| browse_help()},,,.T.)
     nId2:=BRHotSpot(1,18,1,21,{|| browse_key("QUIT")})
     nId3:=BRHotSpot(1,26,1,31,{|| browse_key("SELECT")})

     bScreenInit:={|| cSaveClr:=SetColor(IIF(color_mode="MONO","W/N","W/R")),;
				  DevPos(1,7), DevOut("F1=Help"),;
                      DevPos(1,18), DevOut("Quit"), DevPos(1,26),;
                      DevOut("Select"), SetColor(cSaveClr)}
#endif

*
* See the note in the MyReader routine below for an explanation of the while
* code block's form
*
     bWhile={|x| IIF(x=NIL,LEFT(TBNames->Last,1) == cKey, LEFT(x,1) == cKey)}
     BROWSE aFields, 3, 4, maxrow()-2, maxcol()-2 TO nRecSel WHILE bWhile ;
          KEY cKey SCREENINIT bScreeninit SAVESCREEN FREEZE nFreeze ;
          COLORS cColorList READINIT GET_ON_RETURN+DOUBLE_CLICK_GET ;
          EXIT K_ALT_E APPEND APPREAD {|| myReader()} ;
		MOVEDFUNCTION {|a,b| ShowMovement(a,b)} ;
		KEYHANDLER {|a,b| key_handle(a,b)}

* The equivalent call is shown below 

/*     nRecSel := MBROWSE(aFields,;
          {|x| IIF(x=NIL,TBNames->Last = cKey, x = cKey)}, cKey, nFreeze,;
          lSaveScrn, cColorList, 3, 2, MaxRow() - 2, MaxCol() - 2,;
          bScreenInit,GET_ON_RETURN+DOUBLE_CLICK_GET,,K_ALT_E,.T.,;
          {|| myreader()}, {|a| ShowMovement(a,b)}, {|a,b| key_handle(a,b)})
*/

/*

* Shows a browse with double click exit

     BROWSE aFields, 3, 4, maxrow()-2, maxcol()-2 TO nRecSel WHILE bWhile ;
          KEY cKey SCREENINIT bScreeninit SAVESCREEN FREEZE nFreeze ;
          COLORS cColorList ;
          EXIT K_RETURN+DOUBLE_CLICK_EXIT APPEND APPREAD {|| myReader()} ;
		MOVEDFUNCTION {|a,b| ShowMovement(a,b)}
*/

     * Note you can use Compound Condition 
     * such as cLast =: "Pierce            " and cFirst =: "Hawkeye  "
     * by changing above block to:
     *    {||TBNames->Last = cLast .AND. TBNames->First = cFirst}
     * and setting cKey := cLast + cFirst

* To be formally correct we will deactivate the mouse hot spots

#ifndef NO_MOUSE
      BRRemHotSpot(nId1)
      BRRemHotSpot(nId2)
      BRRemHotSpot(nId3)
#endif
      SET KEY K_F1 TO

     ?
     IF nRecSel == 0
        ? "Sorry, NO Records Were Selected"
     ELSE
        ? "You Selected " + TBNames->Last +" "+ ;
           TBNames->First +" "+ TBNames->City
     ENDIF
     ?

     WAIT
     SetColor(cOldColor)
     CLEAR SCREEN
  RETURN nil

  STATIC FUNCTION make_dbf
  LOCAL x, aData := {                                                               ;
     { "SHAEFER","KATHRYN","415 WEST CITRUS ROAD #150","LOS ANGELES","CA","90030" },;
     { "OLSON","JAMES","225 NORTH RANCH ROAD","LOS ANGELES","CA","90023"          },;
     { "KAYBEE","JOHN","123 SANDS ROAD","CAMARILLO","CA","93010"                  },;
     { "HERMAN","JIM","123 TOON PAGE ROAD","VENTURA","CA","93001"                 },;
     { "BURNS","FRANK","123 VIRGINA STREET","OXNARD","CA","93030"                 },;
     { "PIERCE","HAWKEYE","123 OLD TOWN ROAD","PORT MUGU","CA","93043"            },;
     { "MORGAN","JESSICA","123 FRONTAGE ROAD","CAMARILLO","CA","93010"            },;
     { "POTTER","ROBERT","123 FIR STREET","OXNARD","CA","93030"                   },;
     { "WORTH","MARY","123-1/2 JOHNSON DRIVE","OXNARD","CA","93033"               },;
     { "JOHNSON","SUSAN","123 QUEENS STREET","OXNARD","CA","93030"                },;
     { "SAMSON","SAM","215 MAIN STREET","OXNARD","CA","93030"                     },;
     { "NEWNAME","JAMES","215 MAIN STREET","LOS ANGELES","CA","90000"             },;
     { "OLEANDAR","JILL","425 FLORAL PARK DRIVE","FLORAL PARK","NY","10093"       },;
     { "SMITH","SALLY","919 SOUTH S. ST.","SUN CITY","FL","20322"                 },;
     { "JACKSON","BO","REHAB LANE","CHICAGO","IL","05505"                         },;
     { "HULL","BRETT","400 OAKLAND AVE.","ST. LOUIS","MO","63124"                 },;
     { "COWENS","DAVE","BBALL HALL OF FAME","SPRINGFIELD","MA","01067"            },;
     { "JAGER","TOM","MOUNTAIN TOP LN","SOMEWHERE","NM","82345"                   },;
     { "JOYNER","JACKEE","SPRINT LANE","TRACK CITY","CA","92435"                  },;
     { "WILLIAMS","TED","LANDSDOWN ST","BOSTON","MA","02323"                      },;
     { "TRUMAN","HARRY","PRESIDENTS ROW","INDEPENDENCE","MO","64534"              },;
     { "SMOTHERS","TOMMY","CBS TOWERS","NEW YORK","NY","09123"                    },;
     { "TISCH","LAWRENCE","MOST OF","NEW YORK","NY","09100"                       },;
     { "BIRD","BIG","SESAME ST.","HARLEM","NY","09043"                            },;
     { "KIRK","JAMES","USS ENTERPRISE","HOLLYWOOD","CA","92567"                   },;
     { "PAUL","JOHN","1 VATICAN LN","VATICAN CITY","IT","99999"                   },;
     { "SUGARMAN","CANDY","1541 SWEETHEART ROAD","HERSHEY","PA","10132"           } }

  DbCreate( "TBNAMES", { { "LAST ", "C", 18, 0, } ,;
                         { "FIRST", "C",  9, 0, } ,;
                         { "ADDR ", "C", 28, 0, } ,;
                         { "CITY ", "C", 21, 0, } ,;
                         { "STATE", "C",  2, 0, } ,;
                         { "ZIP  ", "C",  9, 0, } } )
  USE tbnames
  FOR x := 1 TO Len( aData )
     APPEND BLANK
     Aeval( aData[x], {|e,n| FieldPut( n, e ) } )
  NEXT
  USE
  RETURN NIL

FUNCTION myReader
* Creates Gets and READs for appends to the browse
*
* Calling parameters: none
*
* Returns the number of records appended
*

LOCAL cLast, cFirst, cAddr, cCity, cState, cZip
LOCAL savescr, GetList:={}, nAppend:=0
LOCAL oBrowse:=ActiveBrowse(), lOk
FIELD Last, First, Addr, City, State, Zip IN TBNames

* Obviously this routine could be placed in a loop so that multiple records
* can be added. This function was split out since it becomes too difficult to
* allow an append directly in the browse while under the restraints of a 
* while condition.

SAVE SCREEN TO savescr

@ 6,6 CLEAR TO 12,72
@ 6,6,12,72 BOX B_SINGLE

cLast=SPACE(LEN(Last))
cFirst=SPACE(LEN(First))
cAddr=SPACE(LEN(Addr))
cCity=SPACE(LEN(City))
cState=SPACE(LEN(State))
cZip=SPACE(LEN(Zip))

@ 8,10 SAY "Last Name " GET cLast
@ 9,9 SAY "First Name " GET cFirst
@ 10,12 SAY "Address " GET cAddr
@ 11,15 SAY "City " GET cCity
@ 11,43 SAY "State " GET cState
@ 11,53 SAY "Zip " GET cZip PICTURE "@R 99999-9999"

READ

RESTORE SCREEN FROM savescr

IF LASTKEY()!=K_ESC

* Test to see if the new record will be within the current scope
* Note that the while code block was written so that if an argument was passed
* it uses the argument otherwise it uses the database. This was done so that
* it could be used here
     lOk:=EVAL(WHILE_BLOCK(oBrowse),cLast) 
     IF lOk .OR. ((.NOT. lOk) .AND. ;
        UPPER(CHR(FT_DISPMSG({{"This person does not fit current criteria",;
       "Do you still wish to add this person?"}, {"B/R",,"W/R"}},;
       "YyNn",,12)))="Y")
         APPEND BLANK
         Last := cLast
         First:= cFirst
         Addr := cAddr
         City := cCity
         State:= cState
         Zip  := cZip
         nAppend=IIF(lOk,1,0)
      ENDIF
ENDIF

RETURN nAppend

*****
*
* Browse_help()
*
* Put up a help screen
*
FUNCTION Browse_help

LOCAL savescr:=SAVESCREEN()

CLEAR SCREEN

@ 5,8 SAY "This browse has many features including: Mouse support, scroll bars,"
@ 6,8 SAY "editing of the data and appending fields to the database."
@ 7,8 SAY "Mouse Support: Click on a field to move to it. Double click to edit."
@ 8,8 SAY "    Click on the arrows to move database. Left button moves one item."
@ 9,8 SAY "    Right button move page. Both on up and down goes to top or bottom."
@ 10,8 SAY "    Click on scroll bar and display moves to the corresponding"
@ 11,8 SAY "    (proportional) position in the database"
@ 12,8 SAY "    Click on help, quit or select for those actions."
@ 13,8 SAY "Editing: Hit return to edit a field."
@ 14,8 SAY "Append: Scroll to bottom and hit down arrow (key or on screen with "
@ 15,8 SAY "    mouse) and append in form."
@ 16,8 SAY "Exit: Escape selects none. Alt E selects or use the mouse."
@ 20,8 SAY "Hit any key or mouse button to return to browse."


* wait for button to be released

#ifndef NO_MOUSE

DO WHILE FT_MBUTREL(1)!=0
ENDDO

#endif

*now clear the screen and resume when requested

#ifndef NO_MOUSE
DO WHILE inkey()=0.AND.FT_MGETPOS()=0
#else
DO WHILE inkey()=0
#endif
ENDDO

RESTSCREEN(,,,,savescr)

RETURN NIL
* End of browse_help

*****
*
* ShowMovement
*
* Example of routine which is called whenever anyone moves the browse
*
* Calling Parameters: oBrowse - Current browse object
*                     nMovement - Movement indicator - Defined in MBROWSE.CH
*
*
FUNCTION ShowMovement(oBr, nMovement)
LOCAL nRow, nCol

nRow=ROW()
nCol=COL()
@ MAXROW(),3 SAY IIF(nMovement==CHANGED_RECORD,"New Record",;
		IIF(nMovement==PANNED_RECORD,"New Column",;
		IIF(nMovement==PANNED_RECORD+CHANGED_RECORD,"Both New  ",;
		"          ")))
SETPOS(nRow,nCol)

RETURN REFRESH_NONE

*****
*
* Browse_key
*
* forces a key into the buffer to perform a task such as selecting or exiting
*
* Calling Parameters: cAction - Either "QUIT" or "SELECT" as appropriate
*
* Returns: NIL
*
FUNCTION browse_key(cAction)

* Push the key on the input stack - Ugh
* Used the FT_PUTKEY function since KEYBOARD won't put a K_ALT_E in since
* its inkey code > 255

IF cAction=="QUIT"
    FT_PUTKEY(K_ESC)
ELSEIF cAction=="SELECT"
    FT_PUTKEY(K_ALT_E)
ENDIF

RETURN NIL

*End of browse_key

******
*
* Showhelp()
*
* Demo of a when clause
*
* Calling parameters: none
*
STATIC FUNCTION ShowHelp

@ 1,35 SAY "This column contains the state abbreviation."

RETURN .T.

* End of ShowHelp

*****
*
* ClearHelp()
*
* Example of using a valid in read
*
* Calling parameters: none
*
STATIC FUNCTION ClearHelp
LOCAL cOldColor

cOldColor := SetColor("N/BG")
@ 1,35 CLEAR TO 1, 79
SetColor(cOldColor)

RETURN .T.

* End of Clearhelp

******
*
* Key_Handle()
*
* Example key stroke handler
*
STATIC FUNCTION Key_Handle(nKey,oBrowse)

#define PAUSETIME 1
STATIC nTime:=-1    // initial time
STATIC cString:=""  // seek string
LOCAL nRecNo        // current record
LOCAL cChar         // input
LOCAL lMoved:=.F.   // moved

* Translate input

cChar=UPPER(CHR(nKey))

* Only doing names so only accept letters

IF cChar>="A".AND.cChar<="Z"

* Decide if the key strokes are coming in fast enough

	IF SECONDS()-nTime > PAUSETIME    

* No so build a new string

		cString=cChar

	ELSE

* yes. Append to the old string

		cString+=cChar

	ENDIF

* Seek the string
*
* Warning:  you must make sure that this fits within the while clause
*
	nRecNo=RECNO()

	SEEK UPPER(cString) SOFTSEEK

	IF !EVAL(WHILE_BLOCK(oBrowse))
		GOTO nRecNo
	ELSEIF EOF()
		TbWhileBot(oBrowse)
	ENDIF
	lMoved=(nRecNo!=RECNO())

* Get the current time since the above might take a while

	nTime=SECONDS()

ENDIF

RETURN IIF(lMoved,REFRESH_ALL,REFRESH_NONE)
