/*
 * File......: ALERT.PRG
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 06/23/93
 * Revision..: V2.0         // update to Clipper 5.2 release
 *
 *
 * Copyright 1992-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.
 *
 *
 * Alert()
 *
 * Purpose: replace clipper's alert function with mouse aware function
 *
 * Modification History:
 *        Version    Date      Who       Notes
 *         V1.00     5/29/92   LJL       Initial Version
 *         V1.01     12/26/92  LJL       Fixed empty line problem. Increased
 *                                       maximum line length
*/
#include "box.ch"
#include "inkey.ch"

*#define SPECIFY_START   // Remove comment if you wish to use the
                         // option of specifying the starting row of the
                         // alert box
#ifdef SPECIFY_START
	#stdout
	#stdout Added parameter included in ALERT
#endif

/*  $DOC$
 *  $FUNCNAME$
 *     ALERT()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Mouse Aware replacement of ALERT()
 *  $SYNTAX$
 *     ALERT( <cMessage> [, <aOptions] [, <cColorString>] [, <nStartRow>])
 *         --> <nChoice>
 *  $ARGUMENTS$
 *     <cMessage> defines a message shown centered in the alert box.
 *     If the message contains one or more semicolons, the text after the
 *     semicolons is centered on succeeding lines in the dialog box.
 *
 *     <aOptions> defines a list of possible responses to the dialog
 *     box.
 *
 *     <cColorString> which is a color string defining the colors of the alert
 *     box. The standard color is used for the box and the background. The
 *     selected color is used for the options. This option is available within
 *     the standard Clipper ALERT function but is undocumented. It defaults to
 *     "W+/R+, W+/B+","W+/N, N/W+" for color and monochrome screens.
 *
 *     <nStartRow> which is an option which specifies the starting row of the
 *     alert box. This option is normally disabled by compiler directive but
 *     can be turned on for more flexibility in the use of ALERT. If NIL then
 *     normal behavior of centering occurs.
 *
 *  $RETURNS$
 *     ALERT() returns a numeric value indicating which option was
 *     chosen.  If the Esc key is pressed, the value returned is zero.
 *  $DESCRIPTION$
 *     The ALERT() function creates a simple modal dialog.  It is useful in
 *     error handlers and other "pause" functions.  The user can respond
 *     chosen by moving a highlight bar and pressing the Return or Space
 *     keys, or by pressing the key corresponding to the first letter of
 *     the option.  If <aOptions> is not supplied, a single "Ok" option is
 *     presented.
 *
 *     NOTE: If you use RTLINK with PLLs then you must rebuild your PLL to
 *     exclude ALERT. You do this by just adding the line "exclude ALERT" to
 *     BASE50.LNK and running RTLINK. (Turn off the PLL switch if it is in
 *     your RTLINKCMD environment variable.) Ignore any doubly defined symbol
 *     warning message. They cause no harm.
 *
 *  $EXAMPLES$
 *     nResult=ALERT("Floppy Not Ready",{"Abort","Retry"})
 *  $SEEALSO$
 *     MInkey()
 *  $INCLUDE$
 *     
 *  $END$
 */

#ifndef SPECIFY_START
FUNCTION ALERT(cMessage,aOptions,cColorString)
#else
FUNCTION ALERT(cMessage,aOptions,cColorString,nStartRow)
#endif

* Local Variables
#define LONGEST_LINE  55      // Longest line in text

LOCAL aTextLines:={}
LOCAL nLongest, nTemp, i, nStart
LOCAL cSaveColor, cSaveScreen
LOCAL nResult
LOCAL lUseMouse:=FT_MINIT()
LOCAL nTop, nLeft, nBottom, nRight
LOCAL aSaveKey[8]
LOCAL nSaveX, nSaveY
LOCAL nNumLines, nRow, nStartSave
LOCAL nN, nChoiceLines
LOCAL nCols:=MAXCOL()
LOCAL cSaveDev:=SET(_SET_DEVICE,"SCREEN")
LOCAL nSaveRow:=ROW()
LOCAL nSaveCol:=COL()

* Take care of the defaults
IF aOptions=NIL

	aOptions={"Ok"}

ENDIF

* First parse the text lines

aTextLines=ListAsArray(cMessage,";")

* Find the longest and adjust any that are too long

nLongest=0
i=1
DO WHILE i<=LEN(aTextLines)

* Now check for too long

	nTemp=IIF(!EMPTY(aTextLines[i]),LEN(aTextLines[i]),0)

	IF nTemp>LONGEST_LINE

* Find first space prior to LONGEST_LINE to break the line

		nTemp=RAT(" ",LEFT(aTextLines[i],LONGEST_LINE))

* If there is no space then just break the line???

		IF nTemp=0
			nTemp=LONGEST_LINE
		ENDIF

* No make the array larger and break up the line

		AINS(AADD(atextLines,NIL),i+1)
		aTextLines[i+1]=SUBSTR(aTextLines[i],nTemp+1)
		aTextLines[i]=LEFT(aTextLines[i],nTemp)
	ENDIF

* Now test for the longest

	IF nTemp>nLongest
		nLongest=nTemp
	ENDIF
	i++
ENDDO

* Add spaces to the longest line

nLongest+=10

* Now determine the length of the choices

nTemp=2
AEVAL(aOptions,{|a| nTemp+=LEN(a)+4})
nChoiceLine=0

IF nTemp>LONGEST_LINE

	nStart:=nStartSave:=INT((nCols-LONGEST_LINE+6)/2)
	nTemp=0
	FOR i=1 TO LEN(aOptions)
		IF nStart+LEN(aOptions[i])+2>=LONGEST_LINE
			nTemp=nStart-2
			nStart=nStartSave
			nChoiceLines++
		ELSE
			nStart+=LEN(aOptions[i])+4
		ENDIF

	NEXT
ELSE
	nChoiceLines=1
ENDIF

IF nTemp>nLongest
	nLongest=nTemp
ENDIF

* Set colors and build the box

cSaveColor=SETCOLOR(IIF(cColorString=NIL,IIF(ISCOLOR(),;
				"W+/R+, W+/B+","W+/N, N/W+"),cColorString))

nNumLines=LEN(aTextLines)

* Depending upon compiler directive include standard or enhanced
* behavior

#ifndef SPECIFY_START

nTop=INT((MAXROW()-nNumLines-3)/2)

#else

IF nStartRow=NIL

	nTop=INT((MAXROW()-nNumLines-3)/2)
ELSE
	nTop=MIN(MAXROW()-nNumLines-3,nStartRow)
ENDIF

#endif

nBottom=nTop+nNumLines+nChoiceLines+2
nLeft=INT((nCols-nLongest)/2)
nRight=nLeft+nLongest

cSaveScreen=SAVESCREEN(nTop,nLeft,nBottom,nRight)

@ nTop, nLeft CLEAR TO nBottom, nRight

@ nTop, nLeft, nBottom, nRight BOX B_SINGLE

* Put up the messages

FOR i=1 TO nNumLines

	IF !EMPTY(aTextLines[i])
		@ nTop+i, INT((nCols-LEN(aTextLines[i]))/2) SAY aTextLines[i]
	ENDIF
NEXT

* Now use menu to to present options

nStart:=nStartSave:=INT((nCols-nTemp+6)/2)
nRow=nBottom-nChoiceLines

FOR i=1 TO LEN(aOptions)

* Test for going beyond end of box
	IF nStart+LEN(aOptions[i])+2>=nRight
		nRow++
		nStart=nStartSave
	ENDIF

* Now make menu

	@ nRow, nStart PROMPT " "+aOptions[i]+" "
	nStart=COL()+2

NEXT

* Save mouse position

IF lUseMouse
	FT_MGETPOS(@nSaveX,@nSaveY)
	FT_MSETPOS(8*(nBottom-nChoiceLines),4*(nCols-nTemp+8))
ENDIF

* Set the space key to be a return disable other menu to termination keys

aSaveKey[1]={32,SETKEY( 32, {|| __Keyboard(CHR(K_RETURN))})}
aSaveKey[2]={K_HOME,SETKEY(K_HOME,{|| nN:=0})}
aSaveKey[3]={K_END,SETKEY(K_END,{|| nN:=0})}
aSaveKey[4]={K_PGUP,SETKEY(K_PGUP,{|| nN:=0})}
aSaveKey[5]={K_PGDN,SETKEY(K_PGDN,{|| nN:=0})}
aSaveKey[6]={K_UP,SETKEY(K_UP,{|| nN:=0})}
aSaveKey[7]={K_DOWN,SETKEY(K_DOWN,{|| nN:=0})}

* Get the user's response

MENU TO nResult

* restore the mouse, keys and screen

IF lUseMouse
	FT_MSETPOS(nSaveX,nSaveY)
ENDIF

FOR i=1 TO 7
	SETKEY( aSaveKey[i,1], aSaveKey[i,2])
NEXT

* restore the screen and devices to the original

SETCOLOR(cSaveColor)

RESTSCREEN(nTop,nLeft,nBottom,nRight,cSaveScreen)

DEVPOS(nSaveRow,nSaveCol)

SET(_SET_DEVICE, cSaveDev)

* Return to caller

RETURN nResult

/***
*  ListAsArray( <cList>, <cDelimiter> ) --> aList
*  Convert a delimited string to an array - Taken from
*  CLIPPER5\SOURCE\STRING.PRG
*
*/
STATIC FUNCTION ListAsArray( cList, cDelimiter )
   LOCAL nPos
   LOCAL aList := {}                            // Define an empty array

   IF cDelimiter = NIL
      cDelimiter := ","
   ENDIF
   //
   DO WHILE (nPos := AT(cDelimiter, cList)) != 0
      AADD(aList, SUBSTR(cList, 1, nPos - 1))   // Add a new element
      cList := SUBSTR(cList, nPos + 1)
   ENDDO
   AADD(aList, cList)                           // Add final element
   //
   RETURN aList                                 // Return the array
