#include "inkey.ch"
#include "achoice.ch"
#include "box.ch"

STATIC nId  // id number for the achoice hot spot
STATIC nID2 // id number for the menu hot spot

FUNCTION MAIN()
LOCAL nChoice, saveclr:=SETCOLOR("W/B, R/W,,,G/N+")

* initialize now so slow BIOS' don't show their weaknesses

FT_MINIT()

* Put up a menu of achoice types

CLEAR SCREEN
SET WRAP ON

DO WHILE .T.
	SET MESSAGE TO 2
	@ 1,1 PROMPT "Scroll" MESSAGE "Achoice demo with scroll bars"
	@ 1, COL()+2 PROMPT "NoScroll" MESSAGE "Achoice without scroll bars"
	@ 1, COL()+2 PROMPT "Exit" MESSAGE "Return to DOS"
	@ 6,5 SAY "Clicking on an item selects it. You can move the mouse over an"
	@ 7,5 SAY "item with the left button down to scroll to it."

	@ 1,70 SAY "F1=Help"
	SET KEY K_F1 TO amhelp
	nId2=MHotSpot(1,70,1,76,{|nBut,nRow,nCol,nTime,nMId| amhelp(nBut,nRow,nCol,nTime,nMId)};
	,,,.T.)
	MENU TO nChoice
	MRemHotSpot(nId2)
	SET KEY K_F1 TO
	IF nChoice=0.OR. nChoice>2
		RETURN NIL
	ELSEIF nChoice=1
		DemoAChoice("S")
	ELSE
		DemoAChoice("N")
	ENDIF
ENDDO

SETCOLOR(saveclr)

RETURN NIL

* End of MAIN()


FUNCTION DemoAchoice(cMode)

* demo achoice
#define NUMELEMENTS 4
LOCAL aArr[NUMELEMENTS], lArr[NUMELEMENTS]
LOCAL i, savescr:=SAVESCREEN()

FOR i=1 To NUMELEMENTS

	lArr[i]=.T.//((i%3)<>1)
	aArr[i]="Item "+STR(i,2,0)

NEXT
CLEAR SCREEN
* give some indication of what is going on
@ 11,30 SAY                  "The mouse will select the item if you click"
@ 12,30 SAY                  "on it and it is selectable (white on blue)."
@ 13,30 SAY                  "The mouse can also scroll up and down and"
@ 14,30 SAY                  "the selected item (red on white) will keep up."
@ 15,30 SAY                  "Click on the scroll bar arrows: left button moves"
@ 16,30 SAY                  "one item; right button one page; both top or"
@ 17,30 SAY                  "bottom. Clicking in scroll moves to that relative"
@ 18,30 SAY                  "position. Clicking outside of area terminates the"
@ 19,30 SAY                  "achoice. However, moving through the menu"
@ 20,30 SAY                  "deactivates the abort. Above is the values of the"
@ 21,30 SAY                  "user function calls"
@ 10,10, 18,20 BOX B_SINGLE
@ 8,10 SAY "F1=Help"

SET KEY K_F1 TO achelp
nID=ACHotSpot(8,10,8,16,{|nBut,nRow,nCol,nTime,nMId| achelp(nBut,nRow,nCol,nTime,nMId)};
	,,,.T.)
i=ACHOICE(11,11,17,19,aArr,lArr,"myfunc",MIN(NUMELEMENTS,3),2,cMode="S")

ACRemHotSpot(nId)
SET KEY K_F1 TO

@ 24,10 SAY "Item "+STR(i,2,0)+" Selected - Waiting 3 seconds"

MINKEY(3)

RESTSCREEN(,,,,savescr)

RETURN NIL

FUNCTION myfunc(nAction,nElement,nLine,MouseKey)

LOCAL cString, nReturn:=AC_CONT
LOCAL nKey

IF MouseKey=NIL
	MouseKey=0
ENDIF

DO CASE
CASE nAction=AC_IDLE
	cString="Idle     "
CASE nAction=AC_HITTOP
	cString="HitTop   "
CASE nAction=AC_HITBOTTOM
	cString="HitBottom"
CASE nAction=AC_EXCEPT
	cString="Exception"
CASE nAction=AC_NOITEM
	cString="NoItems  "
	nReturn=AC_ABORT
OTHERWISE
	cString="Unknown  "
ENDCASE

@6,40 SAY "State:  "+cString
@7,40 SAY "Element:"+STR(nElement,3,0)
@8,40 SAY "Line:   "+STR(nLine,3,0)

IF nAction=AC_EXCEPT

	nKey=LASTKEY()
	IF nKey=K_ESC.OR.MouseKey=K_ESC
		nReturn=AC_ABORT
	ELSEIF nKey=K_RETURN
		nReturn=AC_SELECT
	ELSE
		nReturn=AC_GOTO
	ENDIF
ENDIF

RETURN nReturn




FUNCTION acHelp

* This routine just puts up another achoice to test it being called as an
* interupt from another achoice

LOCAL aMenu:={"Choice 1","Selection 2","Item 3"}
LOCAL savescr:=SAVESCREEN()

SET KEY K_F1 TO

* Cool off the hot spot

ACCoolSpot(nId)

@20,1 CLEAR TO maxrow(),maxcol()

@ 15,12,19,24 BOX B_SINGLE
@ 21,0 SAY "Picking any item will exit the above menu."
@ 22,0 SAY "Clicking on an item will select. Moving over an item with the left button down"
@ 23,0 SAY "will highlight that item. Clicking outside of the box will abort the menu."

ACHOICE(16,13,18,23,aMenu)

RESTSCREEN(,,,,savescr)

SET KEY K_F1 TO achelp
* Warm up the hot spot again

ACWarmSpot(nId)

RETURN NIL

FUNCTION amhelp

* This routine demonstrates that a menu can be called from within a function
* key interupt or mouse hot spot with a menu already active.

LOCAL savescr:=SAVESCREEN(), nChoice

SET KEY K_F1 TO

* Cool off the hot spot

MCoolSpot(nId2)
@ 21,0 SAY "Picking any item will exit the above menu."
@ 22,0 SAY "Clicking on an item will select. Moving over an item with the left button down"
@ 23,0 SAY "will highlight that item."


SET MESSAGE TO 11 CENTER
@ 10,1 PROMPT "Item1" MESSAGE "This is item 1"
@ 10, COL()+2 PROMPT "Item2" MESSAGE "This is item 2"
@ 10, COL()+2 PROMPT "Item3" MESSAGE "This is item 3"

MENU TO nChoice

RESTSCREEN(,,,,savescr)

SET KEY K_F1 TO amhelp

* Warm up the hot spot again

MWarmSpot(nId2)

RETURN NIL
