Class:Contact           | Class definition for a Contact structure
  Index:FullName        | Full name
  Index:Company         | Company
  Index:WorkPhone       | Work Phone
  Index:LastName        | Last Name
  Index:ZipCode         | Zip Code
  Addr1                 | Address
  Addr2
  Addr3
  HomePhone             | Home Phone
  WorkPhone
  FaxPhone
  Birthday
  Anniversary
  Dear
  Comment
  Notes                 | Notepad
  Type

MailList:Start                     | Little Mail List Program
  New (Contact:Con)                | Create Contact Structure
  Jorf:File ("CONTACT.JCM",Here)   | Set Database File to CONTACT.JCM
  Event:Add ("MailKey","Key",Here) | Set MailKey as a keystroke handler
  Mem:Ptr->IndexName = "FullName"  | Index Name

  | The main screen with menu options
  Win:Add ("Josephine's Mail List Manager", 2, 2, 22, 78, Here)
    Menu:"&File"
      Menu:"&About            "  Action:"MailList:About"
      Menu:
      Menu:"&Rebuild        ",   Action:"Jorf:Rebuild"
      Menu:
      Menu:"E&xit        Alt-X", Action:"Kbd:Put('Esc_Key')"

    Menu:"&Edit"
      Menu:"&Add     Alt-A", Action:"MailList:Add(Con)"    HotKey:"Alt_A_Key"
      Menu:"&Change  Alt-C", Action:"MailList:Change(Con)"
      Menu:"&Delete  Alt-D", Action:"MailList:Delete(Con)" HotKey:"Alt_D_Key"

    Menu:"&Search",
      Menu:"&Name       ",  Action:"MailList:KeySearch (Con, 'FullName' )
      Menu:"&Company    ",  Action:"MailList:KeySearch (Con, 'Company'  )
      Menu:"&Last Name  ",  Action:"MailList:KeySearch (Con, 'LastName' )
      Menu:"&Phone      ",  Action:"MailList:KeySearch (Con, 'WorkPhone')
      Menu:"&Zip        ",  Action:"MailList:KeySearch (Con, 'ZipCode'  )

    Menu:"&Reports"
      Menu:"&Mail List    ", Action:"MailList:List()"
      Menu:"&This Contact ", Action:"MailList:PrintData(Con)"
      Menu:"&Lotsa Labels ", Action:"MailList:ContinLabels(Con,'All')"
      Menu:"&One Label",     Action:"MailList:ContinLabels(Con,'One')"

    InpBefore:"MailList:Lock(Con)"
    Group:"&Browse List", Row:1 Col:41, Len:6, Wid:36
    List:""
      Field:"Con"
      Next:"MailList:NextRecord(Con,'Next')"
      Prev:"MailList:NextRecord(Con,'Prev')"
      Show:"MailList:Show(Con)"
      Before:"MailList:Write()"
      Display:"(Mem:Ptr->Locked==Null)"

    Group:"&Contact Name and Address", Row:1, Col:1, Wid:38, Len:6
    Input:"Name   ",    Wid:30, Field:"Con->FullName"
      After:"MailList:SplitName(Con)"
    Input:"Company", Wid:30,    Field:"Con->Company"
    Input:"Address", Wid:30,    Field:"Con->Addr1"
    Input:"       ", Wid:30,    Field:"Con->Addr2"
    Input:"       ", Wid:30,    Field:"Con->Addr3"
      After:"MailList:ZipCode(Con)"

    Group:"Mail List Fields"
      Row:9  Col:1  Len:11  Wid:76
    Input:"&Work Phone" Field:"Con->WorkPhone"
      Row:10  Col:2  Wid:20
    Input:"&Home Phone"  Field:"Con->Homephone"
      Row:11  Col:2  Wid:20
    Input:"Fax &Phone " Field:"Con->FaxPhone"
      Row:12  Col:2  Wid:20
    Input:"Birthda&y  " Field:"Con->BirthDay"
      Row:13  Col:2  Wid:20
    Input:"C&omment   "  Field:"Con->Comment"
      Row:15  Col:2  Wid:50
    Input:"&Last Name " Field:"Con->LastName"
      Row:10  Col:35  Wid:14
    Input:"Dear      " Field:"Con->Dear"
      Row:11  Col:35  Wid:14
    Input:"Zip Code  " Field:"Con->Zipcode"
      Row:12  Col:35  Wid:14
    Radio:"Fr&iend"
      Check:"Con->Type=='Friend'"
      Action:"Con->Type='Friend'"
      UnAction:"Con->Type= Null"
      Row:10  Col:62
    Radio:"Fa&mily"
      Check:"Con->Type=='Family'"
      Action:"Con->Type='Family'"
      UnAction:"Con->Type= Null"
      Row:11  Col:62
    Radio:"Clien&t"
      Check:"Con->Type=='Client'"
      Action:"Con->Type='Client'"
      UnAction:"Con->Type= Null"
      Row:12  Col:62
    Radio:"&Vendor"
      Check:"Con->Type=='Vendor'"
      Action:"Con->Type='Vendor'"
      UnAction:"Con->Type= Null"
      Row:13  Col:62
    HLine:"&Notes"
      Row:16  Col:2  Len:1  Wid:76
    Text:"" Field:"Con->Notes"
      Row:17  Col:2  Len:4  Wid:76
  Return (Ok)                         | That is all, Folks!

MailList:About
  Msg:Add ("The JORF Mail List Manager", "Ok")
    The JORF MailList Manager   Version 1.0     December 22, 1992

    Copyright (C) 1992 by Wayland Bruns, All Rights Reserved

    This program is a small version of the CONTACT.J contact manager. &
    It features a name/address/phone number file, and limited &
    label printing.  It does not support multiple files, filters &
    and mail merge capability all found in CONTACT.J.

    Use this program as a base for new data base applications.  It &
    is less complex than CONTACT.J but contains multiple keys, &
    record locking and screen management functions needed by all &
    data bases. For an even simpler example, see FILTER.J
  Return (Ok)

MailList:Add(*Con)                 | Create a new record
  | The key to creating a new record is to use the New function.
  | The new function must be the first function used in a method.
  | The new function is the only way in JORF to allocate memory
  | and disk resources to create a new piece of data.
  New (Contact:NewCon)            | Create and new empty maillist structure
  NewCon->FullName = "New Record"  | Set a piece of data in it
  Jorf:Write(NewCon)               | Write it to the correct file
  Con = NewCon                      | And reset "Con" to point to our new one.
  Win:Dsp                         | Redisplay everything
  Kbd:Put("Alt_C_Key")            | Move the cursor to "Name"
  Return(Ok)

MailList:Change()               | Change the current Con record
  Kbd:Put("Alt_C_Key")          | stuff Alt_C to move the cursor to Name
  Return(Ok)                    | That is all!

MailList:ContinLabels(Con,Flag)
  New (Dest,Count,i)
  Dest=Jorf:Printer()
  If (Dest)
    | Report format for Continuous labels, 6 lines per label, 1 line between
    |
    Rep:Add ("Continuous Labels")
      Next:"MailList:Nextlabel(Con,Flag,Count)"
      Item:"" NewRow:1 Col:26 Wid:12
      Item:"Con->FullName"    NewRow:1 Col:1  Wid:40
      Item:"Con->Company"     NewRow:1 Col:1  Wid:40
        Before:"Con->Company!=Null"
      Item:"Con->Addr1"       NewRow:1 Col:1  Wid:40
      Item:"Con->Addr2"       NewRow:1 Col:1  Wid:40
      Item:"Con->Addr3"       NewRow:1 Col:1  Wid:40
      Item:"" NewRow:1
        Before:"Con->Company==Null"

    | I like to append one blank label to advance the printer so I can
    |  tear off the label just printed.
    For (i=1 Thru 5)
      File:Append("JREPORT.LST")

    | The Rep:Add function does not actually print, it just makes
    | a report file called JREPORT.LST.  We can print this file
    | using the File:Print function.
    File:Print("JREPORT.LST",Dest,TRUE)
  Return(Ok)

MailList:Delete(Con)             | Delete MailList Record
  New (Result)

  | Pop up a nice screen to ask if they are sure
  Result=Msg:Add('MailList Delete','No')
    Delete this contact?

    Name:     {Bold:5}{Str:Pad(Con->FullName,30)}{Bold:0}
    Company:  {Bold:5}{Str:Pad(Con->Company ,30)}{Bold:0}
    Address : {Bold:5}{Str:Pad(Con->Addr1,30)}{Bold:0}
              {Bold:5}{Str:Pad(Con->Addr2,30)}{Bold:0}
              {Bold:5}{Str:Pad(Con->Addr3,30)}{Bold:0}

  | If they said "Yes", then Result will equal Ok (1)
  If (Result==Ok)
    Jorf:Del(Con)
    Win:Dsp
  Return (Ok)

MailList:KeySearch (*Con, Field)
  New (Value,Prompt)

  Event:Add               | Block "MailKey" Events so Alt-C won't work
  Switch (Field)
    Case ("FullName")
      Prompt="Name"
    Case ("Company")
      Prompt="Company"
    Case ("WorkPhone")
      Prompt="Phone"
    Case ("LastName")
      Prompt="Last Name"
    Case ("ZipCode")
      Prompt="Zip Code"
    Else
      Msg:Add
        Unknown Field {Field}
      Return (Ok)

  Win:Add ("Key Search", 10, 15, 6, 60, Here)
    Input:"Search for {Prompt}", Row: 2 Col:5 Wid:30, Field:"Value"
    Button:"&Search"  Row:4 Col:5  Wid:20 Action:"Return (Null)"
    Button:"&Cancel"  Row:4 Col:35 Wid:20 Action:"Return ('Esc_Key')"

  If (Kbd:Got <> "Esc_Key")
    Mem:Ptr->IndexName=Field
    Con=Struct:Find('Contact',Mem:Ptr->IndexName,Value)
    If (Con==Null)
      If (Value)
        Msg:Add
          Cannot find {Prompt} {Value}
      Con=Struct:Find('Contact',Mem:Ptr->IndexName,Null)
    Win:Dsp
  Return (Ok)

MailList:List()
  New (Dest,Date,Page,Con,Count)
  Dest=Jorf:Printer()
  If (Dest)
    Date = Date:Str(Date:Get,"s d, yyyy")
    Rep:Add ("MailList Listing", 5, 5, 60, 75, Here)
      Header:"'MailList Listing Report'"    NewRow:1 Col:30
      Header:"'Page '+Page"        NewRow:1 Col:1
        Before:"MailList:NextPage(Page)"
      Header:"'Date '+Date"                Col:54
      Header:"Str:AtSet(Null,1,'-',70)"     NewRow:1 Col:1
      Next:"MailList:NextLabel(Con,'All',Count)"
      Item:"Con->FullName"      NewRow:2 Col:1  Len:28
      Item:"Con->Company "               Col:30 Len:32
      Item:"Con->WorkPhone"              Col:62 Len:28
      Item:"Con->Addr1+', '+Con->Addr2+' '+Con->Addr3"
        NewRow:1 Col:5  Len:70
    File:Print("Jreport.lst",Dest)
  Return (Ok)

MailList:Lock(Con)
  If (Mem:Ptr->Locked==Con)
    If (Win:Ptr->InpField = "Con->Notes")
      Win:Msg("Press Alt-B to finish note and return to Browse Area")
    Else
      Win:Msg("You have locked this Record")
    Return (Ok)
  MailList:Write()
  If (Jorf:Lock(Con))
    Mem:Ptr->Locked=Con
    Win:Msg("You have locked this Record")
    Return (Ok)
  If (Con <> Mem:Ptr->Unlocked)         | If first time
    Msg:Add("Record is Locked")         |  show message
      Either someone else has this
      record locked now, or it has
      been locked before but never
      unlocked.

      If no one else is in the data
      base, you can unlock this
      record by rebuilding the file.
    Mem:Ptr->Unlocked = Con              | Make a record that message is shown
  Return(Null)

MailList:NextLabel(*Con,Flag,*Count)     | Label "Next function
  | If Flag = "All", Returns next record according to index.
  | If Flag = One, returns Con if count is 1 and Null if Count > 1
  |  returning null indicates that there is no "Next" record and the
  |  report is finished.
  Count = Count + 1
  If (Flag=='All')
    If (Count == 1)
      Con = Null
    Con = MailList:NextRecord(Con,'Next')
  Else
    If (Count > 1)
      Con=Null
  Return (Con)

MailList:NextPage(*Page)                | Increment page counter
  ++Page
  Return (Ok)

MailList:NextRecord(*Con,Flag)           | Return next or prev record
  | Gets the next (or previous) record depending on Flag
  | Flag is "Next" or "Prev" Easy!
  MailList:Write()                      | Write current record if necessary
  If (Flag=='Prev')
    Con=Struct:Prev('Contact',Mem:Ptr->IndexName,Con)
  Else
    Con=Struct:Next('Contact',Mem:Ptr->IndexName,Con)
  Return(Con)

MailList:PrintData(Con)
  | Print the data from this entry - Uses a report "Format" in
  |  the file MAILLIST.RPT.  This format is an ASCII file that
  |  can easily be modified.
  New (Dest,MailList,Date,Page)
  If (File:Exist("MailList.Rpt")==False) | If file not found.
    Msg:Add
      Print format "MailList.Rpt" is
      not in the current directory.
    Return (Ok)
  Dest=Jorf:Printer()                           | Get printer
  If (Dest)
    Date = Date:Str(Date:Get,"s d, yyyy")       | Set Date
    Rep:Add ("MailList Information", 5, 5, 60, 75,Here)
      | Report header . . .
      Header:"'MailList Information Report'"    NewRow:1 Col:30
      Header:"'Page '+Page"                     NewRow:1 Col:1
        Before:"MailList:NextPage(Page)"
      Header:"'Date '+Date"                              Col:54
      Header:"Str:AtSet(Null,1,'-',70)"         NewRow:1 Col:1
      | To print report text, Ust say "Text"
      Text:"File:Load('MailList.Rpt')"
      | Rep:Add system uses a "Next" to get the next record.
      | For this report, we only want to show one record, so
      | we make the next function return "Null" indicating that
      | there is no next record and the report is finished.
      Next:"Null"
    | The JORF report system only makes a print file called JREPORT.LST.
    | Once created, we use File:Print to print it.
    File:Print("Jreport.lst",Dest)
  Return (Ok)

MailList:Show (Con)
  | The "Show" routine is used for the browser window.  The data that
  | is shown changes depending on the index in use - (try switching to
  | the phone number or zip code indexes to see the difference).
  New (Display)                        | Create "Display"
  Switch (Mem:Ptr->IndexName)
    Case ("FullName")
      Display = Str:Pad(Con->FullName,17)+' '+Str:Pad(Con->Company,17)
    Case ("Company")
      Display = Str:Pad(Con->Company,17)+' '+Str:Pad(Con->FullName,17)
    Case ("WorkPhone")
      Display = Str:Pad(Con->WorkPhone,17)+' '+Str:Pad(Con->FullName,17)
    Case ("LastName")
      Display = Str:Pad(Con->LastName,10)+' '+Str:Pad(Con->Dear,12)
      Display = Display +' '+Str:Pad(Con->Company,17)
    Case ("ZipCode")
      Display = Str:Pad(Con->ZipCode,5)+' '+Str:Pad(Con->Company,16)
      Display = Display +' '+Str:Pad(Con->FullName,12)
  Return (Display)

MailList:SplitName(Con)          | "After" function to find Dear and lastname
  If (Con->FullName)                     | If there is a name
    If (Con->Dear==Null)                 |  But dear is still empty
      Con->Dear=Word:At(Con->FullName,1)  | Dear is the first word
    If (Con->LastName==Null)             | Last name is the last word
      Con->LastName=Word:At(Con->FullName,Word:Len(Con->FullName))
  Return (Ok)                   | This works in most cases.

MailList:Write()
  New (Result,Con)
  If (Mem:Ptr->Locked)           | If there is a locked record
    Jorf:Write(Mem:Ptr->Locked)  |   write it
    Win:Dsp                      |   and redisplay browse box
    Mem:Ptr->Locked=Null         | No longer locked
    Win:Msg()                    | Erase "Locked" message
  Return (Ok)                    | That is all

MailList:ZipCode (Con)           | "After" function to set zip code
  New (Field)                    | Create new variable "Field"
  If (Con->ZipCode==Null)        | If zip code is still blank
    If (Con->Addr3)              | Find the last line of the address
      Field=Con->Addr3           |   is it line 3?
    Else
      Field=Con->Addr2           |   or line 2.
    While (Str:In(Field," "))   |               While there is a space
      Field=Str:At(Field,Str:In(Field," ")+1)  | take away up to space+1
    Con->ZipCode=Field           | Now we have the last expression of the
    Win:Dsp                     |  line - set zip.  Redisplay everything.
  Return (Ok)

MailKey:Alt_F4_Key
  Return (MailKey:Esc_Key())   | Alt_F4 (Windows exit) - same as Esc_Key

MailKey:Alt_X_Key
  Return (MailKey:Esc_Key())   | Alt_X - does same as Esc_Key

MailKey:Enter_Key
  | Change enter key - to tab key.  This makes a lot of PC people
  | happier.  In Windows land, the Tab key moves between fields,
  | but in DOS land, the Enter key does this.  JORF defaults to Windows
  | "Common User Access" Standard, but this routine lets us also
  | support the common DOS practice (Even though this is not "Standard".
  |
  | Test if we are in an input then InpLen is set to the
  |  number of input lines.
  If (Win:Ptr->InpLen == 1)
    Return ("Tab_Key")
  Return (Null)

MailKey:Esc_Key         | Block the escape key - provide an exit routine.
  New (Res)
  MailList:Write()
  Res=Msg:Add(Null,"Cancel")
    This will end your session with
    Josephine's MailList Manager
  If (Res)
    Return ("Esc_Key")
  Return (Ok)

MailKey:Shift_F5_Key
  Jorf:Status
  Jorf:StatusClear
  Return (Ok)

MailKey:Alt_F5_Key
  Win:Add
    Flushing
  Jorf:Flush
  Return (Ok)

