Class:Calc      | Declare class Calc
  Entry         | Current entry value
  Op            | Last operation key
  Result        | Result of last calc

Calc:start
  New(Calc:Calc)
  Calc->Entry  = "0"
  Calc->Result = "0"
  Mem:Ptr->Calc=Calc
  Event:Add(Null)

  Win:Add ("Calculator",0,0,8,17)
    Button:"&=",    Row:8, Col:14, Wid:3, Len:1 Action:"Calc:Do('=')"

    Input:"Res"  Row:1, Col:2, Wid:11, Len:1
      Field:"Mem:Ptr->Calc->Result" Before:"Null"
    Input:"Ent"  Row:2, Col:2, Wid:9, Len:1
      Field:"Mem:Ptr->Calc->Entry" Before:"Null"
    Input:""        Row:2, Col:15, Wid:1, Len:1
      Field:"Mem:Ptr->Calc->Op"    Before:"Null"
    HLine:"" Row:3
    Button:"&C",    Row:4, Col:2,  Wid:3, Len:1 Action:"Calc:Do('C')"
    Button:"c&E",   Row:4, Col:6,  Wid:3, Len:1 Action:"Calc:Do('E')"
    Button:"e&Xit", Row:4, Col:10, Wid:3, Len:1 Action:"Calc:Do('X')"
    Button:"&/",    Row:4, Col:14, Wid:3, Len:1 Action:"Calc:Do('/')"

    Button:"&7",    Row:5, Col:2,  Wid:3, Len:1 Action:"Calc:Do('7')"
    Button:"&8",    Row:5, Col:6,  Wid:3, Len:1 Action:"Calc:Do('8')"
    Button:"&9",    Row:5, Col:10, Wid:3, Len:1 Action:"Calc:Do('9')"
    Button:"&*",    Row:5, Col:14, Wid:3, Len:1 Action:"Calc:Do('*')"

    Button:"&4",    Row:6, Col:2,  Wid:3, Len:1 Action:"Calc:Do('4')"
    Button:"&5",    Row:6, Col:6 , Wid:3, Len:1 Action:"Calc:Do('5')"
    Button:"&6",    Row:6, Col:10, Wid:3, Len:1 Action:"Calc:Do('6')"
    Button:"&-",    Row:6, Col:14, Wid:3, Len:1 Action:"Calc:Do('-')"

    Button:"&1",    Row:7, Col:2,  Wid:3, Len:1 Action:"Calc:Do('1')"
    Button:"&2",    Row:7, Col:6 , Wid:3, Len:1 Action:"Calc:Do('2')"
    Button:"&3",    Row:7, Col:10, Wid:3, Len:1 Action:"Calc:Do('3')"
    Button:"&+",    Row:7, Col:14, Wid:3, Len:1 Action:"Calc:Do('+')"

    Button:"&0",    Row:8, Col:2,  Wid:3, Len:1 Action:"Calc:Do('0')"
    Button:"&.",    Row:8, Col:6,  Wid:3, Len:1 Action:"Calc:Do('.')"
    Button:"C&S",   Row:8, Col:10, Wid:3, Len:1 Action:"Calc:Do('S')"
  Return (Mem:Ptr->Calc->Result)

Calc:Do(KeyLetter)
  New (Calc)
  Calc=Mem:Ptr->Calc

  Switch KeyLetter
    Case "X"
      Kbd:put('Esc_Key')
    Case "C"
      Calc->Result="0"
      Calc->Entry ="0"
      Calc->Op    =Null
    Case "E"
      Calc->Entry ="0"
    Case "S"
      If (Calc->Entry!="0")
        Calc->Entry = 0-Calc->Entry
      Else
        If (Calc->Result!="0")
          Calc->Result = 0-Calc->Result
    Case "-"
    Case "+"
    Case "/"
    Case "*"
    Case "="
      If (Calc->Entry!="0")
        Switch (Calc->Op)
          Case "-"
            Calc->Result = To:Num(Calc->Result) - To:Num(Calc->Entry)
          Case "+"
            Calc->Result = To:Num(Calc->Result) + To:Num(Calc->Entry)
          Case "*"
            Calc->Result = To:Num(Calc->Result) * To:Num(Calc->Entry)
          Case "/"
            Calc->Result = To:Num(Calc->Result) / To:Num(Calc->Entry)
          Else
            Calc->Result = Calc->Entry
      Calc->Entry  = "0"
      Calc->Op     = KeyLetter
    Else
      If Str:In("1234567890.",KeyLetter)
        If (Calc->Op == "=" Or Calc->Entry=="0")
          Calc->Entry = KeyLetter
          If (Calc->Op=="=")
            Calc->Op    = Null
        Else
          Calc->Entry = Calc->Entry + KeyLetter
  Kbd:Put("Home_Key")
  Win:Dsp
  Return Ok

