Class:DirList                   | Class Definition
  Name                          | File Name
  Path                          | File Path
  WildCard                      | Wildcard for directory
  ExclusionList                 | Extension Exclusion List
  FileArray                     | Array of files on this path
  DirArray                      | Array of other paths

DirList:Start                   | FOR TESTING:  Start routine
  New (FileName)
  FileName = DirList:GetFile("*.*",Null)
  Msg:Add
    File name is {FileName}
  Return (Ok)

DirList:Cancel(List)            | Routine to Cancel data entry
  List->Name=Null               | Signal that we canceled
  Return(Null)                  | Returning Null will finish input

DirList:Done(List,Name)         | Routine to finish data entry
  If (Str:In(List->Name,"*") Or Str:In(List->Name,"?"))
    List->WildCard  = List->Name
    List->FileArray = DirList:FileArray(List->Wildcard, List->Exclusionlist)
    Kbd:Put("Home_Key")		| Stuff home key
    Win:Dsp			| Redisplay (including arrays)
    Return (Ok)

  If (List->Name==Null)         | If name is still null display message
    Msg:Add
      Please select a file
      name or "Cancel".
    Return (Ok)                 | Returning Ok will continue input
  Return (Null)                 | Returning Null will finish input

DirList:FileArray(WildCard,Exclusionlist)  | Read a file array
  New (Array,OldMessage)
  If (WildCard!='SUBDIR')
    If (Win:Ptr)
      OldMessage = Win:Msg('Reading Directory')
    Else
      Win:Add("Reading")
	Reading Directory
  Array = Arr:Dir (WildCard, ExclusionList, 12)
  If (WildCard!='SUBDIR')
    Win:Msg(OldMessage)
  Return (Array)

DirList:GetFile(WildCard,ExclusionList)
  New (OrigPath, DirList:List, DirChoice, FileChoice)

  | Initalize values
  OrigPath            = File:ChDir()
  List->Path          = OrigPath
  List->WildCard      = WildCard
  List->ExclusionList = Exclusionlist
  List->FileArray     = DirList:FileArray(List->Wildcard, List->Exclusionlist)
  List->DirArray      = DirList:FileArray("SUBDIR")

  Event:Add(Null)               | Block prior keystroke events
  Win:Add ("Get File Name", 0, 0, 14, 56, Here)
    Type:"Message"

    | Input File Name
    Input:"File&name:  ",  Wid:24, Row:2, Col:3, Field:"List->Name"

    | Files array with a group box around
    Group:"&Files",       Row:6, Col:2, Wid:16, Len:14
    Array:"", Field:"List->FileArray",
              Choice:"FileChoice",
              Action:"DirList:NewName(List,List->FileArray[FileChoice])"

    | Directories array with a group box around
    Group:"&Directories", Row:6, Col:22, Wid:16, Len:14
    Array:"", Field:"List->DirArray",
              Choice:"DirChoice"
              Action:"DirList:NewDir(List,List->DirArray[DirChoice])"

    | Input File Path
    Input:"Directory: ",   Wid:24, Row:4, Col:3, Field:"List->Path"
	      After:"DirList:NewDir(List,List->Path)"

    | Two buttons
    Button:"   &Ok   ", Row:1, Col:42, Wid:14
      Action:"DirList:Done(List,List->FileArray[FileChoice])"
    Button:" &Cancel ", Row:4, Col:42, Wid:14
      Action:"DirList:Cancel(List)"

  If (File:ChDir(OrigPath))
    If (List->Name)
      If (Str:At(List->Path,Str:Len(List->Path),1)=='\')
	Return (List->Path+List->Name)
      Return (List->Path+'\'+List->Name)
  Return (Null)

DirList:NewDir(List,Path)       | Routine to set a new path
  If (File:Chdir(Path))         | Change to the new path
    List->Path = File:ChDir()   | Reset path name
    List->Name = Null           | Set file name to null
    | Re-read file array
    List->FileArray = DirList:FileArray(List->Wildcard, List->Exclusionlist)
    | Re-Read directory array - special argument "SUBDIR" does this
    List->DirArray  = DirList:FileArray("SUBDIR")
    Win:Dsp                     | Redisplay Window
  Return(Ok)                    | Returning Ok continues input

DirList:NewName(List,Name)      | Routine to set a new name
  List->Name = Word:At(Name,1)  | Set the name (Easy!)
  Win:Dsp                       | Redisplay the screen
  Kbd:Put("Home_Key")		| And go back to file name
  Return(Ok)                    | Returning OK will continue input

