Class:Attack
  StartSpeed
  TypeWord
  ThisWord
  CurrSpeed
  CurrLevel
  CurrScore
  CurrHits
  Restart
  Sound
  WordList
  InpRow
  InpCol

Attack:Start
  New (Attack:AtStru)

  AtStru->StartSpeed = 45
  AtStru->CurrSpeed  = 45
  AtStru->CurrLevel  = 20
  AtStru->Sound      = "Y"
  AtStru->Restart    = False
  AtStru->WordList   = File:Load("Attack.Txt")

  Attack:OpenWindow(AtStru)
  If (Kbd:Got!='Esc_Key')
    Event:Add("Attack")
    Attack:MainWindow(AtStru,Here)
    Attack:DrawCastle()
    Win:Msg("Press Escape to Exit, Press Enter to Pause")
    While (Kbd:Got!="Esc_Key")
      Attack:GetWord(AtStru)
      Attack:Attack(AtStru)
      Jorf:Flush(80)
  Return (Ok)

Attack:About
  Msg:Add
    JORF Typewriter Attack

    A sample program for the
    JORF Interpreter.

    November 23, 1992
    By Wayland Bruns
  Return (Ok)

Attack:Attack(AtStru)
  New (Len,HalfLen,Spaces,Row,Col,Wait,WaitEnd)
  Len = Str:Len(AtStru->ThisWord)
  HalfLen = Len/2
  Row = 1
  Col = Num:Rand(1, 78-Len)
  AtStru->InpRow = 22
  AtStru->InpCol = 40 - Halflen
  Wait   = ((55-AtStru->CurrSpeed)*2)

  Move:To (AtStru->InpRow,1)
  Str:Put(Str:AtSet(Null,1,' ',78))

  Move:To (AtStru->InpRow-2,1)
  Str:Put("Level "+Num:Str(AtStru->CurrLevel/20,"#.##")+"  ")
  Str:Put("Speed "+AtStru->CurrSpeed+" Mph")

  Move:To (AtStru->InpRow-1,1)
  Str:Put("Score "+Str:Aft(Num:Str(AtStru->CurrScore,"#,###,###,##0")," "))
  Str:Put(" Points")

  Attack:DrawCastle()
  AtStru->TypeWord = ""
  Spaces = Str:AtSet(Null,1,' ',Len)
  While (Row < 21)
    Move:To(Row,Col)
    Str:Put(AtStru->ThisWord)
    WaitEnd = Time:Ticks()+Wait
    While (Ok)
      While (Kbd:Hit())
        Kbd:Get()
      If (AtStru->Restart Or Str:In(AtStru->TypeWord,AtStru->ThisWord))

        Move:To(Row,Col)
        Str:Put(Str:AtSet(Null,1,"",Len))
        Kbd:Hit()
	Attack:Sound(AtStru,440,4)

        Move:To(Row,Col)
        Str:Put(Str:AtSet(Null,1,"",Len))
        Kbd:Hit()
	Attack:Sound(AtStru,240,4)

        Move:To(Row,Col)
        Str:Put(Str:AtSet(Null,1,"",Len))
        Kbd:Hit()
	Attack:Sound(AtStru,440,4)

        Move:To(Row,Col)
        Str:Put(Str:AtSet(Null,1," ",Len))
        Kbd:Hit()
	Attack:Sound(AtStru,240,4)

        AtStru->CurrScore = AtStru->CurrScore + ((AtStru->CurrSpeed/20)*(AtStru->CurrLevel/20)) + 1
        AtStru->CurrHits  = AtStru->CurrHits + Num:Max(1,Num:Int((14-Row)/2))
        AtStru->CurrSpeed = Num:Btw(1,55,AtStru->CurrSpeed+Num:Int((10-Row)/4))
        AtStru->Restart = False
        Return (Ok)
      If (Kbd:Got=="Esc_Key")
        Return(Ok)
      If (Time:Ticks > WaitEnd)
        Break
    Move:To(Row,Col)
    Str:Put(Spaces)
    ++Row
    If (Col > (39-HalfLen))
      Col = Col - ((Col-(39-HalfLen))/10)
    Else
      Col = Col + (((39-Halflen)-Col)/10)
  Attack:Boom(AtStru)
  AtStru->CurrSpeed = AtStru->CurrSpeed-5
  AtStru->CurrHits  = 0
  Return (Ok)

Attack:Backspace_Key
  If (Str:Len(AtStru->TypeWord) > 0)
    AtStru->TypeWord = Str:At(AtStru->TypeWord,1,-1)
    Move:To (AtStru->InpRow,AtStru->InpCol)
    Str:Put(AtStru->TypeWord)
    Str:Put(" ")
  Return ("Esc_Key")

Attack:Boom(AtStru)
  Move:To(18,32)
  Str:Put("         ")
  Move:To(19,32)
  Str:Put("          ")
  Move:To(20,32)
  Str:Put("    ")
  Move:To(21,32)
  Str:Put("      ")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Attack:Sound(AtStru,40,8)
  Move:To(17,32)
  Str:Put("            ")
  Move:To(18,32)
  Str:Put("          ")
  Move:To(19,32)
  Str:Put("           ")
  Move:To(20,32)
  Str:Put("      ")
  Move:To(21,32)
  Str:Put("      ")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Move:To(17,32)
  Str:Put("                   ")
  Move:To(18,32)
  Str:Put("             ")
  Move:To(19,32)
  Str:Put("            ")
  Move:To(20,32)
  Str:Put("    .  ...")
  Move:To(21,32)
  Str:Put("     ")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Move:To(18,32)
  Str:Put("                   ")
  Move:To(19,32)
  Str:Put("      .   .    ")
  Move:To(20,32)
  Str:Put("          . . ")
  Move:To(21,32)
  Str:Put("  ")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Move:To(19,32)
  Str:Put("                   ")
  Move:To(20,32)
  Str:Put("      .   .    ")
  Move:To(21,32)
  Str:Put("  ")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Move:To(20,32)
  Str:Put("                   ")
  Move:To(21,32)
  Str:Put("   ...")
  Attack:Sound(AtStru,40,8)
  Attack:Sound(AtStru,20,8)
  Attack:Correction(AtStru)
  Move:To(21,32)
  Str:Put("                   ")
  Return (Ok)

Attack:Correction(AtStru)
  New (NewWOrd)
  Kbd:Bye()
  Event:Add()
  Event:Add("EditKey")
  Switch
    Case (Str:Len(AtStru->ThisWord) > 25)
      Win:Add ("Typewriter Attack", 2, 10, 9, 78)
        Idle:"Attack:Correctidle()"
        Input:"What you typed was", Row:2 Col:2 Field:"AtStru->Typeword", Wid:55 Before:"Null"
        Input:"The word was      ", Row:4 Col:2 Field:"AtStru->Thisword" Wid:55 Before:"Null"
        Input:"Type the word now ", Row:6, Col:2, Field:"NewWord" Wid:55
        Button:"&Ok" Action:"Null"  Row:8 Col:30 Wid:20
    Case (Str:Len(AtStru->ThisWord) > 1)
      Win:Add ("Typewriter Attack", 2, 10, 9, 50)
        Idle:"Attack:Correctidle()"
        Input:"What you typed was", Row:2 Col:5 Field:"AtStru->Typeword", Wid:25 Before:"Null"
        Input:"The word was      ", Row:4 Col:5 Field:"AtStru->Thisword" Wid:25 Before:"Null"
        Input:"Type the word now ", Row:6, Col:5, Field:"NewWord" Wid:25
        Button:"&Ok" Action:"Null"  Row:8 Col:20 Wid:20
    Else
      Win:Add ("Typewriter Attack", 2, 10, 9, 40)
        Idle:"Attack:Correctidle()"
        Input:"What you typed was  ", Row:2 Col:5 Field:"AtStru->Typeword",Wid:4 Before:"Null"
        Input:"The letter was      ", Row:4 Col:5 Field:"AtStru->Thisword" Wid:4 Before:"Null"
        Input:"Type the letter now ", Row:6, Col:5, Field:"NewWord" Wid:4
        Button:"&Ok" Action:"Null"    Row:8 Col:10 Wid:20
  Return (Ok)

Attack:CorrectIdle
  If (NewWord==AtStru->ThisWord)
    Msg:Add
      Very good!  Are you ready
      to continue?
    Kbd:Put("Enter_Key")
    Return (Null)
  Return (Ok)

Attack:DrawCastle
  Move:To(19,36)
  Str:Put("    ")
  Move:To(20,36)
  Str:Put("")
  Move:To(21,36)
  Str:Put("  ")
  Return (Ok)

Attack:Else(Key)
  If (Str:At(Key,2,4) = '_Key')
    Move:To (AtStru->InpRow,AtStru->InpCol)
    If (Str:Len(Atstru->TypeWord) < (78-AtStru->InpCol))
      AtStru->TypeWord = AtStru->TypeWord + Str:At(Key,1,1)
    Str:Put(AtStru->TypeWord)
    Return ("Esc_key")
  Return (Null)

Attack:Enter_Key()
  Msg:Add("Game Paused")
    Press the {Bold:"Lo"}Enter{Bold:"No"} key when you
    are ready to continue.
  AtStru->Restart = True
  Return (Ok)

Attack:Esc_Key
  Return ("Esc_Key")

Attack:Finish()
  Msg:Add "End"
    You have finished the highest level of this &
    program with a score of &
    {Str:Aft(Num:Str(CurrScore,"#,###,###,##0")," ")} Points.

    You are a typing Champion!

    Press Enter to keep playing on level 9.
  Return (Ok)

Attack:GetWord(AtStru)
  New (Row, Line,Word)
  If (AtStru->CurrHits > 4)
    ++AtStru->CurrLevel
    If (AtStru->Currlevel % 20 == 19)
      ++AtStru->CurrLevel
      If (AtStru->CurrLevel >= 200)
        Attack:Finish(AtStru)
        AtStru->CurrLevel = 181
      Else
        Msg:Add
          Get ready for level {AtStru->CurrLevel/20}!
    AtStru->CurrHits = 0
  Row = (Num:Int(AtStru->CurrLevel / 20)-1) * 20
  Row = Row + (AtStru->CurrLevel%20) + 2
  Line = Text:At(AtStru->WordList,Row)
  While (Word:At(Line,1)==Null)
    Line = Text:Prev(Line)
  Word = Word:At(Line,Num:Rand(1,Word:Len(Line)))
  AtStru->ThisWord = Word
  Return (Ok)

Attack:MainWindow(AtStru,Level)
  Win:Add("Typewriter Attack!", 0, 0, 22, 78, Level)
    Menu:"&File"
      Menu:"&Pause"  Action:"Attack:Enter_Key" Hotkey:"Alt_P_Key"
      Menu:"E&xit"   Action:"Return Null"
    Menu:"&Levels"
      Menu:"Level &1 - Single Letters",
        Action:"Attack:SetLevel(AtStru,20)"
        HotKey:"Alt_1_Key"
      Menu:"Level &2 - Home row words",
        Action:"Attack:SetLevel(AtStru,40)"
        HotKey:"Alt_2_Key"
      Menu:"Level &3 - Simple words",
        Action:"Attack:SetLevel(AtStru,60)"
        HotKey:"Alt_3_Key"
      Menu:"Level &4 - Longer Words",
        Action:"Attack:SetLevel(AtStru,80)"
        HotKey:"Alt_4_Key"
      Menu:"Level &5 - Names and Titles",
        Action:"Attack:SetLevel(AtStru,100)"
        HotKey:"Alt_5_Key"
      Menu:"Level &6 - Punctuation Characters",
        Action:"Attack:SetLevel(AtStru,120)"
        HotKey:"Alt_6_Key"
      Menu:"Level &7 - Short Sentences",
        Action:"Attack:SetLevel(AtStru,140)"
        HotKey:"Alt_7_Key"
      Menu:"Level &8 - Grab Bag",
        Action:"Attack:SetLevel(AtStru,160)"
        HotKey:"Alt_8_Key"
      Menu:"Level &9 - Expert Typist",
        Action:"Attack:SetLevel(AtStru,180)"
        HotKey:"Alt_9_Key"
    Menu:"&Speed"
      Menu:"Starter      -  5 Mph",
        Action:"Attack:SetSpeed(AtStru,5)"
      Menu:"Novice       - 15 Mph",
        Action:"Attack:SetSpeed(AtStru,15)"
      Menu:"Intermediate - 25 Mph"
        Action:"Attack:SetSpeed(AtStru,25)"
      Menu:"Expert       - 35 Mph"
        Action:"Attack:SetSpeed(AtStru,35)"
      Menu:"Pro          - 45 Mph"
        Action:"Attack:SetSpeed(AtStru,45)"
      Menu:"Full Speed   - 55 Mph"
        Action:"Attack:SetSpeed(AtStru,55)"
    Menu:"S&ound"
      Menu:"Use Sound" Action:"Attack:SetSound(AtStru,'Y')"
      Menu:"No Sound " Action:"Attack:SetSound(AtStru,'N')"
    Menu:"&About" Action:"Attack:About"

Attack:OpenWindow(AtStru)
  New (StartLevel)
  StartLevel = Num:Int(AtStru->CurrLevel/20)
  Win:Add("Welcome to Typewriter Attack!", 4, 4, 20, 64)
    String:'The object of this game is to "Shoot" the falling letters by'
    String:"typing them on the keyboard.  The sooner you shoot, the faster"
    String:"the game will go.
    String:""
    String:"There are nine levels, each with about 100 words.  If you can"
    String:"complete to level 9, you will become an expert typist."
    String:""
    String:"This program is a sample of what you can write using the"
    String:"JORF Interpreter.  The source code for this program is in the"
    String:"Attack.J source file."
    String:""
    String:"Please set these starting parameters:"
    String:""
    Input:"Starting Level (1-9)", Row:14  Col:15 Field:"StartLevel", Wid:4
    Input:"Starting Speed (Mph)", Row:15, Col:15 Field:"AtStru->StartSpeed", Wid:4
    Input:"Use Sound      (Y/N)", Row:16, Col:15 Field:"AtStru->Sound", Wid:4

    Button:"&Ok",   Row:18, Col:5 Wid:20 Action:"Null"
    Button:"E&xit", Row:18, Col:40 Wid:20 Action:"Kbd:Put('Esc_Key')"
  AtStru->CurrLevel = Num:Btw(StartLevel * 20,20,180)
  Return (Ok)

Attack:SetLevel(AtStru,Level)
  AtStru->CurrLevel = Level
  AtStru->CurrSpeed = AtStru->StartSpeed
  AtStru->Restart = True
  Return (Null)

Attack:SetSound(AtStru,NewSound)
  AtStru->Sound = NewSound
  AtStru->Restart = True
  Return (Ok)

Attack:SetSpeed(AtStru,Speed)
  AtStru->StartSpeed = Speed
  AtStru->CurrSpeed  = Speed
  AtStru->Restart    = True
  Return (Ok)

Attack:Sound(AtStru,Tone,Dur)
  If (AtStru->Sound=="Y")
    Jorf:Sound(Tone,Dur)
  Else
    Win:Pause(Dur)
  Return (Ok)

Attack:Space_Bar()
  AtStru->TypeWord = AtStru->TypeWord + " "
  Return ("Esc_Key")

