Class:Filter
  Index:Name
  Descr
  Method

Filter:Start
  New (Filter:Fi)

  |  This small application can be linked to larger data bases.  It is
  |  in itself a small data base of text methods, indexed by name and
  |  stored with a description.

  |  Although the resulting selection is set into MEM:PTR as a global,
  |  The filters are "Encapsulated".  For this reason, programs should
  |  use Filter:GetMethod(), Filter:GetName() and Filter:GetDescr()
  |  to obtain selected values.  Encapsulation in this way enhances
  |  the ability to add improvements to this program (class) without
  |  breaking other programs.

  Jorf:File("FILTER.DAT",Here)
  Event:Add()           | Add a "blocking" null Key event
  Event:Add("Filter")   | Add an event to capture some keys

  If (Struct:Next('Filter','Name',Null)==Null)
    Fi->Name  = "All"
    Fi->Descr = "All Records"
    Fi->Method= Null
    Jorf:Write(Fi)

  Fi = Mem:Ptr->Filter
  Win:Add ("Contact Filters")
    Menu:"&File"
      Menu:"&Rebuild      "     Action:"Filter:Rebuild(Fi)"
      Menu:"E&xit    Alt-X"     Action:"Return(Null)"
    Menu:"&Edit"
      Menu:"&Add        "  Action:"Filter:Edit(Fi,'Add')"
      Menu:"&Change     "  Action:"Filter:Edit(Fi,'Change')"
      Menu:"&Delete     "  Action:"Filter:Edit(Fi,'Delete')"
    Menu:"&Help         "  Action:"Filter:F1_Key()"
    Group:"Filters", Row:1, Col:1, Len:8, Wid:42
    String:"Name             Description"
    List:"" Row:3, Col:2, Len:7, Wid:42
      Field:"Fi"
      Next:"Struct:Next ('Filter','Name',Fi)"
      Prev:"Struct:Prev ('Filter','Name',Fi)"
      Show:"Str:Pad(Fi->Name,12)+Str:Pad(Fi->Descr,30)"
    Button:" &Select ",    Row:11 Col:04 Action:"Return(Ok)"
    Button:" &Cancel ",    Row:11 Col:26 Action:"Return(Null)"

  Mem:Ptr->Filter=Fi
  Return (Ok)

Filter:Descr
  Return (Mem:Ptr->Filter->Descr)

Filter:Edit(Fi,Action)          | Add/Edit/Delete Filters
  New (Filter:NewFi, Result)

  If (Action=="Add")            | If Adding a new filter
    Jorf:Write(NewFi)
    Fi=NewFi

  If (Jorf:Lock(Fi)==Null)
    Msg:Add
      Cannot lock this filter for your
      exclusive use.  If you don't think
      anyone else is using it, please
      rebuild the filter file to release
      the record lock.
    Return (Ok)

  If (Action=='Delete')            | If Deleting a filter
    Result=Msg:Add('Filter Delete','No')
      Delete this filter

      Name:   {Fi->Name}
      Descr:  {Fi->Descr}
    If (Result)
      Jorf:Del(Fi)
      Win:Dsp
    Return

  Event:Add("Filter")   | Add an event to capture some keys

  Win:Add ("{Action} Filter")
    Msg:"Press F1 for help on each field"
    Input:"&Name       ", Row:1 Wid:10, Field:"Fi->Name"
    Input:"&Description", Row:2 Wid:30, Field:"Fi->Descr"
    Group:"Co&mmand",     Row:4 Wid:42, Len:10
    Input:"",             Row:5 Wid:40, Len:10, Field:"Fi->Method"
    Button:"&Ok"          Row:1 Col:46, Wid:10, Action:"Null"
    Button:"&Cancel"      Row:4 Col:46, Wid:10, Action:"Fi->Name=Null"

  If (Kbd:Got == "Esc_Key" Or Fi->Name ==Null)
    Jorf:Unlock(Fi)
  Else
    Jorf:Write(Fi)

  Win:Dsp
  Return(Ok)

Filter:GetDescr()
  Return (Mem:Ptr->Filter->Descr)

Filter:GetMethod()
  Return Mem:Ptr->Filter->Method

Filter:GetName()
  Return Mem:Ptr->Filter->Name

Filter:Method
  Return Mem:Ptr->Fi->Method

Filter:Name
  Return Mem:Ptr->Fi->Name

Filter:Rebuild(Fi)
  Fi = Null
  Jorf:Rebuild()
  Win:Dsp
  Return (Null)

Filter:F1_Key()
  New (Field)
  Field = Word:At( Win:Ptr->CurLine, Word:Len( Win:Ptr->CurLine ) )
  Switch (Field)
    Case "Name"
      Msg:Add
	Enter any value to be the
	name of this filter.
    Case "Descr"
      Msg:Add
	Enter a description up to 30 characters
	that will help people understand what
	records are found with this filter.
    Case "Method"
      Msg:Add
	Enter a JORF Language expression that
	returns "Ok" if this record fits the filter,
	or "Null" if the record does not fit.

	The expression can be on one line, or
	it can be multiple lines.  If you use
	multiple lines, you must use the "Return"
	function for the result.
    Else
      Msg:Add
	Highlight any entry to select a filter.
	With the filter highlighted, press the
	"Enter" key to select it.

	You can Add, Change and Delete filters
	using the Edit submenu.
  Return (Ok)

Filter:Alt_X_Key()
  Jorf:Unlock(Fi)
  Return (Null)