About:DOS
  Title:"MS-DOS"
  A lot of Computer Magazines would have you believe that
  somehow died when {Bold:"Lo"}Windows Version 3.x{Bold:"No"}
  was introduced. But anyone with two eyes can see that a
  majority of computer users are still running DOS uprograms
  most of the time.

  I don't question that the future is
  in MS-Windows.  But there are {Bold:"Lo"}Millions{Bold:"No"}
  of PC XT and AT computers in current usage that
  cannot run Windows at a reasonable speed.
  And there are thousands of {Bold:"Lo"}Networks{Bold:"No"}, that
  are too speed sensitive to run Windows.

  And don't forget that trade restrictions limit
  the sale of 386 machines to formerly communist countries.
  Until these barriers are lifted, MS-DOS will make an
  indeleble mark on Eastern Europe, just as it has in
  Western Europe.

About:DOS1
  Title:"Will continue to Dominate"
  DOS is {Bold:"Lo"}fast{Bold:"No"} and
  DOS is {Bold:"Lo"}cheap{Bold:"No"}.  DOS isn't going to die
  this year or next.  We will continue to see DOS in
  speed sensitive and cost sensitive applications
  through the turn of the century, eight years from now.

  If DOS isn't dead and MS-Windows is the Future, then
  the {Bold:"Lo"}Present{Bold:"No"} of
  IBM PC style machines is locked into {Bold:"Lo"}Dual
  Platforms{Bold:"No"}; DOS and MS-Windows.

About:DOS2
  Title:"The PC Industry for at least eight more years"
  The JORF Language was written for DOS and remains
  a DOS style application, even when running under
  MS-Windows.  That doesn't mean it can't be fancy.

  The {Bold:"Lo"}JORF {Bold:"No"} language features a
  window handler that conforms to the keystroke, menu
  and input style of MS-Windows.
  This handler is fast, even on standard XT computers, and
  and provides some of the visual and functional
  benefits of the MS-Windows interface.

  Since MS-DOS and MS-Windows files are the same, it is easy
  to provide same source, same data support in these environments.
  So that is what I did!

About:Mem
  Title:"Memory and Disk Management"
  Row:1
  Col:1
  My greatest frustration as a grunt programmer comes from
  the amount of time I spend dinking around with memory
  allocation and disk storage of variables.

  It is not my memory, and not my disk.  The management of the
  computer is the responsiblity of the operating system, and the
  software tools.  Instead, most languages make me responsible
  for memory, especially when its time to
  say {Bold:"Lo"}Out of Memory{Bold:"No"}.

  We put men on the moon a decade ago.  The Berlin wall has
  disappeared.  We can map the human gene sequence.  Why not
  have a programming language that takes care of Memory and Disk
  so I can spend my time with my program.

About:Mem1
  Title:"Seems Fine to Academics and Engineers"
  The biggest problem now is these friendly user interfaces.
  Just the main Tutorial window takes over 8 Kilobytes for
  background and refresh buffers, and up to 128 bytes for
  every one of the 16 menu items and 10 hypertext prompts.

  Press Ctrl-Break and another 25 Kilobytes is used just to
  display the debugger window.  By the time you pull up a couple
  menus, a browse window, and select a method to edit, you
  will be Out of Memory on any 640K DOS system.

About:Mem2
  Title:"Who get paid, even nothing gets finished"
  The Memory management system in JORF dates from 1988 when
  most applications were not as fancy.  But this system has
  paid off now, because the "professional software look"
  demands this memory intensive interface.

  Even under MS-Windows, where the operating system is
  supposed to handle memory for you (but actually fails
  if too many items are allocated), the JORF scheme has
  considerable benefits.

About:Mem3
  Title:"But no one pays Me to waste time!"
  Wid:68
  In the JORF language, use the {Bold:"Lo"}New{Bold:"no"}
  command to allocate memory for a variable.  New variables
  may be numbers, strings, text, or arrays.  New variables are
  always initialized to Null.

  The JORF automatic garbage collection system will deallocate
  your variable automatically unless:

     A) It is an indexed structure and you write it to file.
     B) You use the Rule Based Index system to index your variable
     C) Your variable is pointed to by an array or structure that
        is saved through scheme A or B.

  There is no distinction in JORF between a memory variable
  and a disk variable.

About:Tut
  Title:"The JORF Tutorial"
  The JORF Tutorial is a demonstration of the JORF language.
  It features hypertext screens, self writing programs, pull
  down and pop up menus, and data entry screens.

  This tutorial is also being run, {Bold:"Lo"}(Right Now){Bold:"No"}
  from within the JORF Editor and Debugger.  The Debugger is an
  integrated part of the Runtime system for interpreted programs.

  To see the Debugger, press {Bold:"Lo"}Ctrl-Break{Bold:"No"}.  (Press
  the Alt-G key to "Go" back to running the program from the Debugger).
  Try it now!

About:Tut1
  Title:"Tutorial Program"
  Wid:70
  There are two files used for this tutorial:

    TUTORIAL.J is the driver file that displays the menu and boxes.
    TUTTEXT.J contains the text screens that you see here.

  The text is actually hashed through a routine that builds the
  window and places the button automatically.  This makes writing
  the text as easy as typing.  There is, however, a slight delay
  in screen display "snap" that would not be needed if the buttons
  were preset in the text file.

About:Tut2
  Title:""
  {FLRCO:"C"}
  The JORF Tutorial
  by Wayland Bruns

  Version 2.1   April 1, 1993

About:Win
  Title:"Fast Windows"
  When you look at most WinApps today, it is
  easy to sum them up as {Bold:"Lo"}Sophisticated,
  Slow, and Spendy{Bold:"No"}.

  But grunt programmer that I am, all I want
  out of MS-Windows is {Bold:"Lo"}Friendly,
  Fast, and Cheap{Bold:"No"}.

  This is what I want JORF to be.

About:Win1
  Title:"for Winning"
  When Running under MS-Windows, only
  only the System Fixed Font is supported,
  only the top window is active, and data entry is done using
  JORF style prompts, not Windows dialog boxes.

  JORF uses your MS-Windows colors and border styles, supports
  several types of MS-Windows button styles, and is terribly
  well behaved with MS-Windows Memory and Disk functions.

  In supporting a subset of MS-Windows features, JORF is smaller,
  faster and easier to use than most other MS-Windows application
  tools.  The MS-Windows version is almost as
  fast as the DOS version, and that is pretty good for a WinApp.

About:Win2
  Title:"Fair re-Wards"
  I'm not here to give you a cheap version of Toolbook,
  or FoxBase.  If you need fancy graphics, image processing
  dynamic data exchange, and some of the other fancy features of
  Windows, you are not going to find them here in JORF.

  What you will find here is a programming language where
  you can create a new data entry screen in one tenth the time
  of Visual BASIC.

  With JORF, you can easily create a
  decent screen that runs fast and looks fine in just a few
  lines of code.  Faster and easier than Point and Click,
  and runs on DOS systems too.  Easy!

Intro:Grunt
  Title:"Wayland Bruns"
  Row:2
  For the better part of a decade I have supported
  myself by writing accounting and document processing
  computer applications.  That is to say - I'm a grunt
  programmer.

  In these years I have used languages by well paid
  engineers and ivory tower academics.  These languages,
  like C++ and Pascal allow me to create beautiful
  bubblesorts, and flexible file storage systems.

  I've also done a lot of programming in dBASE, which was
  really innovative when it was introduced in 1984.  Now is
  the era of Object Oriented Programming, and despite what
  Bill Gates says, an Icon-handling Windows dBASE language is
  not Object Oriented.

Intro:Grunt1
  Title:"Striving to Create"
  JORF is my attempt to create a simple programming language
  for business (not graphics) programming.  A language that
  a new programmer can handle to create a simple data base,
  do some calculations and print some reports.

  The JORF language takes responsiblity for niggly stuff
  wastes programmer time in other languages.
  You don't have to worry about {Bold:"Lo"}type mismatch errors{Bold:"No"}
  because the JORF language has just one data type!

  The JORF Language also handles {Bold:"Lo"}memory allocation{Bold:"No"}.
  One failure of C++ is that it lacks a better way of handling
  temporary memory structures.  JORF not only handles temporary
  structures for you, it can even swap them to disk.  That way,
  your {Bold:"Lo"}DOS Apps{Bold:"No"} don't run out of memory, and
  your {Bold:"Lo"}Win Apps{Bold:"No"} are well behaved.

Intro:Grunt2
  Title:"A Language for Regular People"
  The JORF language is my language.  I've made my career
  creating {Bold:"Lo"}Business Applications{Bold:"No"},
  that is what JORF is best at.

  Since my pet-peeves are machine language data types,
  numeric overflows, data file handling, and memory management,
  I've created a language that takes care of these things.

  With the world moving {Bold:"Lo"}backward{Bold:"No"},
  toward more complex versions of C, more C-Like versions
  of BASIC, and dialects of dBASE that claim to be Object
  Oriented, I think it is time to share my effort.

  I think you will agree, when it comes to creating simple Business
  Applications, JORF is a step toward an easier future.

Intro:Hyper
  Title:"Hypertext"
  The Hypertext system highlights the current prompt.  Use
  your arrow keys to highlight the next or previous prompts.

  If there are menu letters, or prompt letters highlighted on
  the screen, you can zoom to them by holding down the Alt key
  and pressing the appropriate letter.

  The Hypertext system is designed so that
  pressing {Bold:"Lo"}Enter{Bold:"No"}
  brings you to the next prompt,
  or back to the beginning if you have
  finished.  You can press {Bold:"Lo"}Escape{Bold:"No"} to
  exit from the current screen.

Intro:Hyper1
  Title:"CUA Compliance"
  The JORF Screen manager is compliant with Common User Access
  key standards.  That means that it conforms to the same
  cursor keys and menu handling found in MS-Windows program.

  That also means the the Enter key does something different
  than most DOS users expect.

  In a CUA compliant application:
  {Bold:"Lo"}
	Use the TAB key to move between fields.

	The ENTER key "presses" the default button
	(even if that button is not highlighted.)
  {Bold:"No"}

Intro:Hyper2
  This is a stupid standard, because the tab
  key is little and the cursor key is big.

  But this is a standard, and the DOS PC world
  has long needed a standard so that users can
  more easily use all programs.

  I guess if we all got used to a control key on
  the {Bold:"Lo"}bottom{Bold:"No"} of the keyboard,
  then we can get used to pressing the little tab
  key between fields.

  Press Enter now press this button and
  return to the main screen.

Intro:Jo
  Title:"Josephine T. Goat"
  Josephine is a tan pygmy goat that lives at the
  foot of the Cascade Mountains in
  lovely Colton, Oregon.

  Josephine doesn't file recipes or write
  Object Oriented Programs.  Instead she
  dances and plays in the sunshine.  Her
  message is simple:
  {Bold:"Lo"}
		 Lighten-up
		 Eat
		 Dance
		 Baaaah.
  {Bold:"No"}
  Josephine doesn't have to work for a living.


Quick:Start
  Script:"QuickDemo1" "Demo:Start"
  Title:"Real Windows Programming"
  The bigger problem is how long it takes to create a CUA
  Compliant MS-Windows style data entry screen, with pull
  down menus, keyboard accelerators buttons and text boxes.

  Microsoft is advocating the Point and Click tool building system
  of Visual Basic.  I prefer the faster and more primitive method
  of creating a screen definition.  I also drive a car with a
  standard transmission.

  How quick can you make a Data Entry Window with Inputs, Check boxes
  Radio Buttons, and Pull Down Menus?  Try it and see!

Quick:Start1
  Script:"QuickDemo2" "Demo:Screen"
  Title:"Quick Demo Summary"
  How about that?  A data entry screen in JORF uses
  one line per option or prompt on the screen, and can
  take more for complicated prompts.

  Each prompt can
  set a value or run a method.  This system is extremely
  flexible, supporting on-line equations and instant data
  verification.

Tut:About
  Title:"About the JORF language"
  The JORF language is intended to be an easy
  language for business application programming.

  An unusal feature of the JORF language is automatic handling of
  of {Prompt:"&Memory and Disk",   Action:"Tutorial:Box('About:Mem')"}
  functions.

  Another feature is the Window Manager, that supports menus
  and buttons for &
  for {Prompt:"Fast &Windows",      Action:"Tutorial:Box('About:Win')"}
  and {Prompt:"Fancy &DOS",         Action:"Tutorial:Box('About:DOS')"}
  programming.

  This tutorial is written in the JORF language,
  and can be run as an interpreted or compiled program.
  Press enter here for more information about
  the {Prompt:"&Tutorial"     Action:"Tutorial:Box('About:Tut')"}.

Tut:JorfCo
  Title:""
  JORF Company is just me, Wayland Bruns.  I
  have been working on JORF for six years, and
  ran out of money three years ago.

  I run JorfCo part time, from 9-5 Pacific Time
  Monday through Wednesday.

  I never forget that {Bold:"Lo"}YOU{Bold:"No"}
  are an important part of my
  life, so please feel free to
  write or call:
  {Bold:"Lo"}
               Wayland Bruns
               The JORF Company
               25858 Elwood Road
               Colton, OR 97017
               (503) 824-5673

Tut:Overseas
  Title:"Overseas Shipping"
  Please add $10 to cover the cost of U.S. Air Mail.  We can
  take checks from most major coutries as long as the check is
  written in the native currency for the bank that issued the check.

  For instance, you can send a check for 600 French Francs as
  long as the check is from a French bank.  You can send German
  Marks as long as the check is from a German bank.  You can send
  Japanese Yen as long as the check is from a Japanese bank.

  Of course, you can always get a check in dollars from your
  local Citibank office.

  We accept Postal Money Orders but they must be in U.S. dollars.
  Shipping is by U.S. Air Mail unless you say otherwise.

Tut:Prod
  Title:"Demonstration/Shareware packages"
  Wid:60
  {Bold:"Lo"}DOS/Windows Demonstration Package                   Just $5{Bold:"No"}
    Send just 5 buckaroos to JORF Company to get shareware
    versions of the JORF386 and Windows versions of
    the JORF interpreter.  This version ships with FULL
    documentation On-Disk.  You also get a command quick
    reference card and notice of the next upgrade.

    This version ships on 3 1/2 1.44MB disk.  Please
    specify if you need a 5 1/4 1.2MB disk instead.

  {Bold:"Lo"}JORF-PC Registration                                    $45{Bold:"No"}
    The full benefits of Registration for the DOS Version.
    Get a biggo reference guide (280 pages), a programming
    workbook, Mail and Telephone support, notice of upgrades,
    and great Karma for supporting The JORF Company.


Tut:Prod1
  Title:"Registered Versions"
  Wid:60
  {Bold:"Lo"}JORF Programmer's Pack                                  $85{Bold:"No"}
    You get everything in the JORF Registered package
    plus the JORF386 version (Runs faster on 386 PCs with
    extended or expanded memory), and the Microsoft
    Windows 3.x version.  This is everything you need
    to write programs for DOS {Bold:"Lo"}and{Bold:"No"} Windows using one
    set of source code and program data.

  {Bold:"Lo"}JORF Developer's Kit                                   $170{Bold:"No"}
    The libraries you need to Translate and compile your
    JORF programs into true EXE files.  You will also
    need the Borland Turbo C compiler (about $104) to
    compile for DOS, and the Borland C++ compiler
    (about $350) to compile for Windows programs.

Write:Start
  Title:"Writing JORF Programs"
  Wid:50
  There is a significant gap between reading
  this tutorial, and creating
  new programs using JORF.  This gap can be
  crossed, and {Bold:"Lo"}You can do it!{Bold:"No"}

  The best way to write JORF programs is to use
  the {Bold:"Lo"}JORF integrated editor and debugger{Bold:"No"}.  This
  tool allows you to watch the program and stack as
  the program runs.  The JORF editor allows you to
  change stack values, and even the program code, without
  having to stop and restart it like most debuggers.

  You can enter the debugger by pressing {Bold:"Lo"}Ctrl-Break{Bold:"No"}
  at any time.  The Break key is near the number pad and
  is labeled Scroll Lock on an XT or Pause on an AT keyboard.

Write:Start1
  Title:"The Help System"
  Wid:60
  The Help system documents JORF functions available to you.
  These vary from the prosaic {Bold:"Lo"}Kbd:Get{Bold:"No"} to
  the complex {Bold:"Lo"}Win:Add{Bold:"No"}.  Also documented
  are the control functions {Bold:"Lo"}If{Bold:"No"}, &
  {Bold:"Lo"}Else{Bold:"no"}, {Bold:"Lo"}While{Bold:"No"}, and &
  {Bold:"Lo"}Switch{Bold:"No"}.

  You can access the help system at any time by
  hitting {Bold:"Lo"}F1{Bold:"No"}.  (Try it now!)  The Help system
  is a JORF language program, just like this tutorial, and
  depends on there being a HELP.J or HELP.JRF file on
  the current directory.

Write:Start2
  Title:"Handling .JRF files"
  Wid:76
  JORF programs are kept in an indexed format with
  an extension of {Bold:"Lo"}.JRF{Bold:"No"}.
  This file contains indexes and browse list information that is
  not contained in the source file.  When you edit your program,
  the source file will be automatically saved when you exit.  You
  should also save it using F3 periodically.

  The JORF Interpreter uses a file called SWAPFILE.JRF for variables
  and screens swapped while a program is running.  If you bomb while
  in JORF, you CHKDSK will recover this file, which is usually from
  5 to 50K.  Just erase it.  The JORF Interpreter creates a new
  SWAPFILE.JRF every time it is run.


Write:Start3
  Title:"Summary"
   Start with a small change and work your way up.

   Make changes using the integrated editor and debugger.

   Reload source files by invoking The JORF Interpreter with
  the names of the class files to be reloaded.

   Send $85 to The JORF Company to get the latest (more bombproof)
  version of the interpreter and a neat manual that steps you
  through the process of writing programs.

Tut:DataEntry
  Title:"The JORF Window manager"
  Wid:70
  The Window Manager handles windows that contain data
  entry areas.  In the window definition,
  certain keywords are used to set up the fields to
  be input.  Each window element is noted using
  a keyword.  Keywords are followed by the prompt
  for that item.
  {Bold:"Lo"}
      Array:"Item"      - Array pick list
      Radio:"Item"      - Radio Button
      ChBox:"Item"      - Check Box
      InPut:"Prompt"    - Input
      Text:"Prompt"     - Input text
      Group:"Prompt"    - Group Box
      List:"Item"       - Record pick list
      Prompt:"Prompt"   - Hypertext Prompt
      String:"Item"     - Plain text, no entry.
      Button:"Item"     - Push Button
  {Bold:"No"}
  Data entry is done automatically when the window is displayed.

Tut:DataEntry1
  Script:"LetterScript" "JORFNote:Start"
  Title:"Data Display and Entry"
  Wid:56
   Input items are created using special key words.  You
  can enter structure elements and array elements as easily
  as simple variables.

   The {Bold:"Lo"}Time:Get{Bold:"No"} function will
  get the current date and time
  and can format this for International as well as U.S. standards.

   Input text is just as easy as input strings.  Just specify
  a length and a text entry field is created.  Text is a basic
  data type in JORF, and can be handled almost as easily as the
  string data type.

Script:Hello
  Script:Say ("Hello:Start")
  Script:Box ("Method Name Declaration", 12, 50)
    Button:" More . . . ", Row:10, Col:20, Action:"Return(Ok)"
    This line declares a method that &
    belongs to the class {Bold:"Lo"}Hello{Bold:"No"}.  It &
    is called {Bold:"Lo"}Start{Bold:"No"}.

    This method is being written by the JORF system &
    just as if you were typing it in.  When finished, the &
    system will run the program.

    An interesting features of JORF is the ability to &
    create and change methods on-the-fly.
  If (Kbd:Got='Esc_Key')
    Return
  Script:Say ('  Msg:Add ("Hello", "Ok")')
  Script:Say ('    Welcome to the Wonderful World of JORF!')
  Script:Box ('Creating a Text Window', 10, 40)
    Button:" More . . . ", Row:8, Col:12, Action:"Return(Ok)"
    There is a JORF function named &
    {Bold:"Lo"}Msg:Add{Bold:"No"}. This function creates a dialog box &
    exactly big enough to display the indented text.

    The box Title will be "Hello" and type will be an "Ok" box.
  If (Kbd:Got="Esc_Key")
    Return
  Script:Box ('Running Hello from DOS', 13, 50)
    Button:" More . . . ", Row:11, Col:14, Action:"Return(Ok)"
    The {Bold:"Lo"}Hello{Bold:"No"} program has been included &
    to be run from DOS.  It is in a file called HELLO.J.
    To run it, start JORF using {Bold:"Lo"}Hello{Bold:"No"}.

         C>{Bold:"Lo"}JORF HELLO{Bold:"No"}

    After running this program, you will be put in the &
    JORF debugger.  Interpreted programs will always end in the &
    debugger unless they end with the command {Bold:"Lo"}Jorf:Exit{Bold:"No"}.
  Return (Tutorial:Ret)

Script:Letter1
  Script:Say ('Class:Address Name Street CityStZip')
  Script:Box ('Address', 12, 56)
    Button:" More . . . ", Row:10, Col:20, Action:"Return(Ok)"
    Create a class for holding names and addresses.  &
    Although this is sorely lacking in sophistication &
    (No company name or international mailing code) &
    it makes a nice base for our letter.

    You may note that JORF lets you add fields on &
    existing databases with no need to reformat or &
    modify the database.  This is because items are &
    stored by Name reference and not position reference.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter2
  Script:Say ('Class:JORFNote Parent:Address Feeling Thought')
  Script:Box ('The JORFNote Class', 14, 50)
    Button:" More . . . ", Row:12, Col:16, Action:"Return(Ok)"
    This is a special class for our letter.  It uses the &
    last {Bold:"Lo"}Address{Bold:"No"} class as &
    a parent.  That means that this class inherits the &
    elements {Bold:"Lo"}as if they were declared here{Bold:"No"}.

    Structure elements are referenced using pointers.
    {Bold:"Lo"}
	  New (JORFNote:MyLetter)
	  MyLetter->Name = "Josephine"
          MyLetter->Feeling = "Dance-a-Dance-a-Dance"
    {Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter3
  Script:Put ('JORFNote:Start')
  Script:Box ('No More Cute', 9, 50)
    Button:" More . . . ", Row:7, Col:16, Action:"Return(Ok)"
    I want to dispel the notion that the script system is &
    slow.  I was just trying to be cute and gentle by &
    using a on-at-a-time character display.

    Now, its time to roll up our sleeves and really get to &
    work.  No more Little-Bo-Peep.  {Bold:"Lo"}Jo Raps!{Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put ('  New (JORFNote:Letter)')
  Script:Put ('  Win:Add ("Letter To The JORF Company" 0,0,5,20)')
  Script:Put ('    String:"Press TAB between fields"')
  Script:Put ('    Input:"Your Name   ", Field:"Letter->Name"')
  Script:Put ('    Input:"Your Street ", FIeld:"Letter->Street"')
  Script:Put ('    Input:"City/St/Zip ", Field:"Letter->CityStZip"')
  Script:Box ('Entering Structure Elements', 7, 50)
    Button:" More . . . ", Row:5, Col:16, Action:"Return(Ok)"
    And input window to gather information.  In the
    {Bold:"Lo"}Foo{Bold:"No"} program we were inputting a &
    {Bold:"Lo"}New{Bold:"No"} variable.  Here we are &
    inputting structure elements.  The process is the same.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put
  Script:Put ('    String:"How does JORF make you feel?  (Excited, Bored, Confused...)"')
  Script:Put ('    Input:"Your Feeling ", Wid:20, Field:"Letter->Feeling"')
  Script:Put
  Script:Put ('    String:"What do you think of JORF? (Really Neat, Too Complicated...)"')
  Script:Put ('    Input:"", Wid:60 Len:6, Field:"Letter->Thought"')
  Script:Put ('    String:"           (Press Escape to Finish Text Entry)"')
  Script:Put ('  JORFNote:Say (Letter)')
  Script:Put ('  Return(Ok)')
  Script:Put
  Script:Put
  Script:Box ('Text Entry', 4, 48)
    Button:" More . . . ", Row:3, Col:14, Action:"Return(Ok)"
    You can enter text just by specifying the length as well as &
    the width of the input.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter4
  Script:Put ('JORFNote:Say (Letter)')
  Script:Put ('  Msg:Add ("My Letter", "Ok")')
  Script:Put ('    {Date:Str(Date:Get,"S d, y")}')
  Script:Box ('The Date', 10, 50)
    Button:" More . . . ", Row:8, Col:18, Action:"Return(Ok)"
    The {Bold:"Lo"}Date:Get{Bold:"No"} function returns the &
    current date, and the {Bold:"Lo"}Date:Str{Bold:"no"} function
    formats the date according to the formatter &
    {Bold:"lo"}"s d, y"{Bold:"no"}.  The formatter letters
    stand for String-month, day and year respectively.

    The result of these two commands will be a nicely formatted &
    string containing today's date.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put
  Script:Put ('    Dear Wayland,')
  Script:Put
  Script:Put ('    I just had to write to you, because I am &')
  Script:Put ('    so {Letter->Feeling} by JORF. In Fact, &')
  Script:Put ('    {Letter->Thought}')
  Script:Put
  Script:Put ('    Yours Truly,')
  Script:Put
  Script:Put ('    {Letter->Name}')
  Script:Put ('    {Letter->Street}')
  Script:Put ('    {Letter->CityStZip}')
  Script:Put ('  Return(Ok)')
  Script:Put
  Script:Put
  Script:Box ('Our Letter', 5, 68)
    Button:" More . . . ", Row:3, Col:24, Action:"Return(Ok)"
    So I know this is stupid.  You try writing a hundred help &
    screens and a half dozen program scripts!  You'll get pretty &
    rummy too!
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:QuickDemo1
  Script:Add("Script:Quick1")
  Return (Tutorial:Ret)

Script:QuickDemo2
  Script:Add("Script:Quick2")
  Return (Tutorial:Ret)

Script:LetterScript
  New Counter
  Jorf:Flush
  While (Counter < 4)
    Switch Counter
      Case 0
	Script:Add ("Script:Letter1")
      Case 1
	Script:Add ("Script:Letter2")
      Case 2
	Script:Add ("Script:Letter3")
      Case 3
	Script:Add ("Script:Letter4")
    If (Kbd:Got='Esc_Key')
      Break
    Else
      ++Counter
  Return (Tutorial:Ret)

Script:MantraDo
  Script:Say ('Mantra:Show (Level)')
  Script:Box ('Show a Mantra', 11, 58)
    Button:" More . . . ", Row:9, Col:20, Action:"Return(Ok)"
    A Method called {Bold:"Lo"}Show{Bold:"No"} that belongs &
    to the {Bold:"Lo"}Mantra{Bold:"No"} class.

    The level is the {Bold:"Lo"}Here{Bold:"No"} from the &
    calling function.  We will pass this to the final &
    window function, so the interpreter knows when the &
    window can be deleted.

    Windows are deleted when the method that creates them &
    has been completed.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

  Script:Say ('  New (Row, Col)')
  Script:Say ('  Row = Num:Rand (1, 20)')
  Script:Say ('  Col = Num:Rand (1, 70)')
  Script:Box ('Randomizing Row and Column', 6, 40)
    Button:" More . . . ", Row:4, Col:12, Action:"Return(Ok)"
    Create a random Row and Column.  The row must be &
    between 1 and 20, and the column between 1 and 70.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  Win:Add ("OM", Row, Col, 0, 0, Level)')
  Script:Box ('Calling Win:Add', 10, 40)
    Button:" More . . . ", Row:8, Col:12, Action:"Return(Ok)"
    Call the JORF Win:Add Function.  Title is "OM". &
    Row and Col we just set.

    Setting Length and &
    width to zero tells the system to make a window &
    just the right size.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Am I a butterfly that')
  Script:Say ('    dreams I am a computer?')
  Script:Say
  Script:Say ('    Or am I a computer that')
  Script:Say ('    dreams I am a Butterfly?')
  Script:Say ('  Return (Ok)')
  Script:Box ('Just some Text', 8, 50)
    Button:" More . . . ", Row:6, Col:16, Action:"Return(Ok)"
    Indented Text can be passed to methods without &
    even quoting it.  This text is taken loosely   &
    from the writings of Chuang-Tsu, a Chinese     &
    Taoist philosopher who studied recursion and &
    self-reference.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:MantraScript
  New (Counter)
  While (Counter < 5)
    Switch Counter
      Case 1
	Script:Add ("Script:MantraDo")
      Case 0
	Script:Add ("Script:MantraStart")
    If (Kbd:Got='Esc_Key')
      break
    Else
      ++Counter
  Return (Tutorial:Ret)

Script:MantraStart
  Script:Say ('Mantra:Start')
  Script:Box ('The Start of the Program', 5, 40)
    Button:" More . . . ", Row:3, Col:12, Action:"Return(Ok)"
    A Method called {Bold:"Lo"}Start{Bold:"No"} that belongs &
    to the {Bold:"Lo"}Mantra{Bold:"No"} class.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  New (Counter)')
  Script:Say ('  While (Kbd:Hit==False)')
  Script:Box ('A Loop', 10, 44)
    Button:" More . . . ", Row:8, Col:16, Action:"Return(Ok)"
    The {Bold:"Lo"}While{Bold:"No"} statement tests a condition &
    and ends the loop if it is true.  In this case, the loop &
    continues until {Bold:"Lo"}Kbd:Hit{Bold:"No"} is True, which &
    happens when you hit a key.  {Bold:"Lo"}Kbd:Hit{Bold:"No"} remains &
    True until {Bold:"Lo"}Kbd:Get{Bold:"No"} or {Bold:"Lo"}Kbd:Bye{Bold:"No"} &
    is called to get the key or clear the keyboard buffer.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    While (Counter < 40 And Kbd:Hit==False)')
  Script:Say ('      Mantra:Show (Here)')
  Script:Say ('      ++Counter')
  Script:Box ('Count up to 40', 4, 54)
    Button:" More . . . ", Row:2, Col:20, Action:"Return(Ok)"
    This loop counts up to 40, but stops if you hit a key.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    While (Counter > 0 And Kbd:Hit==False)')
  Script:Say ('      Win:Del')
  Script:Say ('      --Counter')
  Script:Box ('Count back down', 4, 58)
    Button:" More . . . ", Row:2, Col:20, Action:"Return(Ok)"
    This loop counts down, and also stops if you hit a key.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  Kbd:Bye')
  Script:Say ('  Return(Ok)')
  Script:Say
  Script:Say
  Script:Box ('Clear the Keyboard Buffer', 5, 58)
    Button:" More . . . ", Row:3, Col:23, Action:"Return(Ok)"
    We know a key has been hit, so we must take it out &
    of the input stream.  {Bold:"Lo"}Kbd:Bye{Bold:"No"} &
    will clear the keyboard buffer.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Page_Up_Key
  Return 'Back'

Script:Put Line
  Win:Ptr->Text=Text:Add (Line, Win:Ptr->Text)
  Str:PutLine (Line)

Script:Quick1
  Script:Say ("Demo:Start")
  Script:Say ('  Msg:Add ("Quick Demonstration", "Ok")')
  Script:Say ('    Sure you can say "Hello World" in one line of')
  Script:Say ('    C code.  But how many punctuation characters')
  Script:Say ('    are required to display a dialog box like this?')
  Script:Say ('  Return (Ok)')
  Script:Box ('Creating a Dialog Box', 4, 56)
    Button:" Press Enter to save and run this new method ", Row:2, Col:2, Action:"Return(Ok)"
    The JORF Interpreter supports self writing programs!
  If (Kbd:Got="Esc_Key")
    Return
  Return (Tutorial:Ret)

Script:Quick2
  Script:Say ("Demo:Screen")
  Script:Say ('  New (Rad, Chk, Inp1, Inp2)')
  Script:Say ('  Win:Add ("A Real Screen", 4, 8, 14, 50, Here)')
  Script:Say ('    Menu:"&Help"')
  Script:Say ('      Menu:"&Indented Menu Items"')
  Script:Say ('        Menu:"&Create Sub Menus"')
  Script:Say ('          Menu:"&And Even Deeper"')
  Script:Say ('          Menu:"&Sub Menus"')
  Script:Say ('        Menu:""')
  Script:Say ('        Menu:"(Escape to Exit)"')
  Script:Say ('      Menu:"&Jorf Help           F1" Action:"Tutorial:F1_Key"')
  Script:Say ('      Menu:"&Time and Date  Alt-F10" Action:"Tutorial:Alt_F10_Key"')
  Script:Say ('    String:"  Use your Arrow Keys to go up and down.  On"')
  Script:Say ('    String:"  Check Boxes and Radio Buttons, the Enter Key"')
  Script:Say ('    String:"  checks and Space Bar skips.  Be sure to Press"')
  Script:Say ('    String:"  Alt-H to check out the Menus and Submenus!"')
  Script:Say ('    Radio:" Radio &1" Row:6 Col:8')
  Script:Say ('      Check:"Rad==True", Action:"Rad=True"')
  Script:Say ('    Radio:" Radio &2"')
  Script:Say ('      Check:"Rad==False", Action:"Rad=False"')
  Script:Say ('    ChBox:" Check Box &A" Row:6, Col:26')
  Script:Say ('      Check:"Chk==True", Action:"Chk=True"')
  Script:Say ('    ChBox:" Check Box &B"')
  Script:Say ('      Check:"Chk==False", Action:"Chk=False"')
  Script:Say ('    Input:"&Input 1  " Row:9, Col:8 Field:"Inp1"')
  Script:Say ('    Input:"I&nput 2  "              Field:"Inp2"')
  Script:Say ('    Button:"  &Done  "   Row:12, Col:24, Action:"Return '+"'Esc_Key'"+'"')
  Script:Say ('  Return(Ok)')
  Script:Say
  Script:Say
  Script:Box ('A Real Dialog Box', 4, 56)
    Button:" Press Enter to save and run this new method ", Row:2, Col:2, Action:"Return(Ok)"
    Pull Down Menus, Radio buttons, Check boxes and Prompts.
  If (Kbd:Got="Esc_Key")
    Return
  Return (Tutorial:Ret)

Script:ThreeFoo
  Script:Say ('ThreeFoo:Start')
  Script:Say ('  New (Foo, Counter)')
  Script:Box ('New Variables',9, 40)
    Button:" More . . . ", Row:7, Col:12, Action:"Return(Ok)"
    New Variables are created using the {Bold:"Lo"}New{Bold:"No"} &
    command.  This line creates two new variables of the {Bold:"Lo"}Jorf{Bold:"No"} &
    class called {Bold:"Lo"}Foo{Bold:"No"} and &
    {Bold:"Lo"}Counter{Bold:"No"}.

    All new instances are Null when created.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  While (Counter < 3)')
  Script:Box ('While', 7, 54)
    Button:" More . . . ", Row:5, Col:18, Action:"Return(Ok)"
    The {Bold:"Lo"}While{Bold:"No"} command creates a loop.  This &
    loop will check the value of Counter and will execute until   &
    it is 3.  A {Bold:"Lo"}Break{Bold:"No"} command &
    can also end a while loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Win:Add("OUR SECOND PROGRAM")')
  Script:Box ('JORF Methods', 15, 40)
    Button:" More . . . ", Row:13, Col:10, Action:"Return(Ok)"
    This line calls the {Bold:"Lo"}Win:Add{Bold:"No"} function.  &
    This is the most powerful and complex function in JORF, and &
    is used for all text and input windows.

    The only parameter here is the title.  In version 2.0 of &
    JORF parameters must be enclosed in parentheses.

    This line is indented from the {Bold:"Lo"}While{Bold:"No"} command &
    making it part of the loop.  All indented lines are part of the loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('      String:"This entry window repeats three times."')
  Script:Say ('      Input:"Enter Something to Say:", Wid:22, Field:"Foo"')
  Script:Box ('Indented Lines',10, 60)
    Button:" More . . . ", Row:8, Col:24, Action:"Return(Ok)"
    Indented lines are part of the command above them.  These lines &
    are passed to the {Bold:"Lo"}Win:Add{Bold:"No"} method directly above.
    The two lines are Window Directives.  These look like &
    JORF language commands, but are specific commands to the &
    window.  The {Bold:"Lo"}String{Bold:"No"} command will &
    display a line, and the {Bold:"Lo"}Input{Bold:"No"} &
    command will change the value of {Bold:"Lo"}Foo{Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    ++Counter')
  Script:Box ('Incrementing a Counter',5, 34)
    Button:" More . . . ", Row:3, Col:10, Action:"Return(Ok)"
    The {Bold:"Lo"}++Counter{Bold:"No"} &
    command is just like saying {Bold:"Lo"}Counter=Counter+1{Bold:"No"}.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Msg:Add')
  Script:Say ('      Counter is: {Counter}')
  Script:Say ('      Foo is: {Foo}')
  Script:Box ('Displaying Data',8, 60)
    Button:" More . . . ", Row:6, Col:28, Action:"Return(Ok)"
    Create a {Bold:"Lo"}Message{Bold:"No"} Box to display the &
    contents of {Bold:"Lo"}Foo{Bold:"No"}.

    I use {Bold:"Lo"}Msg:Add{Bold:"No"} a &
    lot when writing new routines &
    to display intermediate values.  As you see here, &
    you can display any stack variable just by &
    enclosing it in curly brackets.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Foo=Null')
  Script:Say ('  Return(Ok)')
  Script:Box ('Assignment',6, 64)
    Button:" Press Enter to Run this Method ", Row:4, Col:14, Action:"Return(Ok)"
    The next line sets the value of {Bold:"Lo"}Foo{Bold:"No"} to &
    {Bold:"Lo"}Null{Bold:"No"}.  If this is not done, the value of &
    {Bold:"Lo"}Foo{Bold:"No"} will show as a default value &
    on the second and third interations of the loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Return (Tutorial:Ret)

Tut:Basic
  Title:"Basic stuff"
    JORF has many basic concepts that have been proven effective
    in other programming languages.

     {Prompt:"&Strings" Action:"Tutorial:Box('Basic:Strings')"} are &
    quoted with single or double quotes.

     {Prompt:"&Comments" Action:"Tutorial:Box('Basic:Comments')"} begin with a | pipe symbol.

     {Prompt:"&Numeric expressions" Action:"Tutorial:Box('Basic:Numbers')"} can &
    be integers and decimals.

     {Prompt:"&Type conversion" Action:"Tutorial:Box('Basic:Types')"} is &
    usually automatic in math expressions.

     {Prompt:"M&ethods" Action:"Tutorial:Box('Basic:Meth1')"} are the same as &
    subroutines, Functions are pre-programmed JORF Library routines

Tut:Basic1
    Title:"More Basic Stuff"
    Wid:68
     Method and variable {Prompt:"&Labels" Action:"Tutorial:Box('Basic:Labels')"} are &
    the same as in C.

     {Prompt:"&Keyboard" Action:"Tutorial:Box('Basic:Kbd1')"} keys are handled as &
    simple strings, not numbers, and are easy to test.

     {Prompt:"&Class names" Action:"Tutorial:Box('Basic:Classes')"} are &
    separated from variable names by a colon.

     Structure elements are referenced using &
    a ->{Prompt:"&Pointer" Action:"Tutorial:Box('Basic:Pointers')"}.

     Parentheses surround {Prompt:"P&arameter lists" Action:"Tutorial:Box('Basic:Params')"}.

Tut:Basic2
  Title:"Still More Basic Stuff"
    Wid:76
    The JORF language also has some unique features:

     {Prompt:"&Indentation" Action:"Tutorial:Box('Basic:Indent')"} controls &
    program flow, not punctuation or ENDIF commands.

     There are no declared {Prompt:"&Data types" Action:"Tutorial:Box('Basic:DTypes')"}, &
    variables are all JORF Pointers.

     {Prompt:"&Structures (Records)" Action:"Tutorial:Box('Basic:Strucs')"} can &
    have automatic indexes.

     The JORF language has few {Prompt:"&key words" Action:"Tutorial:Box('Basic:KeyWords')"}, &
    most control functions are functions.

     The JORF language handles windows using a &
    {Prompt:"&window manager" Action:"Tutorial:Box('Basic:WinMan')"}.

     JORF handles reports using a &
    {Prompt:"&report manager" Action:"Tutorial:Box('Basic:RepMan')"}.

Basic:Strings
  Title:"Strings"
  A "String" is computer-ese for a data type designed to
  hold letters, words and sentences.  Most data base address
  data is stored as strings.  Even telephone numbers, employee
  numbers and Social Security numbers are stored as strings
  because the have embedded dashes (non-numeric characters).

  A string is:
  {Bold:"Lo"}
	"A"			A Letter
	"Hi"			A Word
	"Hi Jo"			Two Words
	"Wayland Bruns"		A Name
	"25858 Elwood Road"	An Address
	"503-824-5673"		A phone number
  {Bold:"No"}
Basic:Strings1
  Title:"Constant Strings"
  Wid:70
  Constant strings (the opposite of variable strings) are
  quoted.  You see them a lot in programs to set a message
  or title:

	{Bold:"Lo"}Win:Msg("Reading file, please wait . . ."){Bold:"No"}

  This command displayes a message at the bottom of the window
  with the string value "Reading file, Please wait . . .".

Basic:Strings2
  Title:"More Constant Strings"
  In the JORF language, Constant Strings are declared using
  single or double quotes.
  {Bold:"Lo"}
    "A string"			'A String'
  {Bold:"No"}
  A single quoted string may contain double quotes and vice versa.
  {Bold:"Lo"}
    "A string with a 'single quote'"
    'Another string with "Double Quotes"'
  {Bold:"No"}
Basic:Strings3
  Title:"Quoted Numbers"
  Quoted numbers are treated as strings.
  {Bold:"Lo"}
    "1"		"2"	"44.4"	Strings
    "1" + "44.4" = "144.4"	Adding catenates strings

    1		 2	44.4	Numbers
    1   + 44.4   = 45.4		Adding is numeric
  {Bold:"No"}
  Don't be scared, if one of the operators is a number, the
  numeric type conversion is automatic.
  {Bold:"Lo"}
    "2"	+ 3 = 5			Converts 2 to numeric
    "1000" * .33 = 330		Converts 1000 to numeric
  {Bold:"No"}

Basic:Numbers
  Title:"Integers and Decimals"
  In the JORF language, as in X-base/dBASE, you don't
  need to make any distinction between integers and
  decimals.  Numbers are converted to the "best"
  type by the runtime system.

  dBASE programmers and new programmers should understand
  that some languages, notably Basic, C and Pascal, have
  specific numeric types.  In these languages the programmer
  must choose the correct type, and suffer the consequences
  when the number is too large or becomes a decimal.

Basic:Numbers2
  Title:"More integers and Decimals"
  Because JORF is written in C, experienced programmers might
  better understand using the following chart:

    Number   	  is stored as		in a Jorf Pointer{Bold:"Lo"}
    1       	  Long Integer		taking 10 bytes.
    1000    	  Long Integer		taking 10 bytes.
    100000	  Long Integer		taking 10 bytes.
    800000000000  Double		taking 10 bytes.
    345678.9999   Double		taking 10 bytes.
    1.2		  Double		taking 10 bytes. {Bold:"No"}

  As you can see, I am not magic.  I have also decided that
  the speed advantage of Short and Float types is not worth the
  extra code space to automatically convert two more types.

  Also the smallest a JORF Pointer
  is {Prompt:"&10 bytes" Action:"Tutorial:Box('Basic:DataSorry')"}, even
  if it holds only one bit of information.

Basic:DataSorry
  Title:"Bill Smith memorial comment"
  Sorry about the minimum data size.  Experienced programmers
  will well recognize that a minimum 10 byte data size will
  fill memory and bloat data files.

  JORF is a high level language designed to make application
  programming fast and easy.  If you need small data use C.
  In C, bit twiddling comes easy.  The problem with C is that
  you get so busy twiddling bits that it takes a whole month
  just to write a flat file indexed data app with one screen.

  JORF Compensates for memory bloat by using a virtual memory
  system, and file bloat is compensated by using variable
  length records and not storing "whitespace".

  Face it, Bill, you have spent your life storing files that
  are 80% spaces. Why quibble about wasted bytes now!

Basic:Types
  Title:"Type Conversions for Math"
  Wid:70
  In the String screen, you saw how JORF uses the plus
  sign to concatenate strings.

    {Bold:"Lo"}"1" + "44.4" =    "144.4"	Adding catenates strings{Bold:"No"}

  The only math symbol with special meaning for strings
  is the plus sign, and comparison (equals, not equals,
  greater-than and less-than).

  Most mathematic symbols operate only on numbers.  The JORF
  language automatically converts all expressions to numbers
  when doing math:
  {Bold:"Lo"}
    "2" *  "10" 	= 20	   Converts to numeric
    "2.2" / "10"	= .22      Converts to numeric
  {Bold:"Lo"}

Basic:Types1
  Title:"More math conversions"
  Wid:70
  The JORF language also converts from integer to floating
  point - and back!
  {Bold:"Lo"}
    57   /   8	  = 7.125            Converts to Floating Point
    12.5 *   2	  = 25               Converts to Integer
  {Bold:"No"}
  The Modulus and bitwise operators always returns integer results.
  {Bold:"Lo"}
    8 % 3	  = 2                Integer remainder of division.
  {Bold:"No"}
  The one thing that is not converted is strings that are formatted
  as numbers with commas.  Luckily, there is a nice JORF function
  so you can do this by hand:
  {Bold:"Lo"}
    "24,400.00"         * .07 = 1.68     Just takes up to comma
    To:Num("24,400.00") * .07 = 1680     To:Num knows about commas
  {Bold:"No"}
Basic:Types2
  Title:"Comma decimals"
  Wid:70
  There is an international comma-decimal setting for Argentina
  and other countries where the comma marks the decimal position.
  {Bold:"Lo"}
    To:Num("24.400,00") * .07 = 1680	 Decimal = "," in INI file
  {Bold:"No"}
  The JORF language allows standard programs to support both
  decimal formats without changes.  MS-FoxPro can't even do that!

Basic:Types3
  Title:"Non-Math conversions"
  Wid:70
  There are some data types, like Times and Dates, use special
  functions to add, instead of mathematical operations.
  {Bold:"Lo"}
   Date:Add("10/12/93",1,0,0)	Add one day,    Result "10/13/93"
   Date:Sub("10/12/93",0,1,0)	Sub one month,  Result "09/12/93"
   Date:Add("10/12/93",0,0,1)	Add one year,   Result "10/12/94"

   Time:Add("10:23:44",1,0)	Add one minute, Result "10:24:44"
   Time:Sub("10:23:44",0,1)	Sub one hour,   Result "09:24:44"
  {Bold:"No"}
  Please notes that date string conversion is subject to your
  current international date formatter.

Basic:Types4
  Title:"More Non-Math conversions"
  Wid:70
  The text data type also uses functions to add:
  {Bold:"Lo"}
   Text:Add("New Line",Text)	Adds "New Line" to bottom of Text.
   Text:Chg("Chg Line",Text)	Changes current line of text.
  {Bold:"No"}
  Structures can be "Added" too, but now we are getting really
  obscure.  Don't try this unless you are an OOP Guru!
  {Bold:"Lo"}
   Jorf:Move(Stru1,Stru2,"Class") 	Move elements of Structures
  {Bold:"No"}
  That command moves the elements of Stru1 that belong to "Class"
  to Stru2, adding if necessary.

  If you _are_ an OOP guru, did I just make your day?  Isn't that
  the comand you always wanted to quickly shift blocks of elements
  from one structure to another?

Basic:Labels
  Title:"Labels"
  Labels are little sticky things you use in mass-mailings.

  Labels are also a computer term for function names, method
  names, and variable names.

  In JORF, labels can be in both upper and lower case, can
  include any letter or the underscore character, and can
  contain numbers, but not in the first character.

    Legal Labels:
  {Bold:"Lo"}
       MyVariable	All Letters
       Num1		Letters, trailing number
       Con_Stru		Underscore Ok
       _Und		Leading underscore Ok
  {Bold:"No"}
    Illegal Labels
  {Bold:"Lo"}
       My-Variable		No embedded math symbols
       1Num		No leading number
  {Bold:"No"}

Basic:Classes
  Title:"Class designations"
  Wid:70
  Because JORF is an OOP language, lots of labels have a
  class designation in front.  These are separated by
  a colon.
  {Bold:"Lo"}
    New (Contact:Con1)	New Variable Con1 belongs to Contact class
    Contact:Show()	Method Show belongs to the Contact class
  {Bold:"No"}

Basic:Classes1
  Title:"Class designations"
  Wid:70
  JORF Functions and window commands also use colons, even
  when there is no real class.  I call these "pseudo-classes"
  because a class-like grouping is implied even when no such
  class exists.
  {Bold:"Lo"}
    Win:Add()		Add function for a new Window
    Win:Del()		Delete function for a window

    Num:Str()		Format Number as a String
    Date:Str()		Format Date as a String
    Time:Str()		Format Time as a String
  {Bold:"No"}
  "Pseudo-Classes" are my own invention, not something that is
  truly OOP.  So don't brag about them to
  the {Prompt:"&Academic guys" Action:"Tutorial:Box('Basic:Academics')"}.
  The reason I introduced them is to provide a nice visual
  consistency to JORF language programs.

Basic:Academics
  Title:"Academic Guys"
  The {Bold:"Lo"}Academic guys{Bold:"No"}" are the
  college professors who talk and talk
  about {Bold:"Lo"}paradigms{Bold:"No"}, but who don't seem to
  understand what grunt programmers need in a language.

  I often wonder if any of these self styled
  programming experts have really sat across
  a table from a company owner and
  negotiated the price of programming a custom Accounts
  Receivable program; and
  then {Bold:"Lo"}delivered{Bold:"No"} the program!

  The Academics {Bold:"Lo"}talk{Bold:"No"} a lot about paradigms,
  and they {Bold:"Lo"}draw salary{Bold:"No"} by
  inventing {Bold:"Lo"}five syllable words{Bold:"No"}.
  I get paid for {Bold:"Lo"}results{Bold:"No"}, if my results take
  longer than my bid, I go poor and hungry.

Basic:Pointers
  Title:"Structure (Record) Pointers"
  JORF supports the use of Structures, a feature
  native to the Pascal and C languages.  But you
  will often see me note "Record" when I talk of
  structures, since JORF structures have a
  "Record" nature in common with data base
  languages like dBASE.

  It really depends on your background.

    If you are a C or Pascal programmer, a
    Structure is a Structure.

    If you are a dBASE programmer, a structure
    is a record.  But a structure can also be
    indepenent of a file.  A "memory-record".

    If you are a Smalltalk programmer, a
    Structure is an Unstructured Set.

Basic:Pointers1
  Title:"Declaring a structure"
  A Structure is declared using the Class key word.
  The structure definition is positioned in a
  program just like a method definition.
  {Bold:"Lo"}
    Class:MyClass Elm1, Elm2, Elm3
  {Bold:"No"}
  In the class definition punctuation and commends
  are ignored and the defnition can go on for several
  lines.  I often use this "vertical" definition
  for classes with more than 3 elements:
  {Bold:"Lo"}
    Class:Contact
      FullName		| Name
      Address1		| Street Addrss
      Address2		| City State Zip
      WorkPhone		| WOrk Phone number
  {Bold:"No"}

Basic:Pointers2
  Title:"More about Pointers"
  Wid:70
  To access the members of the structure, the pointer
  operator -> is used.
  {Bold:"Lo"}
  MyMethod:Start
    New (Contact:Con)		  | Con is a Contact Structure
    Con->FullName = "Josphine"    | Setting the name
    Con->Address1 = "The Farm"	  | Setting the Address
    Con->Address2 = "Colton"	  | Setting the City

    Str:Put(Con->FullName)	  | Print the name on the screen
    Str:Put(Con)		  | Wrongo - Nothing to print
  {Bold:"No"}
  You can see in this fragment that the structure Con has
  a pointer nature.  Con by itself does not display (displays
  null) because there is no defined string conversion for
  the structure.  But the elements print, because each element
  is a discrete string value.

  If you are new to programming, just let this stuff flow by.
  You will pick it up very fast as you see how these pointers
  are used.  If you are experienced, you probably know all
  this stuff already.

Basic:Params
  Title:"Parameters"
  Calls to functions and methods in the JORF language can have
  parameters, surrounded by parentheses:
  {Bold:"Lo"}
	Win:Add("My Window",4,4,10,40)
	Win:Msg("Don't stop now!")
  {Bold:"No"}
  The first command creates a window titled "My Window" at
  row 4, column 4 on the screen.  The window length is 10 rows
  and the window width is 40 characters.

  The second command displays a message "Don't stop now!".
  The Win:Add and Win:Msg functions use parameters (the stuff
  inside parentheses) to know what to do.  JORF Functions
  (the pre-built commands documented in the reference guide)
  and Methods (the commands you build) both use parameters in
  the same way.

Basic:Params1
  Title:"Parameters"
  An unusual feature of the JORF Language is that parameters
  may be freely omitted from any command line.  If a paramter
  is omitted, the called function or method will see only
  a null parameter, not an error as in dBASE or a crash as in C.
  {Bold:"Lo"}
	Win:Add("My Window")
	Win:Msg
  {Bold:"No"}
  is exactly the same as
  {Bold:"Lo"}
	Win:Add("My Window",0,0,0,0)
	Win:Msg("")
  {Bold:"No"}
  Most JORF functions have pre-defined defaults for these empty
  commands.  The Win:Add function above will create a window
  in the middle of the screen, with a length of 10 rows and a
  width of 30 characters.  The Win:Msg function, when empty, will
  erase the prior message from the window frame.

  This isn't too hard, is it?

Basic:Params2
  Title:"Parameters"
  The Text data type is difficult to express as a constant.  How
  do you fit in one line, text that takes multiple lines.  In JORF,
  you don't have to.  Instead, text can be indented from the command:
  {Bold:"Lo"}
	Msg:Add("My Message","Ok")
	  This is my message,
	  do you like it?
  {Bold:"No"}
  In the above command, the message box function Msg:Add is getting
  _Three_ parameters.  "My Message" is the title, "Ok" designates an
  "Ok" box, and the third parameter is the text on the next line.

Basic:Params3
  Title:"Parameters"
  In JORF, any function or method called with

	{Bold:"Lo"}A) a missing parameter   {Bold:"No"}	and
	{Bold:"Lo"}B) indented lines beneath{Bold:"No"}

	will have the indented lines passed as the last parameter.

  This system gives a nice way to make text boxes without a lot of
  quotes, commas or other nasty formatting considerations.

Basic:Indent
  Title:"Indentation controls program flow"
  Pascal and dBASE use ENDIF, C uses brackets and semi-colons,
  and BASIC does not use anything.  Yet in each of these languages,
  you are expected to indent.

  In JORF, all you have to do is indent.  Indenting controls
  program flow.  No ENDIF, brackets, no semi-colons, just nicely
  structured indented code.
  {Bold:"Lo"}
		What could be easier?
  {Bold:"No"}

Basic:Indent1
  Title:"Some examples of indenting"
  Wid:70
  A method has the method name and parameter list on top, and each line
  of the method is indented. IF, While and Switch statments
  are indented.
  {Bold:"Lo"}
    MyClass:MyMethod(Param1,Param2)	|Method Label, Params
      New (A,B)				|New variables go first
      A = Param1                    	|Command lines follow
      B = Param2 * 20                   |  (just playing here)
      If (B > 10)			|Test B if true
	Str:Put("A = "+A+" and B="+B)	|  do indented lines
      Else				|else
	Str:Put("B is less than 10")	|  do next indented section
	B = 10                          |  until outdent!
      Str:Put("This line always prints")|This line always prints
      Return (Ok)
  {Bold:"No"}
  Take some time to understand it all.  Once you get used to the
  indenting, programming will be easy.  I usually indent two spaces,
  and all the samples are written that way, but you can indent one
  or ten, doesn't really matter.

Basic:Indent1
  Title:"Indentation also declares text data types"
  Constant text data can also be indented and passed as a parameter.
  This is how a window with buttons is created.  The "Button" syntax
  looks a little like methods, but is really just a consistent-look
  way of declaring window fields.
  {Bold:"Lo"}
    Basic:IndentExample
      New (Field1,Field2,Field3)
      Win:Add("My Windows")
	String:"Press TAB between fields"
	Input:"This is field 1" Field:"Field1"
	Input:"This is field 2" Field:"Field2"
	Input:"This is field 3" Field:"Field3"
	Button:"&Ok" Col:5 Wid:30
      Msg:Add("Result","Ok")
	Field1 is {"{"}Field1{"}"}
	Field2 is {"{"}Field2{"}"}
	Field3 is {"{"}Field3{"}"}
      Return (Ok)
  {Bold:"No"}
  Try out this sample.  Ready...Set... {Prompt:"&Go" Action:"Basic:IndentExample"}.

Basic:IndentExample
  New (Field1,Field2,Field3)

  Win:Add("My Windows")
    String:"Press TAB between fields"
    Input:"This is field 1" Field:"Field1"
    Input:"This is field 2" Field:"Field2"
    Input:"This is field 3" Field:"Field3"
    Button:"&Ok" Col:5 Wid:30

  Msg:Add("Result","Ok")
    Field1 is {Field1}
    Field2 is {Field2}
    Field3 is {Field3}
  Return (Tutorial:Ret)

Basic:DTypes
  Title:"The JORF Data Type"
  Wid:70
  Most languages provide data types that relate directly to
  data objects that the CPU can handle.  These include bytes,
  integers and floating point numbers.

  The JORF Language is uses only one data type;
  a {Bold:"No"}JORF Pointer{Bold:"No"}.  In your program,
  all you need to do is declare a new variable, put data
  into it, and let JORF take care of the reset.

  A {Bold:"Lo"}Jorf{Bold:"No"} can hold

    {Bold:"Lo"}Integers       {Bold:"No"}    88    or    -282
    {Bold:"Lo"}Floating point {Bold:"No"}    5.68989   or  232,000,000.01
    {Bold:"Lo"}Strings        {Bold:"No"}    Title:"Hello"   or   Title:"Josephine"
    {Bold:"Lo"}Dates          {Bold:"No"}    10/12/93
    {Bold:"Lo"}Times          {Bold:"No"}    11:20
    {Bold:"Lo"}Text           {Bold:"No"}    The contents of this window
    {Bold:"Lo"}Arrays         {Bold:"No"}    A directory list of files
    {Bold:"Lo"}Structures     {Bold:"No"}    Defined Class (Indexed Record)

Basic:DTypes1
  Title:"Dates in JORF"
  Wid:76
  I want to take a minute here to insult Ashton-Tate, Borland and
  Microsoft.  In the dBASE language, dates are "International".
  Formats are supported for:

	  AMERICAN FRENCH ITALIAN BRITISH or JAPAN

  In dBASE land, dates for white people use the name of
  their language as a key word.  Yellow people have to use
  their country name.  People from Africa must pick
  from the list of White languages or Yellow countries.

  These command word happened because the racial bias of
  the programmers influenced the command set. Smarter
  programmers strive for racial and ethnic equality in
  all their programming efforts.

  I guess Microsoft and Borland (who now market dBASE
  compatable products) are waiting for little Wayland to
  show them how to accomodate various date formats without
  any unintended ethnic slurs.

Basic:DTypes2
  Title:"Dates in JORF"
  There actually two "date formats" that change from country
  to country. dBASE only addresses the short format.

  Short Format:
  {Bold:"Lo"}
	DD/MM/YY	    | Most of the world uses this
	MM/DD/YY	    | Americans use this
	YY/MM/DD	    | Many oriental countries use this.
  {Bold:"No"}
  Long Format:
  {Bold:"Lo"}
	20 Mars, 1993	    | A Frenchman might like this
	March 20, '93	    | An American might like this
	March 20, '00       | Just seven years away?
  {Bold:"No"}
  Dates are handled in JORF by using format strings.  The default
  format is American (not racist, just shows where I live) but you
  can easily change the format to any other.

Basic:DTypes3
  Title:"Dates in JORF"
  The Month names for the long format are held in a month name
  table.  There is also a table to set weekday names and even the
  AMPM indicator.  The Date:Set funcion allows you to set these names.
  Once set, you are free to use the month names throughout your
  program.

  The really nice thing about the JORF system is that dates
  throughout your program are handled through one set of formatters.
  This system is a tad more difficult than dBASE. But joy of
  knowing that a person in Argentina can use your program, yet see
  her dates print normally (for her), is enough to make it
  worth the effort.

Basic:Strucs
  Title:"Fun with Structures (Records)"
  If you are reading in order, you have already seen that
  a structure is declared with the key word class.
  {Bold:"Lo"}
    Class:MyClass Elm1, Elm2, Elm3
  {Bold:"No"}
  And structures can be multiple line declarations with
  comments.
  {Bold:"Lo"}
    Class:Contact
      FullName		| Name
      Address1		| Street Addrss
      Address2		| City State Zip
      WorkPhone		| WOrk Phone number
  {Bold:"No"}
  But there is more, oh so much more!

Basic:Strucs
  Title:"More Fun"
  Structures have a record nature, and no place is this
  more evident than in the Index key word.
  {Bold:"Lo"}
    Class:Contact
      Index:FullName	| Field Fullname is an Index
      Address1		| Street Addrss
      Address2		| City State Zip
      Index:WorkPhone	| Work Phone is also an index
  {Bold:"No"}
  When declare a variable that belongs to this class,
  you get automatic indexing.  Whenever you add a new
  variable, the {Prompt:"&Indexes" Action:"Tutorial:Box('Basic:GayLord')"}
  will be added automatically.  When you change values, the
  indexes are changed, and when you delete the structure the
  indexes are deleted.
  {Bold:"Lo"}
     You don't even have to declare an index file name.
     You can have up to 256 indexes per structure.
  {Bold:"No"}

Basic:Strucs1
  Title:"Still more Fun"
  Wid:70
  There is another key word in a structure definition,
  and that is Parent.  When you declare a parent, you
  declare that all the elements of the parent are in
  the current structure.
  {Bold:"Lo"}
    Class:Customer
      Index:Number	| Customer Number
      Parent:Contact	| Declares all contact fields and indexes.
      Invoice           | Invoice array
  {Bold:"No"}
  NOTE: To make a pointer to another structure you don't
  need to declare anything.  Just set an element in
  the structure to point to the other structure.  For instance
  in the example above, the Invoice declaration can be an
  array of pointer to an index structure.  This leads to
  some involved pointering that will relieve experienced
  programmers and scare new ones.
  {Bold:"Lo"}
     Cust->Invoice[1]->Date  | Customer's first invoice date
  {Bold:"No"}

Basic:Struc2
  Title:"Parents"
  Back to parents, skipping the fancy array pointer stuff.
  {Bold:"Lo"}
    Class:Customer
      Index:Number	| Customer Number
      Parent:Contact	| Declares all contact fields and indexes.
  {Bold:"No"}
  What we have here is a class definition that declares a
  new type of structure.  One element, which is indexed, is
  a structure.  The next line is not an element at all, but
  a declaration that ALL the elements of Class:Contact are
  now declared here, including ALL the indexes, AND ALL
  the Sub-Parents.

  In ADDITION, any polymorphic calls using the Customer
  class will, if no method is found, also search methods in
  the Contact class.

  In Conclusion, the Parent key word does two things:
  {Bold:"Lo"}
    1) It declares another structure's elements
    2) It declares another classes methods for polymorphism.
  {Bold:"No"}
  Polymorphism is only useful in complex programs.  If you are
  not writing complex programs, don't worry.  When you start
  writing complex programs, you will see how polymorphism fills
  a specific need in the maintenance of those programs.

Basic:"Gaylord"
  Title:"Alfred Gaylord Memorial Message"
  Wid:70
  Al says that the proper plural for "Index" is
  "Indices", not "Indexes" as I use.  Alfred likes
  to see English as a "proper language".

  The word Index comes from a latin root, and
  if I were speaking latin I would agree that "Indices"
  is correct.

  But the word sounds Saxon, like most Americans, the
  sound of a saxon word suggests the saxon plural "Indexes".

Basic:Comments
  Title:"Comments"
  Comments are started using a pipe | symbol (so named because
  of UNIX usage of the same symbol for "data pipes".

  On the screen, the symbol looks like a stretched colon,
  when printed, the symbol turns into a solid line.  The
  engineer's who designed this difference were probably paid
  salary, even if it didn't make sense.

  The reason I chose the pipe is that it looks nice when
  commenting on the side because you get a nice continuous
  line between your code and your comments.

  So comment often, make nice lines, make readable code.

Basic:KeyWords
  Title:"KeyWords"
  Wid:70
  There are so few Key words in JORF that I can list them all
  here:
  {Bold:"Lo"}
    Class   - Declares a structure definition.
    Parent  - Declares a class inheritance of elements and methods.
    Jorf    - The Class of a variable with no declared class.
    Index   - In a class definition, an automatic index field.
    Poly    - Class Prefix for a polymorphic method call.
    And     - I got tired of &&.
    Or      - I got really tired of ??.
  {Bold:"No"}
  That is all.  Every other command, including TRUE, IF and NULL
  are function calls.  While I don't expect anyone to change these
  basic functions, they can be changed and are no more key words
  than strcpy() in the C language.


Basic:WinMan
  Title:"Window Manager"
  Wid:64
  The JORF Language uses a specialized Window manager to
  handles menus, buttons and inputs in windows.  This manager
  is not a multi-level library or a code generator system. It
  is not object oriented in any particular way, nor is it
  very flexible.  There is no message passing WinProc.
  {Bold:"Lo"}
			It is Easy!
  {Bold:"No"}
  At least, it is a easy as you can get for a system that
  lets you program multi-level menus, input lines, input
  text, buttons check boxes, radio buttons, and hypertext
  prompts.

  My goal was to create a system where you could write a
  complete application window in less time than it takes
  to think of a neat design for the window.

Basic:RepMan
  Title:"Report Manager"
  Oh how I wish the report system was as well developed
  as the Window handling system.

  Then I remember, that C and Pascal have neither. dBASE and
  Smalltalk have Ok screen management but primitive Report
  writing.  So I am no worse than them, am I?

  The report system as it stands now does just fine at creating
  flat reports, include any structure element or sub-element, and
  even writing mergeletter and text fields.

  Still to be added (soon?) is the full multi-level system
  for properly handling many-to-one relations so you can
  report on arrays and sub-records.

  This text was written March 20, 1993.  Who knows, by now
  maybe I have introduced Version 2.11 and added the
  new reporting features.  Write or call.

Basic:Meth1
  Title:"Methods"
  Wid:64
  A {Bold:"Lo"}Method{Bold:"No"} is the OOP way
  of saying "Function" or "Subroutine".  Methods
  are procedural routines to perform a specific task.

  In Non-OOP languages like {Bold:"Lo"}BASIC{Bold:"No"}
  and {Bold:"Lo"}C{Bold:"No"}, all variables
  belong to a data type.  But subroutines and functions
  exist independent of the data types.

  In OOP languages like {Bold:"Lo"}JORF{Bold:"No"} and {Bold:"Lo"}Smalltalk{Bold:"No"}, all methods
  belong to a class.  Methods that work on Strings belong
  to the String class.  Methods that print Addresses belong
  to the Address class.

Basic:Meth2
  Title:"Method Declarations"
  Wid:62
  In JORF, the class of a method prefixes the method name. The
  following code fragment defines the class address and
  a {Bold:"Lo"}print{Bold:"No"} method for that class:
  {Bold:"Lo"}
      Class:Address Name Address City State Zip
      Address:Print(A)
      Print (A->Name)
      Print (A->Address)
      Print (A->City + "," + A->State + " " + A->Zip)
  {Bold:"No"}
  A {Bold:"Lo"}Class{Bold:"No"} and
  it's {Bold:"Lo"}Methods{Bold:"No"}
  are packaged together to form an {Bold:"Lo"}Object{Bold:"No"}
  which is why this
  is called Object Oriented Programming.

  The packaging of classes and methods is
  called {Bold:"Lo"}Encapsulation{Bold:"No"}
  because Computer Scientists and Engineers
  get a kickback when they
  obfuscate with five syllable words.

Basic:Meth3
  Title:"The Starting Method"
  Wid:72
  JORF language programs always begin with a
  method called {Bold:"Lo"}Class:Start{Bold:"No"}
  where {Bold:"Lo"}class{Bold:"no"} is the name of
  the source code file.   This sample is in the {Bold:"Lo"}Hello.J{Bold:"no"} source file:
  {Bold:"Lo"}
    Hello:Start
      Msg:Add (Null, "Ok")
        Welcome to the World of JORF!
      Return (Ok)
  {Bold:"No"}
  The first line is the method declaration.  Methods
  are declared flush left, and the rest of the method
  is indented.

  The second command calls the JORF Message Window function
  specifying a Null title, and a button type "Ok".  The
  indented line is the text of the message.  The last line
  calls returns control to the calling method.

  Press G to run the program:  Ready... Set... {Prompt:"&Go" action:"Basic:Hello"}

Basic:Hello
  Msg:Add (Null, "Ok")
    Welcome to the World of JORF!
  Return (Ok)


Basic:Kbd
  Title:"Keyboard Entry"
  Wid:56
  Keyboard entry is handled using one of three
  commands. {Bold:"Lo"}Win:Pause{Bold:"No"} takes
  a parameter for the number of hundredths of seconds to pause, and
  will end and return a keystroke if the operator hits a key.

  The {Bold:"Lo"}Kbd:Hit{Bold:"No"} returns {Bold:"Lo"}True{Bold:"No"}
  if the operator has hit a key, and the {Bold:"Lo"}Kbd:Get{Bold:"No"}
  command returns a keystroke.

  JORF returns keystrokes as "Strings".  When you enter an "A", JORF
  returns a string, five characters long, with the value "A_Key".  JORF does
  not return 41, the ASCII value of "A", like most languages.

Basic:Kbd1
  Title:"Testing Keystrokes"
  Wid:68
  To test the keys, you test the string.  For instance, if
  you want to test to see if the operator hit a normal letter
  or number key, test the second through fifth characters to
  see if they are {Bold:"Lo"}"_Key"{Bold:"No"}.
  {Bold:"Lo"}
       WhatKey:Start
	 New (Key)
         Key=Kbd:Get
         If ((Str:At Key 2 4)="_Key")
	   Str:Put "It Was the {"{"}String:At Key 1 1{"}"} Key"
	 Return (Ok)
  {Bold:"No"}
  To get the value of a key, use the {Bold:"Lo"}To:ASCII{Bold:"No"}
  function.  It returns the ASCII Decimal value of the
  first character of a string.
  {Bold:"Lo"}
           Value=To:ASCII Key
  {Bold:"No"}

Basic:Kbd2
  Title:"The Mantra Program"
  Wid:68
  This next sample programs will display some windows
  and get some keyboard entry.  One of my pet projects
  is making computers say Mantras, and idea proposed by
  Edsger Dijkstra many years ago.

  Tibetan Buddhists use mechanical prayer
  wheels to pray more quickly and efficiently.
  Japanese Buddhists of the Amida sect believe
  that anyone who says "Amida" with pure
  heart will go to heaven, so they say it as many times as possible
  in hopes of forgetting and saying it with pure heart once in their lives.

  This Mantra system combines these ideas just in case they
  may be right.  Who can have purer heart than a
  computer?  If you run a Mantra system often, perhaps
  your computer will also forget and therefore insure your place in heaven.

Basic:Kbd3
  Script:"MantraScript" "Mantra:Start"
  Title:"Data Display and Entry"
  Wid:70
   In JORF, only the top Window is active.  JORF Windows are more
  limited and easier to program than most MS-Windows tools.

   JORF Keyboard commands get keys as Strings.
  The {Bold:"Lo"}To:ASCII{Bold:"No"} function can be
  used to convert these strings to numeric values.


Adv:Arrays
  Title:"Arrays"
  Arrays are created by referencing a variable
  using an offset in [square brackets].

        {Bold:"Lo"}New(Foo)      {Bold:"No"}
        {Bold:"Lo"}Foo[5]=10     | Foo is now an array{Bold:"No"}

  Arrays are allocated to the largest member you have
  referenced.  The interpreter expands them as necessary
  as you reference higher numbers.  Custom dictates the first
  element is 1, although if you want, element zero is available.

Adv:Poly
  Title:"Polymorphism"
  Wid:66
  Sethod calls are usually specified using
  both the class and method name. For example, to
  print elements from a contact structure you use:
  {Bold:"Lo"}
           Contact:Print(C)
  {Bold:"No"}
  To make a polymorphic, use the key word {Bold:"Lo"}Poly{Bold:"No"}.
  {Bold:"Lo"}
           Poly:Print(C)
  {Bold:"No"}
  When {Bold:"Lo"}Poly{Bold:"No"} is used, the actual method
  called will depend on the class of the first parameter of
  the call.

Adv:Poly1
  Title:"More Polymorphic Method Calls"
  Wid:70
  Polymorphism seems obscure in simple examples.  Its
  advantage lies in being able to put data from different
  classes in the same data file, and then use polymorphism
  to redisplay that data.

         {Bold:"Lo"}New (Rule:R, TextWin:TW, Menu:M, Jorf:Q)
         Poly:Start(R)  | Same as 'Rule:Start(R)'
         Poly:Start(TW) | Same as 'TextWin:Start(TW)'
         Poly:Start(M)  | Same as 'Menu:Start(M)'
         Q=R
         Poly:Show(Q)   | Will call Rule:Show(Q)
         Q=TW
         Poly:Show(Q)   | Will call TextWin:Show(Q){Bold:"No"}

  If the method is not found, the parents of the class are
  checked (inheritance).  If still not found, the JORF class
  is checked (Default parent).

Adv:Rules1
  Title:"The Rule System"
  JORF uses an {Bold:"Lo"}Object-Attribute-Value{Bold:"No"} rule system.  This
  system is alien to conventional languages but
  comes from the world of Artificial Intelligence
  research.  This triplet is a compact and flexible way to
  store information to implement deductive systems.

  It is unfortunate that there are name conflicts between
  the triplet's {Bold:"Lo"}Object{Bold:"No"}, and an OOP {Bold:"Lo"}Object{Bold:"No"}.  But the world is
  not perfect and we must live with this.  Also, if this is
  new to you, you will have to memorize this triplet until
  it rolls trippingly from your tongue in your sleep.

  There is no particular meaning to Object-Attribute-Value.
  (There was once, but use has diluted the need for meaning.)
  These names are just used to avoid saying {Bold:"Lo"}Thingy1-Thingy2-Thingy3{Bold:"No"}.

Adv:Rules2
  Title:"The Rule System"
  Wid:64
  The JORF triplet also includes more than three elements:
  {Bold:"Lo"}
    Type       | The Type of Rule  (A Number)
    Obj        | Object
    Att        | Attribute
    Prob       | For AI Probability Calculations
    Val        | Value
    Ptr        | A Pointer to Data
  {Bold:"No"}
  The {Bold:"Lo"}Type{Bold:"No"} is a number that designates
  the index to use.  This is simply to avoid conflicts arising
  from different uses of this system.
  The {Bold:"Lo"}Ptr{Bold:"No"} points to data that pertains to the
  rule.

Adv:Rules3
  Title:"Finding Rules"
  Wid:70
  The Rule system has five commands, {Bold:"Lo"}Rule:Add{Bold:"No"},
  {Bold:"Lo"}Rule:Find{Bold:"No"}, {Bold:"Lo"}Rule:Del{Bold:"No"}
  {Bold:"Lo"}Rule:Next{Bold:"No"}, and {Bold:"Lo"}Rule:Prev{Bold:"No"}.

  The {Bold:"Lo"}Rule:Next{Bold:"No"} command can be used multiple times
  to find the next rule in sequence. {Bold:"Lo"}Rule:Prev{Bold:"No"}
  can be used to "backtrack" in a sequence.

  Rules may be found using a partial rule, but the values must be complete
  to a point.  If you think of a rule as a
  scale, you must fill it to any point but with no gaps:
  {Bold:"Lo"}
         Type    Obj       Att       Prob     Val
    Ok    1      "Jo"      "is a"    100      "Mammal"
    Ok    1      "Festus"  "is a"
    No    1      "is a"              100      "Mammal"
  {Bold:"No"}
  The last example will never find anything because there is
  no {Bold:"Lo"}Object{Bold:"No"}, but there is
  an {Bold:"Lo"}Attribute{Bold:"No"}.

Adv:Rules4
  Title:"How Methods are Indexed"
  Wid:66
  The Rule system is used internally for all indexed storage.
  If you look closely at the {Bold:"Lo"}Method{Bold:"No"} class,
  you find that it can look up methods by knowing that JORF
  stores them like this:
  {Bold:"Lo"}
      Type     121
      Obj      Class Name
      Att      First 7 digits of Method Name
      Val      Method Name
      Prob     100
      Ptr      Method Text
  {Bold:"No"}
  Due to internal storage factors, any string less than seven
  digits will be stored in alphabetical order.  By using this
  in the {Bold:"Lo"}Att{Bold:"No"} JORF keeps classes
  so they will be printed in alphabetical order.

Adv:Rules5
  Title:"String Keys"
  Wid:60
  The String Key system may be used to store
  ordered strings greater than seven digits long.  It
  replaces {Bold:"Lo"}Att{Bold:"No"}
  and {Bold:"Lo"}Val{Bold:"No"} with {Bold:"Lo"}Str{Bold:"No"}.
  {Bold:"Lo"}
    Type       | The Type of Rule  (A Number)
    Obj      | Object
    Str      | Up to 20 characters
    Ptr      | A pointer to data
  {Bold:"No"}
  No {Bold:"Lo"}Prob{Bold:"No"} is set for string keys.  String
  keys are automatically converted to lower case when stored.

Adv:Structs
  Title:"Structures, Records and Classes"
  Wid:66
  JORF Structures are stored by name reference, and structure
  definitions can be made without worrying
  about live data.  New elements to a structure will
  be "null" in existing structures.

  A variable of the JORF class can be made into a
  structure just using the pointer operator.  Structures
  of class JORF have no definition and can hold any
  value.
  {Bold:"Lo"}
    New (Rule:R Jorf:J)
    R->Val = "Josephine" | Assign value
    J->Val = R->Val      | Move to J
    R->QQQ = "Goat"      | Error! QQQ is not in Class Rule
    J->QQQ = "Goat"      | Ok - Class JORF takes anything
  {Bold:"No"}

Adv:Words
  Title:"Words"
  Wid:76
  The {Bold:"Lo"}Word{Bold:"No"} is a basic
  unit of JORF.  Just like you use Str:At to get
  a substring, you use Word:At to get a subword.

  Obviously, a line of text is made of words.  But also structures,
  the program stack, and arrays, are handled as words.

  Structures and the program stack words have a label
  assigned to them.  For instance, {Bold:"Lo"}Rule->Val{Bold:"No"}
  actually references a Word in the Rule structure with
  the label "Val".  (Remember, structures are stored by name
  reference.)  The {Bold:"Lo"}Class:At{Bold:"No"} can be used
  to obtain the label name.

  The labels on the program stack are, naturally, the names
  of variables.  This can easily be seen by looking at the
  Stack display in the debugger.

Math:Cont1
  Title:"JORF Control Functions"
  Wid:68
  Control functions are functions whose job is to change the
  program flow.  They include the {Bold:"Lo"}If/Else{Bold:"No"}, &
  {Bold:"Lo"}While/Break/Continue{Bold:"No"} and &
  {Bold:"Lo"}Switch/Case/Else{Bold:"No"}.  These &
  statements are used to create
  branching paths or loop structures.

  In JORF, control functions are implemented as library
  functions. From the JORF Language, they are used just like
  keywords.  But programmers who purchase the JORF Developer's Kit
  can modify and add new control functions.  This gives
  low level functionality to a very high level language.

Math:Cont2
  Title:"If/Else"
  The {Bold:"Lo"}If{Bold:"No"} function tests the
  value of the following item, and if that item is true it
  executes the indented statements.  If it is false,
  it looks for an else command
  on the same indentation level.
  If the {Bold:"Lo"}else{Bold:"No"}
  the indented section following
  is executed.
  {Bold:"Lo"}
          If (A=2)
            B=4
          Else
            B=6
  {Bold:"No"}
  The {Bold:"Lo"}If{Bold:"No"} test should
  be enclosed in parentheses.

Math:Cont3
  Title:"If/Else"
  The test does not need to be a logical test:
  {Bold:"Lo"}
     If (Rule->Fnd)
       Return Rule
  {Bold:"No"}

  This statement is true
  if {Bold:"Lo"}Rule->Fnd{Bold:"No"} (The Fnd
  element of Structure Rule)
  has any value at all.

  The test may be complex:
  {Bold:"Lo"}
    If (A=1  (B+4)=2)
      ++B
  {Bold:"No"}

Math:Cont4
  Title:"While/Break/Continue"
  Wid:78
  The {Bold:"Lo"}While{Bold:"No"} statement creates a loop.
  This loop is repeated as long as the condition of the While statement is
  not Null.  A {Bold:"Lo"}Break{Bold:"No"} is used
  to break out of the loop even if the condition
  is still true.  A {Bold:"Lo"}Continue{Bold:"No"} is
  used to shortcut the loop, restarting
  the next iteration immediately.
  {Bold:"Lo"}
      Counter=0               | Initialize Counter
      While (++Counter <= 5)  | Increment Counter
      Rule:Find (Rule)        | Find a next rule
      If (Rule->Fnd=Null)     | If sequence is ended
        Break                 |   break out of loop
      If (Rule->Ptr=Null)     | If condition is null
        Continue              | Skip rest of loop
      P=P+"-"+Rule->Ptr       | Add Condition
      Str:PutLine (P)         | Show result
  {Bold:"No"}
  The {Bold:"Lo"}Break{Bold:"No"} is used to exit the loop before
  the condition is false.

  The {Bold:"Lo"}Continue{Bold:"No"} command forces the loop to skip
  back to the the {Bold:"Lo"}While{Bold:"No"} statement.

Math:Cont5
  Title:"Switch/Case/Else"
  Wid:54
  The {Bold:"Lo"}Switch{Bold:"No"} command is always a shortcut for
  repeated {Bold:"Lo"}If/Else{Bold:"No"} commands.
  It tests a condition, and executes a section indicated by that test.

    For example:                Is Replaced By
  {Bold:"Lo"}
    If (A=2)                    Switch (A)
      B=A+C                       Case 2
    Else                            B=A+C
      If (A=3)                    Case 3
      B=A+D                         B=A+D
      Else                        Case 4
      If (A=4)                      B=A+E
        B=A+E                     Else
      Else                          B=A
        B=A
  {Bold:"No"}
  In this case, the Switch command is much neater and easier to use.

Math:Cont6
  Title:"Switch/Case/Else (Continued)"
  Wid:44
  The {Bold:"Lo"}Case{Bold:"No"} clause test a value and
  will execute an indented section
  if the value matches.  Case
  commands may be stacked:
  {Bold:"Lo"}
    Switch (Key)
      Case 'a'
      Case 'A'
        Str:PutLine ('Key is A')
      Case 'b'
      Case 'B'
       Str:PutLine ('Key is B')
      Else
        Str:PutLine ('Key is not A or B')
  {Bold:"No"}

Math:Cont7
  The Switch statement may not have a value, in
  which case the {Bold:"Lo"}Case{Bold:"No"} Statements
  are evaluated.
  {Bold:"Lo"}
    Switch
      Case (Key>='a'  Key<='Z')
      Case (Key>='A'  Key<='Z')
        Str:PutLine ('Key is a Letter')
      Case (Key>='0'  Key<='9')
        Str:PutLine ('Key is a Number')
      Else
        Str:PutLine ('Key is Something Else')
  {Bold:"No"}

Math:Cont8
  Title:"Library Function Summary"
  Wid:64
   JORF Functions include Control Functions such as {Bold:"Lo"}If/Else{Bold:"No"}
  as well as Library Functions like {Bold:"Lo"}Win:Add{Bold:"No"}.

   Control Functions are not Keywords.  The are implemented
  as standard library functions that may be augmented and changed
  using The JORF Developer's Kit.

   {Bold:"Lo"}If/Else{Bold:"No"} is used to test a condition and execute indented
  code sections based on that test.  {Bold:"Lo"}Else{Bold:"No"} is optional.

   {Bold:"Lo"}While/Break/Continue{Bold:"No"} is used to create a loop.
  The {Bold:"Lo"}Break{Bold:"No"} command
  can be used to exit that loop at any time.
  The {Bold:"lo"}Continue{Bold:"No"} command is
  used skip code sections by immediately jumping back to
  the {Bold:"Lo"}While{Bold:"No"} statement.

   {Bold:"Lo"}Switch/Case/Else{Bold:"No"} is used to simplify
  repeated {Bold:"Lo"}If/Else{Bold:"No"} commands.
  It may be used to test a value, or a variety of values, and perform
  relevant indented code sections.

Math:Lib1
  Title:"JORF Library Functions"
  Wid:68
  If objects pass messages to objects ad infinitem, nothing would get
  done.  At some point in time, an object must pass a message to
  someone who can do something.  In the case of JORF, this is the
  JORF Runtime program JORF.EXE which contains some handy
  Library Functions.

  These functions are implemented in C code and source code for them
  is included in The JORF Developer's Kit. This library may be
  changed and extended to suit the needs of various developers.

  The basic library has a minimum of commands
  that give a maximum amount of access to the system.  However, there
  is a lot to do with a computer and there are more than eighty
  library functions.

Math:Lib2
  Title:"Some Window Functions"
  Wid:65
  Here are some examples of JORF Library functions.  The complete
  list is documented in {Bold:"Lo"}F1{Bold:"No"} help system.
  Hit {Bold:"Lo"}F1{Bold:"No"} now to take a look!
  {Bold:"Lo"}
    Win:Add(Title,Row,Col,Len,Wid,Level,Here)  | Adds a new window
  {Bold:"No"}
  Win:Add is the most complicated function of them all, because
  you can use it to create text windows, input windows and
  editing windows.
  {Bold:"Lo"}
     Win:Del           | Deletes top window
     Win:Attr (Mode)   | Changes current text color
     Win:FLRCO (Mode)  | Changes wrap mode.
  {Bold:"No"}
  FLRCO stands for "Full", "Left", "Right", "Center", and "Off".
  These are the wrap modes used for text in a window.

Math:Lib3
  Title:"More Window Functions"
  Wid:64
  More window functions...
  {Bold:"Lo"}
    Move:To (Row, Col)   | Moves Cursor to Row and Col
    Move:By (Row, Col)   | Moves Cursor by relative Row and Col

    Kbd:Get (Size)       | Gets key, Cursor Size (Off,Little,Big)
    Kbd:Hit              | Returns true if key has been hit
    Kbd:Bye              | Clear keyboard buffer
    Kbd:Put(Keystrokes)  | Keyboard stuffer

    Str:Put (String)     | Put a string at current cursor location
    Str:PutLine(String)  | Put a string with new line

Math:Lib4
  Title:"Text and Word Functions"
  Wid:68
  Text commands operate on multi-lined text.  If you use these on
  a word, number or character, that variable will be treated as
  a text with only one line.
  {Bold:"Lo"}
    Text:Top  (Text)  | Returns Top line of text
    Text:Bot  (Text)  | Returns Last Line
    Text:Next (Text)  | Returns Next line of text
    Text:Prev (Text)  | Returns Previous line of text
    Text:Wid  (Text)  | Returns Wid of widest line
  {Bold:"No"}
  Word commands operate on a lines of text, and also
  on structures, including the program stack and class
  definitions.  If something else
  is used it is treated as a line with one word.
  {Bold:"Lo"}
    Word:At     (Line, Pos)  | Returns word at position
    Word:AtPut  (Line, Pos)  | Changes word at position
    Class:At    (Line, Pos)  | Returns class at position
    Class:AtPut (Line, Pos)  | Changes class at position

Math:Lib5
  Title:"All the Functions"
  If you want to see all the functions,
  just look into the help file.
  {Bold:"Lo"}
     Beware:  This file is a biggie,
     be sure to come back and finish
     the tutorial!
  {Bold:"No"}
  If you want to see help - Press H.

  Ready... Set... {Prompt:"&Help", Action:"Math:Lib5a"}.

Math:Lib5A
  Tutorial:F1_Key
  Return (Tutorial:Ret)

Math:Remark
  Title:""
  Lots of people (like your math teacher) think you need
  to know calculus or trig, to be a great programmer.

                Wrongo!

  To be a great programmer, you need
  to know how to add, subtract, multiply
  and divide.  You need to know how to
  balance an account to the penny.  It
  helps to know a debit from a credit
  and what a Balance Sheet says for a company.

  Most of all, you need creativity.
  You need the spark of intuitive logic
  that leads you to an effective solution
  to the problems set in front of you.

        Programmers are Artists,
        not Mathematicians.

Math:Start
  Title:"JORF Mathematics"
  Wid:64
  In most OOP languages, math operations are implemented as methods.
  Although this allows a few interesting benefits, there
  are many penalties.

  Instead, JORF uses an embedded math system.
  Math statements are automatically resolved BEFORE any accompanying
  methods are called.  Math statements operate specifically on
  objects with numeric or string values.

  JORF math syntax and order of operations is taken largely from
  the C language with one notable exception.  Since JORF uses the
  pipe ({Bold:"Lo"}|{Bold:"No"}) symbol for comments,
  the word {Bold:"Lo"}Or{Bold:"No"} is the OR operator.

Math:Start1
  Title:"Order of Operations"
  Wid:68
  These are the basic math characters listed in the order that they are
  evaluated:
  {Bold:"Lo"}
    ->                    Structure Element Ptr
    []                    Array reference
    - ~ ++ --             Negation, Complement, Increment, Decrement
    * / %                 Multiplication, Division, Modulus
    + -                   Addition and Subtraction
    = == != <> > < >= <=  Equality, Inequality and Comparison
    ? ^                   Bitwise And, Or and Xor
    And Or && ??          Logical And, Or
    =                     Assignment of value

Math:Start2
  Title:"Parentheses"
  Wid:64
  Prompt:"Algebra II", Row:6 Col:18 Action:"Tutorial:Box('Math:Remark')"
  Parentheses are a part of the program flow system in JORF, not the
  mathematics system.  They may be used to change the order of
  operations in math statements.

    {Bold:"Lo"}5 * 3 + 4         | 19{Bold:"No"}
    {Bold:"Lo"}5 * ( 3 + 4 )     | 35{Bold:"No"}

  I never finished Algebra II
  and I get pretty confused when I have to
  remember the order of operations.  Math is
  much more clear and robust if you use extra
  parentheses to show the exact order the
  statement is to be evaluated

    {Bold:"Lo"}Don't do  A*B+4/C      | This is not very clear or robust{Bold:"No"}
    {Bold:"Lo"}Instead   (A*B)+(4/C)  | Same operation, Much clearer  {Bold:"No"}

Math:Start3
  Title:"Assignment"
  Wid:56
  Values are assigned using single equals sign.

      {Bold:"Lo"}A=B   | Sets A to the value of B{Bold:"No"}

  Assignment is by value for single items, and by reference
  for structures.  The class is also assigned.
  {Bold:"Lo"}
    New (A, B, Rule:R)
    A = "Hi"      | Value of A is now "Hi".
    B = "Bye"     | Value of B is now "Bye".
    A = B         | Value of A changed to "Bye".
    A = Null      | Value of A is Null, B still "Bye".
    R->Ptr = "Hi" | Rule R's Pointer is now "Hi".
    A = R         | A is now class Rule, A->Ptr is "Hi".
  {Bold:"No"}
  Parameter passing is handled the same way; elements are
  passed by value, and structures are passed by reference.

Methods:Start
  Title:"Method Definitions"
  Wid:64
  Methods are procedural routines like a BASIC Subroutine
  or a C Function.  Good methods are between one and twenty lines
  long.  Methods longer than twenty lines can be divided to
  make them easier to read and understand.

  Each Method must belong to a class.  If no class is declared, then
  the method is assumed to belong to class {Bold:"Lo"}Jorf{Bold:"No"}.

  Methods can have one or more parameters.  The first parameter
  is expected to be the same class as the method.  Other
  parameters may be from any class.

Methods:Start1
  Title:"Method Structure"
  Wid:50
  The first line of a method contains its class name and name,
  followed by the parameter list for the method.

  The lines of the method must be indented.  I usually indent
  by two spaces, but you may use fewer or more as you want.
  {Bold:"Lo"}
        MyClass:MyMethod(Param1, Param2)
          |
          | Text of method
          |
          Return (Ok)
  {Bold:"No"}
  The last line of a method should be a Return command.

Methods:Start2
  Title:"Creating New Variables"
  Wid:74
  New Variables can be created at the start of any method. Each instance
  is comprised of a class and a value, referenced by a name.

  The library function {Bold:"Lo"}New{Bold:"No"} is used to create variables.  It may
  be followed by any number of variables to be created.  Each variable
  has a class and a name.  If class is not specified, the variable
  will be a member of class {Bold:"Lo"}Jorf{Bold:"No"}.
  {Bold:"Lo"}
     New (String:S)   | Creates an instance of String called "S".
     New (Rule:Rule)  | An instance of class Rule called "Rule".
     New (Counter)    | An instance of class Jorf called "Counter".
     New (Text:T, Rule:NewRule) | Two new instances, "T" and "NewRule".
  {Bold:"No"}
  All New values are initialized to Null (which is equivalent to integer 0).
  All elements of New structures are initalized to Null.

Methods:Start3
  Title:"Quotes and Constants"
  Wid:66
  String constants may be enclosed by single or double quotes.
  {Bold:"Lo"}
      Title:"A Constant"
      'Another Constant'
      Title:"A 'Quoted' Constant"
      'A constant with a "quote"'
  {Bold:"No"}
  Constants are assigned using the equals sign:
  {Bold:"Lo"}
      New String:S      | A String called "S"
      S="This is a String." | S has value "This is a String."
  {Bold:"No"}
  A quoted constant that is an integer value is a number.
  {Bold:"Lo"}
      The integer value of "33" is 33.
      The integer value of "555-1212" is 555.
  {Bold:"No"}

Script:ThreeFooScript
  Script:Add("Script:ThreeFoo")
  Return (Tutorial:Ret)

Methods:Start4
  Script:"ThreeFooScript" "ThreeFoo:Start"
  Title:"Indentation and Program Flow"
  Wid:72
  Indented lines "Belong" to the unindented line above.  This system
  eliminates the need for ENDIF or bracket punctuation.
  This method fragment demonstrates indentation.
  {Bold:"Lo"}
    Counter=1                 | 1. Initialize Counter
    While (Counter<=Position) | 2. While less than Position
      Rule:Find Rule          | 3. Next rule in sequence
      If (Rule->Fnd=False)    | 4. If not Fnd - done
      Return 'Escape'         | 5.   return 'Escape'.
      ++Counter               | 6. Increment Counter
    Return Rule->Ptr          | 7. Done - Return Ptr
  {Bold:"No"}
  Lines 3 through 6 execute repeatedly as long as the
  value of Counter is less than or equal to Position (Line 2).
  Line 5 executes only if line 4 is True.
  Line 7 executes when Counter is greater than Position (Line 2)
  which completes the While loop.

Methods:Start5
  Title:"Blocks of Text as a Parameter"
  Wid:54
  Indented blocks of text may be passed as a parameter
  to a method.  Whenever a method is called
  with exactly
  one parameter missing, the following line
  is passed {Bold:"Lo"}IF IT IS INDENTED{Bold:"No"}.
  This is a
  convenient way to create multiple line
  text within program code.
  {Bold:"Lo"}
       Mantra:Box('MU')
	 It could be Franky it
	 could be Franky it could
	 be very fresh and clean.
       ++WindowCounter
  {Bold:"No"}
  The function {Bold:"Lo"}Mantra:Box{Bold:"No"} is called
  with two parameters, the title 'MU' and the text that
  is indented.

  (The text above is from Phillip Glass' first opera,
  Title:"Einstein on the Beach".)

Methods:Start6
  Title:"Method Definition Summary"
  Wid:62
   {Bold:"Lo"}Methods{Bold:"No"} are procedural routines that
  must belong to a class.

   The first line of a method specifies its class, name and
  any parameters passed to the method.

   The program flow in the method is dictated by indentation.

   New variables are created in the top of the method using the
  {Bold:"Lo"}New{Bold:"No"} command.  Each variable has a name
  and belongs to a class.  All new variables are set to Null (Zero).

   An indented block of text can be passed as a parameter to a method.

Tut:AdvStart1
  Title:"Getting on to the Good Stuff"
  Wid:70
  Len:16
  The JORF language also has some sophisticated features.

   {Prompt:"&Arrays" Action:"Tutorial:Box('Adv:Arrays')"} can be up to 2
  billion elements, are easy to declare, and each element can
  be another array or structure.

   {Prompt:"&Polymorphism" Action:"Tutorial:Box('Adv:Poly')"} is fully supported.

   The JORF Language has a
  built-in {Prompt:"&Rule Based System" Action:"Tutorial:Box('Adv:Rules1')"} that
  can be used for in Expert System programming to make logical deduction.  This system is
  used for all indexing in JORF.

   There is set of {Prompt:"&Word" Action:"Tutorial:Box('Adv:Words')"} based
  based functions to make text parsing and word handling easy.

Tut:AdvStart
  Title:"Advanced topics"
  The next few things to cover involve the structure of JORF
  language programs.

   JORF {Prompt:"&Mathematics" Action:"Tutorial:Box('Math:Start')"} is pretty
  much like other languages, especially the C language which
  has a pretty clean syntax.

   {Prompt:"M&ethods" Action:"Tutorial:Box('Methods:Start')"} form the basis
  of all programming.

   {Prompt:"&Control" Action:"Tutorial:Box('Math:Cont1')"} functions are JORF
  Library functions like IF, and WHILE that change program flow.

   {Prompt:"&Library" Action:"Tutorial:Box('Math:Lib1')"} functions from the
  rest of the command set in the JORF language.

Tut:Oop
  Title:"Object Oriented Concepts"
  Wid:70
  The Object-Oriented Paradigm
  is {Prompt:"&Over-hyped and over-used" Action:"Tutorial:Box('Intro:BillG')"} but
  it is still useful for
  solving {Prompt:"&Particular problems" Action:"Tutorial:Box('Intro:Oop2')"}.

  {Prompt:"&Classes" Action:"Tutorial:Box('Intro:Classes')"} let you define a discrete chunk of code.

  And {Prompt:"&Inheritance" Action:"Tutorial:Box('Intro:Inh1')"} allows &
  you to re-use chunks of code as they are,
  without "Cloning" them into new modudules.

  Finally, {Prompt:"P&olymorphism" Action:"Tutorial:Box('Intro:Poly1')"} gives
  particular strength to a data oriented programming
  approach.

Tut:Oop1
  Win:Add "OOP Summary"
  Wid:68
   Object Oriented Programming involves four
  specific features; Classes, Encapsulation,
  Inheritance and Polymorphism.

   {Bold:"Lo"}Classes{Bold:"No"} are Do-it-yourself Data Types

   {Bold:"Lo"}Encapsulation{Bold:"No"} means that Classes and
  Methods are packaged together
  into Objects.

   {Bold:"Lo"}Inheritance{Bold:"No"} saves time when a class can
  share methods from a parent class.

   {Bold:"Lo"}Polymorphism{Bold:"No"} means that method names are
  reused many times, and the appropriate method
  is chosen according to class.


Intro:Classes
  Title:"OOP Classes"
  Officially, a Class is a data definition and the methods that
  belong to that data.  In JORF usage, it is common to use Class
  specifically to describe the structure definition.

  If you wish to pursue a true OOP approach, you should design
  your methods so that they are tightly connected and dependent
  on the class definition.  For instance, all methods in a class
  should use a variable that belongs the class as the first
  parameter:
  {Bold:"Lo"}
	Contact:Show(Contact,Length)
  {Bold:"No"}
  not
  {Bold:"Lo"}
	Contact:Show(Length,Contact)
  {Bold:"No"}



Intro:Inh1
  Run:"Intro:InhParent"
  Title:"Inheritance"
  Wid:76
  The {Bold:"Lo"}Parent{Bold:"No"} key word lets a class inherit
  all the elements and methods that
  belong to another class.

  For instance, suppose you had an Address class.  Then you wanted
  to create a new class for Customer.  The Customer class contains
  many fields that are also in the Address Class.
  {Bold:"Lo"}
    Class:Address Name, Street, City, State, Zip
    Class:Customer Company, Name, Street, City, State, Zip
  {Bold:"No"}
  It is much easier to define the Customer class
  if we just inherit the items from the Address
  class.
  {Bold:"Lo"}
    Class:Address Name, Street, City, State, Zip
    Class:Customer Company, Parent:Address
  {Bold:"No"}

Intro:Inh2
  Title:"Method Inheritance"
  Wid:60
  Methods are also inherited, because they belong to the
  classes.  By declaring Address as a parent, the
  Customer class inherits all the methods that belong
  to Address.

  When you call a method, the interpreter first looks in
  the indicated class.  If the method is declared within
  that class, it is run.  If it is not declared within
  the class, the parent classes are checked.

Intro:Inh3
  Title:"Multiple Inheritance"
  Wid:68
  Some OOP languages like JORF, allow a class to have
  more than one parent.  This ability
  called {Bold:"Lo"}Multiple Inheritance{Bold:"No"}.  For instance
  you may want a Vendor class, that inherits from both the
  Address class, and also from the PurchOrder class:
  {Bold:"Lo"}
      Class:Vendor Parent:Address Parent:PurchOrder
  {Bold:"No"}
  When multiple parents are declared, the order is significant
  in resolving name conflicts.

  Many OOP languages don't support multiple inheritance.
  They should, because multiple inheritance is useful and
  is easy to implement (at least it was in the JORF interpreter).

Intro:InhParent
  New (Count)
  Win:Add(Null, 0, 0, 5, 0, Here)
    How do you write 200 lines
    of code in 6 letters?
  Win:Pause (100)
  Win:Attr ("Lo")
  Move:To (4, 10)
  While (Count < 6)
    ++Count
    Str:Put (Str:At ("Parent",Count,1))
    Win:Chg
    Win:Pause(5)
  Win:Pause (40)
  Win:Attr ("No")
  Win:Msg("Press a key . . .")
  Win:Pause
  Return (Ok)

Intro:BillG
  Title:"O-O Misuse"
  Wid:70
  It seems that the term Object Oriented Programming
  is now so misused, that it is going the way of
  "{Prompt:"&Fifth Generation" Action:"Tutorial:Box('Intro:Fifth')"}".

  Bill Gates has much to blame, because he makes stupid statements
  like "A Windows Icon is an object, Visual Basic handles icons,
  so Visual Basic is Object Oriented".

  Bill is wrong, because an Icon is a Windows Object, but has nothing
  to do with the encpsulation of class definition and methods that
  are intended when an O-O programmer says "Object".

  Bill is spoiling O-O to get a sales edge for VB.

Intro:BillG1
  Title:"Microsoft Marketing is spoiling O-O"
  Microsoft is also pushing Windows as an O-O environment.  Yet most
  MS-Windows sample programs that I have seen have extensive use
  of global variables and massive unstructured switch statements.

  These things are characteristic of Pre-Dykstra BASIC programs,
  not of proper Object Oriented practices.  The technique of O-O
  suggests increased encapsulation.  This is the opposite of the
  rampant use of global variables that is needed for
  MS-Windows programming.

  The C++ language, used for most Windows programming, allows
  a lot of variation in style.  You be very unstructured in C++,
  you can make structured programs in C++ and you can make Object
  Oriented programs in C++.

  Just 'cause a programmer uses C++ does not mean that the programmer
  knows or follows about O-O techniques.  Most don't.

Intro:Fifth
  Title:"Fifth Generation"
  Whatever happened to "Fifth Generation"? Nothing.
  The concept is alive and well in a number of
  products.  But Marketer's killed the expression by
  labeling just about any new version of a third
  generation language as "Fifth Generation".

  Now, no self respecting company will use the
  term, even if their product fits the original
  description of "Fifth Generation".



Intro:BillG2
  Title:"Real O-O"
  What I will tell you is different from most people, but they
  don't have an easy O-O language to sell.  My message:
  {Bold:"Lo"}
      Ignore Object Oriented Programming (until . . .)
  {Bold:"No"}
  Its kinda like Lotus Macros.  95% of all people who use
  Lotus 123 or Quattro do not touch the macro language.  But this
  does not detract from the limited spreadsheets they do.

  In my opinion, 95% of all programmers can safely ignore Object
  Oriented programming because their projects are too small to
  take advantage of O-O techniques.
  {Bold:"Lo"}
     . . . you start using inter-dependent data structures.
  {Bold:"No"}
  When you write a full Recievables system, and add customer
  and vendor information, and your structures start overlapping,
  then you should divide your program into tasks (classes) and
  begin taking advantage of inheritance and polymorphism.

Intro:OOP2
  Title:"Handling Complexity"
  Wid:60
  It used to be quite sufficient to create a screen by
  placing each prompt, invoking an input system, and checking
  the keystrokes.

  Now, a MS-Windows style screen with pull down menus, Alt keys
  buttons, boxes and input fields may have to handle more
  than {Bold:"Lo"}100{Bold:"No"} possible keystrokes.

  The old system of {Bold:"Lo"}If Key = 'M' . . . If Key = 'Q' . . .{Bold:"No"}
  is just inadequate for this complex a screen.  You might as
  well write it in Assembler

Intro:OOP3
  Title:"Writing in Assembler"
  Wid:70
  Assembly language is the first of all computer.
  languages. {Bold:"Lo"}Key words{Bold:"No"} in assembler correspond
  to the {Bold:"Lo"}binary machine code{Bold:"No"}
  that is native to the computer chip.

  The purpose of higher level languages is to use the power of
  the computer to support data constructs beyond those native to
  the CPU.

  As computers have grown more and more powerful, it is clear that
  new languages must support more than complex data constructs.  They
  must also support a {Bold:"Lo"}higher level conceptual framework{Bold:"No"}
  for programming.

Intro:OOP4
  Title:"Object Oriented Programming" 3, 3, 17, 74
  In OOP technique, the {Bold:"Lo"}Data{Bold:"No"} is
  of primary importance.  The {Bold:"Lo"}Program{Bold:"No"} is
  secondary.  Although the program consists of recognizable
  subroutines, they are identified by the {Bold:"Lo"}data they
  handle{Bold:"No"}, not by their function in the program.

  Subroutines, called {Bold:"Lo"}Methods{Bold:"No"} are even
  named by the data they act on.  The are grouped by the data
  type, called the {Bold:"Lo"}Class{Bold:"No"}.  The Class and Methods
  together form a unit called an {Bold:"Lo"}Object{Bold:"No"}, hence
  the name Object Oriented Programming.

  When creating an O-O program, concise and self-sufficient
  subroutines are the mark of quality.  If you move an Object
  to another program, you should not have to make any changes
  for the subroutines to work properly, even in the new environment.

Intro:OOP5
  Title:"Learning OOP"
  Wid:64
  You can use OOP technique with any language, including
  assembly language.  The technique is in your mind, and in
  the way you program, not in the language.

  OOP languages are important because they encourage (and coerce)
  you to use the proper technique.  Most OOP languages also
  support {Bold:"Lo"}inheritance{Bold:"No"} and {Bold:"Lo"}polymorphism{Bold:"No"}
  that make code re-use much easier.  These are the icing on the
  OOP cake, allowing you to easily share like code between Objects.

  The JORF language is the simplest OOP language in data typing and
  method declaration.  This simplicity is tied to a sophisticated
  screen and data base management system.

  While no language is easy, JORF is among the easiest to
  learn of all Object Oriented Programming languages,
  and {Bold:"Lo"}it is the only one named after a goat{Bold:"No"}!

Intro:Poly1
  Title:"Polymorphism"
  Wid:68
  In OOP, it is common for methods of different classes to have
  the same name, like the {Bold:"Lo"}Address:Print{Bold:"No"}
  and {Bold:"lo"}Customer:Print{Bold:"No"} methods.

  Each variable (which true OOP gurus will call
  an {Bold:"Lo"}Instance{Bold:"No"}) also belongs to a class.

  In JORF, the keyword Poly indicates a polymorphic method call, a
  method call based on the class of the variable.

  So when you have a variable {Bold:"Lo"}X{Bold:"No"} or {Bold:"Lo"}Y{Bold:"No"}
  the method called when you use Poly will change according
  to class of the variable.
  {Bold:"Lo"}
    New (Customer:X, Address:Y)  | Creates variables X and Y
    Poly:Print(X)                | Calls Customer:Print
    Poly:Print(Y)                | Calls Address:Print
  {Bold:"No"}
  The system of using methods with the same name, and choosing
  the appropriate method based on class is
  called {Bold:"Lo"}Polymorphism{Bold:"No"}. (Another kickback.)

Intro:Poly2
  Title:"Polymorphism"
  Wid:74
  Legitimate uses for Polymorphism are rare.  Generally when you
  call a method, you are calling a specific method.  In JORF, you
  make the call specific by declaring both the class and name of
  the method:
  {Bold:"Lo"}
    New (Customer:X)   | Create variable X, belongs to class Customer
    Poly:Print (X)     | A polymorphic call to Customer:Print
    Address:Print(X)   | A specific call to Address:Print
  {Bold:"No"}
  Specific calls run faster because the interpreter does not
  have to obtain the class of the variable, and does not have to
  search the parent hierarchy.  When compiled, the method call is
  direct.

Intro:Poly3
  Title:"Polymorphism"
  Wid:58
  Although legitimate uses of Polymorphism are rare, when they are
  necessary nothing else will do.

  The greatest ability of OOP
  languages is to have methods that can manipulate data without
  knowing specifically what the data is.  By using polymorphism
  these "data manager" methods are far more efficient than
  methods that are duplicated for every data type.

