TextEdit:Start(Name)
  Mem:Ptr->Name = To:Ucs(Name)
  Mem:Ptr->Edit = TextEdit:Read(Mem:Ptr->Name)

  Event:Add(Null)                       | Block prior events
  Event:Add("EditKey")                  | Use standard Edit Keys
  Event:Add("TextEdit")                 |  and some special ones defined here

  Jorf:File("TextEdit.Tmp",Here)        | Temporary Storage area

  If (Name == Null)
    Kbd:Put("F4_Key")

  Win:Add("Josephine's Text Editor", 0, 0, 0, 0, Here)
    Save:"TextEdit:Save"
    Restore:"Null"
    Idle:"EditKey:Message"      | When idle - display Row Col info
    Flrco:"o"                   | No wrap mode
    Menu:"&File"
      Menu:"&New      Shift-F4",    Action:'TextEdit:New'    HotKey:"Shift_F4_Key"
      Menu:"&Open           F4",    Action:'TextEdit:Open'   HotKey:"F4_Key"
      Menu:"&Save     Shift-F3",    Action:'TextEdit:Save'   HotKey:"Shift_F3_Key"
      Menu:"Save &As        F3",    Action:'TextEdit:SaveAs' HotKey:"F3_Key"
      Menu:""
      Menu:"&Print          F5",    Action:'TextEdit:Print'  HotKey:"F5_Key"
      Menu:""
      Menu:"A&bout"                 Action:'TextEdit:About'
      Menu:"E&xit        Alt-X",    Action:'TextEdit:Exit'   HotKey:"Alt_X_Key"
    Menu:"&Edit"
      Menu:"&Toggle Insert Mode   Ins", Action:'TextEdit:Stuff("Ins_Key")'
      Menu:"&Beginning of line   Home", Action:'TextEdit:Stuff("Home_Key")'
      Menu:"&End of line          End", Action:'TextEdit:Stuff("End_Key")'
      Menu:"Word &Left         Ctrl-A", Action:'TextEdit:Stuff("Ctrl_A_Key")'
      Menu:"Word &Right        Ctrl-F", Action:'TextEdit:Stuff("Ctrl_F_Key")'
      Menu:"&Delete Word       Ctrl-T", Action:'TextEdit:Stuff("Ctrl_T_Key")'
      Menu:"De&lete to End   Ctrl-K Y", Action:'TextEdit:Stuff("Ctrl_K_Key", "Y_Key")'
    Menu:"&Block"
      Menu:"&Beginning  Ctrl-K B",  Action:'TextEdit:Stuff("Ctrl_K_Key","B_Key")'
      Menu:"&End        Ctrl-K K",  Action:'TextEdit:Stuff("Ctrl_K_Key","K_Key")'
      Menu:"&Delete     Ctrl-K Y",  Action:'TextEdit:Stuff("Ctrl_K_Key","Y_Key")'
      Menu:"&Copy       Ctrl-K C",  Action:'TextEdit:Stuff("Ctrl_K_Key","C_Key")'
      Menu:"&Move       Ctrl-K V",  Action:'TextEdit:Stuff("Ctrl_K_Key","V_Key")'
      Menu:"&Hide       Ctrl-K H",  Action:'TextEdit:Stuff("Ctrl_K_Key","H_Key")'
    Menu:"&Goto"
      Menu:"&Beginning of file  Ctrl-Q R",  Action:'TextEdit:Stuff("Ctrl_Q_Key","R_Key")'
      Menu:"&End of file        Ctrl-Q C",  Action:'TextEdit:Stuff("Ctrl_Q_Key","C_Key")'
      Menu:"&Line Number        Ctrl-Q G",  Action:'TextEdit:Stuff("Ctrl_Q_Key","G_Key")'
    Menu:"&Search"
      Menu:"&Find        Ctrl-Q F", Action:'TextEdit:Stuff("Ctrl_Q_Key","F_Key")'
      Menu:"Find &Next     Ctrl-L", Action:'TextEdit:Stuff("Ctrl_L_Key")'
      Menu:"&Replace     Ctrl-Q A", Action:'TextEdit:Stuff("Ctrl_Q_Key","A_Key")'
    Text:'', Field:'Mem:Ptr->Edit' Row:1 Col:1 Wid:78 Len:22

  File:Del("TextEdit.Tmp")              | Delete Storage area
  Return

TextEdit:About
  Msg:Add ("About TextEdit", "Ok")
    Josephine's Text Editor is a sample program included &
    with the JORF Interpreter.  It provides many of the &
    functions as other text editors, and is written in &
    about three pages of program code.

    Version 1.1                              May 11, 1992
        Copyright (C) 1991,1992 by The JORF Company
  Return (Ok)

TextEdit:Exit
  If (TextEdit:Save)
    Kbd:Put('Esc_Key')
  Return (Null)

TextEdit:New()
  If (TextEdit:Save)
    EditKey:Ctrl_Page_Up_Key
    Mem:Ptr->Name = Null
    Mem:Ptr->Edit = Text:Add()
    Win:Dsp
  Return (Ok)

TextEdit:Open
  New (Name)
  Name = DirList:GetFile("*.txt")
  If (Name)
    If (TextEdit:Save)
      Mem:Ptr->Name = To:Ucs(Name)
      Mem:Ptr->Edit = TextEdit:Read (Name)
      Win:Dsp
  Return (Ok)

TextEdit:Print()
  New (Dest)
  Dest=Jorf:Printer()
  File:Save("JREPORT.LST",Mem:Ptr->Edit)
  File:Print("JREPORT.LST",Dest)
  Return(Ok)

TextEdit:Read(FileName)
  If (FileName)
    If (File:Exist (FileName))
      Win:Add ('Reading')
        Loading file "{FileName}"
      Return (File:Load (FileName))
    Else
      Msg:Add ('Error', 'Ok')
        Cannot find file "{FileName}"
  Return (Text:Add)

TextEdit:Save
  If (Mem:Ptr->Name==Null)
    TextEdit:SaveAs()
  Else
    TextEdit:Write (Mem:Ptr->Name, Mem:Ptr->Edit)
    Jorf:Del (Win:Ptr->Copy)
    Win:Ptr->Copied=False
  Return (Ok)

TextEdit:SaveAs
  New (Key, FileName)
  FileName = Mem:Ptr->Name
  If (Win:Ptr->Copied)
    While (Ok)
      Win:Add ('File Name')
	Input:'File Name to Save ', Wid:30, Field:'FileName'
      Win:Del
      If (Kbd:Got == 'Esc_Key')
	Return (Ok)
      If (FileName != Null)
	If (File:Exist (FileName) != 0)
	  Key=Msg:Add ('File Already Exists' 'No')
	    File "{FileName}" Already Exists!
	    Do you want to overwrite it?
	  If (Key==Null)          | If not ok - loop back to while OK
	    Continue
      Break                       | Otherwise break and write file
    Mem:Ptr->Name = To:Ucs(FileName)
    TextEdit:Write (Mem:Ptr->Name, Mem:Ptr->Edit)
  Jorf:Del (Win:Ptr->Copy)
  Win:Ptr->Copied=False
  Return (Ok)

TextEdit:Stuff (Key1,Key2)
  Kbd:Put(Key1)
  Kbd:Put(Key2)
  Return(Null)

TextEdit:Write (FileName, Text)
  If (FileName And Text)
    Win:Add ('Writing')
      Saving file "{FileName}"
    File:Save (FileName, Text)
  Return (Ok)

