EditIni:Start
  New (Ini:IniStruct, FileName,PrintChoice, WinChoice)

  FileName = EditIni:FileName()
  If (File:Exist (FileName)==False)
    Msg:Add ('Error', 'Ok')
      Cannot find file "{FileName}"
    Return

  EditIni:Backup(FileName)
  Event:Add("EditIni")
  Win:Add ('JORF Options',0,0,0,0,Here)
    Idle:"Editini:CheckRead(IniStruct,FileName)"
    Menu:"&File"
      Menu:"&About EditIni" Action:"EditIni:About"
      Menu:"&New File"      Action:"Editini:GetFile(IniStruct,FileName)"
      Menu:"E&xit"          Action:"EditIni:Cancel(FileName)"
    Group:"Windows and DOS Options" Row:1 Col:1 Len:3 Wid:30
    ChBox:"&MultiUser Mode"  Check:"IniStruct->Multiuser=='Yes'"
      Action:"IniStruct->MultiUser='Yes'" UnAction:"IniStruct->MultiUser='No'"
    ChBox:"Memory &status "   Check:"IniStruct->MemStats=='Yes'"
      Action:"IniStruct->MemStats='Yes'" UnAction:"IniStruct->MemStats='No'"
    Input:"Ram Disk       " Field:"IniStruct->RamDisk" Wid:10
    Group:"&DOS Options" Row:6 Col:1 Len:5 Wid:30
    ChBox:"&Bios Screens"      Check:"IniStruct->Bios=='Yes'"
      Action:"IniStruct->Bios='Yes'" UnAction:"IniStruct->Bios='No'"
    ChBox:"&Monochrome Override" Check:"IniStruct->Monochrome=='Yes'"
      Action:"IniStruct->Monochrome='Yes'" UnAction:"IniStruct->Monochrome='No'"
    ChBox:"Use &Graphics Mode"      Check:"IniStruct->Graphics=='Yes'"
      Action:"IniStruct->Graphics='Yes'" UnAction:"IniStruct->Graphics='No'"
    ChBox:"Using XT &Keyboard"      Check:"IniStruct->IsXt=='Yes'"
      Action:"IniStruct->IsXt='Yes'" UnAction:"IniStruct->IsXt='No'"
    Input:"Explode Speed (0-9)  " Field:"IniStruct->Explode" Wid:1

    Group:"&Printer prompts" Row:1 Col:34 Len:5 Wid:24
    Array:"" Field:"IniStruct->PrintList"
       Show:"EditIni:PrintShow"
       Choice:"PrintChoice"
       Action:"EditIni:PrintDo(IniStruct,PrintChoice)"
    Group:"&Window colors"  Row:8 Col:34 Len:7 Wid:24
    Array:"" Field:"IniStruct->WinList"
       Show:"EditIni:WinShow"
       Choice:"WinChoice"
       Action:"EditIni:WinDo(IniStruct,WinChoice)"
    Input:"&File:" Field:"FileName" Row:13 Col:1 Wid:26 Before:Null
    Button:"&Ok"     Row:14 Col:1 Wid:14 Action:"Return Null"
    Button:"&Cancel" Row:14 Col:19 Wid:14 Action:"EditIni:Cancel(FileName)"

  If (Kbd:Got!='Esc_Key')
    EditIni:Write(FileName,IniStruct)
  Return Ok

Class:Ini
  Bios
  Monochrome
  Multiuser
  Memstats
  Decimal
  Graphics
  Isxt
  Ramdisk
  Explode
  Printlist
  Winlist

class:IniPrint
  Prompt
  Device

class:IniWin
  Name
  MonoColor
  Linestyle
  Clrborder
  Clrtitle
  Clrshadow
  Clrmessage
  Clrnormal
  Clrlow
  Clrmedium
  Clrhigh
  Clrbold

Editini:About
  Msg:Add ("EditIni")
    Flrco:"Center"
    Program to edit JORF.INI files

    Written by Wayland Bruns
    March 10, 1993 for Version 2.1
  Return (Ok)

Editini:Alt_F5_Key
  Jorf:Flush
  Return (Ok)

EditIni:Backup(FileName)
  New (BakName)
  BakName = Str:AtCut(FileName,Str:In(FileName,".")) + ".BAK"
  File:Copy(FileName,BakName)
  Return (Ok)

EditIni:Cancel(FileName)
  New (BakName)
  BakName = Str:AtCut(FileName,Str:In(FileName,".")) + ".BAK"
  File:Copy(BakName,FileName)
  Kbd:Put("Esc_Key")
  Return (Ok)

Editini:CheckRead(*IniStruct,FileName)
  If (IniStruct->Bios==Null)
    Win:Msg("Reading INI file")
    IniStruct=EditIni:Read(FileName)
    If (IniStruct->Bios==Null)
      IniStruct->Bios="No"
    Win:Msg
    Win:Dsp
  Return (Ok)

EditIni:ChkBkdColor(WorkColor,Color)
  Return (Color==Str:At(WorkColor,Str:In(WorkColor,"/")+1))

EditIni:ChkForColor(WorkColor,Color)
  Return (Color==Str:AtCut(WorkColor,Str:In(WorkColor,"/")))

EditIni:ColorSet(OldWin)
  New (ArrColor,ArrChoice,LastChoice,WorkColor,IniWin:Win)

  Win = Jorf:Dup(OldWin)
  ArrChoice  = 1
  LastChoice = 1
  WorkColor  = Win->ClrNormal

  ArrColor[1] = "Normal  - Text and prompts"
  ArrColor[2] = "Low     - Hot keys"
  ArrColor[3] = "Medium  - Lines and Groups"
  ArrColor[4] = "High    - Unselected fields"
  ArrColor[5] = "Bold    - Selected field"
  ArrColor[6] = "Message - Window message"
  ArrColor[7] = "Border  - DOS Border"
  ArrColor[8] = "Title   - DOS Title"
  ArrColor[9] = "Shadow  - DOS Shadow"

  Win:Add("JORF Window Colors")
    Group:"&Color to change"     Row:10 Col:1 Len:9 Wid:30
      Display:"EditIni:ColorShow(Win)"
    Array:"" Field:"ArrColor"
      Choice:"ArrChoice"
      Action:"EditIni:NewColor(Win,WorkColor,ArrChoice,LastChoice)"
    Input:"Setting" Field:"ArrColor[ArrChoice]" Row:2 Col:36 Wid:28 Before:"Null"
      Display:"EditIni:NewColor(Win,WorkColor,ArrChoice,LastChoice)"

    Group:"&Foreground" Row:3 Col:36 Len:16 Wid:16
    Radio:"Black"
      Check:"EditIni:ChkForColor(WorkColor,'Black')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Black',ArrChoice)"
    Radio:"Blue"
      Check:"EditIni:ChkForColor(WorkColor,'Blue')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Blue',ArrChoice)"
    Radio:"Green"
      Check:"EditIni:ChkForColor(WorkColor,'Green')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Green',ArrChoice)"
    Radio:"Cyan"
      Check:"EditIni:ChkForColor(WorkColor,'Cyan')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Cyan',ArrChoice)"
    Radio:"Red"
      Check:"EditIni:ChkForColor(WorkColor,'Red')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Red',ArrChoice)"
    Radio:"Magenta"
      Check:"EditIni:ChkForColor(WorkColor,'Magenta')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Magenta',ArrChoice)"
    Radio:"Brown"
      Check:"EditIni:ChkForColor(WorkColor,'Brown')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Brown',ArrChoice)"
    Radio:"White"
      Check:"EditIni:ChkForColor(WorkColor,'White')"
      Action:"EditIni:SetForColor(Win,WorkColor,'White',ArrChoice)"
    Radio:"Gray"
      Check:"EditIni:ChkForColor(WorkColor,'Gray')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Gray',ArrChoice)"
    Radio:"Light Blue"
      Check:"EditIni:ChkForColor(WorkColor,'Light Blue')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Light Blue',ArrChoice)"
    Radio:"Light Green"
      Check:"EditIni:ChkForColor(WorkColor,'Light Green')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Light Green',ArrChoice)"
    Radio:"Light Cyan"
      Check:"EditIni:ChkForColor(WorkColor,'Light Cyan')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Light Cyan',ArrChoice)"
    Radio:"Light Red"
      Check:"EditIni:ChkForColor(WorkColor,'Light Red')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Light Red',ArrChoice)"
    Radio:"Light Magenta"
      Check:"EditIni:ChkForColor(WorkColor,'Light Magenta')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Light Magenta',ArrChoice)"
    Radio:"Yellow"
      Check:"EditIni:ChkForColor(WorkColor,'Yellow')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Yellow',ArrChoice)"
    Radio:"Bright White"
      Check:"EditIni:ChkForColor(WorkColor,'Bright White')"
      Action:"EditIni:SetForColor(Win,WorkColor,'Bright White',ArrChoice)"
    Group:"&Background" Row:3 Col:56 Len:16 Wid:16
    Radio:"Black"
      Check:"EditIni:ChkBkdColor(WorkColor,'Black')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Black')"
    Radio:"Blue"
      Check:"EditIni:ChkBkdColor(WorkColor,'Blue')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Blue',ArrChoice)"
    Radio:"Green"
      Check:"EditIni:ChkBkdColor(WorkColor,'Green')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Green',ArrChoice)"
    Radio:"Cyan"
      Check:"EditIni:ChkBkdColor(WorkColor,'Cyan')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Cyan',ArrChoice)"
    Radio:"Red"
      Check:"EditIni:ChkBkdColor(WorkColor,'Red')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Red',ArrChoice)"
    Radio:"Magenta"
      Check:"EditIni:ChkBkdColor(WorkColor,'Magenta')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Magenta',ArrChoice)"
    Radio:"Brown"
      Check:"EditIni:ChkBkdColor(WorkColor,'Brown')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Brown',ArrChoice)"
    Radio:"White"
      Check:"EditIni:ChkBkdColor(WorkColor,'White')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'White',ArrChoice)"
    Radio:"Gray"
      Check:"EditIni:ChkBkdColor(WorkColor,'Gray')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Gray',ArrChoice)"
    Radio:"Light Blue"
      Check:"EditIni:ChkBkdColor(WorkColor,'Light Blue')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Light Blue',ArrChoice)"
    Radio:"Light Green"
      Check:"EditIni:ChkBkdColor(WorkColor,'Light Green')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Light Green',ArrChoice)"
    Radio:"Light Cyan"
      Check:"EditIni:ChkBkdColor(WorkColor,'Light Cyan')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Light Cyan',ArrChoice)"
    Radio:"Light Red"
      Check:"EditIni:ChkBkdColor(WorkColor,'Light Red')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Light Red',ArrChoice)"
    Radio:"Light Magenta"
      Check:"EditIni:ChkBkdColor(WorkColor,'Light Magenta')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Light Magenta',ArrChoice)"
    Radio:"Yellow"
      Check:"EditIni:ChkBkdColor(WorkColor,'Yellow')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Yellow',ArrChoice)"
    Radio:"Bright White"
      Check:"EditIni:ChkBkdColor(WorkColor,'Bright White')"
      Action:"EditIni:SetBkdColor(Win,WorkColor,'Bright White',ArrChoice)"
    Button:"&Ok"          Row:21 Col:2 Wid:14 Action:"Return Null"
    Button:"&Cancel"      Row:21 Col:18 Wid:14 Action:"Kbd:Put('Esc_Key')"
    Button:"&Pick Scheme" Row:21 Col:42 Wid:24 Action:"EditIni:Scheme(Win,WorkColor,ArrChoice)"
  If (Kbd:Got!='Esc_Key')
    Jorf:Move(Win,OldWin)
    Win:Dsp
  Jorf:Del(Win)
  Return (Ok)

EditIni:ColorShow(Win)
  New (LineChars,i)

  Switch (Win->LineStyle)
    Case 'Double'
      LineChars = "ͻͼĶ"
    Case 'Single'
      LineChars = "ĿĴ"
    Case 'Thick'
      LineChars = ""
    Else
      LineChase = "          "
  Win:Attr(Win->ClrBorder)
  Move:To(2,4)
  Str:Put(Str:At(LineChars,1,1))
  Str:Put(Str:AtSet(Null,1,Str:At(LineChars,2,1),25))
  Str:Put(Str:At(LineChars,3,1))
  Move:To(2,12)
  Win:Attr(Win->ClrTitle)
  Str:Put(" Title ")

  EditIni:OneLine(Win,LineChars,3)

  Move:To(3,5)
  Win:Attr(Win->ClrBold)
  Str:Put("M")
  Win:Attr(Win->ClrHigh)
  Str:Put("enu high")
  Win:Attr(Win->ClrNormal)
  Str:Put("   ")
  Win:Attr(Win->ClrLow)
  Str:Put("M")
  Win:Attr(Win->ClrNormal)
  Str:Put("enu low")

  EditIni:OneLine(Win,LineChars,4)
  Move:To(4,5)
  Win:Attr(Win->ClrMedium)
  Str:Put(Str:AtSet(Null,1,Str:At(LineChars,10,1),25))
  Win:Attr(Win->ClrLow)
  Move:To(4,6)
  Str:Put("Line")

  EditIni:OneLine(Win,LineChars,5)
  Move:To(0,5)
  Win:Attr(Win->ClrLow)
  Str:Put("P")
  Win:Attr(Win->ClrNormal)
  Str:Put("rompt 1")
  Move:To(0,14)
  Win:Attr(Win->ClrBold)
  Str:Put("Selected Field  ")

  EditIni:OneLine(Win,LineChars,6)
  Move:To(0,5)
  Win:Attr(Win->ClrLow)
  Str:Put("P")
  Win:Attr(Win->ClrNormal)
  Str:Put("rompt 2")
  Move:To(0,14)
  Win:Attr(Win->ClrHigh)
  Str:Put("Unselected Field")

  Win:Attr(Win->ClrBorder)
  Move:To(7,4)
  Str:Put(Str:At(LineChars,6,1))
  Str:Put(Str:AtSet(Null,1,Str:At(LineChars,7,1),25))
  Str:Put(Str:At(LineChars,8,1))
  If (Win->ClrShadow!='Black/Black')
    Win:Attr(Win->ClrShadow)
  Else
    Win:Attr(0)
  Str:Put("  ")
  Move:To(8,6)
  Str:Put(Str:AtSet(Null,1," ",27))

  Move:To(7,6)
  Win:Attr(Win->ClrMessage)
  Str:Put("Message")

  Win:Attr(0)
  Return (Ok)

EditIni:FileName
  New (FileName)
  FileName   = Str:At (Mem:Ptr->Args, 1, Str:In (Mem:Ptr->Args, '.'))
  FileName   = FileName + 'INI'
  Return (FileName)

EditIni:GetColor(Win,*WorkColor,ArrChoice)
  Switch (ArrChoice)
    Case 1
      WorkColor = Win->ClrNormal
    Case 2
      WorkColor = Win->ClrLow
    Case 3
      WorkColor = Win->ClrMedium
    Case 4
      WorkColor = Win->ClrHigh
    Case 5
      WorkColor = Win->ClrBold
    Case 6
      WorkColor = Win->ClrMessage
    Case 7
      WorkColor = Win->ClrBorder
    Case 8
      WorkColor = Win->ClrTitle
    Case 9
      WorkColor = Win->ClrShadow
  Return (Ok)

Editini:GetFile(*IniStruct,*FileName)
  New (Res,NewFile)
  NewFile = DirList:GetFIle("*.INI")
  If (NewFile And NewFile!=FileName)
    Res = Msg:Add("Save Changes","Yes")
      Do you want to save changes &
      to last file {FileName}?
    If (res)
      EditIni:Write(FileName,IniStruct)
    FileName  = NewFile
    Win:Add
      Reading INI file
    IniStruct = EditIni:Read(FileName)
    Win:Dsp
  Return (Ok)

EditIni:NewColor(Win,*WorkColor,ArrChoice,*LastChoice)
  EditIni:SetColor(Win,WorkColor,LastChoice)
  EditIni:GetColor(Win,WorkColor,ArrChoice)
  LastChoice = ArrChoice
  Return (Ok)

EditIni:NewPrint(Line)
  New (Pos,IniPrint:Print)
  Pos = Str:In(Line,",")
  If (Pos)
    Print->Prompt = Str:At(Line,1,Pos-1)
    Print->Device = Str:Aft(Str:At(Line,Pos+1)," ")
  Return (Print)

EditIni:NewScheme(Win,Color)
  Switch (Color)
    Case 'Blue'
      Win->LineStyle    ='Double'
      Win->ClrBorder    ='Bright White/Blue'
      Win->ClrTitle     ='Bright White/Cyan'
      Win->ClrShadow    ='White/Black'
      Win->ClrNormal    ='Light Blue/Blue'
      Win->ClrLow       ='Bright White/Blue'
      Win->ClrMedium    ='Light Blue/Blue'
      Win->ClrHigh      ='Bright White/White'
      Win->ClrBold      ='Light Blue/White'
      Win->ClrMessage   ='Yellow/Blue'
    Case 'White'
      Win->LineStyle    ='Thick'
      Win->ClrBorder    ='Bright White/White'
      Win->ClrTitle     ='Bright White/White'
      Win->ClrShadow    ='Black/Gray'
      Win->ClrMessage   ='Gray/White'
      Win->ClrNormal    ='Bright White/White'
      Win->ClrLow       ='Gray/White'
      Win->ClrMedium    ='Bright White/White'
      Win->ClrHigh      ='White/Gray'
      Win->ClrBold      ='Bright White/Gray'
    Case 'Default'
      Win->LineStyle    ='Single'
      Win->ClrBorder    ='Bright White/White'
      Win->ClrTitle     ='Light Blue/White'
      Win->ClrShadow    ='Light Magenta/Blue'
      Win->ClrNormal    ='Bright White/White'
      Win->ClrLow       ='Yellow/White'
      Win->ClrMedium    ='Light Blue/White'
      Win->ClrHigh      ='Yellow/Blue'
      Win->ClrBold      ='Bright White/Blue'
      Win->ClrMessage   ='Yellow/White'
    Case 'Gray'
      Win->LineStyle    ='Double'
      Win->ClrBorder    ='Light Blue/Gray'
      Win->ClrTitle     ='Bright White/Gray'
      Win->ClrShadow    ='Blue/Black'
      Win->ClrMessage   ='Light Cyan/Gray'
      Win->ClrNormal    ='Bright White/Gray'
      Win->ClrLow       ='Light Cyan/Gray'
      Win->ClrMedium    ='Light Blue/Gray'
      Win->ClrHigh      ='Light Cyan/White'
      Win->ClrBold      ='Bright White/White'
    Case 'Green'
      Win->LineStyle    ='Double'
      Win->ClrBorder    ='Bright White/Cyan'
      Win->ClrTitle     ='Bright Cyan/White'
      Win->ClrShadow    ='Cyan/Black'
      Win->ClrMessage   ='Yellow/Cyan'
      Win->ClrNormal    ='Bright White/Cyan'
      Win->ClrLow       ='Yellow/Cyan'
      Win->ClrMedium    ='Light Cyan/Cyan'
      Win->ClrHigh      ='Yellow/Blue'
      Win->ClrBold      ='Bright White/Blue'
    Case 'Mono'
      Win->LineStyle    ='Double'
      Win->ClrBorder    ='Bright White/Black'
      Win->ClrTitle     ='Bright White/Black'
      Win->ClrShadow    ='Black/White'
      Win->ClrMessage   ='Bright White/Black'
      Win->ClrNormal    ='White/Black'
      Win->ClrLow       ='Blue/Black'
      Win->ClrMedium    ='Bright Cyan/Black'
      Win->ClrHigh      ='Black/White'
      Win->ClrBold      ='Blue/White'
    Case 'RevMono'
      Win->LineStyle    ='Double'
      Win->ClrBorder    ='Black/White'
      Win->ClrTitle     ='Black/Bright White'
      Win->ClrShadow    ='White/Black'
      Win->ClrMessage   ='Black/Bright White'
      Win->ClrNormal    ='Black/White'
      Win->ClrLow       ='Blue/White'
      Win->ClrMedium    ='Black/White'
      Win->ClrHigh      ='Bright White/Black'
      Win->ClrBold      ='Blue/Black'
  Return (Null)

EditIni:NewWin(Line)
  New (IniWin:Win)
  Win->Name   = Line
  Return (Win)

EditIni:OneLine(Win,LineChars,Row)
  Move:To(Row,4)
  Win:Attr(Win->ClrBorder)
  Str:Put(Str:At(LineChars,4,1))
  Win:Attr(Win->ClrNormal)
  Str:Put(Str:AtSet(Null,1,' ',25))
  Win:Attr(Win->ClrBorder)
  Str:Put(Str:At(LineChars,5,1))
  If (Win->ClrShadow!='Black/Black')
    Win:Attr(Win->ClrShadow)
  Else
    Win:Attr(0)
  Str:Put("  ")
  Return (Ok)

EditIni:PrintDo(IniStruct,PrintChoice)
  New (IniPrint:Print)
  Print = IniStruct->PrintList[PrintChoice]
  Win:Add("Printer prompt and device",0,0,8,40,Here)
    Input:"Prompt" Field:"Print->Prompt" Wid:26 Row:2 Col:2
    Group:"&Device" Row:4 Col:2 Len:4 Wid:36
    Radio:"&Screen" Row:5 Col:4
      Check:"Print->Device=='Screen'"
      Action:"Print->Device='Screen'"
      UnAction:"Print->Device=Null"
    Radio:"&File"
      Check:"Print->Device=='File'"
      Action:"Print->Device='File'"
      UnAction:"Print->Device=Null"

    Radio:"LPT&1" Row:5 Col:15
      Check:"Print->Device=='LPT1'"
      Action:"Print->Device='LPT1'"
      UnAction:"Print->Device=Null"
    Radio:"LPT&2"
      Check:"Print->Device=='LPT2'"
      Action:"Print->Device='LPT2'"
      UnAction:"Print->Device=Null"
    Radio:"LPT&3"
      Check:"Print->Device=='LPT3'"
      Action:"Print->Device='LPT3'"
      UnAction:"Print->Device=Null"
    Radio:"LPT&4"
      Check:"Print->Device=='LPT4'"
      Action:"Print->Device='LPT4'"
      UnAction:"Print->Device=Null"

    Radio:"&COM1" Row:5 Col:28
      Check:"Print->Device=='COM1'"
      Action:"Print->Device='COM1'"
      UnAction:"Print->Device=Null"
    Radio:"COM2"
      Check:"Print->Device=='COM2'"
      Action:"Print->Device='COM2'"
      UnAction:"Print->Device=Null"
    Radio:"COM3"
      Check:"Print->Device=='COM3'"
      Action:"Print->Device='COM3'"
      UnAction:"Print->Device=Null"
    Radio:"COM4"
      Check:"Print->Device=='COM4'"
      Action:"Print->Device='COM4'"
      UnAction:"Print->Device=Null"

    Button:"&Ok" Row:10 Col:10 Wid:20 Action:"Null"
  Win:Dsp
  Return (Ok)

EditIni:PrintShow(Print)
  Return (Str:Pad(Print->Prompt,16)+" "+Print->Device)

EditIni:Read(FileName)
  New (Line,Pos,Value,Ini:IniStruct,IniPrint:Print,PrintCount,IniWin:Win,WinCount)

  While (File:Ok(FileName))
    Line  = File:Read(FileName)
    Pos = Str:In(Line,"=")
    If (Pos)
      Value = Str:Aft(Str:At(Line,Pos+1)," ")
    Else
      Value = Null

    Switch (Str:At(Line,1,4))
      Case Null
        | Nothing
      Case "Bios"
        IniStruct->Bios = Value
      Case "Mono"
        IniStruct->Monochrome = Value
      Case "Mult"
        IniStruct->Multiuser = Value
      Case "Mem "
        IniStruct->MemStats  = Value
      Case "Deci"
        IniStruct->Decimal   = Value
      Case "Grap"
        IniStruct->Graphics  = Value
      Case "IsXt"
        IniStruct->IsXt      = Value
      Case "Ram "
        IniStruct->Ramdisk   = Value
      Case "Expl"
        IniStruct->Explode   = Value
      Case "Prin"
        ++PrintCount
        Print = EditIni:NewPrint(Value)
        IniStruct->PrintList[PrintCount] = Print
      Case "Wind"
        ++WinCount
        Win = EditIni:NewWin(Value)
        IniStruct->WinList[WinCount] = Win

      Case "+Mon"
        Win->MonoColor = Value
      Case "+Lin"
        Win->LineStyle = Value
      Case "+Bor"
        Win->ClrBorder = Value
      Case "+Tit"
        Win->ClrTitle  = Value
      Case "+Sha"
        Win->ClrShadow = Value
      Case "+Mes"
        Win->ClrMessage= Value
      Case "+Nor"
        Win->ClrNormal = Value
      Case "+Low"
        Win->ClrLow    = Value
      Case "+Med"
        Win->ClrMedium = Value
      Case "+Hig"
        Win->ClrHigh   = Value
      Case "+Bol"
        Win->ClrBold   = Value
  Return (IniStruct)

EditIni:Scheme(Win,*WorkColor,ArrChoice)
  Win:Add ("Color Schemes",14,46)
    MLine:"&Barbara Blue    "  Action:"EditIni:NewScheme(Win,'Blue')"
    MLine:"&NYC White       "  Action:"EditIni:NewScheme(Win,'White')"
    MLine:"&JORF Default    "  Action:"EditIni:NewScheme(Win,'Default')"
    MLine:"Traffic Cop &Gray"  Action:"EditIni:NewScheme(Win,'Gray')"
    MLine:"Jealous G&reen   "  Action:"EditIni:NewScheme(Win,'Green')"
    MLine:"&Monochrome      "  Action:"EditIni:NewScheme(Win,'Mono')"
    MLine:"&Rev Monochrome  "  Action:"EditIni:NewScheme(Win,'RevMono')"
  EditIni:GetColor(Win,WorkColor,LastChoice)
  Win:Dsp
  Return (Ok)

EditIni:SetBkdColor(Win,*WorkColor,Color,ArrChoice)
  WorkColor = Str:AtCut(WorkColor,Str:In(WorkColor,"/")+1) + Color
  EditIni:SetColor(Win,WorkColor,ArrChoice)
  Win:Dsp
  Return (Ok)

EditIni:SetColor(Win,*WorkColor,LastChoice)
  Switch (LastChoice)
    Case 1
      Win->ClrNormal = WorkColor
    Case 2
      Win->ClrLow = WorkColor
    Case 3
      Win->ClrMedium = WorkColor
    Case 4
      Win->ClrHigh = WorkColor
    Case 5
      Win->ClrBold = WorkColor
    Case 6
      Win->ClrMessage = WorkColor
    Case 7
      Win->ClrBorder = WorkColor
    Case 8
      Win->ClrTitle = WorkColor
    Case 9
      Win->ClrShadow = WorkColor
  Return (Ok)

EditIni:SetForColor(Win,*WorkColor,Color,ArrChoice)
  WorkColor = Color + Str:At(WorkColor,Str:In(WorkColor,"/"))
  EditIni:SetColor(Win,WorkColor,ArrChoice)
  Win:Dsp
  Return (Ok)

Editini:Shift_F5_Key
  Jorf:Status
  Jorf:StatusClear
  Return (Ok)

EditIni:WinDo(IniStruct,WinChoice)
  New (IniWin:Win)
  Win = Jorf:Dup(IniStruct->WinList[WinChoice])
  Win:Add("JORF Window Options and Colors",0,0,8,40,Here)
    Input:"Name" Field:"Win->Name" Wid:12 Row:2 Col:4
    Group:"Scheme is for" Row:4 Col:2 Len:2 Wid:20
    Radio:"&Monochrome" Row:5 Col:4
      Check:"Win->MonoColor=='Mono'"
      Action:"Win->MonoColor='Mono'"
      UnAction:"Win->MonoColor='Color'"
    Radio:"Co&lor"
      Check:"Win->MonoColor=='Color'"
      Action:"Win->MonoColor='Color'"
      UnAction:"Win->MonoColor='Mono'"
    Group:"DOS Line Style" Row:8 Col:2 Len:4 Wid:20
    Radio:"S&ingle"
      Check:"Win->LineStyle=='Single'"
      Action:"Win->LineStyle='Single'"
      UnAction:"Win->LineStyle=Null"
    Radio:"&Double"
      Check:"Win->LineStyle=='Double'"
      Action:"Win->LineStyle='Double'"
      UnAction:"Win->LineStyle=Null"
    Radio:"&Thick"
      Check:"Win->LineStyle=='Thick'"
      Action:"Win->LineStyle='Thick'"
      UnAction:"Win->LineStyle=Null"
    Radio:"&Blank"
      Check:"Win->LineStyle=='Blank'"
      Action:"Win->LineStyle='Blank'"
      UnAction:"Win->LineStyle=Null"

    Group:"Text Colors" Row:1 Col:26 Len:6 Wid:33
    Input:"Normal " Field:"Win->ClrNormal"  Wid:24 Before:"Null"
    Input:"Low    " Field:"Win->ClrLow"     Wid:24 Before:"Null"
    Input:"Medium " Field:"Win->ClrMedium"  Wid:24 Before:"Null"
    Input:"High   " Field:"Win->ClrHigh"    Wid:24 Before:"Null"
    Input:"Bold   " Field:"Win->ClrBold"    Wid:24 Before:"Null"
    Input:"Message" Field:"Win->ClrMessage" Wid:24 Before:"Null"

    Group:"DOS Box Colors"     Row:9 Col:26 Len:3 Wid:33
    Input:"Border " Field:"Win->ClrBorder" Wid:24 Before:"Null"
    Input:"Title  " Field:"Win->ClrTitle"  Wid:24 Before:"Null"
    Input:"Shadow " Field:"Win->ClrShadow" Wid:24 Before:"Null"

    Button:"&Ok"          Row:14 Col:2  Wid:10 Action:"Return Null"
    Button:"&Cancel"      Row:14 Col:14 Wid:10 Action:"Kbd:Put('Esc_Key')"
    Button:"&Set Colors"  Row:14 Col:29 Wid:30 Action:"EditIni:ColorSet(Win)"

  If (Kbd:Got!='Esc_Key')
    IniStruct->WinList[WinChoice] = Win
    Win:Dsp
  Return (Ok)

EditINi:WinShow(Win)
  Return (Str:Pad(Win->Name,16)+" "+Win->MonoColor)

EditIni:Write(FileName,IniStruct)
  New (I,IniPrint:Print,IniWin:Win)
  File:Del (FileName)
  File:Write (FileName,"Bios       = "+IniStruct->Bios)
  File:Write (FileName,"Monochrome = "+IniStruct->Monochrome)
  File:Write (FileName,"Multiuser  = "+IniStruct->Multiuser)
  File:Write (FileName,"Mem Status = "+IniStruct->Memstats)
  File:Write (FileName,"Decimal    = "+IniStruct->Decimal)
  File:Write (FileName,"Graphics   = "+IniStruct->Graphics)
  File:Write (FileName,"IsXt       = "+IniStruct->IsXT)
  File:Write (FileName,"Ram Disk   = "+IniStruct->Ramdisk)
  File:Write (FileName,"Explode    = "+IniStruct->Explode)

  File:Write(FileName)
  For (I = 1 Thru Arr:Len(IniStruct->PrintList))
    Print = IniStruct->PrintList[i]
    File:Write(FileName,"Printer = "+Print->Prompt+", "+print->device)

  File:Write(FileName)
  For (I = 1 Thru Arr:Len(IniStruct->WinList))
    Win = IniStruct->WinList[i]
    File:Write(FileName,Null)
    File:Write(FileName,"Window = "+Win->Name)
    File:Write(FileName,"+Mono/Color="+Win->MonoColor)
    File:Write(FileName,"+Line Style="+Win->LineStyle)
    File:Write(FileName,"+Border Color="+Win->ClrBorder)
    File:Write(FileName,"+Title Color="+Win->ClrTitle)
    File:Write(FileName,"+Shadow Color="+Win->ClrShadow)
    File:Write(FileName,"+Message Color="+Win->ClrMessage)
    File:Write(FileName,"+Normal Color="+Win->ClrNormal)
    File:Write(FileName,"+Low Color="+Win->ClrLow)
    File:Write(FileName,"+Med Color="+Win->ClrMedium)
    File:Write(FileName,"+High Color="+Win->ClrHigh)
    File:Write(FileName,"+Bold Color="+Win->ClrBold)

  Return (Ok)

