Class:Contact
  Index:FullName
  Index:Company
  Index:WorkPhone
  Index:LastName
  Index:ZipCode
  Addr1
  Addr2
  Addr3
  HomePhone
  FaxPhone
  StartDate
  LastUpDate
  MailCode
  CustCode
  Location
  Dear
  PhoneNote
  Comment
  Type          | Customer, Vendor
  Notes         | Memo Notes
  Sales         | Sales to date

Contact:Start()
  | JORF Contact Management Data Base
  New (Contact:Contact)

  | Other source files
  Jorf:File("TextEdit.J",Here)            | Text Editor
  Jorf:File("Filter.J",Here)              | Filters
  Jorf:File("ConHelp.J",Here)             | Help
  Jorf:File("ConFlds.J",Here)            | Fields

  | Initialization . . .
  Mem:Ptr->ContactFile   = "CONTACT.JCM"  | Default Contact File
  Mem:Ptr->ContactFName  = "CONTACT"      | Name to display
  Mem:Ptr->ContactFilter = Null           | All Records
  Mem:Ptr->FilterDescr   = "All Records"  | All Records
  Mem:Ptr->TopLevel      = Here           | Top Level
  Mem:Ptr->PageNo        = 0              | Starting Page No

  | System Parameters.
  Event:Add ("Contact","Key",Here)              | Set Contact handler
  Contact:KeySearch(Contact,"FullName",False)   | Go to top of file

  | Contact Manager Main Window
  |  The purpose of this window is to provide basic information on
  |  the contact, as well as show a browser of nearby contacts.  When
  |  you add, change or view, you can see additional information for
  |  this contact.  The Additional screens are unlimited.
  |
  |  The Main Window also acts as the Main Menu.  All functions are
  |  menu options from this screen.  When the operator hits escape
  |  (or Alt-X) we are done with the program.
  Win:Add ("Josephine's Contact Manager", 2, 2, 22, 78, Here)
    Before:"Contact:Page(1)"
    Menu:"&File"
      Menu:"&Open           F4", Action:"Contact:OpenFile()", Hotkey:"F4_Key"
      Menu:"&Filter         F7", Action:"Contact:Filter()",   Hotkey:"F7_Key"
      Menu:"F&ield Editor     ", Action:"Contact:SetFields()"
      Menu:"&Text Editor    F9", Action:"Textedit:Start()" HotKey:"F9_Key"
      Menu:"&Rebuild        ",   Action:"Contact:Rebuild()"
      Menu:
      Menu:"&Dos Shell      F5", Action:"Jorf:System(Null,'C')", Hotkey:"F5_Key"
      Menu:"Ca&lculator     F8", Action:"Calc:Start()",  Hotkey:"F8_Key"
      Menu:
      Menu:"&Set Mailcode   ",   Action:"Contact:SetMailCode(Contact)"
      Menu:"&Clear Mailcode ",   Action:"Contact:ClearMailCode(Contact)"
      Menu:
      Menu:"&About            "  Action:"Contact:About"
      Menu:"Cou&nt Records    ", Action:"Contact:Count"
      Menu:"&Help           F1", Action:"Contact:Help" Hotkey:"F1_Key"
      Menu:
      Menu:"E&xit        Alt-X", Action:"Kbd:Put('Esc_Key')"
    Menu:"&Edit"
      Menu:"&Add     Alt-A",  Action:"Contact:Add(Contact)"    HotKey:"Alt_A_Key"
      Menu:"&Change  Alt-C",  Action:"Contact:Change(Contact)" HotKey:"Alt_C_Key"
      Menu:"&Delete  Alt-D",  Action:"Contact:Delete(Contact)" HotKey:"Alt_D_Key"
      Menu:"&Hundreds     ",  Action:"Contact:Hundreds(Contact)"
    Menu:"&Search",
      Menu:"&Name       ",  Action:"Contact:KeySearch (Contact, 'FullName' ,True)
      Menu:"&Company    ",  Action:"Contact:KeySearch (Contact, 'Company'  ,True)
      Menu:"&Last Name  ",  Action:"Contact:KeySearch (Contact, 'LastName' ,True)
      Menu:"&Phone      ",  Action:"Contact:KeySearch (Contact, 'WorkPhone',True)
      Menu:"&Zip        ",  Action:"Contact:KeySearch (Contact, 'ZipCode'  ,True)
    Menu:"&Reports"
      Menu:"&Contact Data",       Action:"Contact:PrintData"
      Menu:"&List of Contacts",   Action:"Contact:List"
      Menu:"&Merge Letter",       Action:"Contact:MergeLetter"
      Menu:"L&abels",
        Menu:"&Avery 5162 - Laser Labels", Action:"Contact:Avery5162(Contact,'All')"
        Menu:"&Continuous - 1x3 Inch   ", Action:"Contact:ContinLabels(Contact,'All')"
      Menu:"&One Label",
        Menu:"&Avery 5162 - Laser Labels", Action:"Contact:Avery5162(Contact,'One')"
        Menu:"&Continuous - 1x3 Inch   ", Action:"Contact:ContinLabels(Contact,'One')"
    InpBefore:"Contact:Lock(Contact)"
    Input:"File:"   Row:22 Col:1  Wid:8  Field:"Mem:Ptr->ContactFName" Before:"False"
    Input:"Index:"  Row:22 Col:18 Wid:10 Field:"Mem:Ptr->IndexName"    Before:"False"
    Input:"Filter:" Row:22 Col:40 Wid:30 Field:"Mem:Ptr->FilterDescr"  Before:"False"
    Group:"&Browse List", Row:1 Col:41, Len:6, Wid:36
    List:""
      Field:"Contact"
      Next:"Contact:NextRecord(Contact,'Next')"
      Prev:"Contact:NextRecord(Contact,'Prev')"
      Show:"Contact:Show(Contact)"
      Before:"Contact:Write()"
      Display:"(Mem:Ptr->Locked==Null)"
      Action:"Contact:Change(Contact)"
    Group:"C&ontact", Row:1, Col:1, Wid:38, Len:6
    Input:"Contact", Wid:30, Field:"Contact->FullName"
      After:"Contact:SplitName(Contact)"
    Input:"Company", Wid:30, Field:"Contact->Company"
    Input:"Address", Wid:30, Field:"Contact->Addr1"
    Input:"       ", Wid:30, Field:"Contact->Addr2"
    Input:"       ", Wid:30, Field:"Contact->Addr3"
      After:"Contact:ZipCode(Contact)"
    Radio:"USA"  Row:7 Col:2
      Action:"Contact->Location='USA'"
      UnAction:"Contact->Location=Null"
      Check:"Contact->Location=='USA'"
    Radio:"Canada/Mexico" Row:7 Col:11
      Action:"Contact->Location='CanMex'"
      UnAction:"Contact->Location=Null"
      Check:"Contact->Location=='CanMex'"
    Radio:"Foreign" Row:7 Col:30
      Action:"Contact->Location='Foreign'"
      UnAction:"Contact->Location=Null"
      Check:"Contact->Location=='Foreign'"
    Marker:"Box"
    Marker:"Fields"
      | Fields will go here
    Marker:"EndFields"
  If (Kbd:Got='Esc_Key')
    Return (Null)
  Return (Contact)

Contact:About
  Msg:Add ("The JORF Contact Manager", "Ok")
    The JORF Contact Manager
    Version 1.3,  March 20, 1993

    Copyright (C) 1993 by Wayland Bruns
    All Rights Reserved

    The JORF Contact Manager is written as
    a demonstration of what you can do with
    the JORF Language.  The contact manager
    is a "flat file" data base with multiple
    keys, multiple files, filters, mail-
    merge capability, reports and labels.

    The source code for this entire system
    is less than 1000 lines, and you can
    easily change it to suit your own
    contact management needs.
  Return (Ok)

Contact:Add(*Contact)
  New (Contact:NewContact)
  Contact:SetFile()
  NewContact->FullName="New Record"
  Jorf:Write(NewContact)
  Contact=NewContact
  Win:Dsp
  Kbd:Put("Alt_O_Key")
  Return(Ok)

Contact:Alt_F5_Key
  Win:Msg('Flushing')
  Jorf:Flush
  Win:Msg()
  Return (Ok)

Contact:Alt_Page_Down_Key
  If (ConFlds:IsPage(Mem:Ptr->PageNo+1))
    Contact:Page(Mem:Ptr->PageNo+1)
  Else
    Contact:Page(1)
  Return (Ok)

Contact:Alt_Page_Up_Key
  New (PageNo)
  If (Mem:Ptr->PageNo>1)
    Contact:Page(1)
  Else
    Contact:Page(ConFlds:LastPage())
  Return (Ok)

Contact:Alt_X_Key
  Return (Contact:Exit)

Contact:Avery5162(Contact,Flag)
  New (Dest,Count,StartPos,OrigContact)
  Dest=Jorf:Printer()
  If (Dest)

    Event:Add
    StartPos=1
    Mem:Ptr->InsMode='OverStrike'
    Win:Add ("Starting Position")
      Type:"Message"
      String:"This format prints on the right row of the"
      String:"Avery 5162 label.  To conserve paper, you"
      String:"may enter the label to start with.  The top"
      String:"label is #1, and the bottom is #7."
      String:""
      Input:"Label to start        ", Wid:5, Field:"StartPos"
      String:""
      String:"When each sheet is printed, turn it around"
      String:"to print on the other side."
    Win:Del
    Mem:Ptr->InsMode='Insert"
    If (Kbd:Got = 'Esc_Key')
      Return (Ok)

    Contact:SetFile()
    OrigContact = Contact
    | Report format for Continuous labels, 6 lines per label
    |
    Rep:Add ("Avery Labels", 9, 5, 49, 45, Here)
      Next:"Contact:NextLabel(Contact,Flag,Count)"
        Before:"Contact:Avery5162check(Contact,OrigContact,StartPos,Count)"
      Item:"" NewRow:2
      Item:"" NewRow:1 Col:26 Wid:12
      Item:"Contact->FullName"    NewRow:1 Col:1  Wid:40
      Item:"Contact->Company"     NewRow:1 Col:1  Wid:40
        Before:"Contact->Company!=Null"
      Item:"Contact->Addr1"       NewRow:1 Col:1  Wid:40
      Item:"Contact->Addr2"       NewRow:1 Col:1  Wid:40
      Item:"Contact->Addr3"       NewRow:1 Col:1  Wid:40
      Item:"" NewRow:1
        Before:"Contact->Company==Null"
    File:Print("JREPORT.LST",Dest)
  Return(Null)

Contact:Avery5162check(*Contact,OrigContact,*StartPos,*Count)
  If (StartPos > 1)
    --StartPos
    Count = 0
    Contact    = Null
    Return (False)
  If (Count < 1)
    Contact    = OrigContact
  Return (True)

Contact:Change(Contact)
  | Just get them started on the Contact information
  Kbd:Put("Alt_O_Key")
  Return(Ok)

Contact:ClearMailCode
  New (Res,Contact)

  Contact:SetFile()
  Res=Msg:Add ('Clear Mail Code','Cancel')
    This process will clear the Mail Code field
    that is used to filter for labels and merge
    letters.
  If (Res)
    Win:Add
      Type:"Message"
      Clearing contact records
    While (Ok)
      Contact=Contact:NextRecord(Contact,'Next'))
      If (Contact==Null)
        Break
      If (Contact->MailCode)
        If (Jorf:Lock(Contact)==False)
          While (Jorf:Lock(Contact)==False)
            Win:Msg("Waiting for locked record to clear")
          Win:Del
        Contact->MailCode=Null
        Jorf:Write(Contact)
    Win:Dsp
  Return(Ok)

Contact:ContinLabels(Contact,Flag)
  New (Dest,Count,i)
  Dest=Jorf:Printer()
  If (Dest)

    Contact:SetFile()
    | Report format for Continuous labels, 6 lines per label, 1 line between
    |
    Rep:Add ("Continuous Labels")
      Next:"Contact:Nextlabel(Contact,Flag,Count)"
      Item:"" NewRow:1 Col:26 Wid:12
      Item:"Contact->FullName"    NewRow:1 Col:1  Wid:40
      Item:"Contact->Company"     NewRow:1 Col:1  Wid:40
        Before:"Contact->Company!=Null"
      Item:"Contact->Addr1"       NewRow:1 Col:1  Wid:40
      Item:"Contact->Addr2"       NewRow:1 Col:1  Wid:40
      Item:"Contact->Addr3"       NewRow:1 Col:1  Wid:40
      Item:"" NewRow:1
        Before:"Contact->Company==Null"

    | I like to append one blank label to advance the printer so I can
    |  tear off the label just printed.
    For (i=1 Thru 5)
      File:Append("JREPORT.LST")

    File:Print("JREPORT.LST",Dest,TRUE)
  Return(Ok)

Contact:Count
  New (NewContact,Counter)
  Contact:SetFile()
  Win:Add ("Counting Records",0,0,5,30)
    Type:"Message"
  Move:To(2,2)
  Str:Put("Record")
  Move:To(3,2)
  Str:Put("Name")
  While (Ok)
    NewContact = Struct:Next('Contact','FullName',NewContact)
    If (NewContact = Null)
      Break
    ++Counter
    Move:To(2,12)
    Str:Put(Counter)
    Move:To(3,12)
    Str:Put(Str:Pad(NewContact->FullName,18))
    If (Kbd:Hit)
      If (Kbd:Get=="Esc_Key")
        Break
  Win:Pause
  Return (Ok)

Contact:Dear (Contact)
  If (Contact->Dear==Null)
    Contact->Dear = (Word:At(Contact->FullName,1))
  Return(Ok)

Contact:Delete(*Contact)                | Delete Contact Record
  New (Result,NextContact)

  | Pop up a nice screen to ask if they are sure
  Result=Msg:Add('Contact Delete','No')
    Delete this record

    Name:     {Contact->FullName}
    Company:  {Contact->Company}

  | If they said "Yes", then Result will equal ok (1)
  If (Result==Ok)
    Contact:SetFile()
    NextContact = Struct:Next('Contact',Mem:Ptr->IndexName,Contact)
    Jorf:Del(Contact)
    Contact=NextContact
    Win:Dsp
  Return (Ok)

Contact:Dial(Number)
  New (Port)
  Port='COM2'
  Win:Add ("Dialing")
    Type:"Message"
    Dialing {Number}

  Str:Print("ATDT"+Number+To:Char(13),Port)	| Dial
  Win:Pause(500)

  Msg:Add("Dial")
    Please pick up your phone and
    press Enter to connect the call.

  Str:Print("ATH1"+Number+To:Char(13),Port)	| Switch to Voice mode
  Return(Ok)

Contact:Enter_Key
  | Change enter key - to tab key.
  | Test if we are in an input then InpLen is set to the
  |  number of input lines.
  If (Str:In(Win:Ptr->InpField,"Phone"))
    Contact:Dial(Win:Ptr->CurLine)
    Return (Ok)
  If (Win:Ptr->InpLen == 1)
    Return ("Tab_Key")
  Return (Null)

Contact:Left_Mouse_DClick
  If (Str:In(Win:Ptr->InpField,"Phone"))
    Contact:Dial(Win:Ptr->CurLine)
    Return (Ok)
  Return (Null)

Contact:Esc_Key
  | Even block the escape key - which would otherwise cause
  | the screen (and program) to go bye.
  Return (Contact:Exit)

Contact:Exit
  New (Res)
  Contact:Write()
  Res=Msg:Add(Null,"Cancel")
    This will end your session with
    Josephine's Contact Manager
  If (Res)
    Jorf:Exit
  Return (Ok)

Contact:Filter
  New (NewFilter)
  NewFilter=Filter:Start()
  If (Kbd:Got!='Esc_Key')
    Mem:Ptr->ContactFilter = Filter:Method()
    Mem:Ptr->FilterName    = Filter:Name()
    Mem:Ptr->FilterDescr   = Filter:Descr()
  Win:Dsp

  | Test current contact - if it doesn't count, null it out
  If (Mem:Ptr->ContactFilter != Null)
    If (Jorf:Do(Mem:Ptr->ContactFilter)==False)
      Contact=Null
  Return(Null)

Contact:GetLetter
  New (PrintList,PrintChoice,Letter)

  PrintList = Arr:Sort(Arr:Dir('*.LTR'))
  If (Arr:Len(PrintList) < 1)
    Msg:Add
      There are no .LTR files
      on the current directory.
  Else
    Win:Add("Select Letter")
      Type:"Message"
      Group:"&Merge Letters", Row:1 Col:1 Len:6 Wid:22
      Array:"" Field:"PrintList" Choice:"PrintChoice"

      Button:"  &Go  " Row:1 Col:32
        Action:"Letter=PrintList[PrintChoice]"
      Button:" &Cancel " Row:4 Col:32 Action:"Return ('Esc_Key')"
  Return(Letter)

Contact:Help
  If File:Exist("ConHelp.Jrf" 0)
    Jorf:File ("ConHelp.Jrf",Here)
    ConHelp:Start
  Else
    Msg:Add
      The CONHELP.JRF file is not &
      on the current directory
  Return Ok

Contact:Hundreds(Contact)
  New (Count,Counter,Contact:NewContact,NewName)
  Win:Add("Adding Hundreds")
    Type:"Message"
    String:"Some people want to know how JORF acts when it has"
    String:"a lot of records in a data base.  I created this"
    String:"option to to add hundreds of records so you can"
    String:"test program performance on a large data base."
    String:""
    String:"Adding Hundreds of records takes about 300K per"
    String:"hundred.  Please be sure you have enough disk"
    String:"space.  Press ESCAPE now to avoid adding hundreds."
    String:""
    Input:"Number of Records to add" Field:"Count" Wid:10
    String:""
    String:"Press ESCAPE now to avoid adding hundreds"
  If (Count < 1)
    Return (Ok)
  Win:Add("Adding Hundreds",0,0,6,30)
    Type:"Message"
  Move:To(2,2)
  Str:Put("Record")
  Move:To(3,2)
  Str:Put("Name")
  Move:To(5,2)
  Str:Put("Press ESC to exit")
  Contact=Null
  Contact:SetFile()
  While (Count > 0)
    ++Counter

    | Get a "Living" record for prototype
    Contact = Struct:Next('Contact',Mem:Ptr->IndexName,Contact)
    If (Contact==Null)
      Contact = Struct:Next('Contact',Mem:Ptr->IndexName,Null)

    NewContact=Jorf:Dup(Contact)

    | Make up a random name, set fields
    NewName=          To:Char(Num:Rand(65,90)) + To:Char(Num:Rand(97,122))
    NewName=NewName + To:Char(Num:Rand(97,122)) + To:Char(Num:Rand(97,122))
    NewName=NewName + ' '+To:Char(Num:Rand(65,90)) + '. '
    NewName=NewName + To:Char(Num:Rand(65,90)) + To:Char(Num:Rand(97,122))
    NewName=NewName + To:Char(Num:Rand(97,122)) + To:Char(Num:Rand(97,122))
    NewName=NewName + To:Char(Num:Rand(97,122))

    NewContact->FullName = NewName
    NewContact->LastName = Word:At(NewName,Word:Len(NewName))
    NewContact->Dear     = Word:At(NewName,1)
    Jorf:Write(NewContact)
    Move:To(2,12)
    Str:Put(Counter)
    Move:To(3,12)
    Str:Put(Str:Pad(NewContact->FullName,18))
    If (Kbd:Hit)
      If (Kbd:Get=="Esc_Key")
        Break
    --Count
  Contact = Struct:Next('Contact',Mem:Ptr->IndexName,Null)
  Win:Dsp
  Return Ok

Contact:KeySearch (*Contact, Field, GetInp)
  New (Value,Prompt,Display)

  Contact:SetFile()         | Set Current File
  Event:Add                     | Block "Contact" Events so Alt-A won't work
  Switch (Field)
    Case ("FullName")
      Prompt="Name"
    Case ("Company")
      Prompt="Company"
    Case ("WorkPhone")
      Prompt="Phone"
    Case ("LastName")
      Prompt="Last Name"
    Case ("ZipCode")
      Prompt="Zip Code"
    Else
      Msg:Add
        Unknown Field {Field}
      Return (Ok)

  If (GetInp)
    Win:Add ("Key Search", 10, 25, 0, 0, Here)
      Type:"Message"
      Input:"Search for {Prompt}", Wid:30, Field:"Value"
  If (Kbd:Got <> "Esc_Key")
    Mem:Ptr->IndexName=Field
    Contact=Struct:Find('Contact',Mem:Ptr->IndexName,Value)
    If (Contact=Null And Value)
      Msg:Add
        Cannot find {Prompt} {Value}
      Contact=Struct:Find('Contact',Mem:Ptr->IndexName,Null)
    Win:Dsp
  Return (Contact)

Contact:LastName (Contact)
  If (Contact->LastName==Null)
    Contact->LastName= (Word:At(Contact->FullName,Word:Len(Contact->FullName)))
  Return(Ok)

Contact:List()
  New (Dest,Date,Page,Contact,Count)
  Dest=Jorf:Printer()
  If (Dest)
    Contact:SetFile()
    Date = Date:Str(Date:Get,"s d, yyyy")
    Rep:Add ("Contact Listing", 5, 5, 60, 75, Here)
      Header:"'Contact Listing Report'"    NewRow:1 Col:30
      Header:"'Page '+Page"        NewRow:1 Col:1
        Before:"Contact:NextPage(Page)"
      Header:"'Date '+Date"                Col:54
      Header:"Str:AtSet(Null,1,'-',70)"     NewRow:1 Col:1
      Next:"Contact:NextLabel(Contact,'All',Count)"
      Item:"Contact->FullName"      NewRow:2 Col:1  Len:28
      Item:"Contact->Company "               Col:30 Len:32
      Item:"Contact->WorkPhone"              Col:62 Len:28
      Item:"Contact->Addr1+', '+Contact->Addr2+' '+Contact->Addr3"
        NewRow:1 Col:5  Len:70
    File:Print("Jreport.lst",Dest)
  Return (Ok)

Contact:Lock(Contact)
  If (Mem:Ptr->Locked==Contact)
    Win:Msg("You have locked this Record")
    Return (Ok)
  Contact:Write()
  If (Jorf:Lock(Contact))
    Mem:Ptr->Locked=Contact
    Win:Msg("You have locked this Record")
    Return (Ok)
  If (Contact <> Mem:Ptr->Unlocked)         | If first time
    Msg:Add("Record is Locked")             |  show message
      Either someone else has this
      record locked now, or it has
      been locked before but never
      unlocked.

      If no one else is in the data
      base, you can unlock this
      record by rebuilding the file.
    Mem:Ptr->Unlocked = Contact             | Make a record that message is shown
  Return(Null)

Contact:MergeLetter
  New (Dest,Letter,CurrContact,Count)
  Time:Get(Mem:Ptr)

  Letter=File:Load(Contact:GetLetter)
  If (Letter!=Null)
    Dest=Jorf:Printer()
    If (Dest)
      CurrContact=Contact
      Contact=Null
      Rep:Add ("Merge Letter", 5, 5, 60, 75,Here)
        Next:"Contact:NextLabel(Contact,'All',Count)"
        Text:"Letter" Row:1
      File:Print("JREPORT.LST",Dest)
      Contact=CurrContact
  Return (Ok)

Contact:NextLabel(*Contact,Flag,*Count)
  Count = Count + 1
  If (Flag=='All')
    If (Count == 1)
      Contact = Null
    Contact = Contact:NextRecord(Contact,'Next')
  Else
    If (Count > 1)
      Contact=Null
  Return (Contact)

Contact:NextPage(*Page)
  ++Page
  Return (Ok)

Contact:NextRecord(*Contact,Flag)
  | Gets the next (or previous) record depending on Flag
  | Flag is "Next" or "Prev" Easy!
  |
  Contact:Write()
  Contact:SetFile()
  While (Ok)
    If (Flag=='Prev')
      Contact=Struct:Prev('Contact',Mem:Ptr->IndexName,Contact)
    Else
      Contact=Struct:Next('Contact',Mem:Ptr->IndexName,Contact)
    If (Contact==Null)
      Break
    If (Mem:Ptr->ContactFilter = Null)
      Break
    If (Jorf:Do(Mem:Ptr->ContactFilter))
      Break
  Return(Contact)

Contact:OpenFile()
  New (NewFile,Pos)
  NewFile=Dirlist:GetFile("*.JCM")
  If (NewFile)
    If (Str:In(Newfile,".")==0)
      NewFile = NewFile + ".JCM"
    Mem:Ptr->ContactFile=NewFile
    Pos = Str:In(NewFile,"\")
    While (Pos)
      NewFile = Str:At(Newfile,Pos+1)
      Pos =Str:In(NewFile,"\")
    Pos = Str:In(NewFile,".")
    If (Pos)
      NewFile = Str:At(Newfile,1,Pos-1)
    Mem:Ptr->ContactFName=To:Ucs(NewFile)
    Contact=Contact:NextRecord(Null,'Next')
    Win:Dsp
  Return (Ok)

Contact:Page(PageNo)
  New (WinText)

  If (PageNo == Mem:Ptr->PageNo)
    Return (Ok)

  WinText=ConFlds:GetPage(PageNo)
  If (WinText==Null)
    PageNo = 1
    WinText=ConFlds:GetPage(PageNo)
  If (WinText)
    Win:Chg("Box",9,1,11,76,WinText)
    Mem:Ptr->PageNo=PageNo
  Return (Ok)

Contact:PrintData
  New (Dest,Contact)
  Time:Get(Mem:Ptr)
  Mem:Ptr->Page=1

  If (File:Exist("Contact.Rpt")==False)
    Msg:Add
      Print format "Contact.Rpt" is
      not in the current directory.
    Return (Ok)
  Dest=Jorf:Printer()
  Contact=Contact
  If (Dest)
    Rep:Add ("Contact Information", 5, 5, 60, 75,Here)
      Header:"'Contact Information Report'"     NewRow:1 Col:30
      Header:"'Date '+Mem:Ptr->SDate"         Col:50
      Header:"Str:AtSet(Null,1,'-',80)" NewRow:1 Col:1
      Text:"File:Load('Contact.Rpt')"
      Next:"Null"
    File:Print("Jreport.lst",Dest)
  Return (Ok)

Contact:Rebuild()
  | A rebuild writes the entire data file to an ascii file,
  | then erases the original, reads the ascii and reindexes.
  | The resulting process cleans any problem with the file and
  | indexes.
  |
  | Set file
  Contact:SetFile()

  | Then do the rebuild . . .
  Jorf:Rebuild
  Return (Ok)

Contact:SetFields()
  New (PageNo)
  ConFlds:Start()
  PageNo=Mem:Ptr->PageNo
  Mem:Ptr->PageNo=0
  Contact:Page(PageNo)
  Return (Null)

Contact:SetFile()
  | This method is used to set the current file.  The current file
  | name is in Mem:Ptr->ContactFile
  Jorf:File (Mem:Ptr->ContactFile, Mem:Ptr->TopLevel) | Set file to use
  Return

Contact:SetMailCode(Contact)
  New (Res)

  Event:Add
  If (Jorf:Lock(Contact)==False) | Lock Record
    Msg:Add
      Cannot set mail code,
      record is locked.
  Else
    Win:Add ('Set Mail Code')
      Type:"Message"
      Input:"Set code to", Wid:20 Field:"Mem:Ptr->MailCode"
    If (Kbd:Got!='Esc_Key')
      Contact->MailCode=Mem:Ptr->MailCode
    Jorf:Write(Contact)          | Write and Unlock
    Win:Dsp
  Return(Ok)

Contact:SetPage(Page)
  Mem:Ptr->Page=Page
  Return(Null)

Contact:Shift_F5_Key
  Jorf:Status
  Jorf:StatusClear
  Return (Ok)

Contact:Show (Contact)
  | The "Show" routine is used for the browser window.  The data that
  | is shown changes depending on the index in use - (try switching to
  | the phone number or zip code indexes to see the difference).
  New (Display)                        | Create "Display"
                                       | And interpret "Display" string
  Switch (Mem:Ptr->IndexName)
    Case ("FullName")
      Display = Str:Pad(Contact->FullName,17)+' '+Str:Pad(Contact->Company,17)
    Case ("Company")
      Display = Str:Pad(Contact->Company,17)+' '+Str:Pad(Contact->FullName,17)
    Case ("WorkPhone")
      Display = Str:Pad(Contact->WorkPhone,17)+' '+Str:Pad(Contact->FullName,17)
    Case ("LastName")
      Display = Str:Pad(Contact->LastName,10)+' '+Str:Pad(Contact->Dear,12)
      Display = Display +' '+Str:Pad(Contact->Company,17)
    Case ("ZipCode")
      Display = Str:Pad(Contact->ZipCode,5)+' '+Str:Pad(Contact->Company,16)
      Display = Display +' '+Str:Pad(Contact->FullName,12)
  Return (Display)

Contact:SplitName(Contact)
  If (Contact->FullName)
    If (Contact->Dear==Null)
      Contact->Dear=Word:At(Contact->FullName,1)
    If (Contact->LastName==Null)
      Contact->LastName=Word:At(Contact->FullName,Word:Len(Contact->FullName))
  Return (Ok)

Contact:Write()
  If (Mem:Ptr->Locked)
    Jorf:Write(Mem:Ptr->Locked)
    Mem:Ptr->Locked=Null
    Win:Dsp()
    Win:Msg()
  Return (Ok)

Contact:ZipCode (Contact)
  New (Field)
  If (Contact->ZipCode==Null)
    If (Contact->Addr3)
      Field=Contact->Addr3
    Else
      Field=Contact->Addr2
    While (Str:In(Field," "))
      Field=Str:At(Field,Str:In(Field," ")+1)
    Contact->ZipCode=Field
  Return (Ok)

