DECLARE SUB ReadDest (DestDir$)
DECLARE SUB ErrorMessage (Message$)
DECLARE SUB AddADir (DestDir$)
' Jenge Software    July 7, 1993    HDINSTAL.BAS        FREEWARE

'This program installs / copies files from your A-Drive to your hard drive.

'The destination directory is specified in the file: A:\HDINSTAL.CFG

DEFINT A-Z
 
COLOR 7, 1
CLS

CALL ReadDest(DestDir$)
IF LEN(DestDir$) > 0 THEN
   'This example uses the MKDIR statement to create a subdirectory. The
   'AddADir procedure uses the CHDIR statement with the ON ERROR statement
   'to check if the subdirectory already exists. If it does not exist, the
   'error-handling routine traps error 76, prompts the user, and creates
   'the directory.

   CLS
   'CREATE THE SUB-DIRECTORY
   CALL AddADir(DestDir$)

   CLS : LOCATE 10, 15: PRINT "Installing to "; DestDir$; " ... Please Wait"
   
   JD$ = "COPY A:\*.* " + DestDir$ + "\*.*"
   SHELL (JD$)
   CLS : LOCATE 10, 20: PRINT "Installation Complete ... Thank You"
   FOR i = 1 TO 4000: NEXT i                            'timing loop
   LOCATE 22, 1
ELSE
    PRINT "            * Jenge Software * FREEWARE *"
    PRINT " "
    PRINT "This program installs / copies files from your A-drive to"
    PRINT ""
    PRINT "your hard drive. The destination directory is specified in"
    PRINT ""
    PRINT "the file: A:\HDINSTAL.CFG"
    PRINT ""
    PRINT "------------------------------------------------------------------"
    PRINT "** HDINSTAL.CFG file is empty. NO INSTALLATION MADE **"
    PRINT " "
    PRINT "The proper syntax is:"
    PRINT " "
    PRINT "                 A:\HDINSTAL"
    PRINT " "
    PRINT "Press any key to continue..."
    DO
    LOOP WHILE INKEY$ = ""
END IF
END

SUB AddADir (DestDir$)
ON LOCAL ERROR GOTO ErrHandler  'Set up the local error handler.
    CurDirName$ = CURDIR$       'Preserve the name of the current directory.
    CHDIR DestDir$              'Change to DestDir$ - Error 76 if not exist.
    CHDIR CurDirName$           'Change back to original directory.
    EXIT SUB
 
ErrHandler:
    IF ERR = 76 THEN
       'PRINT "Directory does not exist. Create ?";
       'Ans$ = INPUT$(1)
       'PRINT Ans$
        ANS$ = "Y"
        IF UCASE$(ANS$) = "Y" THEN
            MKDIR DestDir$      'Make the directory.
            PRINT DestDir$; " directory created."
            RESUME NEXT
        ELSE
            PRINT DestDir$; " directory NOT created."
        END IF                  'Return control to caller.
    END IF
    RESUME NEXT                 'Just continue.
END SUB

SUB ErrorMessage (Message$)
    ON LOCAL ERROR GOTO MessageError
    CLS
    PRINT Message$
    PRINT "Cannot continue."
    PRINT
    PRINT "Press any key to exit."
    DO
    LOOP WHILE INKEY$ = ""
    EXIT SUB
MessageError:
    RESUME NEXT
END SUB

SUB ReadDest (DestDir$)
ON LOCAL ERROR GOTO ErrDest  'Set up the local error handler.
OPEN "a:\HDINSTAL.CFG" FOR INPUT AS #1

DestDir$ = "C:\GIGO\"
DO WHILE NOT EOF(1)
   LINE INPUT #1, DestDir$

   DestDir$ = LTRIM$(RTRIM$(DestDir$))

   'REMOVE THE LAST \ IF IT EXISTS
   IF RIGHT$(DestDir$, 1) = "\" THEN
      X = LEN(DestDir$) - 1
      DestDir$ = LEFT$(DestDir$, X)
   END IF

LOOP
CLOSE #1

EXIT SUB


ErrDest:
 
SELECT CASE ERR
    CASE 52  'Bad file name or number.
        END
    CASE 53  'File not found.
         DestDir$ = "C:\GIGO"
         EXIT SUB
         'RESUME NEXT
    CASE 57  'Device I/O error.
        ErrorMessage "You should probably format the diskette."
        END
    CASE 64  'Bad File Name.
        ErrorMessage "The drive name you specified was not correct."
        END
    CASE 68  'Device unavailable.
        ErrorMessage "The drive you named is unavailable."
        END
    CASE 71  'Drive not ready.
        ErrorMessage "The drive was not ready. Check the drive!"
        END
    CASE 76
       'Directory does not exist. Create it.
            MKDIR DestDir$      'Make the directory.
            PRINT DestDir$; " directory created."
            RESUME NEXT
            RESUME NEXT                 'Just continue.
    CASE ELSE
        ErrorMessage "An unexpected FATAL error has occurred."
        STOP
END SELECT

END SUB

