*************************************
* Funcion   : AchoFunc()
* Autor     : Jose Manuel Ortiz
* Contenido : Achoice para modo VESA.
*************************************

#include "fastgt.ch"

FUNC AchoiceVesa( nFila1, nCol1, nFila2, nCol2, aTabla, aParal, cFuncion, nPosMenu, nPosVent )
local hButtom1, hButtom2, hButtom3, hButtom4, hButtom5
local aBotones, aBoton
local nAcho, cAntColor:= setcolor()
local nColBoton


if ( pcount() < 5 )
	RETURN(0)
endif
if ( pcount() < 6 )
	aParal:= .t.
endif
if ( pcount() < 7 )
	cFuncion:= ""
endif
if ( pcount() < 8 )
        nPosMenu:= 1
endif
if ( pcount() < 9 )
        nPosVent:= 1
endif

private nAchoMenu:= nPosMenu
private nAchoVent:= nPosVent

@ nFila1, nCol2-3 GTDRAWBTN chr(24) INTO hButtom1
@ nFila2-2, nCol2-3 GTDRAWBTN chr(25) INTO hButtom2

setcolor( "w/n" )
@ nFila1+1, nCol2-3 clear to nFila2-3, nCol2
setcolor( cAntColor )

@ nFila1+1, nCol2-3 GTDRAWBTN " " INTO hButtom5

nColBoton:= int (((nCol2-nCol1)-22) /2 )+nCol1

@ nFila2, nColBoton GTDRAWBTN "  Ok  " INTO hButtom3
@ nFila2, nColBoton+10 GTDRAWBTN " Cancelar " INTO hButtom4

aBotones:= { hButtom1, hButtom2, hButtom3, hButtom4 }
setkey( 451, { || aBoton:= Pulsar( aBotones, { || PulsaENTER() } ) } )

while .t.
	aBoton:= {}
        nAcho:= achoice( nFila1, nCol1, nFila2-2, nCol2-5, aTabla, aParal, cFuncion, nAchoMenu, nAchoVent )

	if lastkey()=27 .and. empty( aBoton )
		GtPushBtn hButtom4
		exit
	endif

	if lastkey()=13 .and. empty( aBoton )
		GtPushBtn hButtom3
		exit
	endif

	if !empty( aBoton )
		do case
			case aBoton == hButtom1
				nAchoMenu--
				nAchoVent--
			case aBoton == hButtom2
				nAchoMenu++
				nAchoVent++
                        case aBoton == hButtom3
                                exit
                        case aBoton == hButtom4
                                nAcho:=0
                                exit
		endcase
	endif
end

setkey( 451, nil )

RETURN nAcho




*******************************************
STATIC FUNC Pulsar( aBotones, bCode )
*******************************************
* Averigua si se ha pulsado algn boton.
*
local nX1, nX2, nY1, nY2
local i, aDev:= {}

for i:= 1 to len( aBotones )
        nX1:= aBotones[i,1]
        nY1:= aBotones[i,2]
        nX2:= nX1+1
        nY2:= nY1+len( aBotones[i,3] )+3

        if Marea( CoordX( nX1 ), CoordY( nY1 ), CoordX( nX2 ), CoordY( nY2 ))
                GtPushBtn aBotones[i]
		aDev:= aBotones[i]
		eval( bCode )
		exit
        endif
next i

RETURN aDev




******************************************************************
FUNC PulsaEnter()
******************************************************************
* Introduce una marca de ENTER en el buffer para salir del achoice
*
 keyboard chr(13)

RETURN nil

****************************************
STATIC FUNC CoordX( nX )
****************************************
* Convierte coordenada X en modo grfico
*
RETURN ( nX * 16 )


****************************************
STATIC FUNC CoordY( nY )
****************************************
* Convierte coordenada Y en modo grfico
*
RETURN ( nY * 8 )


*********************************************************
STATIC FUNC MArea( nX1, nY1, nX2, nY2 )
*********************************************************
* Averigua si el ratn est en cierta area de la pantalla
*
RETURN ( MouseX() > nY1 .and. MouseX() < nY2 .and. MouseY() > nX1 .and. MouseY() < nX2 )
