// HLD.C - Horizontal Line Drawing

// Written by Phil Inch for Game Developers Magazine (issue 2).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.

// Note to experienced C programmers: I'm deliberately using 'double'
// instead of 'int' to exaggerate the optimisation.  I don't know if
// other languages optimise integer calculations as well as C does
// so by doing this I hope to present a more general result.



#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>



// Routine to swap to integers
void swap( double a, double b ) {
	double temp;
	temp = a;
	a = b;
	b = temp;
}


// Routine to put screen into mode 13h
void set_mode_13h( void ) {
	asm {
		mov ax,0x13
		int 0x10
		}
}


// Routine to put screen into mode 3h (text mode)
void set_text_mode( void ) {
	asm {
		mov ax,0x03
		int 0x10
		}
}


// Slow horizontal line drawing program
void slow_horizontal_line( double x1, double x2, double y, unsigned char colour ) {
	char far *screen_location;
	double xcount;

	for ( xcount = x1; xcount <= x2; xcount++ ) {
		screen_location = MK_FP( 0xA000, ( (int)y*320 ) + (int)xcount );
		*screen_location = colour;
		}
}


// Fast horizontal line drawing program
void fast_horizontal_line( double x1, double x2, double y, unsigned char colour ) {
	char far *screen_location;
	double xcount;

	screen_location = MK_FP( 0xA000, ((int)y*320) + (int)x1 );
	for ( xcount = x1; xcount <= x2; xcount++ ) {
		*screen_location = colour;
		screen_location++;
		}
}


// This is where the program first starts
void main( void ) {
	double x1, x2, y;
	long lines, number_of_lines;
	unsigned char colour;
	char input[80];
	clock_t slow_start, slow_end, slow_elapsed;
	clock_t fast_start, fast_end, fast_elapsed;

	clrscr();

   printf( "*** HORIZONTAL LINE DRAWING DEMO ***\n\n" );

	printf( "Suggestions for number of lines:\n\n" );
	printf( "486/50:  25000\n" );
	printf( "486/33:  10000\n" );
	printf( "486/25:   5000\n" );
	printf( "386/40:    500\n" );
	printf( "386/33:    200\n" );
	printf( "lower :    100\n\n" );

	printf( "Enter number of lines to draw: " );
	gets( input );

	number_of_lines = atol(input);
	if ( number_of_lines <= 0 ) {
		printf( "That's not a valid number!" );
		exit(1);
		}

	set_mode_13h();

	gotoxy( 18, 13 ); puts( "\"Slow\"" ); delay( 1500 );

	slow_start = clock();

	for ( lines = 0; lines < number_of_lines; lines++ ) {
		x1 = rand()%320;        // 0 <= x1 <= 319
		x2 = rand()%320;        // 0 <= x2 <= 319
		y  = rand()%200;			// 0 <= y  <= 199
		colour = rand()%256;		// 0 <= colour <= 255
		if ( x1 > x2 ) swap( x1, x2 );
		slow_horizontal_line( x1, x2, y, colour );
		}

	slow_end = clock();
	slow_elapsed = slow_end - slow_start;

	set_mode_13h();  // quick way of clearing the screen

	gotoxy( 18, 13 ); puts( "\"Fast\"" ); delay( 1500 );

	fast_start = clock();

	for ( lines = 0; lines < number_of_lines; lines++ ) {
		x1 = rand()%320;        // 0 <= x1 <= 319
		x2 = rand()%320;        // 0 <= x2 <= 319
		y  = rand()%200;			// 0 <= y  <= 199
		colour = rand()%256;		// 0 <= colour <= 255
		if ( x1 > x2 ) swap( x1, x2 );
		fast_horizontal_line( x1, x2, y, colour );
		}

	fast_end = clock();
	fast_elapsed = fast_end - fast_start;

	set_text_mode();

	printf( "\n\nTimes for %ld lines:\n", number_of_lines );

	printf( "\nSLOW:  Took %ld clock cycles (about %ld seconds)\n",
		slow_elapsed, 5*(9+slow_elapsed)/91 );

	printf( "\nFAST:  Took %ld clock cycles (about %ld seconds)\n",
		fast_elapsed, 5*(9+fast_elapsed)/91 );

	printf( "\nSAVING: FAST was %ld clock cycles (about %ld seconds) faster!\n\n",
		slow_elapsed-fast_elapsed, 5*(9+slow_elapsed-fast_elapsed)/91 );

}
