// SOUNDS.C - Demonstrates music and sound effects using PC speaker

// Written by Phil Inch for Game Developers Magazine (issue 2).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.






#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

#define NOTE_DELAY 500

void connect_to_timer2( void ) {
	asm {
		in al,0x61
		or al,3
		out 0x61,al
		}
}

void disconnect_from_timer2( void ) {
	asm {
		in al,0x61
		and al,252
		out 0x61,al
		}
}

void set_timer2_countdown( unsigned int countdown ) {
	char countlo, counthi;

	counthi = countdown/256;
	countlo = countdown-counthi;

	asm {
		mov dx,0x43
		mov al,0xB6
		out dx,al

		mov dx,0x42
		mov al,countlo
		out dx,al

		mov al,counthi
		out dx,al
		}
}

void set_timer2_frequency( long freq ) {
	unsigned int countdown;

	countdown = (unsigned int) (1193280L / freq);
	set_timer2_countdown( countdown );
}

void check_for_keystroke( void ) {
	if ( kbhit() ) {
		disconnect_from_timer2();
		getch();
		exit(0);
		}
}

void main( void ) {
	int c;
	long f;
	clrscr();

	printf( "*** PC SPEAKER SOUND DEMO ***\n\n" );

	printf( "\n\nWARNING!  If you're running this at work, I suggest\n" );
	printf( "you stop now, as this can be loud on some machines, and\n" );
	printf( "the noises definitely do NOT sound like a Lotus spreadsheet!\n" );
	printf( "\nTo stop now, press the ESCAPE key.  You can also stop the\n" );
	printf( "demo at any time by pressing a key.  This will stop the demo\n" );
	printf( "at the end of the current sound effect.\n" );

	printf( "\n... Press ESCAPE to abort, any other key to start ...\n\n" );
	if ( getch() == 27 ) exit(0);

	printf( "The octave from C4 (middle C) to C5 ..." );

	connect_to_timer2();

	set_timer2_frequency( 261 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 293 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 329 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 349 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 392 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 440 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 494 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	set_timer2_frequency( 523 );
	check_for_keystroke();
	delay(NOTE_DELAY);

	disconnect_from_timer2();

	delay(1000);

	printf( "\n\nAn alarm sound ..." );
	connect_to_timer2();

	for ( c = 0; c < 5; c++ ) {
		check_for_keystroke();
		set_timer2_frequency( 349 );
		delay(NOTE_DELAY);
		set_timer2_frequency( 261 );
		delay(NOTE_DELAY);
		}
	disconnect_from_timer2();

	delay(1000);

	printf( "\n\nA different alarm ..." );
	connect_to_timer2();

	for ( c = 0; c < 5; c++ ) {
		check_for_keystroke();
		for ( f = 200; f <= 800; f+=10 ) {
			set_timer2_frequency( f );
			delay(10);
			}
		check_for_keystroke();
		for ( f = 800; f >= 200; f-=10 ) {
			set_timer2_frequency( f );
			delay(10);
			}
		}
	disconnect_from_timer2();

	delay(1000);

	printf( "\n\nA laser gun ..." );

	for ( c = 0; c < 5; c++ ) {
	connect_to_timer2();
		check_for_keystroke();
		for ( f = 2700; f >= 2000; f-=10 ) {
			set_timer2_frequency( f );
			delay(6);
			}
		disconnect_from_timer2();
		delay(400);
		}

	printf( "\n\nThat's it - now you design some!\n\n" );
}



