 /*
  * File......: FTOOL.PRG
  * Author....: Torsten Radtke
  * CIS ID....: 100113,717
  * Date......: $Date$ 11/24/1993
  * Revision..: $Revision$ 1.0
  * Log file..: $Logfile$
  * 
  * This is an original work by Torsten Radtke and is placed in the
  * public domain.
  *
  * Modification history:
  * ---------------------
  *
  * $Log$
  *
  *  $DOC$
  *
  *  $FUNCNAME$
  *     FT_STRFILE()
  *
  *  $ONELINER$
  *     Write a string to a file
  *
  *  $SYNTAX$
  *     FT_STRFILE([<cString>],<cFile>[,<lOverwrite>]
  *     [,<nOffset>][,<lTruncate>]) -> nByteWritten
  *
  *  $ARGUMENTS$
  *  <cString> is the string to be written to a file.
  *
  *  <cFile> specifies a filename. Drive and path can be included
  *  (no Wildcards!).
  *
  *  <lOverwrite> not specified or .F. means the file will be created new
  *  in any case. .T. will write to an existing file.
  *  Default: Create new (.F.)
  *
  *  <nOffset> This option allows a position to be specified, from where
  *  the String will be written into the file.
  *  Default: End of file
  *
  *  <lTruncate> If specified as .T. this option will truncate the
  *  remainder of the file, if the written data ends before the last byte
  *  of the file.
  *  Default: Don't truncate (.F.)
  *
  *  $RETURNS$
  *  nByteWritten
  *  Returns the number of bytes that have been written to the file,
  *  or 0 if an error occured.
  *
  *  $DESCRIPTION$
  *  This function is another possibility to write the content of a string 
  *  into a file. Contrary to the CA-Clipper Fxxxx()-functions only one
  *  function call is needed to write the data. FT_STRFILE() creates the
  *  targetfile in any case. This function was created when the original
  *  CA-Tools III function STRFILE() caused an VM-Error on different PC's
  *
  *  $EXAMPLES$
  *    ? FT_STRFILE("ABCDEFGH", "TEST.TXT", .T.)        // Result: 8
  *
  *   A file with drive- and path specification.
  *
  *    ? FT_STRFILE("0123456789", "C:\DOCS\TEST.TXT")      // Resultat: 10
  *
  *   Data in an existing file will be overwritten with the specified string
  *    from position 20.
  *
  *    ? FT_STRFILE("COMPUTER ASSOCIATES", "TEST.TXT", .T., 20)   // Result: 9
  *
  *   A string with a length of 5 bytes will be written from position 10
  *    of a 20 bytes long file. Because the last argument is once .F.,
  *    once .T. the results are different.
  *
  *    FT_STRFILE(REPLICATE("X", 20), "TEST.TXT")
  *    FT_STRFILE("AAAAA", "TEST.TXT", .T., 10, .F.) // "XXXXXXXXXXAAAAAXXXXX"
  *    FT_STRFILE("AAAAA", "TEST.TXT", .T., 10, .T.) // "XXXXXXXXXXAAAAA"    
  *  $SEEALSO$
  *  $INCLUDE$
  *  $END$
  */

function FT_STRFILE(cString,cFile,lOverwrite,nOffset,lTruncate)

  PRIVATE nRetVal:=0

  IF cString==NIL
    cString:=""
  ENDIF
  
  IF cFile==NIL
    RETURN(nRetVal)
  ENDIF
  
  IF lOverwrite==NIL
    lOverwrite:=.F.
  ENDIF
  
  IF nOffset==NIL
    nOffset:=-1
  ENDIF
  
  IF lTruncate==NIL
    lTruncate:=.f.
  ENDIF
  
  IF lOverwrite
    IF FILE(cFile)
      nHandle:=FOPEN(cFile,18)
      IF FERROR()!=0
        RETURN(nRetVal)
      ENDIF
      IF lTruncate
        IF nOffset=-1
          FSEEK(nHandle,0,2)
        ELSE
          IF nOffset<(32*1024)+1
            cBuffer:=SPACE(nOffset)
            nBYTES:=FREAD(nHandle,@cBuffer,nOffset)
            FCLOSE(nHandle)
            nHandle:=FCREATE(cFile)
            IF FERROR()!=0
              RETURN(nRetVal)
            ELSE
              FWRITE(nHandle,cBuffer)
            ENDIF
          ELSE  /* create temporary file */
            nHandle2:=FCREATE("___ftool.$$$")
            IF FERROR()!=0
              FCLOSE(nHandle)
              RETURN(nRetVal)
            ELSE
              DO WHILE nOffset>(32*1024)
                cBuffer:=SPACE(32*1024)
                nBYTES:=FREAD(nHandle,@cBuffer,32*1024)
                IF FERROR()!=0
                  FCLOSE(nHandle)
                  FCLOSE(nHandle2)
                  DELETE FILE ("___ftool.$$$")
                  RETURN(nRetVal)
                ELSE
                  nBYTES:=FWRITE(nHandle2,cBuffer)
                  IF nBYTES!=(32*1024)
                    FCLOSE(nHandle)
                    FCLOSE(nHandle2)
                    DELETE FILE ("___ftool.$$$")
                    RETURN(nRetVal)
                  ELSE
                    nOffset:=nOffset-(32*1024)
                  ENDIF
                ENDIF
              ENDDO
              IF nOffset>0
                cBuffer:=SPACE(nOffset)
                nBYTES:=FREAD(nHandle,@cBuffer,nOffset)
                IF FERROR()!=0
                  FCLOSE(nHandle)
                  FCLOSE(nHandle2)
                  DELETE FILE ("___ftool.$$$")
                  RETURN(nRetVal)
                ELSE
                  nBYTES:=FWRITE(nHandle2,cBuffer)
                  IF nBYTES!=nOffset
                    FCLOSE(nHandle)
                    FCLOSE(nHandle2)
                    DELETE FILE ("___ftool.$$$")
                    RETURN(nRetVal)
                  ELSE
                    FCLOSE(nHandle)
                    FCLOSE(nHandle2)
                    DELETE FILE &cFile
                    COPY FILE ("___ftool.$$$") TO &cFile
                    DELETE FILE ("___ftool.$$$")
                    nHandle:=FOPEN(cFile,18)
                    IF FERROR()!=0
                      RETURN(nRetVal)
                    ELSE
                      FSEEK(nHandle,0,2)
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ELSE
        IF nOffset=-1
          FSEEK(nHandle,0,2)
          IF FERROR()!=0
            FCLOSE(nHandle)
            RETURN(nRetVal)
          ENDIF
        ELSE
          FSEEK(nHandle,nOffset,0)
          IF FERROR()!=0
            FCLOSE(nHandle)
            RETURN(nRetVal)
          ENDIF
        ENDIF
      ENDIF
    ELSE
      nHandle:=FCREATE(cFile)
      IF FERROR()!=0
        RETURN(nRetVal)
      ENDIF
    ENDIF
  ELSE
    nHandle:=FCREATE(cFile)
    IF FERROR()!=0
      RETURN(nRetVal)
    ENDIF
  ENDIF
  nRetVal:=FWRITE(nHandle,cString)
  FCLOSE(nHandle)
 RETURN(nRetVal)
* -----------------------------------------------------------
