#include "fast.ch"
#include "inkey.ch"



/********************************************************************
*      Fast Library For Clipper Demo Program
*
*      (c) 1992-93 Manu Roibal
*
*      Compile with : clipper demo /A /M /N /W
*
*      Link with    : rtlink FI demo LIB fast
*             or    : blinker FI demo LIB fast
*/


Function Main()
Local nX := Col ()
Local nY := Row ()
Local cColor  := SetColor()
Local nCursor := SetCursor( 0 )
Local nInd
Local aE
    SetCancel( .F. )
    Set ( _SET_SCOREBOARD, .F. )
    SetColor ( "W+/B" )
    BoxWarning( { "Fast Library For Clipper", ;
                  "", ;
                  "The best library ever created for Clipper", ;
                  "", ;
                  "(C) 1993-94 Manu Roibal", ;
                  "", ;
                  "De omni re scibili et quibusdam aliis" } )
    Pantalla ( .T. )
    aE := GaugeNew ( 8, "Fast Library For Clipper. L'enfant Terrible", "B" )
    For nInd := 1 To 30
      GaugeUpdate( aE, 1 / 30 )
      Delay( .01 )
    Next
    SetFont ( "Roman.Fon" )
    Screen ( "", "B+/B" )
    Clock( .T., 0, 71, "B+/B" )
    FastSign( 1, 2 )
    SetColor ( "N/BG,N/W" )
    NewBox ( 3, 22, 22, 59, "Fast Library Demo Program", "ͻȺ ", .T. )
    aChoice ( 5, 25, 21, 56, ;
              { " 1. Clipper GIF decoder", ;
                " 2. PCX in EGA-VGA", ;
                " 3. Calculator", ;
                " 4. Autodesk FLI animations!!!", ;
                " 5. Calendar", ;
                " 6. Serpent game", ;
                " 7. Screen Saver", ;
                " 8. Clipper Notes", ;
                " 9. Enjoy Tetris", ;
                "10. File Manager", ;
                "11. Backup", ;
                "12. Restore", ;
                "13. Window System Demo", ;
                "14. Directory Structure", ;
                "15. Load INI files", ;
                "16. Load and modify INI files", ;
                "17. A little Text Editor", ;
                "18. Windows with light focus", ;
                "19. Get Password", ;
                "20. Encrypt string", ;
                "21. Deencrypt string", ;
                "22. Graphics Demo", ;
                "23. GraphBar on Clipper", ;
                "24. GraphTart on Clipper", ;
                "25. VGA efects!!", ;
                "26. Keyboard demo", ;
                "27. Menu System Demo", ;
                "28. Another Graph bar", ;
                "29. Serial Comunications", ;
                "30. Mouse demo", ;
                "31. Font Editor", ;
                "32. Footing with Clipper", ;
                "33. Big Clock", ;
                "34. Puzzle", ;
                "35. Another Graph Bar", ;
                "36. A mini debugger", ;
                "37. Ascii Table", ;
                "38. A message with scroll", ;
                "39. Sound Blaster demo", ;
                "40. Parallel DAC demo", ;
                "41. Speaker demo", ;
                "42. New Memo edit function", ;
                "43. Ellipse Graphs", ;
                "44. More Speed please", ;
                "45. Fast Icons", ;
                "46. CD Audio Support!!!"  }, .T., "USERFUNC" )
    Pantalla ( .F. )
    SetPos ( nY, nX )
    SetColor ( cColor )
    SetCursor ( nCursor )
    SetFont ( "Standard.Fon" )
Return ( Nil )


Function UserFunc ( nModo, nElemento, nRel )
Local aPanta
Local nRet    := 2
Local nInd
Local cMemo   := "To be or not to be, that's the fastquestion"
    If Lastkey () == K_ESC
      If BoxQuery( "Are you sure you want to exit to DOS?" )
        Return( 0 )
      Else
        Return( 32 )
      EndIf
    ElseIf Lastkey () == K_RETURN
      aPanta := SaveScr ( , , , , 1 + nRandom ( 3 ) )
      Pantalla ( .F. )
      Do Case
        Case nElemento == 1
          SetVGA256()
          If GIFShow256( "demo.gif" )
            rCursorOn()
            rInkey( 0 )
            rCursorOff()
          EndIf
          TxtMode()
          SetBlink(.F.)
        Case nElemento == 2
          PCXDemo ()
        Case nElemento == 3
          Calculator ( "N/W", "G+/N", "R+/N" )
        Case nElemento == 4
          FliEver( "fast.fli" )
        Case nElemento == 5
          Calendar ( 5, 20, "N/BG", "R/BG", "GR+/B" )
        Case nElemento == 6
          Serpent ( "W+/B*", "R+/B*", "G+/B*" )
        Case nElemento == 7
          ScreenSave ( "BG+/N", "Fast Library For Clipper. (C) 1993 Manu Roibal" )
        Case nElemento == 8
          Notes( "W/B,N/BG", "W/B,N/BG,G/B,W/B,R+/B", "HojaCalc.hc" )
        Case nElemento == 9
          Tetris ( 25, 3, 4 )
        Case nElemento == 10
          Manager ( "N/W,N/BG", "N/BG", "*.prg" )
        Case nElemento == 11
          Backup ( Date (), Time (), "Root", "A:\", ;
                   { { "C:\DOS\",      "*.*"   }, ;
                     { "C:\OS2\MDOS\", "*.COM" } }, ;
                   .T., "N/W,N/W" )
        Case nElemento == 12
          Restore ( "A:\", { "D:\DOS" }, "N/W,N/W" )
        Case nElemento == 13
          DemoVentanas ()
        Case nElemento == 14
          TreeDemo ( "C:\", "\*.*" )
        Case nElemento == 15
          LeerIni ( "FAST", "MANU", "CPUTYPE" )
        Case nElemento == 16
          ModificarIni ( "FAST", "MANU", "TIMESLIZE" )
        Case nElemento == 17
          Editor ( "Fast.Ini", "W/B" )
        Case nElemento == 18
          DemoFoco ()
        Case nElemento == 19
          DamePass ()
        Case nElemento == 20
          Revuelve ()
        Case nElemento == 21
          Revuelve ()
        Case nElemento == 22
          GrafDemo ()
        Case nElemento == 23
          BarraDemo ()
        Case nElemento == 24
          TartaDemo ()
        Case nElemento == 25
          EfectosVGA ()
        Case nElemento == 26
          KeyDemo()
        Case nElemento == 27
          Menues ()
        Case nElemento == 28
          Graf3Demo()
        Case nElemento == 29
          DemoCom ()
        Case nElemento == 30
          DemoRata ()
        Case nElemento == 31
          FontEdit( "cubo.fon" )
        Case nElemento == 32
          Footing()
        Case nElemento == 33
          BigClock()
        Case nElemento == 34
          BoxWarning( "The winner is... " + If( Puzzle(), "the User", "the Computer" ) )
        Case nElemento == 35
          Graf2Demo()
        Case nElemento == 36
          MiniDebug( 7, "Replicate( 'Fast ', 2 )" )
        Case nElemento == 37
          AsciiTab()
        Case nElemento == 38
          MsgScroll( 10, 20, 30, "Fast Library For Clipper, the best Clipper extender", "GR+/B" )
        Case nElemento == 39
          If sbInit()
            sbVocPlay ( "Fast.voc", 8192 )
          EndIf
        Case nElemento == 40
          If BoxQuery( "Do you have a Parallel DAC in LPT2?" )
            dacPort( 2 )
            dacVocPlay( "Fast.voc", 8192 )
         EndIf
        Case nElemento == 41
          spkVocPlay( "Fast.voc", 8192 )
        Case nElemento == 42
          cMemo := FastMemo( 10, 10, 20, 60, cMemo, "Demo", "W+/B", .T., .T. )
        Case nElemento == 43
          EllipseDemo ()
        Case nElemento == 44
          MoreSpeed()
        Case nElemento == 45
          DemoIcons()
        Case nElemento == 46
          cdDemo()
      EndCase
      SetFont ( "Roman.Fon" )
      RestScr ( , , , , aPanta )
      SetCursor ( 1 )
      SetCursor ( 0 )
    ElseIf LastKey () == K_ESC
      nRet := 0
    EndIf
Return ( nRet )


Function Pantalla ( lModo )
Static cPanta
    If lModo
      cPanta := SaveScreen ( 0, 0, 24, 79 )
    Else
      Return ( Implode ( 0, 0, 24, 79, cPanta ) )
    EndIf
Return ( Nil )


Function DamePass ()
Local cPanta  := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B" )
    NewBox ( 5, 5, 9, 74, "Security", "ͻȺ ", .T. )
    GetPass ( 7, 12, "Input your access key (15 letters Max.):", 15 )
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cPanta )
Return ( Nil )


Function Revuelve ()
Local cPanta  := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B" )
Local cEncrip
Local cDeEncrip
    NewBox ( 5, 5, 10, 74, "De/Encrypt", "ͻȺ ", .T. )
    cEncrip := Encrypt ( "Manu Roibal" )
    Message ( 7, 12, "<Manu Roibal> -> encrypt -> " + cEncrip )
    cDeEncrip := DeEncrypt ( cEncrip )
    Message ( 8, 12, "<" + cEncrip + "> -> deEncrypt -> " + cDeEncrip )
    Inkey (0)
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cPanta )
Return ( Nil )


Function TreeDemo ( cDisco, cMascara )
Local cPanta  := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B,N/W" )
Local aDisco  := DirTree ( cMascara, cDisco )
    Window ( 4, 0, 22, 29, "Directory " + cDisco, "ͻȺ ", .T. )
    Achoice ( 5, 2, 21, 27, aDisco, .T. )
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cPanta )
Return ( Nil )


Function DemoVentanas ()
Local aColor := { "N/BG", "W+/R", "R/W",  "G/W",  "B/W",  "W/B", ;
                  "G+/W", "W+/G", "BG/N", "N/BG", "R+/B", "GR+/N" }
Local nTipo
Local cColor
Local nInd := 0
Local nX1  := 0
Local nY1  := 0
Local nX2  := 0
Local nY2  := 0
Local aPan := {}
Local cPan := ""
    For nInd := 1 To 25
      nX1 := nRandom ( 77 ) + 1
      nY1 := nRandom ( 22 ) + 1
      nX2 := nRandom ( 77 - nX1 ) + nX1 + 1
      nY2 := nRandom ( 22 - nY1 ) + nY1 + 1
      cColor  := aColor [ nRandom ( 11 ) + 1 ]
      nTipo := nRandom ( 3 ) + 1
      If nX2 - nX1 < 22
        nTipo := 4
      EndIf
      If nTipo == 1
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, "Window with shadow", "ͻȺ ", .T., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, "NewBox with shadow", "ͻȺ ", .T., cColor )
        EndIf
      ElseIf nTipo == 2
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, "Window without shadow", "ͻȺ ", .F., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, "NewBox without shadow", "ͻȺ ", .F., cColor )
        EndIf
      ElseIf nTipo == 3
        Wall ( nY1, nX1, nY2, nX2, cColor )
      Else
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, , "ͻȺ ", .T., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, , "ͻȺ ", .T., cColor )
        EndIf
      EndIf
    Next
    Inkey(5)
    Stars()
    cPan := SaveScreen ( 0, 0, 24, 79 )
    Fascinate( "G", "BG" )
    Inkey(0)
    aPan := SaveScr ( , , , , 1 )
    RestScreen ( 0, 0, 24, 79, cPan )
    RestScr ( , , , , aPan )
    aPan := SaveScr ( , , , , 2 )
    RestScreen ( 0, 0, 24, 79, cPan )
    RestScr ( , , , , aPan )
    aPan := SaveScr ( , , , , 3 )
    RestScreen ( 0, 0, 24, 79, cPan )
    RestScr ( , , , , aPan )
    aPan := SaveScr ( , , , , 4 )
    RestScreen ( 0, 0, 24, 79, cPan )
    RestScr ( , , , , aPan )
Return ( Nil )


Function LeerIni ( cFichero, cAplicacion, cCampo )
Local cValor
Local cPantalla := SaveScreen ( 0, 0, 24, 79 )
Local aIniFile  := IniLoad ( cFichero, cAplicacion )
    cValor := IniSearch( aIniFile, cCampo, "386SX" )
    Window ( 9, 15, 16, 64, "Configuration", "ͻȺ ", .T., "N/BG" )
    Message ( 11, 20, "The .Ini shows CPU Type -> " + cValor, "N/BG" )
    Message ( 12, 20, "Default value is        -> 386SX" , "N/BG" )
    Message ( 14, 20, "For more information read Fast.ini", "N/BG" )
    Inkey ( 0 )
    Implode ( 0, 0, 24, 79, cPantalla )
Return ( Nil )


Function ModificarIni ( cFichero, cAplicacion, cCampo )
Local cValor
Local cNuevo
Local cPantalla := SaveScreen ( 0, 0, 24, 79 )
Local aIniFile  := IniLoad ( cFichero, cAplicacion )
    cValor := IniSearch( aIniFile, cCampo, "50" )
    Window ( 9, 15, 16, 64, "Configuration", "ͻȺ ", .T., "N/BG" )
    Message ( 11, 20, "The .Ini shows Time Slize -> " + cValor, "N/BG" )
    cNuevo := TransForm ( nRandom ( 99 ), "99" )
    IniSave( aIniFile, cCampo, cNuevo )
    IniWrite( aIniFile, cFichero, cAplicacion )
    Message ( 12, 20, "New value will be         -> " + cNuevo, "N/BG" )
    Message ( 14, 20, "For more information read Fast.ini", "N/BG" )
    Inkey ( 0 )
    Implode ( 0, 0, 24, 79, cPantalla )
Return ( Nil )


Function DemoFoco ()
Local aBoton
    aBoton := BoxOpen ( 3, 10, 5, 50, "B", .1 )
    Message ( 4, 13, "- Original idea by Urbano Garca -", "W+/B" )
    While Inkey ( 0 ) != K_ESC
      BoxPush ( aBoton )
    End
    BoxClose ( aBoton )
Return ( Nil )


Function GrafDemo ()
    SetVGA()
    DispStr ( "Now, i am going to generate lines until you press any key", 35, 50, 9, 0, 10 )
    Inkey(0)
    While Inkey() == 0
      gLine( nRandom(639), nRandom(479), nRandom(639), nRandom(479), nRandom( 15 ) )
    End
    TxtMode()
    SetBlink(.F.)
Return ( Nil )


Function BarraDemo ()
    SetVGA ()
    GraphBar ( "This is a VGA special efects demo", ;
               { "Item 1",               { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               , ;
               { "Item 3",               { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               { "Item 4 and last",      { 2281, 3332, 3212, 2557, 7499, 2612 } } )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function Graf2Demo ()
    SetVGA ()
    GraphBar2 ( "This is a VGA special efects demo", ;
                { { 9481, 4212, 5212, 4266, 8699, 9442, 9298 }, ;
                  { 7481, 1212, 4642, 1234, 6542, 9312, 1921 }, ;
                  { 2481, 3212, 4212, 1266, 1699, 6312, 7921 }, ;
                  { 2281, 3332, 3212, 2557, 7499, 2612, 3120 } } )
    Legend (  20, 420, 15,  9, "Fast Library" )
    Legend ( 340, 420, 15, 10, "Other" )
    Legend (  20, 450, 15, 11, "Other" )
    Legend ( 340, 450, 15, 12, "Other" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function Graf3Demo ()
    SetVGA ()
    GraphBar3 ( "This is a VGA special efects demo", ;
               { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5", "Item 6", ;
                 "Item 7", "Item 8", "Item 9", "Item A", "Item B", "Item C", ;
                 "Item D", "Item E", "Item F", "Item 0" }, ;
               {     9481,     4212,     5212,     4266,     8699,     9442, ;
                    19481,    23212,     5212,     2166,     1699,    19442, ;
                     7212,    12266,      699,    22442 } )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function TartaDemo ()
Local cTitulo := "Statistics"
    SetVGA ()
    GraphTart ( 540, 60, 40, { 17, 3, 15, 60, 15 } )
    GraphTart ( 80, 120, 30, { 17, 3, 15, 60, 15 } )
    gBox ( 210, 130, 430, 350, 10 )
    GraphTart ( 320, 240, 100, { 17, 3, 15, 60, 15 } )
    DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
    Legend ( 320, 460, 15, 4, "Fast Library For Clipper" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function EllipseDemo ()
Local cTitulo := "Statistics"
    SetVGA ()
    GraphEllipse ( 540, 60, 40, { 17, 3, 15, 60, 15, 21, 21, 23, 54 } )
    GraphEllipse ( 80, 120, 30, { 17, 3, 15, 60, 15, 21, 47, 11, 11, 64, 11 } )
    gBox ( 210, 130, 430, 350, 10 )
    GraphEllipse ( 320, 240, 100, { 17, 23, 12, 72, 3, 15, 60, 21, 15 } )
    DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
    Legend ( 320, 460, 15, 4, "Fast Library For Clipper" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function DemoRata ()
    Cls
    If rIsMouse()
      ? "Well, you have a mouse; Them, press any key or mouse button"
      rInkey(0)
      rCursorOn ()
      rSetPos ( 12, 39 )
      ? "Now mouse cursor is on 12,39"
      rSetPos ( 12, 39 )
      rSetArea ( 16, 30, 18, 50 )
      rInkey(0)
      rCursorOff ()
      ? "good bye mouse"
      rInkey(0)
      rCursorOn()
      ? "hello mouse"
      rInkey(0)
      rColors ( 1, 8 )
      ? "Now, press any key or mouse button"
      rInkey(0)
      rCursorOff()
    Else
      BoxWarning ( "There is no mouse on system" )
    EndIf
Return ( Nil )


Function EfectosVGA()
Local nInd    := 0
Local nValor  := 3
Local cCambio := ""
    SetVGA ()
    GraphBar ( "This is a VGA special efects demo", ;
               { "Item 1",               { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               , ;
               { "Item 3",               { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               { "Item 4 and last",      { 2281, 3332, 3212, 2557, 7499, 2612 } } )
    egVGAOn()
    egHigh( "w" )
    egChange( "rb",  "gr+" )
    egChange( "w+",  "n"   )
    egChange( "r",   "b"   )
    egChange( "bg+", "n"   )
    egChange( "b",   "gr+" )
    egChange( "w",   "b+"  )
    egChange( "r+",  "bg"  )
    egChange( "gr+", "n"   )
    Inkey(0)
    egRatePal( 4 )
    egRateClk( 1 )
    Inkey(0)
    egRatePal( 1 )
    egRateClk( 4 )
    Inkey(0)
    egRestAll()
    egBlink( "r",  "g+", .T. )
    egBlink( "gr", "bg"  )
    egBlink( "w+", "g",  .T. )
    Inkey(0)
    egRestAll()
    egFixPal( .T. )
    cCambio := ""
    nValor  := 3
    For nInd = 1 TO 16
       cCambio += Chr ( nValor ) + Chr ( 0 ) + Chr ( 0 )
       nValor  += 4
    Next
    egPalette( 14, cCambio )
    egPalNo( 14 )
    Inkey ( 0 )
    cCambio := ""
    nValor  := 3
    For nInd = 1 TO 16
       cCambio += Chr ( 0 ) + Chr ( nValor ) + Chr ( 0 )
       nValor  += 4
    Next
    egPalette( 14, cCambio )
    egPalNo( 14 )
    Inkey(0)
    cCambio := ""
    nValor  := 3
    For nInd = 1 TO 16
       cCambio += Chr ( 0 ) + Chr ( 0 ) + Chr ( nValor )
       nValor  += 4
    Next
    egPalette( 14, cCambio )
    egPalNo( 14 )
    Inkey(0)
    egVGAOff()
    TxtMode ()
    SetBlink ( .F. )
Return ( Nil )


Function Menues ()
Local aMenu
Local nOpt
Local cColor   := "W+/BG,N+/BG"
local cGet1    := "Manu Roibal                 "
local cGet2    := "Fast Library For Clipper "
local GetList  := {}
local nChoice1 := 2
local nChoice2 := 1
local nChoice3 := 1
local nChoice4 := 3
local nChoice5 := 2
    Fascinate ( "GR", "BG" )
    Set wrap On
    Set message To 24 Center
    @ 24, 0 Say Space ( 80 ) Color "N/W"
    aMenu := NewMenu( { "^System", "^Tools", "^States", "^Last" }, ;
                      { "N/W", "R/W", "W/B", "W+/B", "N/W", "W+/B", "N+/W", ;
                        "R/W", "GR+/B" } )
    AddItem ( aMenu, 1, "^New", "Nothing" )
    AddItem ( aMenu, 1, "^Open" )
    AddLine ( aMenu, 1 )
    AddItem ( aMenu, 1, "^Save", "More messages", , { "Item 1", "Item 2", "Item 3" } )
    AddItem ( aMenu, 1, "^Discard", , , { "First Item", "Second Item", "Third Item" } )
    AddLine ( aMenu, 1 )
    AddItem ( aMenu, 1, "Good m^orning sir", , 3 )
    AddItem ( aMenu, 1, "^Quit", "Are you sure you want exit from here?" )
    DelItem ( aMenu, 1, 3 )
    OffItem ( aMenu, 1, 2 )
    AddItem ( aMenu, 2, "^Cut" )
    AddItem ( aMenu, 2, "^Paste" )
    AddItem ( aMenu, 2, "^Copy" )
    AddItem ( aMenu, 3, "^Search" )
    AddItem ( aMenu, 3, "^Replace" )
    AddItem ( aMenu, 4, "^Help" )
    AddItem ( aMenu, 4, "And ^more Help" )
    AddItem ( aMenu, 4, "And more, ^and more..." )
    AddLine ( aMenu, 4 )
    AddItem ( aMenu, 4, "Little rabbit ^Duracell", , , { "1 Item", "2 Item", "3 Item" } )
    nOpt := DispMenu ( aMenu, 3 )
    BoxWarning ( "And the winer is... " + Str ( nOpt ) )
    Cls
    SetCursor ( 1 )
    @ 4,5  say "Get Normal 1:" get cGet1
    @ 6,5  say "Clipper Lib"   get nChoice1 VALID nChoice1 == 3 COLOR cColor ;
           with radiobuttons { "1 Option1", "2 No buttons 2", "3 Not Selected" }
    @ 6,40 say "Fast Library"  get nChoice2 when nChoice1 != 2 COLOR cColor ;
           with radiobuttons { "1 Adios", "2 Agur", "3 Bye bye", "4 Adeu" }
    @ 7,60 get nChoice3        COLOR cColor ;
           with radiobuttons { "1 Fast", "2 Normal", "3 Slow" } ;
           nobox
    @ 12,5 say "Get Normal 2:" get cGet2
    @ 15,5 say "Botones 4:"
    @ 15,col()+1 get nChoice4 COLOR cColor ;
                 with radiobuttons { "1 Option 1", "2 Option 2", "3 Option 3" } ;
                 nobox ;
                 horizontal
    @ 17,5 Say "Botones 5:" get nChoice5 COLOR cColor ;
           with radiobuttons { "1 Option1", "2 Option 2", "3 Option 3" } ;
           double ;
           horizontal
    read
Return ( Nil )


Function PCXDemo ()
Local i
    SetVGA()
    PCXShow ( "fast.pcx", .F., 100,  10 )
    DispStr ( "Press any key to continue", 350, 60, 15, 0 )
    While Inkey() == 0
      For i := 0 To -340 Step -2
        Origin( 0, i )
      Next
      For i := -340 To 0 Step +2
        Origin( 0, i )
      Next
      Origin( 0, 0 )
    End
    Degrade( GetPalette() )
    TxtMode ()
    SetBlink(.F.)
Return ( Nil )


Function DemoCom()
#define COMPORT 2
Local nAux := ComInst( COMPORT )
    Cls
    If nAux != 0
      BoxWarning( "Error number " + Str( nAux, 1 ) + " in COM" + Str( COMPORT, 1 ) )
    Else
      ComHighDTR()
      ComSpeed( 2400 )
      ComParity( COM_NONE, 1 )
      Message( 10, 10, "Alt-X Exit. Another key go to port" )
      While .T.
        nAux := Inkey( 0 )
        If nAux == K_ALT_X
          ComUnInst()
          Exit
        EndIf
        ComOutput( nAux )
        nAux := ComInput()
        If nAux != Nil
          Message( 12, 10, "Received from port : " + Str( nAux ) )
        EndIf
      End
    EndIf
Return( Nil )


Function MoreSpeed()
Local nTime
Local aBoton
Local nInd
    aBoton := BoxOpen ( 8, 2, 14, 76, "B", .1 )
    @ 10, 10 Say "Writes 1 to 15.000 with @ Say ->" Color "W+/B"
    nTime := Seconds()
    For nInd := 1 to 15000
      @ 10, 40 Say Str( nInd ) Color "W+/B"
    Next
    @ 10, 60 Say Str( Seconds() - nTime ) Color "GR+/B"
    @ 12, 10 Say "Writes 1 to 15.000 with Fast  ->" Color "W+/B"
    nTime := Seconds()
    For nInd := 1 to 15000
      FastPrint( 12, 40, Str( nInd ), 31 )
    Next
    @ 12, 60 Say Str( Seconds() - nTime ) Color "GR+/B"
    Inkey(0)
    BoxClose( aBoton )
Return( Nil )


Function DemoIcons()
Local aExit, aCubo, aLine
    Cls
    SetFont( "Cubo.Fon" )
    aExit := BoxOpen( 5, 30, 7, 34, "B", 0.2 )
    @ 6, 31 Say "" Color "GR+/B"
    aCubo := BoxOpen( 5, 38, 7, 42, "B", 0.2 )
    @ 6, 39 Say "  " Color "GR+/B"
    aLine := BoxOpen( 5, 46, 7, 50, "B", 0.2 )
    @ 6, 47 Say " " Color "GR+/B"
    Inkey( 0 )
    BoxPush( aExit )
    Inkey( 0 )
    BoxPush( aCubo )
    Inkey( 0 )
    BoxPush( aLine )
    SetFont( "Standard.Fon" )
Return( Nil )


Function Footing()
Local nI      := 0
Local nCont   := 1
Local cC      := ""
Local nN      := 1
Local cColor  := setcolor( "Gr+/B" )
Local aFrase  := {}
Local cLit    := "Fast-Fonts Demo. Created by Yosu Unibaso Suarez"
Local nLonLit := Len( cLit ) + 12 - 1
Local aBox
    aFrase = Array( 80 )
    aFill( aFrase, " " )
    For nI := 12 To nLonlit
      aFrase[ nI ] := SubStr( cLit, nI - 11, 1 )
    Next
    SetFont( "cubo.fon" )
    aBox := BoxOpen( 4, 0, 6, 79, "b", 0.2 )
    @ 5, 2 Say ""
    For nI := 2 To 78
      If nCont == 1
        cC := ""
      ElseIf nCont == 2
        cC := ""
      ElseIf nCont == 3
        cC := ""
      ElseIf nCont == 4
        cC := ""
      EndIf
      @ 5, nI say cC
      nCont := If( nCont < 4, ++nCont, 1 )
      Delay( 0.1 )
      @ 5, nI say aFrase[ nI ]
    Next
    cC := ""
    For nI := 2 To 77
      @ 5, nI Say cC
      Delay( 0.1 )
      @ 5, nI Say "  "
    Next
    BoxPush( aBox )
    BoxClose( aBox )
    SetFont( "standard.fon" )
    SetColor( cColor )
Return( Nil )


Function KeyDemo()
    Cls
    While Inkey() != K_ESC
      @  1, 2 say "Insert     " + If( IsInsert(), "Yes", "No " )
      @  2, 2 say "Caps       " + If( IsCaps(),   "Yes", "No " )
      @  3, 2 say "Num        " + If( IsNum(),    "Yes", "No " )
      @  4, 2 say "Scroll     " + If( IsScroll(), "Yes", "No " )
      @  5, 2 say "Alt        " + If( IsAlt(),    "Yes", "No " )
      @  6, 2 say "Ctrl       " + If( IsCtrl(),   "Yes", "No " )
      @  7, 2 say "lShift     " + If( IsLShift(), "Yes", "No " )
      @  8, 2 say "rShift     " + If( IsRShift(), "Yes", "No " )
      @ 10, 2 say "Joystick 1 " + If( jButton1(), "Yes", "No " )
      @ 11, 2 say "Joystick 2 " + If( jButton2(), "Yes", "No " )
      @ 14, 2 say "Push Esc to exit"
    End
Return Nil


Function cdDemo()
Local nKey
Local aButtons := Array( 5 )
Local aTracks
Local nInd
   BoxOpen( 1, 1, 7, 70, "B" )
   @  3, 3 say "CD Install & ready : " + if( cdInstall(), "Yes", "No" )  Color "GR+/B"
   @  4, 3 say "MSCDEX Version     : " + MSCDEXVer()                     Color "GR+/B"
   @  5, 3 say "First CD unit      : " + cdDrive()                       Color "GR+/B"
   aButtons[ 1 ] := BoxMessage( "<F1>  Start the CD ", 11,  5 )
   aButtons[ 2 ] := BoxMessage( "<F2>  Stop the CD  ", 15,  5 )
   aButtons[ 3 ] := BoxMessage( "<F3>  Resume the CD", 11, 40 )
   aButtons[ 4 ] := BoxMessage( "<F4>  Eject the CD",  15, 40 )
   aButtons[ 5 ] := BoxMessage( "<Esc> Exit         ", 19,  5 )
   While ( nKey := Inkey( 0 ) ) != K_ESC
     Directory( "d:\*.*" )
     if nKey == K_F1
       BoxPush( aButtons[ 1 ] )
       cdPlay( 1 )
     ElseIf nKey == K_F2
       BoxPush( aButtons[ 2 ] )
       cdStop()
     ElseIf nKey == K_F3
       BoxPush( aButtons[ 3 ] )
       cdResume()
     ElseIf nKey == K_F4
       BoxPush( aButtons[ 4 ] )
       cdEject()
     EndIf
   End
   BoxPush( aButtons[ 4 ] )
Return( Nil )



Function FastSign( nY, nX )
    DEFAULT nX = 2
    DEFAULT nY = 1
    BoxOpen( nY, nX, nY + 7, nX + 17, "B", .1 )
    Message( nY + 1, nX + 1, "     Ŀ       ", "G+/B" )
    Message( nY + 2, nX + 1, "     FĿ     ", "G+/B" )
    Message( nY + 3, nX + 1, "    ĴAĿ   ", "G+/B" )
    Message( nY + 4, nX + 1, "   ĴSĿ ", "G+/B" )
    Message( nY + 5, nX + 1, "  ĴT  ", "G+/B" )
    Message( nY + 6, nX + 1, "  ", "G+/B" )
Return( Nil )

