















                                       DOC

                     Source Code Documentor for Clipper 5.x

                                  Version 3.03










                               Copyright (C) 1991
                          Clarity Computer Consultants
                                 1831 - 13th St.
                                Moline, IL 61265


























                                        1





                                 DOC IS NOT FREE

          DOC is not, and has never been, free. It is shareware.  Share-
        ware is software you can try before purchasing. After trying it
        for a reasonable time you must either register or delete it from
        your hard disk.  Registration is US $70.  When you register you
        will receive a registration # by E-Mail, phone or fax to turn off
        the UNREGISTERED VERSION messages and a printed Users Manual by
        mail.

          To register by credit card log onto CompuServe and GO SWREG.
        DOC's Registration ID is 519.  When you register via CIS you will
        received your registration # by CompuServe Mail within 24 hours.

          You can also register by mailing a check or money order payable
        in US funds to

                          Clarity Computer Consultants
                                  1831-13th St.
                                Moline, IL 61265
                                       USA

          When registering by mail, if you send a money order or a certi-
        fied check and a phone or fax number where we can reach you we
        will phone or fax you your registration # the day we receive
        payment.  Otherwise, we will phone, fax or mail you your regis-
        tration # when payment is confirmed and send the printed manual
        by mail.

          To contact the author with problems or questions send a message
        via CompuServe to

                         David Barrett, CIS # 72037,105

        or by mail to Clarity Computer Consultants at the above address.





















                                        2




                                    CHAPTER I
                                    Overview

        DOC, the Source Code Documenter for Clipper 5.x code, will read
        your Clipper source code files and rewrite them into another
        directory, indenting the code to show program control structures,
        inserting a file header listing all the functions and procedures
        in the file and a function header preceding each function and
        procedure listing all the other functions which call or are
        called by this function, lists the parameters and provides space
        for the programmer to insert comments for each parameter and to
        state the function's purpose, output and assumptions.  These
        programmer comments in the headers are supported by DOC in that
        each time DOC documents your source code it saves any existing
        comments and reinserts them in the new header.  DOC saves the
        name of the parameter with the parameter comments so that even if
        the parameter order has been changed DOC will keep the comment
        with the correct parameter.

        DOC now allows you to configure the appearance of the function
        headers.

        DOC can also send your source code files to the printer, or print
        to disk.  The printed source code files have page headers insert-
        ed at the top of each page and a Table of Contents, listing the
        page on which each function and parameter starts.  DOC can op-
        tionally also insert line numbers in printed source code files.
        DOC will optionally also create an action diagram for each source
        code file with lines marking the program control structures.  The
        printed action diagrams also have page headers, Table of Contents
        and, optionally, line numbers inserted.

        DOC can create a list of source code files to be documented
        automatically from a make file or any ASCII text file in which
        the names of the source code files appear.  Clipper library
        functions and other functions can be listed in KEY files, identi-
        fying them to DOC.  For each KEY file you can tell DOC whether or
        not the functions in that library should be listed in the headers
        and reports.  DOC can also change the capitalization in your
        source code of the name of functions listed in the key files.
        Capitalization choices are all lower case, all upper case, first
        letter capitalized or case changed to match the capitalization in
        the Key File.

        DOC optionally also creates a Function and Procedure Report
        listing each function and procedure in the source code files in
        either alphabetical or order read or both.  Each function and
        procedure is listed with a list of functions called, the func-
        tion's parameters and comments and the other programmers com-
        ments.

        DOC can optionally create a Cross Reference Report listing every
        word found in the source code.  The report lists the source code
        file, function name and line number for each occurrence of the
        word.  Optionally DOC will include or omit function names listed


                                        3




        in the key files.

        DOC can optionally create a database and index file report for
        every database and index file explicitly named in a USE or INDEX
        command (or in a * SNAPCODE comment) or passed explicitly to a
        user-defined open database function, that it can find on disk,
        listing for each DBF file its structure and the index files
        associated with it and for the index file the index key expres-
        sion.  DOC also creates an include file for each dbf file with
        handy preprocessor defines of the field names for scatter and
        gathering to an array and a structure array for creating the
        database using dbcreate() when it does not exist.

        DOC creates a report, called STAT.DOC, which lists the number of
        lines of code, the number of lines of DOC created headers, total
        lines and number of functions in each source code file and totals
        for all the source code files.

        DOC optionally creates a Index and a Table of Contents document
        listing all the functions and procedures in the system with the
        page number and name of the name of the source code file for
        each.  The Index document lists the functions and procedures in
        alphabetical order and the Table of Contents lists them in the
        order read.

        DOC, in conjunction with a Norton guide compiler and linker such
        as those that are supplied with Expert Help, can create a Norton
        Guide database for all the functions and procedures in the system
        using the parameter list for the syntax and the programmer's
        comments for the text.  DOC creates NGC compile files, the NGL
        link file and a batch file which, when run, automatically com-
        piles and links the guide.  DOC supports creating multiple func-
        tion lists within a Norton Guide Database and also See Also:
        references.























                                        4





                                   CHAPTER II
                     Running DOC and Command Line Parameters

        A. DOCPATH Environmental Variable
          DOC creates a number of temporary databases while it is proc-
        essing which it erases before terminating.  DOC looks for an
        environmental variable named DocPath.  If found it creates its
        temporary files in the drive and directory specified by this
        variable.  If there is no DocPath in the environment it looks for
        an environmental variable named TEMP and uses the drive and
        directory specified by it.  If it finds neither it uses the
        current DOS directory for its temporary files.
          If you have a RAM drive that is big enough (2 or 3 MBytes
        should be big enough if you are not documenting a HUGE applica-
        tion) set DocPath to it.  Otherwise, it would be good to specify
        a directory where you have no permanent files to avoid any possi-
        bility of a name collision.

        B. RUNNING DOC
          If the file DOC.EXE resides in a directory in your path you can
        invoke DOC from any DOS prompt.  There are four command line
        parameters which DOC understands.

                       DOC [-M] [-S<path>] [-C<name>] [-G]

        C. THE -M PARAMETER
           When DOC is started it queries the hardware (using Force's
        ISCOLOR function) to determine whether the computer has a color
        monitor and sets the screen colors accordingly.  The -M command
        line parameter forces DOC to use monochrome screen colors even if
        it detects a color monitor.  Use this parameter on computers
        which simulate a color screen using shades of gray if this makes
        DOC's screens difficult to read.

        D. THE -S PARAMETER
          This command sets the Make File and Source Code Path (the
        directory containing the configuration file and the make file) to
        <path>.  If DOC is being used interactively, (i.e. the -G command
        line parameter is not being used) the Make File and Source Code
        path can also be specified on the Enter System Variable screen.
        See the Enter System Variable section of this manual for more
        information about the Make File and Source Code Path.


        E. THE -C PARAMETER
          This command sets the Configuration File name to something
        other than the default CONFIG.DOC.  If several programming
        projects share a source code directory only one of them can use
        the default name of CONFIG.DOC for its configuration file and the
        others must specify a different name whenever DOC is started.  If
        DOC is being used interactively, (i.e. the -G command line param-
        eter is not being used) the Configuration File name can also be
        specified on the Enter System Variable screen. See the Enter
        System Variable section of this manual for more information about


                                        5




        the Configuration File name.


        F. THE -G PARAMETER
           This command causes DOC to skip the menus and start document-
        ing.  This can only be done successfully when DOC has been run at
        least once interactively and the menus and input screens have
        been used to create a Configuration File for the particular
        programming project to be documented including the list of source
        code files.  Once the configuration is set and the user is satis-
        fied with the way DOC is documenting that set of source code
        files (i.e. no more changes need to be made to the configuration)
        then DOC can be invoked with the -G parameter so that the menus
        are skipped and DOC immediately begins documenting.


        G. EXAMPLES OF USE OF COMMAND LINE PARAMETERS
           The following line in a batch or make file:

                  DOC -sD:\CLIPPER5\SOURCE\MYAPP -cMYAPP.CFG -g

        would run DOC unattended assuming there was a DOC configuration
        file named MYAPP.CFG in the directory D:\CLIPPER5\SOURCE\MYAPP.
        The following lines in a batch file:

                 D:
                 CD \CLIPPER5\SOURCE\MYAPP
                 DOC -G

        would run DOC unattended assuming there was a DOC configuration
        file named CONFIG.DOC in directory D:\CLIPPER5\SOURCE\MYAPP.


























                                        6





                                   CHAPTER III
                             Enter System Variables


        A. MAKE FILE AND SOURCE CODE PATH
          The Make File and Source Code Path is the directory in which
        DOC looks for source code files which are listed without a path,
        where it looks for the make file and in which it creates and from
        which it reads the Configuration File.  If this variable is left
        blank the current DOS directory is the Make File and Source Code
        Path.


        B. CONFIGURATION FILE NAME
          If this variable is left blank DOC uses the default name of
        CONFIG.DOC.  If there already is a file with this name or you
        want more than one configuration of DOC with the same Make File
        and Source Code Path you must specify another name.  DOC stores
        all variables set through the menus in the Configuration File.

          When DOC is run interactively, after prompting the user for the
        Make File and Source Code Path and the Configuration File name,
        if a configuration file with the specified name in the specified
        directory exists, it is read and all variables are set as they
        were when that configuration was last saved.  If no configuration
        file already exists the system variables are set to default
        values.


        C. MAKE FILE NAME
          Type in the name of the make file, or an ASCII text file con-
        taining the names of the source code files for the programming
        project to be documented, if one exists.  The file must be in the
        Source Code directory and if no extension is specified an exten-
        sion of RMK is assumed.  If the file name has no extension put a
        period at the end of the name.


        D. NAME OF APPLICATION, AUTHOR and COPYRIGHT HOLDER
          The data typed in these 3 fields will be used in the file
        headers DOC creates for all output source code files and reports.


        E. OUTPUT FILE PATH
          Specify a directory where the output source code files, action
        diagrams, reports and print to disk files will be created.  This
        must be different than the Source Code Path or other directories
        where input source code files reside or there will be name con-
        flicts between the input and output files.


        F. KEY FILE PATH
          The drive and directory where DOC expects to find the key files
        specified in the key file list.


                                        7






        G. DATABASE PATH
           When DOC finds USE and INDEX statements in the source code it
        tries to open the referenced database and index files to document
        their structure and index expressions.  If the database and index
        file names do not include a path DOC will look for the files in
        the directory named here or in the default DOS directory if this
        parameter is left blank.

        G. NAME OF OPEN DATABASE FUNCTION
          If the name of a function is entered here DOC will look for a
        database name in quotes passed as a parameter to that function
        whenever it finds that function in the source code. If the data-
        base can be found its structure will be documented in the
        DBF_NTX.DOC report and the DATADICT.DBF database.

        I. EXITING THE SYSTEM DATA INPUT SCREEN
           Press the ESC key when finished inputting data.  The Main Menu
        screen will appear.





































                                        8





                                   CHAPTER IV
                                  FILES SubMenu

        A. SYSTEM DATA <F1>
           Pressing F1 brings up the System Data screen again.


        B. KEY FILE LIST <F8>
           Selecting this option places you in the Key File Names, Doc
        Names and Capitalization screen.  Type in the names of your key
        files including extension.  DOC will assume these files are in
        the key file directory specified on the System Data screen.
           If you leave the Doc Name column blank the functions listed in
        that key file will be ignored by DOC.  If you type in a Doc Name
        the functions in that key file will included in the file headers
        and reports and will be listed as being "from" that Doc Name.
           If you type a "L", "U", "F" or "K" in the Cap column then any
        words in your source code which match a word in that Key File
        will be capitalized (or uncapitalized) as specified :
                L - all lower case
                U - all upper case
                F - first letter capitalized, rest lower case
                K - capitalized the same as function name in the key
        file.
        *** WARNING *** If you are using the case sensitive feature of
        the #define pre-processor directive be careful when using this
        feature.
           Press ENTER to be editing on the current line.  Press the down
        arrow key to add a new line.  Press the ESC key when done.


        C. FROM MAKE FILE <F2>
           Selecting this option causes DOC to read the make file and
        extract the names of all files with an extension of PRG or SCR
        which it finds and creates the List of Files to be Documented.


        D. EDIT FILE LIST <F3>
           When you select this option you can edit the List of Files to
        be Documented.  To add new source code file names use the down
        arrow key to move to a blank line and type in the name.  Press
        the DEL key to delete an existing name.  Be sure to specify a
        path for any source code files which are not in the Source Code
        Path drive and directory.  Press ESC key when done.












                                        9





                                    CHAPTER V
                                 OUTPUT SubMenu

        A. SOURCE CODE <F4>
            When this option is selected a screen pops up with the fol-
        lowing options.  On questions with non-numeric answers toggle
        through the options by pressing any keys other than the arrow
        keys.  Use the up and down arrow keys to move the cursor.  Press
        the ESC key when done.

         1.) Write SourceCode files to output path   YES/NO
        If YES, each source code file in the File List is rewritten to
        the Output Directory with headers inserted and indented.

         2.) Print Source Code files                 YES/NO
        If YES, each source code file is sent to a printer port or a disk
        file with headers inserted, indented, page breaks and headers and
        a Table of Contents.

         3.) Send Printed Source Code to   LPT1/LPT2/LPT3/COM1/COM2/FILE
        If FILE, the Source Code files are printed to a file with an
        extension of *.PRN in the output directory.  Otherwise the print-
        ed source code is sent to the printer port selected.

         4.) Line numbers in printed source code       YES/NO
        If YES, line numbers are inserted at the beginning of each line
        of the printed file.

         5.) Write action diagrams to output path       YES/NO
        If YES, each source code file is rewritten to the Output Directo-
        ry with an extension .ACT, headers, indenting and lines marking
        the program control structures.

         6.) Print action diagrams                      YES/NO
        If YES, each action diagrams is sent to a printer port or printed
        to disk with page breaks, headers and a Table of Contents.

         7.) Send Printed Action diagrams to  LPT1/LPT2/.../COM2/FILE
        If FILE, the action diagrams are printed to files in the output
        directory with an extension of .APN.  Otherwise they are sent to
        the selected printer port.

         8.) Line numbers in printed action diagrams     YES/NO
        If YES, line numbers are inserted at the beginning of each line
        in the printed action diagrams.

         9.) Use graphics in action diagrams             YES/NO
        If YES, IBM upper ASCII box-drawing characters are used to mark
        the control structures in action diagrams.  If your printer
        cannot print these characters properly select NO.

         10.) Final page eject in printed output           YES/NO
        If NO, the page eject on the final page of printed output is
        omitted.  This avoids extra blank pages when using utilities such


                                        10




        as LJBOOK after printing to disk.

         11.) Indent continued lines 1 level              YES/NO
        If NO, DOC indents continued lines (lines following a line ending
        with a semicolon) the same amount as the line was indented origi-
        nally or the normal control level indent  -- whichever is a
        larger indent.  If YES, DOC indents continued lines one extra
        level in, irregardless of the original indent.

         12.) Spaces to indent comment lines        [Numeric input]
        Number of spaces to indent file and function headers created by
        DOC.  If you want only FUNCTION and PROCEDURE declaration lines
        to start in Column 0 in your source code enter a number other
        than 0 here.

         13.) Indent #if, #else, #endif                     YES/NO
        If YES, #if #else and #endif are treated the same as IF, ELSE and
        ENDIF in terms of indenting and in the action diagrams.  If NO,
        they are not treated as program control structures.

         14.) Number of char/line in printer output   [Numeric input]
        Number of characters per line your printer can handle.  Lines
        longer than this a counted as 2 lines in determining page breaks.

         15.) Number of lines/page in printer output   [Numeric input]
        Used when printing source code files, action diagrams or in
        reports to determine where page breaks occur.

         16.) Number of spaces to indent per level    [Numeric input]
        Number of spaces to indent each control level.

         17.) Create file and function headers                 YES/NO
        If YES, DOC inserts file headers at the begining of each source
        code file and Action Diagram and function headers before each
        function, as configured in the ENTER FUNCTION HEADERS MENU.  If
        NO, DOC does not insert the function and file headers.  In either
        case DOC removes any existing headers which match the READ param-
        eters in the ENTER FUNCTION HEADERS MENU.

         18.) (O)verwrite, (A)bort, enter (N)ew name or
             (R)ename existing file if already exists       O/A/N/R
        Determines what DOC does when it is about to create a file in the
        Output directory and it discovers a file with the same name
        already there.  If O, it ignores the problem and overwrites the
        existing file.  If A, it aborts processing.  If N, it prompts the
        user for a new name for the file it is about to create.  If R, it
        prompts the user for a new name for the existing file.


        B. REPORTS <F5>
          When this option is selected the user is presented with a
        screen containing the following options:

         1.) Send printed reports to     LPT1/LPT2/LPT3/COM1/COM2/FILE
        Determines where the reports are sent.


                                        11





         2.) Create Data Dictionary and CH files            YES/NO
        If YES, creates a Data Dictionary data base and a report for all
        the databases and indexes it finds in the Source Code directory
        which are referred to the source code.  It also creates a CH
        include file with some handy preprocessor defines for each data-
        base.

         3.) Create Index and TOC listing of functions      YES/NO
        If YES, creates reports listing every function and procedure, the
        source code file name in which it was found and the page number
        in the source code where it starts.  (If neither source code
        files or action diagrams are printed no page numbers are created
        and all page numbers will be 0.)  The Index and Table of Contents
        are identical except for the order in which the functions appear.

         4.) Create Function report in read order            YES/NO
        This is a report which lists all the functions and procedures in
        the application along with all the information from its header,
        source code, line number and source code file name.

         5.) Create Function report in alpha order            YES/NO
        Same as above except the functions and procedures are listed in
        alphabetical order.

         6.) Create Cross Reference Report                   YES/NO
        This is a report which lists all the words in the source code,
        listing for each one the source code file, function and line
        number of each occurrence.  Enabling this report significantly
        increases DOC's processing time and the space needed on the disc
        for the DOC's temporary files.

         7.) Cross Reference Key Functions                   YES/NO
        If this is disabled DOC ignores function names listed in the key
        files when creating the Cross Reference Report.


        C. ENTER FUNCTION HEADERS

         1.) The Enter Function Headers Input Screen
        The input screen looks like this:

                     Enter Function Header Options

          (Read) Purpose Heading           "   Purpose :"
          (Write) Purpose Heading          "   Purpose :"
          (Read) Out Heading               "   Out     :"
          (Write) Out Heading              "   Out     :"
          (Read) Comment 1 Heading         "   Assumes :"
          (Write) Comment 1 Heading        "   Assumes :"
          (Read) Comment 2 Heading         "   Author  :"
          (Write) Comment 2 Heading        "   Author  :"
          (Read) See Also Heading          "  See Also :"
          (Write) See Also Heading         "  See Also :"
          (Read) Ngo File Heading          "   NgoFile :"


                                        12




          (Write) Ngo File Heading         "   NgoFile :"
          (Read) First Header line         "*!*********************"
          (Write) First Header line        "*!*************************************"
          (Read) Last Header line          "*!*********************"
          (Write) Last Header line         "*!*************************************"
          (Read) Header left edge          "*!   "
          (Write) Header left edge         "*!   "
          Blank lines between sections       "Y"


         2.) The Read and Write Variables.
           The (Read) variables are used when DOC is extracting program-
        mer comments from the code it is reading.  The (Write) variables
        determine how the headers look in the output code, action dia-
        grams, function reports and Norton Guides.  Therefore, if you
        have programmer comments in DOC created headers that you want to
        retain you need to set the (Read) variables the way the matching
        (Write) variables were set the last time DOC was run.

         3.) Examples
          For example, if you wish your headers to look like this :
        /* -------------------------
        |     Function Main
        |  Calls : MyFunc()
        |        : MyFunc2()
        | Overview : This is the main menu routine  Sets defaults.
        |            Sets screen color defaults based on ISCOLOR()
        |            unless given a B/W command line parameter.
        | In       : Param1 - first command line parameter.
        |          : Param2 - second command line parameter.
        | Returns  : Nothing
        | Comments : Expects MYDATA.DBF to be in the default directory.
        -------------------------- */

          and the code contains these comments in a header created by a
        previous version of DOC you would set the variables like this:

          (Read) Purpose Heading           "   Purpose :"
          (Write) Purpose Heading          "  Overview :"
          (Read) Out Heading               "   Out     :"
          (Write) Out Heading              "   Returns :"
          (Read) Comment 1 Heading         "   Assumes :"
          (Write) Comment 1 Heading        "  Comments :"
          (Read) Comment 2 Heading         "           :"
          (Write) Comment 2 Heading        "           :"
          (Read) See Also Heading          "           :"
          (Write) See Also Heading         "           :"
          (Read) Ngo File Heading          "           :"
          (Write) Ngo File Heading         "           :"
          (Read) First Header line         "*!************"
          (Write) First Header line        "/* ---------------------------"
          (Read) Last Header line          "*!************"
          (Write) Last Header line         "---------------------------- */"
          (Read) Header left edge          "*!   "
          (Write) Header left edge         "|    "


                                        13




          Blank lines between sections       "N"


        If the next time you run DOC you have changed your mind and you
        want the headers to look like this:

        /* =======================
        ||
        ||     Function Main
        ||
        ||  Calls : MyFunc()
        ||        : MyFunc2()
        ||
        || Overview : This is the main menu routine  Sets defaults.
        ||            Sets screen color defaults based on ISCOLOR()
        ||            unless given a B/W command line parameter.
        ||
        || In       : Param1 - first command line parameter.
        ||          : Param2 - second command line parameter.
        ||
        || Returns  : Nothing
        ||
        || Comments : Expects MYDATA.DBF to be in the default directory.
        ||
        ============================ */

         you would set the variables like this:

          (Read) Purpose Heading           "  Overview :"
          (Write) Purpose Heading          "  Overview :"
          (Read) Out Heading               "   Returns :"
          (Write) Out Heading              "   Returns :"
          (Read) Comment 1 Heading         "  Comments :"
          (Write) Comment 1 Heading        "  Comments :"
          (Read) Comment 2 Heading         "           :"
          (Write) Comment 2 Heading        "           :"
          (Read) See Also Heading          "           :"
          (Write) See Also Heading         "           :"
          (Read) Ngo File Heading          "           :"
          (Write) Ngo File Heading         "           :"
          (Read) First Header line         "/* -----------"
          (Write) First Header line        "/* ============================"
          (Read) Last Header line          "--------------"
          (Write) Last Header line         "============================ */"
          (Read) Header left edge          "|   "
          (Write) Header left edge         "||   "
          Blank lines between sections       "Y"


         4.) The First and Last Header line variables.
          You must make absolutely sure that no other lines in you code
        match the First and Last Header line variables.  You also must be
        aware that if you do not have the "(Read) Purpose Heading" varia-
        ble set correctly, (it does not match the existing headers ) DOC
        will not find you comments and that if you do not have the


                                        14




        "(Read) Last Header Line" variable set correctly DOC will treat
        your entire source code like a comment and not document anything
        [this does, however, speed up the processing <g>].

         5.) Leading and trailing spaces
          DOC rtrims these variables so spaces on the left are signifi-
        cant, but spaces on the right are ignored.

         6.) See Also and Ngo File Headings
            Any programmer's comments placed in See Also and NGO file
        sections of the function headers have special meanings to DOC
        when it creates the Norton Guide database. If a Norton Guide
        database is not to be created then these sections can be retitled
        and used for something else, such as "History :" or "Changes :".
           See the chapter on Norton Guide Database creation for more
        information on how DOC uses the programmer's comments typed into
        these sections of the function headers.



        D. NORTON GUIDE CREATION INPUT SCREEN

         1.) The input screen looks like this:

           Long Name     "My Personal Library                "
           Norton Guide Short Name                  "mylib   "
           Default NGO File                         "MISC    "
           Norton Guide Compile File Extension           "NGC"
           Norton Guide Object File Extension            "NGO"
           Norton Guide Link File Extension              "NGL"
           Command to invoke Norton Guide compiler
            " NGC                                            "
           Command to invoke Norton Guide linker
            " NGML                                           "

         2.)  Norton Guide Long Name
          Whatever is entered here is written as the !name parameter in
        the link file.  This is the name of the Norton Guide Database
        created from this application. It defaults to the name of the
        application as entered in the System Data menu.

         3.) Norton Guide Short Name
          This must be a valid DOS base file name of up to 8 characters.
        This will be the base file name of the link file and the *.NG
        file.  It defaults to the base name of the make file entered in
        the System Data menu.

         4.) Default NGO file
          The object file for any functions for which no NGO file was
        specified either in the header or by means of a NGOFile comment.
        If left blank, functions without a NGO file specified either
        through a NGOFILE comment or an entry in the NgoFile: section of
        the function header will not be included in the Norton Guide.

         5.) Norton Guide Compile File Extension


                                        15




          If you are using Expert Help you may wish to change this to
        "EHC".

         6.) Norton Guide Object File Extension
          If you are using a version of the Expert Help linker which ex-
        pects object files to have an extension of "EHO" you must enter
        that here.

         7.) Norton Guide Link File Extension
          If you are using Expert Help you may wish to change this to
        "EHL".

         8.) Commands to invoke compiler and linker
           If your Norton Guide Compiler and Linker are not in a directo-
        ry in the DOS path you must enter their full path names here.
        These will be used in the batch file, named MAKENG.BAT, that DOC
        creates to automatically compile and link the Norton Guide data-
        base.







































                                        16






                                   CHAPTER VI
                         NORTON GUIDE DATABASE CREATION

        A.  DESIGNING THE NORTON GUIDE DATABASE
          The Ngo File parameter in the headers allows the programmer to
        set up multiple function lists and menus in the Norton Guide
        database created by DOC. The way it works is if the user wants
        the Norton Guide create by DOC to list the functions in multiple
        lists selected from a menu rather than the default of all the
        functions in one big list then the user needs to do some plan-
        ning.

         1. Divide up all the functions in the application into a number
        of groups.

         2. For each group select a menu name and a Ngo File name. The
        Ngo File name must be a valid DOS base file name of up to 8
        characters.

         3. Label each function with the Ngo File name of the group to
        which it belongs. This can be done either by typing it into the
        function header created by DOC following the Ngo File : prompt or
        by using a NgoFile comment line.  You can place NgoFile comments
        anywhere in your source code except inside function or file
        headers.  These comment lines must start with *, // or && (not
        /* ... */ style comments).  The first word must be NGOFILE fol-
        lowed by a valid, up to 8 character, DOS base file name.  All the
        functions following that line (until the next NgoFile comment or
        the end of the source code file) that do not have a group (Ngo
        File name) specified in the function header will be assigned to
        that function group.

         4. When DOC is next run it will create a separate .NGC (or .EHC)
        file for each Ngo File name and will create the lines in the
        MAKENG.BAT file to compile them.


        B. NORTON GUIDE DATABASE LINK FILE CREATION
           DOC also creates a Norton Guide Database Link file with a
        default menu structure. This link file can be used as is, or the
        programmer can edit it with a text editor to change the menu
        wording or organization if desired before running the MAKENG
        batch file to compile and link the Norton Guide database.

          For example: if you have put references to the following Ngo-
        Files in your source code : ARRAY, BROWSE, COLOR, DATABASE,
        DISPLAY, DRIVPATH, MENU, PRINTER, STRING and you specified MISC
        as the default NgoFile, you have accepted NGO as the object file
        extension, and "My Personal Library" as the Long Name, then DOC
        will create the following link file:

             !name: My Personal Library
             !menu: Functions1


                                        17




                   ARRAY   ARRAY.NGO
                   BROWSE   BROWSE.NGO
                   COLOR    COLOR.NGO
                   DATABASE   DATABASE.NGO
                   DISPLAY   DISPLAY.NGO
             !menu: Functions2
                   DRIVPATH   DRIVPATH.NGO
                   MENU   MENU.NGO
                   MISC   MISC.NGO
                   PRINTER   PRINTER.NGO
                   STRING   STRING.NGO

        You must not change the object file names but you can rearrange
        the lines, change the !menu: names and the menu names for the
        object files.  For example you could make the following changes
        before running MAKENG.BAT.

             !name: My Personal Library
             !menu: User Interface
                   BROWSE      BROWSE.NGO
                   SCREEN COLOR  COLOR.NGO
                   DISPLAY     DISPLAY.NGO
                   MENU        MENU.NGO
             !menu: Array & DBF
                   ARRAY       ARRAY.NGO
                   DATABASE    DATABASE.NGO
             !menu: DOS, Print & Misc
                   DRIVE/PATH  DRIVPATH.NGO
                   MISC        MISC.NGO
                   PRINTER     PRINTER.NGO
                   STRING      STRING.NGO


        C. SEE ALSO REFERENCES
          When creating the Norton Guide Database entry for a function,
        if DOC finds one or more function names in the See Also section
        of the function header it creates a "See Also" or "Related Top-
        ics" reference from that entry to the specified other entries in
        the database.


















                                        18





                                   CHAPTER VII
                           WRITE, GO and EXIT SubMenus

        A. WRITE SUBMENU
         1.) Read Configuration <F6>
        When you select this option DOC tries to read in a previously
        created Configuration File from the currently specified Source
        Code Directory.  If another name was not specified on the System
        Data Input Screen it looks for a file called "CONFIG.DOC".  If it
        finds the file it reads it in, over-writing any existing entries.
        The configuration data includes all user input including the data
        in the System Data screen, Output Data screen, Source Code File
        List and Key File List.

         2.) Write Configuration <F7>
        When you select this option DOC saves all the Configuration Data
        to a file in the current Source Code directory with the name
        "CONFIG.DOC" or other name as specified by the Configuration File
        name in System Data screen.  If you do not do this before telling
        DOC to "GO" (since it exits to DOS when it finishes documenting)
        or exiting DOC the configuration you created will be lost and you
        will have to recreate it if you ever want to document this par-
        ticular set of source code files again.


        B. GO SUBMENU
          Start Documenting <F9>
        When the F9 key is pressed DOC starts documenting the source code
        files in the Files To Be Documented List using the current set-
        tings.  You can abort by pressing the ESC key.


        C. EXIT SUBMENU
         1.) Go Back <Alt G>
        Go back to the Main Menu Screen.  Don't exit.

         2.) Quit <F10>
        Exits to DOS without documenting the source code.


















                                        19





                                  CHAPTER VIII
                              THE SNAPCODE COMMENT

          Often in Clipper 5.x code a function is called or a database or
        index is opened through a code block, macro or extended expres-
        sion rather than the explicit way that DOC understands.  In these
        cases DOC will not document the call, database or index.  To get
        around this problem DOC allows the programmer to use a special
        comment that DOC will treat like code so that it will document
        things the way the programmer likes.  As a convience to people
        who have ever used both SNAP and DOC, the author of SNAP, Walter
        Kennamer (who is an all round dynamite fellow), suggested that
        DOC use the same syntax that SNAP uses for this purpose.

          In DOC a SNAPCODE comment is one that starts with * or // or &&
        (not a /* ... */ comment) and is not within a file or function
        header and the first word is SNAPCODE.  Whatever follows SNAPCODE
        is treated by DOC as if it were a regular code line.

        EXAMPLES OF SNAPCODE USE

             cDBFName := PickFromList()
             USE ( cDBFName )
             * SNAPCODE USE People
             * SNAPCODE USE Places
             * SNAPCODE USE Things


             bCodeBlock := iif( lSomething, {|| myfunc1() }, ;
                                            {|| myfunc2() } )
             AnotherFunc( bCodeBlock )
             .....
             ... < inside AnotherFunc() >
             EVAL( bCodeBlock )
             // SNAPCODE myfunc1(), myfunc2()





















                                        20


