

/*
 * File......   : MKDIRS.c
 * Author....   : Peter Kulek
 * Date......   : $Date:   06 Jan 1991  $
 * Revision..   : $Revision:   1.0  $
 * Log file..   : $Logfile:   c:\impala5\c\mkdirs.c  $
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * Copyright (c) 1991  Peter Kulek 
 * You can use this code as you please but please keep 
 * copyright notice in code.
 *
 * compile with MSC 6
 * Modification history:
 * ---------------------
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     MKDIRS()
 *  $CATEGORY$
 *     DOS
 *  $ONELINER$
 *     Build multi-level directories in a single call
 *  $SYNTAX$
 *     MKDIRS(cPath) -> nVal
 *  $ARGUMENTS$
 *     <cPath>       Drive and Path to build
 *  $RETURNS$
 *     <nVal>        Dos error value
 *
 *  $DESCRIPTION$
 *      This function builds a multi-level directory in a single call
 *      If the path already exists or an invalid path is specified 
 *      nothing will be built.
 *  $EXAMPLES$
 *      cFileName := '\bum\ti\ti\bum\ti\ti\bum\ti.bum'
 *      if ! file(cFilename) // Check For Filename
 *           MKDIRS(pathsplit(cFileName,2)) // Get path From File
 *      endif
 *      copy something to cFileName or whatever
 *
 *  $END$
 */

int mkdir ( char *);
int mkdirs( char *);
extern int strlen( char *); // avaiable in clipper 

#define OR ||
 
#include "extend.h"

// Clipper versions
CLIPPER MKDIRS() {  // Build multi-level directories
     _retni(-1);    
     if ISCHAR(1)
         _retni( mkdirs(_parc(1)) );
}
CLIPPER MKDIR() {  // Build single directory
     _retni(-1);    
     if ISCHAR(1)
         _retni( mkdir(_parc(1)) );
}

// c Versions 
int mkdirs( char *path){
      int retval = -1 ;
      int i = 0;
      char subpath[128] = "";
      while ( i < strlen(path)+1 ) {
          if (path[i] == '\\' OR path[i] == '/' OR path[i] == '\0') 
              retval = mkdir(subpath) ;
          subpath[i] = path[i] ;
          i++ ;
      }
      return(retval);
}

int mkdir ( char *path){
   int iRetVal;
   _asm {
           push dx
           push ds
           mov ah, 0x39
           lds dx, [path]
           int 21h
           mov iRetVal,0
           jnc mkdir1
           mov iRetVal,AX
       mkdir1:
           pop ds
           pop dx  
   } 
   return(iRetVal) ;
}


