// DBFDir
//
// Author : ShaunB..  (Shaun Botha [CI$ 70043,2641])
// Purpose: Emulate DOS's DIR command but with special handling for DBF files -
//          show lastRec() and fcount() for each DBF file
// Compile: Clipper DBFDIR /n/m/w
// Link   : Blinker / RTLink fi DBFDIR
// Notes  : This is 'fame-ware' - copy as much as you want, modify all you want,
//          distribute all you want.  Just include my name as the original
//          author.

#include "directry.ch"

procedure main(cSpec, cSwitch)
	local aFiles, x
	local cBase, cExt, cSize, cDate, cTime, nTotSize
	local dLUpd, nRecs, lPaged, nRows, lAborted

	// Fix our parameters
	if cSpec != nil
		cSpec := upper(cSpec)
	endif
	if cSwitch != nil
		cSwitch := upper(cSwitch)
	else
		cSwitch := ""
	endif

	// Determine whether display is to be paged
	lPaged := .f.
	if cSpec == "/P"
		lPaged := .t.
		cSpec := ""
		cSwitch := ""
	endif
	if cSwitch == "/P"
		lPaged := .t.
	endif

	// Default to "*.*"
	if empty(cSpec)
		cSpec := "*.*"
	endif

	// Just some blurb
	? "DBFDIR v1.0 (c) 1993 ShaunB.."
	?

	if cSpec == "/?"
		? "Displays a directory similar to that of DOS's DIR command.  In addition"
		? "the program will display the number of records and fields in a dBase file."
		?
		? "Note: This program does not support path names in DBF files (yet)."
		?
		? "usage: DBFDIR [file_spec] [/P]"
		?
		quit
	endif

	?


	lAborted := .f.
	errorBlock({|e| doBreak(e) })				// Post a basic error handler
	aFiles := directory(cSpec, "HSD")      // Get all files
	nRows    := 0                          // Initialize row count for pages

	// Figure total size of files
	nTotSize := 0
	aeval(aFiles, {|f| nTotSize += f[F_SIZE] })

	for x := 1 to len(aFiles)
		if inkey() == 27
			lAborted := .t.
			exit
		endif

		nRows++
		cBase := cExt := ""                 // Init these vars

		// Treat directories differently to 'normal' files
		if at("D", aFiles[x, F_ATTR]) != 0
			cSize := padr("<DIR>", 8)
			cBase := aFiles[x, F_NAME]
		else
			if at(".", aFiles[x, F_NAME]) != 0
				cBase := left(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])-1)
				cExt  := substr(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])+1)
			else
				cBase := aFiles[x, F_NAME]
			endif
			cSize := ltrim(str(aFiles[x, F_SIZE]))
			cSize := padl(cSize, 8)
		endif

		// Get date and time - convert time to look like DOS
		cDate := dtoc(aFiles[x, F_DATE])
		cTime := left(aFiles[x, F_TIME], 5) + iif(val(left(aFiles[x, F_TIME], 2)) < 12, "a", "p")

		// Show the info
		if lPaged
			if nRows > maxRow()
				?? "Press any key to continue or [Esc] to quit"
				if inkey(0) == 27
					lAborted := .t.
					?
					exit
				endif
				?
				nRows := 0
			endif
		endif
		?? padr(cBase, 9), padr(cExt, 3), cSize, cDate, cTime

		// If this is a DBF file then show some extra info
		if at(".DBF", aFiles[x, F_NAME]) != 0
			begin sequence
				use (aFiles[x, F_NAME]) new shared
				?? "..." + padl(ltrim(str(lastRec())),8,".") + " Records    " + padl(ltrim(str(fcount())),4)+" Fields"
				use
			recover
				// More than likely caused by the current directory not being the
				// one where the DBF is located
				?? "..Could not open file"
			end sequence
		endif
		?
	next x

	// Show some summary info
	if lAborted
		? "*Process aborted*"
	endif
	? padl(ltrim(str(len(aFiles))), 10) + " file(s) " + padl(ltrim(str(nTotSize)),8) + " bytes used"
return


// This is not exactly a great error handler but it does the job
procedure doBreak(e)
	break e
return
