///////////////////////////
// ClipBtn Order Program //
///////////////////////////

#include "inkey.ch"
#include "setcurs.ch"
#include "set.ch"

#include "ClipBtn.ch"

#define PRICE_PER_UNIT 30.00

#define USA_SNH 5.00
#define USA_SNH_STR ALLTRIM(STR(USA_SNH))

#define CANADA_SNH 10.00
#define CANADA_SNH_STR ALLTRIM(STR(CANADA_SNH))

#define FOREIGN_SNH 20.00
#define FOREIGN_SNH_STR ALLTRIM(STR(FOREIGN_SNH))

#define PRICE_STR       (ALLTRIM(STR(PRICE_PER_UNIT)))

#define SINGLE_BORDER 1
#define DOUBLE_BORDER 2

#define CLEAR_BOX_AREA .T.
#define CR ( CHR(13) + CHR(10) )

#define DEFAULT(x, y) IIF(x == NIL .OR. ( EMPTY( x ) .AND. VALTYPE(x) != "L" ), x:= y, )

#define ATTR_CONV(FORE, BACK) (BACK) * 16 + (FORE)

#define BLACK                                    0
#define BLUE                                             1
#define WHITE                                            7
#define GRAY                                             8

#define COL_DEFAULT_SHADOW              ATTR_CONV(GRAY, BLACK)
#define MON_DEFAULT_SHADOW              ATTR_CONV(WHITE, BLACK)

PROCEDURE ClipBtnOrder()
// Temp Vars for Input Sample (*Note:  Memo Var must be declared as Private)
LOCAL   cLastName, cFirstName, cMI, cCompany, cAddress1, cAddress2, cCity, ;
				cState, cZipCode, cCountry, cTelephone, nQty, nSalesTax, nTotal,;
				cPaymentType, nPaymentType, nSnH, nSubTotal,;
				TmpMem := "", cClipperVer

PRIVATE cDosScreen := SAVESCREEN(0, 0, 24, 79), ;
				nDosRow := ROW(), nDosCol := COL()

	SET SCOREBOARD OFF

	CLEAR SCREEN

	// Fill the background with a dark blue
	CB_FillScreen(0, 0, 24, 79, CHR(177), ATTR_CONV(BLUE, BLACK))

	cLastName                       := SPACE(25)
	cFirstName                      := SPACE(25)
	cMI                             := SPACE(4)
	cCompany                        := SPACE(45)
	cAddress1                       := SPACE(30)
	cAddress2                       := SPACE(30)
	cCity                           := SPACE(25)
	cState                          := SPACE(15)
	cZipCode                        := SPACE(10)
	cCountry                        := PADR("USA", 30)
	cTelephone                      := SPACE(13)
	nQty                            := 1
	nSalesTax                       := 0.00
	nSnH                            := USA_SNH
	nSubTotal                       := ROUND(nQty * PRICE_PER_UNIT, 2)
	nTotal                          := nSubTotal + nSnH + nSalesTax
	nPaymentType                    := 1
	cClipperVer                     := PADR("5.01", 7)

	lOk 			:= .F.
	lCancel 	:= .F.
	lPrinter 	:= .F.
	lOrderDoc := .F.

	DO WHILE .T.

		// Set Basic Colors
		SET COLOR TO "W+/B"

		// Draw Box Around Data Entry Fields
		CB_Box(1, 3, 22, 75, DOUBLE_BORDER, .T., " ClipButton Order Program ", ;
					 CLEAR_BOX_AREA, "BG+/B")

		// Now Get the Data
		SET COLOR TO "BG+/B"
		@ 2,  4 TO 4, 74
		@ 2,  6 SAY " Name:  "
		SET COLOR TO "W+/B"
		@ 3,  5 SAY "Last: " GET cLastName PICTURE "@S20"
		@ 3, COL()+ 2 SAY "First: " GET cFirstName PICTURE "@S19"
		@ 3, COL()+ 2 SAY "M.I.: " GET cMI

		SET COLOR TO "BG+/B"
		@ 5,  4 TO 11, 74
		@ 5,  6 SAY " Shipping Information:  "
		SET COLOR TO "W+/B"
		@ 6,  5 SAY "Company: " GET cCompany
		@ 7,  5 SAY "Address: " GET cAddress1
		@ 8, 15 GET cAddress2
		@ 9,  5 SAY "City:    " GET cCity PICTURE "@S15"
		@ 9, COL()+ 2 SAY "State: " GET cState PICTURE "@S11";
									VALID (nQty := MAX(nQty, 1),;
												 nSubTotal := nQty * PRICE_PER_UNIT,;
												 nSalesTax := IIF("HAWAII" $ UPPER(cState) .OR. "HI" $ UPPER(cState),;
													ROUND(.04 * (nQty * PRICE_PER_UNIT), 2), 0.00),;
												 nSnH := IIF("USA" $ UPPER(cCountry) .OR. ;
																		 "UNITED STATES" $ UPPER(cCountry) .OR. ;
																			"UNITED STATES OF AMERICA" $ UPPER(cCountry), ;
																			nSnH := (USA_SNH * nQty), IIF("CANADA" $ UPPER(cCountry), nSnH := CANADA_SNH * nQty, nSnH := FOREIGN_SNH * nQty)),;
												 nTotal := nSubTotal + nSalesTax + nSnH,;
												 _Display(15, 33, "$" + PADL(ALLTRIM(STR(nSalesTax)), 6), "GR+/B"),;
												 _Display(15, 44, "$" + PADL(ALLTRIM(STR(nSnH)), 6), "GR+/B"),;
												 _Display(15, 56, "$" + PADL(ALLTRIM(STR(nTotal)), 10), "W+/R"),;
												 .T.)

		@ 9, COL()+ 2 SAY "Zip Code: " GET cZipCode PICTURE "@ 99999-9999"
		@10,  5 SAY "Country: " GET cCountry ;
									VALID (nQty := MAX(nQty, 1),;
												 nSubTotal := nQty * PRICE_PER_UNIT,;
												 nSalesTax := IIF("HAWAII" $ UPPER(cState) .OR. "HI" $ UPPER(cState),;
													ROUND(.04 * (nQty * PRICE_PER_UNIT), 2), 0.00),;
												 nSnH := IIF("USA" $ UPPER(cCountry) .OR. ;
																		 "UNITED STATES" $ UPPER(cCountry) .OR. ;
																			"UNITED STATES OF AMERICA" $ UPPER(cCountry), ;
																			nSnH := (USA_SNH * nQty), IIF("CANADA" $ UPPER(cCountry), nSnH := CANADA_SNH * nQty, nSnH := FOREIGN_SNH * nQty)),;
												 nTotal := nSubTotal + nSalesTax + nSnH,;
												 _Display(15, 33, "$" + PADL(ALLTRIM(STR(nSalesTax)), 6), "GR+/B"),;
												 _Display(15, 44, "$" + PADL(ALLTRIM(STR(nSnH)), 6), "GR+/B"),;
												 _Display(15, 56, "$" + PADL(ALLTRIM(STR(nTotal)), 10), "W+/R"),;
												 .T.)


		@10, COL()+ 2 SAY "Telephone #: " GET cTelephone PICTURE "(999)999-9999"

		@12, 5 SAY "Clipper Version:  " GET cClipperVer

		SET COLOR TO "BG+/B"
		@13, 4 TO 19, 74
		@13, 6 SAY " Payment Information:  "
		@20, 5 SAY "*Note:  Only Available  "
		@21, 5 SAY "        on 3.5 Diskettes"
		SET COLOR TO "W+/B"
		_Display(14,  7, "Qty:   Price Per Unit    Sales Tax    S & H     Extended Price", "GR+/B")
		_Display(14,  7, "Qty:")
		_Display(15, 14, "$    " + PRICE_STR + "         $  0.00    $  " + USA_SNH_STR + "     $     " + ALLTRIM(STR(PRICE_PER_UNIT + USA_SNH)), "GR+/B")
		_Display(15, 56, "$     " + ALLTRIM(STR(PRICE_PER_UNIT + USA_SNH)), "W+/R")
		@15,  7 GET nQty PICTURE "@ 9999" ;
									VALID (nQty := MAX(nQty, 1),;
												 nSubTotal := nQty * PRICE_PER_UNIT,;
												 nSalesTax := IIF("HAWAII" $ UPPER(cState) .OR. "HI" $ UPPER(cState),;
													ROUND(.04 * (nQty * PRICE_PER_UNIT), 2), 0.00),;
												 nSnH := IIF("USA" $ UPPER(cCountry) .OR. ;
																		 "UNITED STATES" $ UPPER(cCountry) .OR. ;
																			"UNITED STATES OF AMERICA" $ UPPER(cCountry), ;
																			nSnH := (USA_SNH * nQty), IIF("CANADA" $ UPPER(cCountry), nSnH := CANADA_SNH * nQty, nSnH := FOREIGN_SNH * nQty)),;
												 nTotal := nSubTotal + nSalesTax + nSnH,;
												 _Display(15, 33, "$" + PADL(ALLTRIM(STR(nSalesTax)), 6), "GR+/B"),;
												 _Display(15, 44, "$" + PADL(ALLTRIM(STR(nSnH)), 6), "GR+/B"),;
												 _Display(15, 56, "$" + PADL(ALLTRIM(STR(nTotal)), 10), "W+/R"),;
												 .T.)

		@17, 5 SAY "Payment Type:"
		@17, COL()+ 3 RADIOBUTTON "Check", "Money Order" GET nPaymentType

		@20, 30 PUSHBUTTON                      "   OK   " GET lOk ;
						NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		@20, COL()+4 PUSHBUTTON " CANCEL " GET lCancel ;
						NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

		READ

		IF ( LASTKEY() == K_ESC .OR. lCancel )
			IF ( YesNoBox(18, "Exit ClipButton Order Program?" + CR, 40, " Exit Program ",;
								"C", .F.) )
				EXIT
			ENDIF
			LOOP
		ENDIF

		// Draw Box Around Report To Entries
		CB_Box(8, 15, 14, 64, DOUBLE_BORDER, .T., " Print To? ", ;
					 CLEAR_BOX_AREA, "BG+/B")

		@10, 20 SAY "Send Order Form:"
		@12, 20 PUSHBUTTON                      "  PRINTER  " GET lPrinter ;
						NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		@12, COL()+4 PUSHBUTTON " ORDER.DOC " GET lOrderDoc ;
						NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		@12, COL()+4 PUSHBUTTON "  CANCEL  "    GET lCancel             ;
						NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		READ

		IF ( LASTKEY() == K_ESC .OR. lCancel )
			LOOP
		ENDIF

		TmpMem := TRIM(PADC("--- CLIPBUTTONS ORDER FORM ---", 66)) + CR + CR +;
							"NAME:  " + TRIM(cFirstName) + " " + ;
							IIF(!EMPTY(cMI), TRIM(cMI) + IIF(AT(".", cMI) == 0, ".",""), "") +;
							" " + TRIM(cLastName) + CR + CR +;
							"COMPANY:  " + TRIM(cCompany) + CR +;
							"ADDRESS:  " + TRIM(cAddress1) + CR +;
							IIF(!EMPTY(cAddress2), "          " + TRIM(cAddress2) + CR,"") +;
							"          " + TRIM(cCity) + IIF(!EMPTY(cCity) .AND. !EMPTY(cState), ", ","") + TRIM(cState) + "  " +;
							IIF(EMPTY(RIGHT(cZipCode, 4)), LEFT(cZipCode, 5), cZipCode) + CR +;
							"COUNTRY:  " + TRIM(cCountry) + CR +;
							"PHONE #:  " + TRIM(cTelephone) + CR + CR +;
							"CLIPPER VERSION:  " + TRIM(cClipperVer) + CR + CR +;
							"Qty:   Price Per Unit    Sales Tax    S & H     Extended Price" + CR +;
							"--------------------------------------------------------------" + CR +;
							PADC(ALLTRIM(STR(nQty)), 5) + "  $    " + PRICE_STR + "         $" + PADL(ALLTRIM(STR(nSalesTax)), 6) + "    $" + PADL(ALLTRIM(STR(nSnH)), 6) + "     $" + PADL(ALLTRIM(STR(nTotal)), 10) + CR + CR + CR +;
							"MAIL THIS ORDER FORM AND CHECK OR MONEY ORDER TO:  " + CR +;
							"               West Tech Software" + CR +;
							"               ATTN:  CLIPBUTTONS" + CR +;
							"               84-743 Moua Street" + CR +;
							"               Waianae, HI  96792" + CR

		IF ( lPrinter )
			IF ( Printer_Ok("PRN") )
				MEMOWRIT("LPT1.PRN", CR + CR + TmpMem + CHR(12))
			ELSE
				LOOP
			ENDIF
		ELSE
			MEMOWRIT("ORDER.DOC", TmpMem)
		ENDIF

		MsgBox(, CR + "THANK YOU FOR YOUR ORDER...", 40, " THANKS... ", "C")
		EXIT

	ENDDO

	CLOSE ALL
	RESTSCREEN(0, 0, 24, 79, cDosScreen)
	SETPOS(nDosRow, nDosCol)

RETURN


FUNCTION MsgBox(nTopRow, cMessage, nLineLen, cTitle, cJustify)
LOCAL   cOldScreen, nKeyStroke:= 0, nNumLines := 0, nCurLine := 0, i,;
			nTopCol := 0, nOldCursor, lOkButton := .T., ;
			nOldRow, nOldCol, GetList := {}

	nOldCursor      := SETCURSOR(SC_NONE)
	nOldRow                 := ROW()
	nOldCol                 := COL()

	DEFAULT( nLineLen, 30 )
	DEFAULT( cJustify, "L")
	DEFAULT( cTitle,   "" )

	nNumLines := MLCOUNT(cMessage, nLineLen)

	DEFAULT( nTopRow, ( 12 - ( ( nNumLines + 2 ) / 2 ) ) )

	nTopCol         := (40 - (nLineLen / 2 + 3))

	cOldScreen := SAVESCREEN(nTopRow, nTopCol, (nTopRow + 6 + nNumLines),;
												(40 + (nLineLen / 2 + 5)))

	CB_Box(nTopRow, nTopCol, (nTopRow + 4 + nNumLines), ;
			(40 + (nLineLen / 2 + 3)), 2, .T., cTitle)

	nCurLine := nTopRow + 1

	FOR i = 1 TO nNumLines
		IF ( UPPER(cJustify) == "C" )
			@nCurLine, nTopCol + 3 SAY PADC(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSEIF ( UPPER(cJustify) == "R" )
			@nCurLine, nTopCol + 3 SAY PADL(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSE
			@nCurLine, nTopCol + 3 SAY PADR(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ENDIF
		nCurLine++
	NEXT

	@nCurLine + 1, 37 PUSHBUTTON "  OK  "           GET lOkButton ;
					NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
	READ

	nKeyStroke := LASTKEY()

	RESTSCREEN(nTopRow, nTopCol, (nTopRow + 6 + nNumLines),;
						(40 + (nLineLen / 2 + 5)), cOldScreen)

	SETCURSOR(nOldCursor)
	SETPOS(nOldRow, nOldCol)

RETURN nKeyStroke


FUNCTION YesNoBox(nTopRow, cMessage, nLineLen, cTitle, cJustify, lDefault, cColor)
LOCAL cOldScreen, nNumLines := 0, nCurLine := 0, i,;
			nTopCol := 0, cOldColor, nOldCursor, lLetter, bOldY, bOld_y, bOldN, ;
			bOld_n, lYesBtn, lNoBtn, nOldRow, nOldCol, GetList := {}

	DEFAULT(lDefault, .F.)
	DEFAULT(nLineLen, 30 )
	DEFAULT(cJustify, "L")
	DEFAULT(cTitle,   "" )
	DEFAULT(cColor,   "" )

	cOldColor               := SETCOLOR(IIF(!EMPTY(cColor), cColor, "BG+/B"))
	nOldCursor  := SETCURSOR(SC_NONE)
	nOldRow                 := ROW()
	nOldCol                 := COL()

	lYesBtn                 := .F.
	lNoBtn                  := .F.

	cMessage        += CR

	nNumLines := MLCOUNT(cMessage, nLineLen)

	IF ( nTopRow == NIL ) // Center if No nTopRow Given
		nTopRow := ( 12 - ( ( nNumLines + 2 ) / 2 ) )
	ENDIF

	nTopCol := (40 - (nLineLen / 2 + 3))

	cOldScreen := SAVESCREEN(nTopRow, nTopCol, ;
												(nTopRow + 6 + nNumLines),;
												(40 + (nLineLen / 2 + 5)))

	CB_Box(nTopRow, nTopCol, (nTopRow + 3 + nNumLines), ;
			(40 + (nLineLen / 2 + 3)), 2, .T., cTitle, .T., cColor)

	nCurLine := nTopRow + 1

	FOR i = 1 TO nNumLines
		IF ( UPPER(cJustify) == "C" )
			@nCurLine, nTopCol + 3 SAY PADC(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSEIF ( UPPER(cJustify) == "R" )
			@nCurLine, nTopCol + 3 SAY PADL(ALLTRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ELSE
			@nCurLine, nTopCol + 3 SAY PADR(TRIM(MEMOLINE(cMessage, nLineLen, i)), nLineLen)
		ENDIF
		nCurLine++
	NEXT

	@nCurLine, 34 PUSHBUTTON " YES "                GET lYesBtn ;
								NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
	@nCurLine, 42 PUSHBUTTON " NO "                 GET lNoBtn  ;
								NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"

	lLetter := ""

	bOldY   := SETKEY(ASC("Y"))
	bOld_y  := SETKEY(ASC("y"))
	bOldN   := SETKEY(ASC("N"))
	bOld_n  := SETKEY(ASC("n"))

	SETKEY( ASC("Y"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "Y" ) } )
	SETKEY( ASC("y"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "Y" ) } )

	SETKEY( ASC("N"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "N" ) } )
	SETKEY( ASC("n"), { |x, y, z| ( __KillRead(), GetList := {}, lLetter := "N" ) } )

	IF ( !lDefault )
		KEYBOARD CHR(K_TAB)
	ENDIF

	READ

	SETKEY(ASC("Y"), bOldY  )
	SETKEY(ASC("y"), bOld_y )
	SETKEY(ASC("N"), bOldN  )
	SETKEY(ASC("n"), bOld_n )

	RESTSCREEN(nTopRow, nTopCol, ;
						(nTopRow + 6 + nNumLines),;
						(40 + (nLineLen / 2 + 5)), cOldScreen)

	SETCURSOR(nOldCursor)
	SETCOLOR(cOldColor)
	SETPOS(nOldRow, nOldCol)

	IF ( lLetter == "Y" )
		lYesBtn := .T.
	ELSEIF ( lLetter == "N" )
		lYesBtn := .F.
	ENDIF

RETURN ( IIF(lYesBtn, .T., .F.) )


PROCEDURE _Display(nRow, nCol, cString, cSayColor)
LOCAL nOldrow, nOldCol, nOldCursor, cOldColor

	nOldCursor      := SETCURSOR(SC_NONE)
	cOldColor       := SETCOLOR()
	nOldRow                 := ROW()
	nOldCol                 := COL()

	DEFAULT(cSayColor, "")

	IF EMPTY(cSayColor)
		@nRow, nCol SAY cString
	ELSE
		@nRow, nCol SAY cString COLOR cSayColor
	ENDIF
	SETPOS(nOldRow, nOldCol)
	SETCURSOR(nOldCursor)
	SETCOLOR(cOldColor)

RETURN


FUNCTION printer_ok(p_port)
LOCAL tmp_handle, print_port := p_port + ".PRN", err_num, err_msg := "",;
			old_scr := SAVESCREEN(9, 20, 19, 61), old_color := SETCOLOR(),;
			retry_printer := 1, chk_msg := "", lRetry, lCancel

	print_port 		:= p_port + ".PRN"
	err_msg 			:= ""
	old_scr 			:= SAVESCREEN(9, 20, 19, 61)
	old_color 		:= SETCOLOR()
	retry_printer := 1
	chk_msg 			:= ""

	DO WHILE .T.
		lRetry  := .F.
		lCancel := .F.

		tmp_handle := FOPEN(print_port,1)
		IF ( tmp_handle != -1 )
			FWRITE(tmp_handle, " ")
			err_num := FERROR()
			IF ( err_num == 0 )
				FCLOSE(tmp_handle)
				SETCOLOR(old_color)
				RETURN .T.
			ENDIF
		ENDIF

		// Must Be an Error
		SET COLOR TO W+/R                       // WHITE ON RED

		CB_Box(9, 20, 17, 59, DOUBLE_BORDER, .T., " PRINTER ERROR ", ;
					 CLEAR_BOX_AREA, "W+/R")

		DO CASE

			CASE ( err_num == 4 .OR. err_num == 8 )
				err_msg := "TOO MANY OPEN FILES"
				chk_msg := "Exit Properly and Re-Start Computer"

			CASE ( err_num == 5 .OR. err_num == 28 )
				err_msg := "PRINTER OFF LINE"
				chk_msg := "Check Power, Paper and Connections"

			CASE ( err_num == 23 )
				err_msg := "DATA ERROR (CRC)"
				chk_msg := "Check Connection and Printer"

			CASE ( err_num == 31 )
				err_msg := "GENERAL FAILURE"
				chk_msg := "Check Connection and Printer"

			OTHERWISE
				err_msg := "UNABLE TO WRITE TO PRINTER"
				chk_msg := "Check Connection and Printer"

		ENDCASE

		@12, 21 SAY TRIM(PADC(err_msg, 37))

		SET COLOR TO W/R
		@16, 21 SAY chk_msg
		SET COLOR TO W+/R

		@14, 30                          PUSHBUTTON " RETRY " GET lRetry ;
									NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		@14, COL() + 4 PUSHBUTTON " CANCEL " GET lCancel ;
									NORMALCOLOR "N/G" FOCUSCOLOR "W/R+" SELECTEDCOLOR "BG+/B+"
		READ

		IF ( lRetry )
			FCLOSE(tmp_handle)
			RESTSCREEN(9, 20, 19, 61, old_scr)
			SETCOLOR(old_color)
			LOOP
		ELSE                                  // CANCELED
			EXIT
		ENDIF
	ENDDO
	FCLOSE(tmp_handle)
	RESTSCREEN(9, 20, 19, 61, old_scr)
	SETCOLOR(old_color)
RETURN .F.
