////////////////
// ClipBtn.Ch	//
////////////////

#define CB_RIGHT	1
#define CB_LEFT  	2

#define SELECTED 	1
#define FOCUS			2
#define UNFOCUS		3

EXTERNAL CB_UPDATED

// Begin of Commands
/////////////////////
// Get Memo
//#command @ <toprow>, <topcol>, <botrow>, <botcol> GET <memovar> 				;
#command @ <toprow>, <topcol>, <botrow>, <botcol> MEMO <title> GET <memovar>;
												[VALID <valid>]                                 	;
												[WHEN <when>]                                   	;
												[COLOR <normalcolor>]															;
												[BLOCKCOLOR <blockcolor>]    	                    ;
												[LINELEN <linelen>]																;
												[COLROWDISP <colrowdisp>]													;
												[BORDER <nBorder>]																;
			=> SetPos( <toprow>, <topcol> )                                   	;
			 ; GetMemo( {|x| iif(x == NIL, <memovar>, <memovar> := x) },				;
								 <title>, <(memovar)>, GetList, <botrow>, <botcol>,				;
								 <{valid}>, <{when}>,	<normalcolor>, <blockcolor>, 				;
								 <{linelen}>, <colrowdisp>, <nBorder> )										;
			 ; DisplayMemo( GetList, Atail(GetList) )

//////////////////////
// Get Push Buttons
//#command @ <row>, <col> BUTTON <buttontext> GET <buttonvar> 				;
#command @ <row>, <col> PUSHBUTTON <buttontext> GET <buttonvar>						;
												[VALID <valid>]																		;
												[WHEN <when>]                                 		;
												[NORMALCOLOR <normcolor>]													;
												[FOCUSCOLOR <focuscolor>]													;
												[SELECTEDCOLOR <selectcolor>]											;
																																					;
			=> SetPos( <row>, <col> )                           	        			;
				; GetPushButton(<buttontext>,																			;
						{|x| iif(x == NIL, <buttonvar>, <buttonvar> := x) },					;
						<(buttonvar)>, GetList,	<{valid}>, <{when}>,									;
						<normcolor>, <focuscolor>, <selectcolor>)											;
				; DrawButton( GetList, Atail(GetList), UNFOCUS)



***
*   @..CHECKBOX
*
//#command @ <toprow>, <topcol> CHECK_BOX <cbtext> GET <cbvar>								;


#command @ <row>, <col> CHECK_BOX <cbtext> GET <cbvar>	;
			[VALID <valid>]					;
			[WHEN <when>]                                 		;
												[COLOR <color>]																		;
												[CHECKCHR <checkchr>]															;
												[CHECKPOS <checkpos>]															;
			=> SetPos( <row>, <col> )                           	        			;
				; CheckBoxGets(<cbtext>,																					;
								{|x| iif(x == NIL, <cbvar>, <cbvar> := x) },    					;
								<(cbvar)>, GetList, <checkpos>, <checkchr>, 							;
								<{valid}>, <{when}>)   																		;
				; DrawCheckBox(GetList, Atail(GetList))


***
*   @..CHECKBOX
*

#command @ <row>, <col> CHECKBOX <cbtext> GET <cbvar>											;
												[<CBClauses,...>]																	;
																																					;
			=> @ <row>, <col> CHECK_BOX <cbtext> GET <cbvar>										;
												[<CBClauses>] CHECKPOS CB_LEFT

***
*   @..CHECKBOXLEFT
*

#command @ <row>, <col> CHECKBOXLEFT <cbtext> GET <cbvar>									;
												[<CBClauses,...>]																	;
																																					;
			=> @ <row>, <col> CHECK_BOX <cbtext> GET <cbvar>										;
												[<CBClauses>] CHECKPOS CB_LEFT


***
*   @..CHECKBOXRIGHT
*

#command @ <row>, <col> CHECKBOXRIGHT <cbtext> GET <cbvar>								;
												[<CBClauses,...>]																	;
																																					;
			=> @ <row>, <col> CHECK_BOX <cbtext> GET <cbvar>										;
												[<CBClauses>] CHECKPOS CB_RIGHT


***
*   @..3_STATE_BOX
*
// Returns:
// 		1 = Checked
//		2 = Neutral
//		3 = Not Checked
#command @ <row>, <col> 3_STATE_BOX <cbtext> GET <cbvar>									;
												[VALID <valid>]																		;
												[WHEN <when>]                                 		;
												[COLOR <color>]																		;
												[CHECKCHR <checkchr>]															;
												[CHECKPOS <checkpos>]															;
																																					;
			=> SetPos( <row>, <col> )                           	        			;
				; Get3State(<cbtext>,																							;
								{|x| iif(x == NIL, <cbvar>, <cbvar> := x) },    					;
								<(cbvar)>, GetList, <checkpos>, <{checkchr}>,							;
								<{valid}>, <{when}>)	  																	;
				; Draw3StateBox(GetList, Atail(GetList))

***
*   @..3STATEBOX
*

#command @ <row>, <col> 3STATEBOX <cbtext> GET <cbvar>										;
												[<CB3Clauses,...>]																;
																																					;
			=> @ <row>, <col> 3_STATE_BOX <cbtext> GET <cbvar>									;
												[<CB3Clauses>] CHECKPOS CB_LEFT

***
*   @..3STATEBOXLEFT
*

#command @ <row>, <col> 3STATEBOXLEFT <cbtext> GET <cbvar>								;
												[<CB3Clauses,...>]																;
																																					;
			=> @ <row>, <col> 3_STATE_BOX <cbtext> GET <cbvar>									;
												[<CB3Clauses>] CHECKPOS CB_LEFT

***
*   @..3STATEBOXRIGHT
*

#command @ <row>, <col> 3STATEBOXRIGHT <cbtext> GET <cbvar>								;
												[<CB3Clauses,...>]																;
																																					;
			=> @ <row>, <col> 3_STATE_BOX <cbtext> GET <cbvar>									;
												[<CB3Clauses>] CHECKPOS CB_RIGHT


//////////////////
// Radio Buttons
//#command @ <toprow>, <topcol> GET <radiovar> RADIOS <radios,...>					;
#command @ <toprow>, <topcol> RADIOBUTTON <radios,...> GET <radiovar>			;
												[VALID <valid>]																		;
												[WHEN <when>]                                 		;
												[COLOR <color>]																		;
												[RADIOCHR <radiochr>]															;
			=> SetPos( <toprow>, <topcol> )                           	        ;
				; RadioGets( {|x| iif(x == NIL, <radiovar>, <radiovar> := x) },		;
											<radiovar>, {<radios>}, GetList, <radiochr>,				;
											<{valid}>, <{when}>)																;
				; DrawAllRadios(Getlist, Atail(GetList))
