/*  PMChaos.   (C) Copyright Matthew Austern, 1993.

    Permission granted to use, distribute, and modify, provided that this
    notice remains intact.  If you distribute a modified version, you must
    identify your modifications as such.
*/

/* Prototypes for functions in graph.c */

/* Must #include os2.h before including this file. */

struct GraphInfo {
  long WindowWidth, WindowHeight;
  double xMin, xMax, yMin, yMax; /* Limits of the graph. */
  double xFirstTick, yFirstTick, xTickInc, yTickInc;
  long xMargin, yMargin;	/* Blank space by the side of graph. */
  double xConvFactor, yConvFactor; /* Convert from graph to window coords. */
  long MajorTickSize, HalfTickSize, MinorTickSize;
  unsigned short FontPointSize;
  long FontHeight;
  long FontWidth;
};

void DrawAxes(HPS hps, struct GraphInfo *G);
void ClipToGraph (HPS PS, struct GraphInfo *G);
void UndoClipping(HPS);
void SizeAxes(HPS hps,
	      long Width, long Height,
	      double xMin, double xMax, double yMin, double yMax,
	      struct GraphInfo *G);

#include "inline.h"

INLINE POINTL toPoint (double x, double y, struct GraphInfo *G)
{
  POINTL result;
  result.x = (long) (G->xMargin + (x - G->xMin) * G->xConvFactor);
  result.y = (long) (G->yMargin + (y - G->yMin) * G->yConvFactor);
  return result;
}

INLINE void toXY (POINTL P, double *x, double *y, struct GraphInfo *G)
{
  *x = G->xMin + (P.x - G->xMargin) / G->xConvFactor;
  *y = G->yMin + (P.y - G->yMargin) / G->yConvFactor;
}
