#ifndef _GRAPHICS_H
#define _GRAPHICS_H

/* Graph handle */
#define  QWL_HGRAPH                    4

/* Graph handle definition */
typedef  PVOID HGRAPH;
typedef  HGRAPH *PHGRAPH;

/* Graph Option Flags */
#define  GRAPH_CLASSIFICATION_ENABLED  0x00000001
#define  GRAPH_FRAME_WINDOW            0x00000002
#define  GRAPH_FRAME_PLOT              0x00000004
#define  GRAPH_2YAXIS_ENABLED          0x00000008
#define  GRAPH_CORRELATE_GROUPS        0x00000010
#define  GRAPH_CORRELATE_DATA          0x00000020
#define  GRAPH_ENABLE_COLOR            0x00000040
#define  GRAPH_VIEW_PRINTER            0x00000080
#define  GRAPH_GRID_XAXIS              0x00000100
#define  GRAPH_GRID_YAXIS              0x00000200
#define  GRAPH_GRID_2YAXIS             0x00000400
#define  GRAPH_SELECTION_ENABLED       0x00000800  /* Default */
#define  GRAPH_GRID_SOLID              0x00001000
#define  GRAPH_GRID_DOTTED             0x00002000  /* Default */
#define  GRAPH_GRID_GRAYED             0x00004000
#define  GRAPH_LEGEND_ENABLED          0x00010000
#define  GRAPH_LEGEND_BOX              0x00020000  /* Default */
#define  GRAPH_LEGEND_OUTSIDE          0x00040000  /* Default */
#define  GRAPH_LEGEND_INSIDE           0x00080000
#define  GRAPH_LEGEND_SOLID            0x00100000  /* Default */
#define  GRAPH_LEGEND_PATTERN          0x00200000
#define  GRAPH_LEGEND_LINE             0x00400000
#define  GRAPH_LEGEND_MARKER           0x00800000
#define  GRAPH_LEGEND_TOPRIGHT         0x01000000  /* Default */
#define  GRAPH_LEGEND_TOPCENTER        0x02000000
#define  GRAPH_LEGEND_TOPLEFT          0x04000000
#define  GRAPH_LEGEND_BOTTOMRIGHT      0x08000000
#define  GRAPH_LEGEND_BOTTOMCENTER     0x10000000
#define  GRAPH_LEGEND_BOTTOMLEFT       0x20000000
#define  GRAPH_LEGEND_SHADOW           0x40000000 /* Default */
#define  GRAPH_LEGEND_SHADOWBOX        (GRAPH_LEGEND_BOX | GRAPH_LEGEND_SHADOW)

/* Graph types */
#define  GRAPH_TYPE_LINE                  1
#define  GRAPH_TYPE_XYLINE                2
#define  GRAPH_TYPE_SPECTRAL              3
#define  GRAPH_TYPE_SCATTER               4
#define  GRAPH_TYPE_AREA                  5
#define  GRAPH_TYPE_TABLE                 6  /* Not implemented */
#define  GRAPH_TYPE_RADAR                 7  /* Not implemented */
#define  GRAPH_TYPE_COLUMN                8  /* Not implemented */
#define  GRAPH_TYPE_BAR                   9  /* Not implemented */
#define  GRAPH_TYPE_STACKEDCOLUMN         10 /* Not implemented */
#define  GRAPH_TYPE_STACKEDBAR            11 /* Not implemented */
#define  GRAPH_TYPE_PIE                   12 /* Not implemented */
#define  GRAPH_TYPE_STEP                  13
#define  GRAPH_TYPE_AZIMUTHAL             14 /* Not implemented */
#define  GRAPH_TYPE_HIGHLOW               15 /* Not implemented */
#define  GRAPH_TYPE_HIGHLOWCLOSE          16 /* Not implemented */
#define  GRAPH_TYPE_HIGHLOWCLOSEAVE       17 /* Not implemented */
#define  GRAPH_TYPE_3DCOLUMN              18 /* Not implemented */
#define  GRAPH_TYPE_3DLINE                19 /* Not implemented */
#define  GRAPH_TYPE_3DSPECTRAL            20 /* Not implemented */
#define  GRAPH_TYPE_3DAREA                21 /* Not implemented */
#define  GRAPH_TYPE_3DBAR                 22 /* Not implemented */
#define  GRAPH_TYPE_3DSCATTER             23 /* Not implemented */
   
/* Graph Axis Flags */
#define  GRAPH_STAGGER_LABEL           0x00000001  /* Default */
#define  GRAPH_VERTICAL_LABEL          0x00000002
#define  GRAPH_ANGLE_LABEL             0x00000002
#define  GRAPH_SCALE_LABEL             0x00000008   /* Default */
#define  GRAPH_MAJORTICK_NONE          0x00000010
#define  GRAPH_MAJORTICK_INSIDE        0x00000020   /* Default */
#define  GRAPH_MAJORTICK_OUTSIDE       0x00000040   /* Default */
#define  GRAPH_MAJORTICK_ACROSS        (GRAPH_MAJORTICK_INSIDE | \
                                       GRAPH_MAJORTICK_OUTSIDE)
#define  GRAPH_MINORTICK_NONE          0x00000100
#define  GRAPH_MINORTICK_INSIDE        0x00000200   /* Default */
#define  GRAPH_MINORTICK_OUTSIDE       0x00000400   /* Default */
#define  GRAPH_MINORTICK_ACROSS        (GRAPH_MINORTICK_INSIDE | \
                                       GRAPH_MINORTICK_OUTSIDE)
#define  GRAPH_AUTO_UPPERLIMIT         0x00001000   /* Default */
#define  GRAPH_AUTO_LOWERLIMIT         0x00002000   /* Default */
#define  GRAPH_AUTO_RANGE              (GRAPH_AUTO_UPPERLIMIT | \
                                        GRAPH_AUTO_LOWERLIMIT)
#define  GRAPH_AUTO_MAJORTICKS         0x00004000   /* Default */
#define  GRAPH_AUTO_MINORTICKS         0x00008000   /* Default */
#define  GRAPH_AUTO_LABEL              (GRAPH_AUTO_MAJORTICKS | \
                                        GRAPH_AUTO_MINORTICKS)

/* Graph scale indicator */
#define  GRAPH_AUTO_INDICATOR          0x00010000   /* Default */
#define  GRAPH_NO_INDICATOR            0x00020000

/* Graph direction */
#define  GRAPH_REVERSE_LABEL           0x00040000  /* Hi-to-Low */

/* Graph axis type flags */
#define  GRAPH_AXIS_STANDARD           0x01000000  /* Default */
#define  GRAPH_AXIS_LOG                0x02000000
#define  GRAPH_AXIS_PERCENT            0x04000000

/* Graph Data Group Flags */
#define  GRAPH_GROUP_MARKERS           0x00000001
#define  GRAPH_GROUP_FILL              0x00000002
#define  GRAPH_GROUP_CONNECTORS        0x00000004
#define  GRAPH_GROUP_LEGEND            0x00000010   /* default */
#define  GRAPH_GROUP_VISIBLE           0x00000020   /* default */
#define  GRAPH_GROUP_YAXIS             0x00000100   /* default */
#define  GRAPH_GROUP_2YAXIS            0x00000200

/* Graph Data Types (Low word bits 0-15) */
#define  GRAPH_DATA_USHORT             0x00000001
#define  GRAPH_DATA_SHORT              0x00000002
#define  GRAPH_DATA_ULONG              0x00000003
#define  GRAPH_DATA_LONG               0x00000004
#define  GRAPH_DATA_FLOAT              0x00000005
#define  GRAPH_DATA_DOUBLE             0x00000006
#define  GRAPH_DATA_FIXED              0x00000007
#define  GRAPH_DATA_STRING             0x00000008

/* Graph Data Type Modifiers (High word bits 16-31) */
#define  GRAPH_DATA_CALENDAR           0x00010000  /* Standard "C" time() */
#define  GRAPH_DATA_SECONDS            0x00020000  /* default for time    */
#define  GRAPH_DATA_DAYS               0x00030000  /* 1-Sunday...7-Saturday */
#define  GRAPH_DATA_MONTHS             0x00040000  /* 1-January...12-December*/
#define  GRAPH_DATA_YEARS              0x00050000  /* Value as stated */
#define  GRAPH_DATA_DEGREES            0x00100000  /* default for angular */
#define  GRAPH_DATA_RADIANS            0x00110000
#define  GRAPH_DATA_GRADIENT           0x00120000

/* Graphic Feature object types */
#define  GRAPH_NONE                    0
#define  GRAPH_WINDOW                  1
#define  GRAPH_PLOT                    2
#define  GRAPH_TITLE                   3
#define  GRAPH_TITLE1                  4
#define  GRAPH_X_TITLE                 5
#define  GRAPH_Y_TITLE                 6
#define  GRAPH_2Y_TITLE                7
#define  GRAPH_LEGEND                  8
#define  GRAPH_X_AXIS                  9
#define  GRAPH_Y_AXIS                  10
#define  GRAPH_2Y_AXIS                 11
#define  GRAPH_X_INDICATOR             12
#define  GRAPH_Y_INDICATOR             13
#define  GRAPH_2Y_INDICATOR            14
#define  GRAPH_CLASS_TOPLEFT           15
#define  GRAPH_CLASS_BOTRIGHT          16
#define  GRAPH_FEATURES                16

/* Region option flags */
#define  GRAPH_ALIGN_LEFT              0x00000001
#define  GRAPH_ALIGN_RIGHT             0x00000002
#define  GRAPH_ALIGN_HCENTER           0x00000004
#define  GRAPH_ALIGN_TOP               0x00000010
#define  GRAPH_ALIGN_BOTTOM            0x00000020
#define  GRAPH_ALIGN_VCENTER           0x00000040
#define  GRAPH_ROTATE_HORIZONTAL       0x00000100
#define  GRAPH_ROTATE_VERTICAL         0x00000200
#define  GRAPH_DIR_LEFTRIGHT           0x00001000
#define  GRAPH_DIR_TOPBOTTOM           0x00002000
#define  GRAPH_DIR_RIGHTLEFT           0x00004000
#define  GRAPH_DIR_BOTTOMTOP           0x00008000

/* Graph Encoded file types */
#define  GRAPH_ENCODE_PMMETAFILE       1  /* OS/2 PM Metafile */
#define  GRAPH_ENCODE_PM1BITMAP        2  /* OS/2 PM 1.x Bitmap */
#define  GRAPH_ENCODE_PM2BITMAP        3  /* Os/2 PM 2.x Bitmap */
#define  GRAPH_ENCODE_GIF              4  /* Graphics Interchange Format */
#define  GRAPH_ENCODE_WINBITMAP        5  /* Windows 3.x Bitmap */
#define  GRAPH_ENCODE_WINMETAFILE      6  /* Win Metafile (not implemented) */

/* Color Types */
#define GRAPH_CLR_WHITE                CLR_WHITE
#define GRAPH_CLR_BLACK                CLR_BLACK
#define GRAPH_CLR_BLUE                 CLR_BLUE
#define GRAPH_CLR_RED                  CLR_RED
#define GRAPH_CLR_PINK                 CLR_PINK
#define GRAPH_CLR_GREEN                CLR_GREEN
#define GRAPH_CLR_CYAN                 CLR_CYAN
#define GRAPH_CLR_YELLOW               CLR_YELLOW
#define GRAPH_CLR_DARKGRAY             CLR_DARKGRAY
#define GRAPH_CLR_DARKBLUE             CLR_DARKBLUE
#define GRAPH_CLR_DARKRED              CLR_DARKRED
#define GRAPH_CLR_DARKPINK             CLR_DARKPINK
#define GRAPH_CLR_DARKGREEN            CLR_DARKGREEN
#define GRAPH_CLR_DARKCYAN             CLR_DARKCYAN
#define GRAPH_CLR_BROWN                CLR_BROWN
#define GRAPH_CLR_PALEGRAY             CLR_PALEGRAY
#define GRAPH_RGB_BLACK                RGB_BLACK
#define GRAPH_RGB_BLUE                 RGB_BLUE
#define GRAPH_RGB_GREEN                RGB_GREEN
#define GRAPH_RGB_CYAN                 RGB_CYAN
#define GRAPH_RGB_RED                  RGB_RED
#define GRAPH_RGB_PINK                 RGB_PINK
#define GRAPH_RGB_YELLOW               RGB_YELLOW
#define GRAPH_RGB_WHITE                RGB_WHITE

/* Line Types */
#define GRAPH_LINETYPE_DOT             LINETYPE_DOT
#define GRAPH_LINETYPE_SHORTDASH       LINETYPE_SHORTDASH
#define GRAPH_LINETYPE_DASHDOT         LINETYPE_DASHDOT
#define GRAPH_LINETYPE_DOUBLEDOT       LINETYPE_DOUBLEDOT
#define GRAPH_LINETYPE_LONGDASH        LINETYPE_LONGDASH
#define GRAPH_LINETYPE_DASHDOUBLEDOT   LINETYPE_DASHDOUBLEDOT
#define GRAPH_LINETYPE_SOLID           LINETYPE_SOLID
#define GRAPH_LINETYPE_INVISIBLE       LINETYPE_INVISIBLE

/* Marker Symbols */
#define GRAPH_MARKSYM_CROSS            MARKSYM_CROSS
#define GRAPH_MARKSYM_PLUS             MARKSYM_PLUS
#define GRAPH_MARKSYM_DIAMOND          MARKSYM_DIAMOND
#define GRAPH_MARKSYM_SQUARE           MARKSYM_SQUARE
#define GRAPH_MARKSYM_SIXPOINTSTAR     MARKSYM_SIXPOINTSTAR
#define GRAPH_MARKSYM_EIGHTPOINTSTAR   MARKSYM_EIGHTPOINTSTAR
#define GRAPH_MARKSYM_SOLIDDIAMOND     MARKSYM_SOLIDDIAMOND
#define GRAPH_MARKSYM_SOLIDSQUARE      MARKSYM_SOLIDSQUARE
#define GRAPH_MARKSYM_DOT              MARKSYM_DOT
#define GRAPH_MARKSYM_SMALLCIRCLE      MARKSYM_SMALLCIRCLE
#define GRAPH_MARKSYM_BLANK            MARKSYM_BLANK

/* Pattern Definitions */
#define GRAPH_PATSYM_DENSE1            PATSYM_DENSE1
#define GRAPH_PATSYM_DENSE2            PATSYM_DENSE2
#define GRAPH_PATSYM_DENSE3            PATSYM_DENSE3
#define GRAPH_PATSYM_DENSE4            PATSYM_DENSE4
#define GRAPH_PATSYM_DENSE5            PATSYM_DENSE5
#define GRAPH_PATSYM_DENSE6            PATSYM_DENSE6
#define GRAPH_PATSYM_DENSE7            PATSYM_DENSE7
#define GRAPH_PATSYM_DENSE8            PATSYM_DENSE8
#define GRAPH_PATSYM_VERT              PATSYM_VERT
#define GRAPH_PATSYM_HORIZ             PATSYM_HORIZ
#define GRAPH_PATSYM_DIAG1             PATSYM_DIAG1
#define GRAPH_PATSYM_DIAG2             PATSYM_DIAG2
#define GRAPH_PATSYM_DIAG3             PATSYM_DIAG3
#define GRAPH_PATSYM_DIAG4             PATSYM_DIAG4
#define GRAPH_PATSYM_NOSHADE           PATSYM_NOSHADE
#define GRAPH_PATSYM_SOLID             PATSYM_SOLID
#define GRAPH_PATSYM_HALFTONE          PATSYM_HALFTONE
#define GRAPH_PATSYM_HATCH             PATSYM_HATCH
#define GRAPH_PATSYM_DIAGHATCH         PATSYM_DIAGHATCH
#define GRAPH_PATSYM_BLANK             PATSYM_BLANK

typedef struct _GRAPHPOINTER {
   LONG     lRegion;                   /* Graph Region */
   LONG     lGroup;                    /* Graph Data group */
   LONG     lIndex;                    /* Index of data point */
   double   dxPosition;                /* Graph X-data point */
   double   dyPosition;                /* Graph Y-data point */
   RECTL    rectlRegion;               /* Region Boundary */
   } GRAPHPOINTER;

typedef GRAPHPOINTER *PGRAPHPOINTER;

typedef struct _GRAPHLOCATION {
   LONG     lRegion;                   /* Graph Region */
   double   dxPosition;                /* Graph X-data point */
   double   dyPosition;                /* Graph Y-data point */
   LONG     lxDevice;                  /* Graph X-device point */
   LONG     lyDevice;                  /* Graph Y-device point */
   RECTL    rectlRegion;               /* Region Boundary */
   } GRAPHLOCATION;

typedef GRAPHLOCATION *PGRAPHLOCATION;

typedef struct _GRAPHMARGIN {
   LONG     lHeading;                 /* Graph header (in .001 inches) */
   LONG     lFooting;                 /* Graph header (in .001 inches) */
   LONG     lLeftMargin;              /* Graph header (in .001 inches) */
   LONG     lRightMargin;             /* Graph header (in .001 inches) */
   } GRAPHMARGIN;

typedef GRAPHMARGIN *PGRAPHMARGIN;

/* Function Prototypes */
#ifdef __cplusplus
extern "C" {
#endif

BOOL EXPENTRY GraphAppendData(HGRAPH hGraph, int nGroup, 
                              PVOID pXData, PVOID pYData);

BOOL EXPENTRY GraphCopyToClipbd(HGRAPH hGraph, int flFmt);
BOOL EXPENTRY GraphCreate(HWND hwndClinet, PRECTL prectlClient, 
                          PHGRAPH phGraph);

BOOL EXPENTRY GraphDestroy(HGRAPH hGraph);

BOOL EXPENTRY GraphEnableColorPrint(HGRAPH hGraph, BOOL fEnabled);

BOOL EXPENTRY GraphOutputMetafile(HGRAPH hGraph, int flType, PSZ pszFileName);
BOOL EXPENTRY GraphOutputBitmap(HGRAPH hGraph, int flType, PSZ pszFileName);

BOOL EXPENTRY GraphPaint(HPS hps, PRECTL prectl, HGRAPH hGraph);
BOOL EXPENTRY GraphPrint(HGRAPH hGraph, PSZ achJobName, PSZ achQueueName);
BOOL EXPENTRY GraphPrintPreview(HGRAPH hGraph, HWND hwndOwner);
HWND EXPENTRY GraphPopupMenu(HGRAPH hGraph, LONG x, LONG y, HWND hwndFrame);

BOOL EXPENTRY GraphQueryColorPrint(HGRAPH hGraph, BOOL *pfEnabled);
BOOL EXPENTRY GraphQueryData(HGRAPH hGraph, int nGroup, PVOID pXData, 
                             PVOID pYData, PLONG plSize);
BOOL EXPENTRY GraphQueryFontAttrs(HGRAPH hGraph, LONG flRegion, PFATTRS pfattrs);
BOOL EXPENTRY GraphQueryFontName(HGRAPH hGraph, LONG flRegion, PSZ pszFont, int *pnFont,
                              PFIXED pfxPointSize);
BOOL EXPENTRY GraphQueryGroupColor(HGRAPH hGraph, int nGroup, PLONG plColor);
BOOL EXPENTRY GraphQueryGroupCount(HGRAPH hGraph, int *pnGroups);
BOOL EXPENTRY GraphQueryGroupLineType(HGRAPH hGraph, int nGroup, PLONG plLineType);
BOOL EXPENTRY GraphQueryGroupMarker(HGRAPH hGraph, int nGroup, PLONG plMarker);
BOOL EXPENTRY GraphQueryGroupOptions(HGRAPH hGraph, int nGroup, 
                                     PLONG plOptions);
BOOL EXPENTRY GraphQueryGroupPattern(HGRAPH hGraph, int nGroup, 
                                     PLONG plPattern);
BOOL EXPENTRY GraphQueryGroupText(HGRAPH hGraph, int nGroup, PSZ pszText, 
                                  int *pnText);
BOOL EXPENTRY GraphQueryHandle(HWND hwndControl,  PHGRAPH phGraph);
BOOL EXPENTRY GraphQueryLocation(HGRAPH hGraph, PGRAPHLOCATION pLocation);
BOOL EXPENTRY GraphQueryPrintMargin(HGRAPH hGraph, PGRAPHMARGIN pMargin);
BOOL EXPENTRY GraphQueryOptions(HGRAPH hGraph, PLONG pflFlags);
BOOL EXPENTRY GraphQueryPlotType(HGRAPH hGraph, int *pnType);
BOOL EXPENTRY GraphQueryPointer(HGRAPH hGraph, LONG x, LONG y, 
                                PGRAPHPOINTER pPointer);
BOOL EXPENTRY GraphQueryRegionColor(HGRAPH hGraph, LONG lRegion, PLONG plColor);
BOOL EXPENTRY GraphQueryRegionOptions(HGRAPH hGraph, int nRegion,
                                      PLONG plFlags);
BOOL EXPENTRY GraphQueryRegionText(HGRAPH hGraph, LONG flRegion, PSZ pszText, 
                                   int *pnText);
BOOL EXPENTRY GraphQuerySelectedObject(HGRAPH hGraph, int *nRegion, 
                                       int *pnGroup);
BOOL EXPENTRY GraphQueryXData(HGRAPH hGraph, int nGroup, int nFirst, int nLast,
                              PVOID pData, PLONG plSize);
BOOL EXPENTRY GraphQueryXDataRange(HGRAPH hGraph, PLONG plMin, PLONG plMax);
BOOL EXPENTRY GraphQueryXLabeling(HGRAPH hGraph, int *pnMajorLabels, int *pnMinorLabels);
BOOL EXPENTRY GraphQueryXOptions(HGRAPH hGraph, PLONG plOptions);
BOOL EXPENTRY GraphQueryYData(HGRAPH hGraph, int nGroup, int nFirst, int nLast,
                              PVOID pData, PLONG plSize);
BOOL EXPENTRY GraphQueryYDataRange(HGRAPH hGraph, PLONG plMin, PLONG plMax);
BOOL EXPENTRY GraphQueryYLabeling(HGRAPH hGraph, int *pnMajorLabels, int *pnMinorLabels);
BOOL EXPENTRY GraphQueryYOptions(HGRAPH hGraph, PLONG plOptions);
BOOL EXPENTRY GraphQPlotPosition(HGRAPH hGraph, int *pnHeading, int *pnFooting,
                       int *pnLeftMargin, int *pnRightMargin);

BOOL EXPENTRY GraphRegister(PSZ pszClassName);
BOOL EXPENTRY GraphRenderClipbd(HGRAPH hGraph, int flFmt);

BOOL EXPENTRY GraphSetWindowPos(HGRAPH hGraph, LONG x, LONG y,
                                LONG cx, LONG cy);


BOOL EXPENTRY GraphSelectMenuItem(HGRAPH hGraph, int idMenuItem);
BOOL EXPENTRY GraphSelectObject(HGRAPH hGraph, int nRegion, int nGroup);
BOOL EXPENTRY GraphSetData(HGRAPH hGraph, int nGroup, int nPoint,
                           PVOID pXData, PVOID pYData);
BOOL EXPENTRY GraphSetFont(HGRAPH hGraph, LONG flRegion, PSZ pszFont,
                           FIXED fxPointSize);
BOOL EXPENTRY GraphSetFontAttrs(HGRAPH hGraph, LONG flRegion, PFATTRS pfattrs,
                                FIXED fxPointSize);
BOOL EXPENTRY GraphSetGroupCount(HGRAPH hGraph, int nGroups);
BOOL EXPENTRY GraphSetGroupColor(HGRAPH hGraph, int nGroup, LONG lColor);
BOOL EXPENTRY GraphSetGroupLineType(HGRAPH hGraph, int nGroup, LONG lLineType);
BOOL EXPENTRY GraphSetGroupMarker(HGRAPH hGraph, int nGroup, LONG lMarker);
BOOL EXPENTRY GraphSetGroupOptions(HGRAPH hGraph, int nGroup, LONG flOptions,
                          BOOL bEnable);
BOOL EXPENTRY GraphSetGroupPattern(HGRAPH hGraph, int nGroup, LONG lPattern);
BOOL EXPENTRY GraphSetGroupText(HGRAPH hGraph, int nGroup, PSZ pszText);
BOOL EXPENTRY GraphSetPrintMargin(HGRAPH hGraph, PGRAPHMARGIN pMargin);
BOOL EXPENTRY GraphSetOptions(HGRAPH hGraph, LONG flFlags, BOOL bState);
BOOL EXPENTRY GraphSetPlotType(HGRAPH hGraph, int nType);
BOOL EXPENTRY GraphPositionPlot(HGRAPH hGraph, int nHeading, int nFooting,
                                int nLeftMargin, int nRightMargin);
BOOL EXPENTRY GraphSetPrintQData(HGRAPH hGraph, 
                                 PSZ pszPrinterName, PSZ pszQueueName,
                                 PSZ pszDriverName, PSZ pszDeviceName,
                                 PVOID pDriverData);
BOOL EXPENTRY GraphSetRegionFont(HGRAPH hGraph, LONG flRegion,
                        PSZ pszFont, FIXED fxPointSize);
BOOL EXPENTRY GraphSetRegionOptions(HGRAPH hGraph, int nRegion, LONG flFlags);
BOOL EXPENTRY GraphSetRegionText(HGRAPH hGraph, LONG flRegion, PSZ pszText);
BOOL EXPENTRY GraphSetupData(HGRAPH hGraph, int nGroup,
                             LONG lXType, LONG lYType, LONG lPoints);
BOOL EXPENTRY GraphSetXData(HGRAPH hGraph, int nGroup, PVOID pData);
BOOL EXPENTRY GraphSetYData(HGRAPH hGraph, int nGroup, PVOID pData);
BOOL EXPENTRY GraphSetXDataRange(HGRAPH hGraph, LONG lMin, LONG lMax);
BOOL EXPENTRY GraphSetXLabeling(HGRAPH hGraph, LONG nMajorLabels,
                                LONG nMinorLabels);
BOOL EXPENTRY GraphSetXOptions(HGRAPH hGraph, LONG flFlags, BOOL bState);
BOOL EXPENTRY GraphSetYDataRange(HGRAPH hGraph, LONG lMin, LONG lMax);
BOOL EXPENTRY GraphSetYLabeling(HGRAPH hGraph, LONG nMajorLabels, 
                                LONG nMinorLabels);
BOOL EXPENTRY GraphSetYOptions(HGRAPH hGraph, LONG flFlags, BOOL bState);
BOOL EXPENTRY GraphSetRegionColor(HGRAPH hGraph, LONG lRegion, LONG lColor);
#ifdef __cplusplus
}
#endif
#endif
