#define  INCL_DOS
#define  INCL_WIN
#define  INCL_GPI
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <os2.h>
#include <graphics.h>
#include "gtest2.h"

/*
** Local defines
*/
#define FLOAT_ARRAY_SIZE 100

/*
** Local Function Prototypes
*/
static HGRAPH   hGraph;
void InitTest(HGRAPH hGraph);
MRESULT EXPENTRY TestDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

/*
** Global variables
*/
static HWND hwndMenu = (HWND)0;

/*
** Main Program
*/

int main(int argc, char **argv)
{
   HAB      hab;
   HMQ      hmq;
   QMSG     qmsg;
   HWND     hwndFrame;

   /* Initialize into PM Session */
   if(!(hab = WinInitialize(0))) {
      DosBeep(1200, 1000);
      return(-1);
   } /* endif */

   /* Create a message queue */
   if(!(hmq = WinCreateMsgQueue(hab, 50)))  {
      DosBeep(1200, 1000);
      WinTerminate(hab);
      return(-1);
   } /* endif */

   /* Register the SVP Notebook window Class */
   GraphRegister("MYCLASS");

   /* Create the test window */
   hwndFrame = WinLoadDlg( HWND_DESKTOP,
                           HWND_DESKTOP,
                           TestDlgProc,
                           (HMODULE)0,
                           ID_TEST2,
                           (PVOID)0);

   /* Find the graph handle */
   if(GraphQueryHandle(WinWindowFromID(hwndFrame, ID_GRAPH), &hGraph))
      InitTest(hGraph);

   /* Get/Dispatch Message loop */
   while(WinGetMsg(hab, &qmsg, (HWND)0, 0, 0)) {
      WinDispatchMsg(hab, &qmsg);
   } /* endwhile */

   /* Destroy the message queue */
   WinDestroyMsgQueue(hmq);

   /* Terminate the PM Session */
   WinTerminate(hab);

   return(0);
}

void InitTest(HGRAPH hGraph)

{
   RECTL    rectl;

   int   i;
   LONG  lXValue, lYValue;
   float afXData[FLOAT_ARRAY_SIZE], afYData[FLOAT_ARRAY_SIZE];

   /* Set the size of the plot */
   GraphPositionPlot(hGraph, 10, 15, 15, 5);

   /* Set the title of the graph */
   GraphSetRegionText(hGraph,
                      GRAPH_TITLE,
                      "Test Program");

   /* Set the title of the left margin */
   GraphSetRegionText(hGraph,
                      GRAPH_Y_TITLE,
                      "Y-Axis (Units)");

   /* Set the title of the footing */
   GraphSetRegionText(hGraph,
                      GRAPH_X_TITLE,
                     "X-Axis (Units)");

    /* Set the group count */
   GraphSetGroupCount(hGraph, 1);

   /* Set the y-axis options */
   GraphSetYOptions(hGraph, GRAPH_AUTO_LOWERLIMIT, FALSE);
   GraphSetYDataRange(hGraph, 75, 0);  /* Upper limit does not matter */

   /* Setup the data */
   GraphSetupData(hGraph,
                  1,
                  GRAPH_DATA_FLOAT,
                  GRAPH_DATA_FLOAT,
                  FLOAT_ARRAY_SIZE);

   return;
}


MRESULT EXPENTRY TestDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
   static int nTimer = 1;

   switch (msg) {
   case WM_INITDLG:
      srand((unsigned)time((time_t)0));
      WinStartTimer( WinQueryAnchorBlock(HWND_DESKTOP),
                     hwnd,
                     1,
                     1000);
      break;
   case WM_COMMAND:
      if(SHORT1FROMMP(mp1) == DID_OK) {
         WinPostMsg(hwnd, WM_QUIT, MPFROMLONG(0), MPFROMLONG(0));
         return(0);
      } /* endif */
      break;
   case WM_TIMER: {
      int    i;
      LONG   lMin, lMax;
      float  rX, rY;
      rX = (float)(nTimer * 10);
      rY = 60.0 + (10.0 * log(rX));
      GraphAppendData(hGraph, 1, &rX, &rY);
      nTimer++;
      break;
   } /* endcase */
   } /* endswitch */

  return (WinDefDlgProc(hwnd, msg, mp1, mp2));
}

