#define  INCL_DOS
#define  INCL_WIN
#define  INCL_GPI
#include <stdlib.h>
#include <os2.h>
#include <graphics.h>
#include "math.h"

/*
** Local defines
*/
#define DATA_ARRAY_SIZE 100

/*
** Local Function Prototypes
*/
MRESULT EXPENTRY TestWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
HGRAPH InitTest(HWND hwnd);

/*
** Global variables
*/
static HWND hwndMenu = (HWND)0;
static char *szTestClass = "GraphTest";

/*
** Main Program
*/

int main(int argc, char **argv)
{
   HAB   hab;
   HMQ   hmq;
   QMSG  qmsg;
   HWND  hwndFrame, hwndClient;
   ULONG flCreateFlags = FCF_SYSMENU | FCF_TITLEBAR | FCF_SIZEBORDER |
                         FCF_MINMAX  | FCF_SHELLPOSITION |
                         FCF_TASKLIST;

   /* Initialize into PM Session */
   if(!(hab = WinInitialize(0))) {
      DosBeep(1200, 1000);
      return(-1);
   } /* endif */

   /* Create a message queue */
   if(!(hmq = WinCreateMsgQueue(hab, 50)))  {
      DosBeep(1200, 1000);
      WinTerminate(hab);
      return(-1);
   } /* endif */

   /* Register the SVP Notebook window Class */
   WinRegisterClass(hab,
                    szTestClass,
                    TestWndProc,
                    CS_CLIPCHILDREN | CS_CLIPSIBLINGS,
                    4);

   /* Create the test window */
   hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                  WS_VISIBLE,
                                  &flCreateFlags,
                                  szTestClass,
                                  "Graphic Test Program",
                                  (HMODULE)0,
                                  0,
                                  0,
                                  &hwndClient);


   /* Get/Dispatch Message loop */
   while(WinGetMsg(hab, &qmsg, (HWND)0, 0, 0)) {
      WinDispatchMsg(hab, &qmsg);
   } /* endwhile */

   /* Destroy the message queue */
   WinDestroyMsgQueue(hmq);

   /* Terminate the PM Session */
   WinTerminate(hab);

   return(0);
}

MRESULT EXPENTRY TestWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
   static   HWND   hwndMenu = (HWND)0;
   static   int    nSelectedObject = GRAPH_NONE;
   static   int    nSelectedGroup  = 0;
   HGRAPH   hGraph = WinQueryWindowPtr(hwnd, QWL_USER);

   switch (msg) {
   case WM_CREATE:
      hGraph = InitTest(hwnd);
      WinSetWindowPtr(hwnd, QWL_USER, hGraph);
      return(MPFROMLONG(FALSE));

   case WM_SIZE:
      if(hGraph) {
         GraphSetWindowPos(hGraph, 0, 0, SHORT1FROMMP(mp2), SHORT2FROMMP(mp2));
      } /* endif */
      break;

   case WM_PAINT: {
      RECTL    rectl;
      POINTL   aptl[4];
      HPS   hps = WinBeginPaint(hwnd, (HPS)0, &rectl);

      GraphPaint(hps, &rectl, hGraph);

      WinEndPaint(hps);
      break;
   } /* endcase */

   case WM_RENDERFMT:
      GraphRenderClipbd(hGraph, SHORT1FROMMP(mp1));
      break;

   case WM_RENDERALLFMTS:
      GraphRenderClipbd(hGraph, CF_METAFILE);
      GraphRenderClipbd(hGraph, CF_BITMAP);
      break;

   case WM_BUTTON1DOWN:
      if(hGraph)
         GraphSelectObject(hGraph, GRAPH_NONE, 0);
      break;

   case WM_BUTTON2DOWN:
      if(hGraph) {
         GRAPHPOINTER   gptr;
         GraphQueryPointer(hGraph,
                           LOUSHORT(mp1),
                           HIUSHORT(mp1),
                           &gptr);
         GraphSelectObject(hGraph, gptr.lRegion, gptr.lGroup);
         hwndMenu = GraphPopupMenu(hGraph,
                                   SHORT1FROMMP(mp1),
                                   SHORT2FROMMP(mp1),
                                   WinQueryWindow(hwnd, QW_PARENT));
      } /* endif */
      return(0);

   case WM_COMMAND:
      if(hGraph && 
         ((LOUSHORT(mp2) == CMDSRC_MENU) || 
          (LOUSHORT(mp2) == CMDSRC_ACCELERATOR))) {
         GraphSelectMenuItem(hGraph, LOUSHORT(mp1));
      } /* endif */
      break;

   case WM_DESTROY:
      if(hGraph) GraphDestroy(hGraph);
      break;
   } /* endswitch */

  return (WinDefWindowProc(hwnd, msg, mp1, mp2));
}

HGRAPH InitTest(HWND hwnd)

{
   HGRAPH   hGraph = (HGRAPH)0;
   RECTL    rectl;

   /* Create the SVP Graph */
   if (GraphCreate(hwnd, (PRECTL)0, &hGraph)) {

      int      i;
      LONG     lXValue;
      short    sYValue;
      float    afXData[DATA_ARRAY_SIZE];
      double   afYData[DATA_ARRAY_SIZE];

      /* Set graph options */
      GraphSetOptions(hGraph,
                      GRAPH_FRAME_WINDOW |
                      GRAPH_FRAME_PLOT |
                      GRAPH_CLASSIFICATION_ENABLED |
                      GRAPH_LEGEND_ENABLED |
                      GRAPH_CORRELATE_GROUPS |
                      GRAPH_CORRELATE_DATA |
                      GRAPH_LEGEND_OUTSIDE |
                      GRAPH_LEGEND_TOPRIGHT |
                      GRAPH_LEGEND_LINE,
                      TRUE);

      /* Set region colors */
      GraphSetRegionColor(hGraph, GRAPH_LEGEND, CLR_WHITE);
      GraphSetRegionColor(hGraph, GRAPH_PLOT, CLR_YELLOW);
      GraphSetRegionColor(hGraph, GRAPH_WINDOW, CLR_GREEN);

      /* Set the title of the graph */
      GraphSetRegionColor(hGraph,
                          GRAPH_TITLE,
                          CLR_CYAN);
      GraphSetRegionText(hGraph,
                         GRAPH_TITLE,
                         "Test Program");

      /* Set the title of the left margin */
      GraphSetRegionColor(hGraph,
                          GRAPH_Y_TITLE,
                          CLR_BLUE);
      GraphSetRegionText(hGraph,
                         GRAPH_Y_TITLE,
                         "Left Margin (Units)");

      /* Set the title of the footing */
      GraphSetRegionColor(hGraph,
                          GRAPH_X_TITLE,
                          CLR_BLUE);
      GraphSetRegionText(hGraph,
                         GRAPH_X_TITLE,
                         "Footing (Units)");

      /* Set the title of the right margin */
      GraphSetRegionColor(hGraph,
                          GRAPH_2Y_TITLE,
                          CLR_RED);
      GraphSetRegionFont(hGraph,
                         GRAPH_2Y_TITLE,
                         "Helvetica Italic",
                         MAKEFIXED(8, 0));
      GraphSetRegionText(hGraph,
                         GRAPH_2Y_TITLE,
                         "Right Margin");

      /* Set the classification and color */
      GraphSetRegionColor(hGraph,
                          GRAPH_CLASS_TOPLEFT,
                          CLR_RED);
      GraphSetRegionText(hGraph,
                         GRAPH_CLASS_TOPLEFT,
                         "Private");

      /* Set the group count */
      GraphSetGroupCount(hGraph, 1);

      /* Setup the data */
      GraphSetupData(hGraph,
                     1,
                     GRAPH_DATA_FLOAT,
                     GRAPH_DATA_DOUBLE,
                     DATA_ARRAY_SIZE);

      /* Set the group marker */
      GraphSetGroupMarker(hGraph, 1, GRAPH_MARKSYM_DIAMOND);

      /* Setup the float test data */
      for (i=0; i<DATA_ARRAY_SIZE; i++) {
         afXData[i] = (float)(3000.0 + (20.0 * i));
         afYData[i] = 5000.0 + (10000.0 * sin((double)i/2.0));
      } /* endfor */
      GraphSetXData( hGraph,
                     1,
                     afXData);
      GraphSetYData( hGraph,
                     1,
                     afYData);

      /* Set group 1 title */
      GraphSetGroupText(hGraph, 1, "Alpha");

      GraphSetGroupCount(hGraph, 2);

      /* Setup the data */
      GraphSetupData(hGraph,
                     2,
                     GRAPH_DATA_LONG,
                     GRAPH_DATA_SHORT,
                     10);

      /* Initialize the data */
      for (i=0; i<10; i++) {
         lXValue = 4000 + i*100;
         sYValue = (short)(i * 200);
         GraphSetData(hGraph,
                      2,
                      i,
                      &lXValue,
                      &sYValue);
      } /* endfor */

      /* Set the group 2 title */
      GraphSetGroupText(hGraph, 2, "Beta");

   } /* endif */

   return (hGraph);
}


