/* Line 1*/
/* Author Dave Sloan - July 1993*/
/* Written to completely control inbound and outbound files and mail*/
/* Need Control.cmd in same path*/
/* This program starts Control.cmd*/
/* Control.cmd checks that Bink1.cmd is running and we check for Control.cmd*/
'echo on'
signal on failure name EXIT
signal on halt name EXIT
signal on syntax name EXIT
Drive    = 'C:' /* Drive with all the goodies*/
Messages = 'C:' /* Drive with Message Bases*/
Log      = 'C:' /* Drive containing logs*/

Logpath  = 'log'  /* Path to the logs*/
CmdPath  = 'bink' /* Path to the Command files .cmd*/
MaxPath  = 'max'

 /* Setup 
Queue*/
CntlQueue = 'Cntl'
Drive
'cd\'CmdPath
'erase binkley.scd'
'MODE COM1:38400,n,8,1,to=on,xon=off,dtr=off,idsr=off,odsr=off,octs=on,rts=hs'
Do Forever
  'SET TBUF='
  'SET RBUF='
  'SET BTPRIO=F16'
  Drive
  'cd \'CmdPath
/* Start Binkley Mailer*/
  'btp share'
  errorlevel = RC
  select
/* Toss Mail to message bases and make packets for other nodes*/
    when errorlevel = 99 then call toss
    when errorlevel = 97 then call toss
    when errorlevel = 95 then call toss
    when errorlevel = 60 then call toss
/* Pickup IBM Mail 40:6496/0*/
    when errorlevel = 44 then call IBMNET
/* Pickup RBBS Admin 8:990/1*/
    when errorlevel = 43 then call RBBS1
/* Get Mail from 8:916/1*/
    when errorlevel = 42 then call RBBS
/* Get IMEX echos*/
    when errorlevel = 41 then call Richard
/* Create latest and greatest nodelst*/
    when errorlevel = 32 then call nodelst
/*Nightly Cleanup*/
    when errorlevel = 31 then call DAILY
    when errorlevel = 30 then call toss
/* Mail to process*/
    when errorlevel = 20 then call toss
/* Tics to process*/
    when errorlevel = 10 then call toss
/* Weekly Statistics Report*/
    when errorlevel =  7 then call stats
    otherwise NOP
  end
end
exit


TOSS:
/* Go toss all incoming mail*/
oq = RXQueue("Set",CntlQueue)
QUEUE 'toss 1'
xx = RXQueue("Set",oq)
return

DAILY:

/* Go do daily processing*/
oq = RXQueue('Set',CntlQueue)
QUEUE 'daily 1'
xx = RXQueue("Set",oq)
/* Keep the old logs one day*/
Log
'cd\'Logpath
'copy binkley.log bt.log'
'erase binkley.log'
'copy cost01.log co1.log'
'erase cost01.log'
Drive
/* Update the schedule*/
/* recycle user log*/
'cd\'MaxPath
'copy 1 mx1.log'
'erase 1'
Return

RICHARD:
oq = RXQueue("Set",CntlQueue)
QUEUE 'node 89:85/5 1'
xx = RXQueue("Set",oq)
return

RBBS:
oq = RXQueue("Set",CntlQueue)
QUEUE 'node 8:916/1 1'
xx = RXQueue("Set",oq)
return

RBBS1:
oq = RXQueue("Set",CntlQueue)
QUEUE 'node 8:990/1 1'
xx = RXQueue("Set",oq)
return

IBMNET:
oq = RXQueue("Set",CntlQueue)
QUEUE 'node 40:6496/0 1'
xx = RXQueue("Set",oq)
return

STATS:
oq = RXQueue("Set",CntlQueue)
QUEUE 'stats 1'
xx = RXQueue("Set",oq)
return

EXIT:
/* Check that control is running*/
xx = RXQUEUE('Create', CntlQueue)
/* REXX will name queue to another name - otherwise it exists*/
say 'Try to create - 'xx
if xx = CntlQueue then do
  /* Remove it and let control recreate it*/
  xx = RXQUEUE("Delete",CntlQueue)
  Drive
  'cd\'CmdPath
  'start /fs /b control'
  return
end
else
  xx = RXQUEUE("Delete",xx)
/* Let control startup bink1*/
return