/*
program: atrgf.cmd
type:    REXXSAA-OS/2, version 2.x
purpose: execute command at specified time
version: 2.1
date:    1991-05-24
changed: 1991-07-26, RGF, streamlined the code a little bit..., added colors
         1992-06-01, RGF, adapted for 32bit OS/2
         1993-08-02, RGF, bug fixed on /E-switch: would not take starting day
                          into account (reported by Steve Hoiness,
                                        <76077.3121@compuserve.com>)
         1993-09-20, changed the definition of ANSI-color-sequences; gets them from
                     procedure ScrColor.CMD


author:  Rony G. Flatscher,
         Wirtschaftsuniversitt/Vienna
         RONY@AWIWUW11.BITNET
         flatscher@wu-wien.ac.at

needs:   all RxUtil-functions loaded, DATERGF.CMD, DATE2STR.CMD, SCRCOLOR.CMD

usage:   ATRGF [/W] [/T] time command
         ATRGF [/W] [/T] time /NE:dayordate command
         ATRGF [/W] [/T] time /E:dayordate command
         ATRGF [/W] [/T] [time] /I:time command

         see enclosed Tutorial "RGFSHOW.CMD" and syntax below


All rights reserved, copyrighted 1991 & 1992, no guarantee that it works without
errors, etc. etc.

donated to the public domain granted that you are not charging anything (money
etc.) for it and derivates based upon it, as you did not write it,
etc. if that holds you may bundle it with commercial programs too

you may freely distribute this program, granted that no changes are made
to it and that the accompanying tutorial "RGFSHOW.CMD" is being distributed
together with DATERGF.CMD, DATE2STR.CMD, ATRGF.CMD, TIMEIT.CMD

Please, if you find an error, post me a message describing it, I will
try to fix and rerelease it to the net.

procedures:
    CHECK_TIME          check and parse time into hh:mm
    SHOW_DURATION       show duration of command
    DURATION            format elapsed seconds into time
    NEXT_DATE           produce next date
    NEXT_DAY            produce next week-day
    SCHEDULE_IT         schedule command
    SHOW_SLEEP_EXECUTE  show next invocation, sleep until it and execute command


usage:   ATRGF [/W] [/T] time command
         ATRGF [/W] [/T] time /NE:dayordate command
         ATRGF [/W] [/T] time /E:dayordate command
         ATRGF [/W] [/T] [time] /I:time command

syntax:
    COMMAND ..... any command as entered thru the keyboard to start
                  a program
    TIME ........ on input 24hour- (military) or 12hour-format allowed,
                  output will be allways in 24hour-format (military, computer)
    DAYORDATE ... DAY[-DAY]|DATE[-DATE][,...]
                  DAY .... 2 letter digit (MO, TU, WE, TH, FR, SA, SU)
                  DATE ... 1-2 digits (1-31)
                  more than one day or date must be delimited by a comma

flags:
    /W  ......... execute ATRGF.CMD in a separate Window
    /T  ......... Test
    /NE: ........ NExt dayordate
    /E:  ........ Every dayordate
    /I:  ........ every time-Interval

*/

SIGNAL ON HALT

IF ARG(1) = '' | ARG(1) = '?' THEN SIGNAL usage


/* check whether RxFuncs are loaded, if not, load them */
IF RxFuncQuery('SysLoadFuncs') THEN
DO
    /* load the load-function */
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'       

    /* load the Sys* utilities */
    CALL SysLoadFuncs                                                 
END

atrgf. = ''                     /* default for empty subscripts */
/* defaults */
atrgf.executions = 0                            /* number of executions so far */
atrgf.format_date = "%yyyy-%mm-%dd"             /* format string for dates */
atrgf.daynames = "MO TU WE TH FR SA SU"         /* valid daynames */


PARSE ARG tmp                   /* as is argument */

atrgf.argument = STRIP(tmp)     /* get rid of leading & trailing blanks */
atrgf.argument.upp = TRANSLATE(atrgf.argument)    /* get arguments in uppercase    */


SAY

x1 = SUBSTR(atrgf.argument.upp, 1, 2)
IF x1 = "/W" THEN                       /* start an own window ?*/
DO
   a1 = 3
   IF SUBSTR(atrgf.argument.upp,3,1) = ' ' THEN /* find first non-blank */
      a1 = VERIFY(atrgf.argument.upp,' ',,3)

   atrgf.argument = SUBSTR(atrgf.argument, a1)
   '@START /C /WIN /MIN  "ATRGF 'ARG(1)'" /PGM atrgf' atrgf.argument       /* start a new window */
   EXIT        /* end the program */
END

x1 = SUBSTR(atrgf.argument.upp, 1, 2)

IF x1 = "/T" THEN               /* Test mode ? */
DO
   a1 = 3
   atrgf.test = 1
   IF SUBSTR(atrgf.argument.upp,3,1) = ' ' THEN /* find first non-blank */
      a1 = VERIFY(atrgf.argument.upp,' ',,3)
   atrgf.argument.upp = SUBSTR(atrgf.argument.upp, a1)
   atrgf.argument = SUBSTR(atrgf.argument, a1)
END
ELSE
   atrgf.test = 0

word1 = WORD(atrgf.argument.upp, 1)

PARSE VAR word1 hours ':' minutes
time_in_hand = (DATATYPE(hours,'N'))    /* First argument a time-argument? */

IF time_in_hand THEN
   atrgf.tim =  check_time(word1)            /* check time & get 24hourformat */
ELSE
DO /* no time given, therefore interval, starting immediately */
   IF POS("/I:", word1) = 0 THEN
   DO
      errmsg = "wrong syntax; '/I:' expected."
      SIGNAL error
   END
END

/* prepare initialization data */
/* get current date and time */
PARSE VALUE DATE("S") TIME("L") WITH atrgf.start.dat atrgf.start.tim
atrgf.last.dat = atrgf.start.dat
atrgf.last.tim = atrgf.start.tim

word2 = WORD(atrgf.argument.upp,2)     /* get parameter, if any */

SELECT
   WHEN (POS("/I:", word2) > 0) | \time_in_hand THEN    /* Interval ? */
        DO
           atrgf.type = 1
           PARSE VAR atrgf.argument.upp . "/I:" atrgf.interval .
           PARSE VAR atrgf.argument . "/" . atrgf.command
           atrgf.interval = check_time(atrgf.interval)

           /* decimal fraction of interval */
           atrgf.interval.fract = DATERGF(atrgf.interval, "F")

           IF atrgf.tim = '' THEN         /* no start time given = start immediately */
           DO
               tmp = DATERGF(atrgf.start.dat atrgf.start.tim, "+", atrgf.interval.fract)
               atrgf.next.dat = WORD(tmp, 1)

               IF WORDS(tmp) > 1 THEN atrgf.next.tim = SUBSTR(WORD(tmp, 2),1,5)
               ELSE atrgf.next.tim = "00:00"
           END
           ELSE      /* starting time is given */
           DO
               IF atrgf.start.tim > atrgf.tim THEN /* start tomorrow, as it is already later than specified time */
               DO
                  atrgf.next.dat = DATERGF(atrgf.start.dat, "+", 1)
                  atrgf.next.tim = atrgf.tim
               END
               ELSE     /* start today at specified time */
               DO
                  atrgf.next.dat = atrgf.start.dat
                  atrgf.next.tim = atrgf.tim
               END
           END

           CALL schedule_it
        END

   WHEN (POS("/NE:", word2) > 0) THEN   /* start on next date_or_day ? */
        DO
           atrgf.type = 2
           PARSE VAR atrgf.argument.upp . "/NE:" dayordate .
           PARSE VAR atrgf.argument . "/" . atrgf.command

           IF DATATYPE(dayordate, 'N') THEN     /* numeric */
              IF dayordate < 1 OR dayordate > 31 THEN
              DO
                  errmsg = dayordate": invalid day-number for date"
                  SIGNAL ERROR
              END
              ELSE
              DO
                   atrgf.next_date = dayordate % 1    /* get rid of leading 0 */
                   atrgf.next_date_string = atrgf.next_date /* string to show */
                   atrgf.next_date_no = 1             /* no. of dates */
                   atrgf.next.dat = next_date(atrgf.next_date_no, atrgf.last.dat)
              END
           ELSE         /* weekday given */
           DO
               dayindex = WORDPOS(dayordate, atrgf.daynames)
               IF dayindex = 0 THEN
               DO
                  errmsg = dayordate": invalid dayname"
                  SIGNAL ERROR
               END
               atrgf.next_day = dayindex
               atrgf.next_day_string = dayordate     /* string to show */
               atrgf.next_day_no = 1                 /* no. of days */
               atrgf.next.dat = next_day(atrgf.next_day_no, atrgf.last.dat)
           END

           atrgf.next.tim = atrgf.tim

           CALL schedule_it
           CALL show_duration
        END

   WHEN (POS("/E:", word2) > 0) THEN    /* start on every date_or_day ? */
        DO
           atrgf.type = 3
           PARSE VAR atrgf.argument.upp . "/E:" dayordate .
           PARSE VAR atrgf.argument . "/" . atrgf.command

           /* Parse days or dates to execute command */
           DO WHILE dayordate <> ''
              PARSE VAR dayordate tmp1 ',' dayordate
              PARSE VAR tmp1 day_start '-' day_end

              /* day or date ? */
              IF DATATYPE(day_start, 'N') THEN     /* numeric */
              DO
                 IF day_start < 1 | day_start > 31 THEN
                 DO
                     errmsg = day_start": invalid date"
                     SIGNAL ERROR
                 END
                 data_type = 1          /* date */
              END
              ELSE      /* weekday in hand */
              DO
                 IF WORDPOS(day_start, atrgf.daynames) = 0 THEN
                 DO
                    errmsg = day_start": invalid dayname"
                    SIGNAL ERROR
                 END
                 data_type = 2          /* day */
              END

              IF day_end = '' THEN      /* no interval */
              DO
                 IF data_type = 1 THEN  /* date in hand */
                 DO
                    tmp = day_start % 1         /* get rid of possible leading 0 */
                    atrgf.tmp = 'x'             /* next invocation */
                 END
                 ELSE                  /* dayname in hand */
                 DO
                    tmp = WORDPOS(day_start, atrgf.daynames)
                    atrgf.tmp = 'x'                  /* next invocation on dayname */
                 END
              END
              ELSE           /* interval in hand */
              DO
                 IF data_type = 1 THEN       /* first token was a date: 1-31 */
                 DO
                    IF \DATATYPE(day_end, 'N') | day_end < 1 | day_end > 31 THEN
                       DO
                           errmsg = day_start'-'day_end": invalid date"
                           SIGNAL ERROR
                       END

                    IF day_end < day_start THEN         /* wrap around end of month ? */
                    DO

                       day_start = day_start % 1            /* get rid of leading 0 */
                       DO WHILE day_start < 32
                          atrgf.day_start = 'x'           /* next invocation */
                          day_start = day_start + 1
                       END
                       day_start = 1
                    END

                    day_start = day_start % 1      /* get rid of leading 0 */
                    DO WHILE day_start <= day_end
                       atrgf.day_start = 'x'       /* next invocation */
                       day_start = day_start + 1
                    END
                 END
                 ELSE                /* first token was a day: MO-SU */
                 DO
                    dayindex_end = WORDPOS(day_end, atrgf.daynames)
                    IF dayindex_end = 0 THEN
                    DO
                       errmsg = day_start'-'day_end": invalid dayname"
                       SIGNAL ERROR
                    END
                    dayindex_start = WORDPOS(day_start, atrgf.daynames)

                    IF dayindex_end < dayindex_start THEN    /* wrap around end of week ? */
                    DO
                       DO WHILE dayindex_start < 8
                          tmp = WORD(atrgf.daynames, dayindex_start)
                          atrgf.tmp = 'x'    /* next invocation */
                          dayindex_start = dayindex_start + 1
                       END
                       dayindex_start = 1
                    END

                    DO WHILE dayindex_start <= dayindex_end
                       tmp = WORD(atrgf.daynames, dayindex_start)
                       atrgf.tmp = 'x'       /* next invocation */
                       dayindex_start = dayindex_start + 1
                    END
                 END
              END
           END

           /* prepare ordered demo-values and invocation string */
           /* prepare ordered invocation days */
           atrgf.next_day_no = 0
           DO i = 1 TO 7
              tmp = WORD(atrgf.daynames, i)
              IF atrgf.tmp <> '' THEN
              DO
                 IF atrgf.next_day <> '' THEN
                 DO
                    atrgf.next_day = atrgf.next_day i
                    atrgf.next_day_string = atrgf.next_day_string', 'tmp
                 END
                 ELSE   /* first day-element */
                 DO
                    atrgf.next_day = i
                    atrgf.next_day_string = tmp      /* string to show */
                 END
                 atrgf.next_day_no = atrgf.next_day_no + 1
              END
           END
           IF atrgf.next_day_no = 0 THEN atrgf.next_day_no = ''

           /* prepare ordered invocation dates */
           atrgf.next_date_no = 0
           DO i = 1 TO 31
              IF atrgf.i <> '' THEN
              DO
                 IF atrgf.next_date <> '' THEN
                 DO
                    atrgf.next_date = atrgf.next_date i
                    IF (value_inhand + 1) = i THEN
                    DO
                        value_inhand = i
                    END
                    ELSE
                    DO
                       IF value_last_used <> value_inhand THEN
                       DO
                          atrgf.next_date_string = atrgf.next_date_string||'-'||value_inhand||', '||i
                          value_inhand = i
                          value_last_used = i
                       END
                       ELSE
                       DO
                          atrgf.next_date_string = atrgf.next_date_string||', '||i
                          value_inhand = i
                          value_last_used = i
                       END
                    END
                 END
                 ELSE   /* first date-element */
                 DO
                    atrgf.next_date = i
                    atrgf.next_date_string = i       /* string to show */
                    value_inhand = i
                    value_last_used = i
                 END
                 atrgf.next_date_no = atrgf.next_date_no + 1
              END
           END

           IF atrgf.next_date_no = 0 THEN atrgf.next_date_no = ''
           ELSE
              IF value_last_used <> value_inhand THEN     /* interval left ? */
              DO
                 atrgf.next_date_string = atrgf.next_date_string||'-'||value_inhand
                 value_inhand = 0
              END

           CALL schedule_it

        END

   OTHERWISE                            /* start once on given time ? */
        DO
           atrgf.type = 4
           PARSE VAR atrgf.argument . atrgf.command

           CALL schedule_it
           CALL show_duration
        END
END

RETURN
/* end of main routine ********************************************************/



/* parse & check time, return 24hour clock */
CHECK_TIME: PROCEDURE
    PARSE UPPER ARG tmp
    time24 = 1                  /* starting with 24 hour time in mind */
    time12 = POS('M', tmp)      /* AM or PM ? */
    IF time12 > 0 THEN
    DO
      time24 = 0                /* 12 hour time in hand */
      letter = SUBSTR(tmp, time12 - 1, 1)
      IF \((letter = 'A') | letter = 'P') THEN
      DO
         errmsg = ARG(1)': not a valid AM/PM-time'
         SIGNAL error
      END
      tmp = SUBSTR(tmp, 1, time12 - 2)  /* remove ?M */
    END

    PARSE VAR tmp hours ':' minutes ':' seconds

    SELECT
      WHEN hours = '' THEN hours = 0
      WHEN \datatype(hours,'N') THEN     /* no numeric type */
           DO
              errmsg = ARG(1)": hours are not numeric"
              SIGNAL error
           END
      WHEN (hours < 0) | (hours > 23) THEN      /* out of range    */
           DO
              errmsg = ARG(1)": hours out of range"
              SIGNAL error
           END
      OTHERWISE NOP
    END

    SELECT
      WHEN minutes = '' THEN minutes = 0
      WHEN \datatype(minutes,'N') THEN     /* no numeric type */
           DO
              errmsg = ARG(1)": minutes are not numeric"
              SIGNAL error
           END
      WHEN (minutes < 0) | (minutes > 59) THEN /* out of range    */
           DO
              errmsg = ARG(1)": minutes out of range"
              SIGNAL error
           END
      OTHERWISE NOP
    END

    /* ignore seconds, if any */

    IF \time24 THEN             /* received a 12hour time, adjust it to 24hour time */
    DO
       IF (letter = 'A') & (hours = 12) THEN hours = 0
       ELSE IF ((letter = 'P') & (hours < 12)) THEN hours = hours + 12
    END
    RETURN RIGHT(hours,2,'0')':'RIGHT(minutes,2,'0')
/* end of CHECK_TIME **********************************************************/



/* produce next date for /NE: or /E: flags */
NEXT_DATE:
    date_index = ARG(1)         /* index for date-string */
    last_dat = ARG(2)           /* last date to look-up */
    date_index = date_index + 1
    IF date_index > atrgf.next_date_no THEN
       date_index = 1

    next_dat_to_produce = WORD(atrgf.next_date, date_index)

    digits = SUBSTR(last_dat, 7, 2)
    eom = SUBSTR(DATERGF(last_dat, "ME"), 7, 2)

    /* already last date of month in hand ? If so, next month must be chosen */
    IF digits = eom THEN digits = 99    /* already last date of month in hand ?*/

    /* next date within same month ? */
    IF digits < next_dat_to_produce THEN
    DO
        /* already last date in month ? */
        IF next_dat_to_produce < eom THEN       /* o.k. for producing new date */
           result = SUBSTR(last_dat, 1, 6) || RIGHT(next_dat_to_produce,2,'0')
        ELSE                                    /* date is last day of month */
           result = SUBSTR(last_dat, 1, 6) || eom
    END
    ELSE      /* date of following month */
    DO
       tmp = DATERGF(last_dat, "ME", "1")       /* first date of next month */
       last_day = DATERGF(tmp, "ME")            /* end of next month */
       IF next_dat_to_produce < SUBSTR(last_day, 7, 2) THEN
            result = SUBSTR(tmp, 1, 6) || RIGHT(next_dat_to_produce,2,'0')
       ELSE result = last_day
    END

    RETURN result               /* return next date and actual date_index */
/* end of NEXT_DATE ***********************************************************/



/* produce next day for /NE: or /E: flags */
NEXT_DAY:
    day_index = ARG(1)          /* index for date-string */
    last_dat = ARG(2)
    day_index = day_index + 1

    IF day_index > atrgf.next_day_no THEN
       day_index = 1

    next_day_to_produce = WORD(atrgf.next_day, day_index)

    IF DATERGF(last_dat, "DI") < next_day_to_produce THEN
       result = DATERGF(last_dat, "WB", next_day_to_produce-1)
    ELSE
       result = DATERGF(last_dat, "WE", next_day_to_produce)

    RETURN result               /* return next date and actual day_index */
/* end of NEXT_DAY ************************************************************/




/* show-duration, if execution just took place once */
SHOW_DURATION: PROCEDURE EXPOSE atrgf.
    SAY
    IF atrgf.test = 0 THEN
    DO
       SAY " execution started:" RIGHT(DATERGF(atrgf.last.dat, "DN")||',',12) DATE2STR(atrgf.last.dat, atrgf.format_date) SUBSTR(atrgf.last.tim,1,5)

       tmp = "   execution ended:"
       IF atrgf.last.dat <> atrgf.ended.dat THEN
          tmp = tmp RIGHT(DATERGF(atrgf.ended.dat, "DN")||',',12) DATE2STR(atrgf.ended.dat, atrgf.format_date)
       ELSE
          tmp = tmp RIGHT('',12) RIGHT('', LENGTH(DATE2STR(atrgf.ended.dat, atrgf.format_date)))

       SAY tmp  SUBSTR(atrgf.ended.tim,1,5) "(duration:" atrgf.ended.duration")"
    END
    ELSE
    DO
       x = RIGHT('',12) 'ATRGF: *** Test mode ***'
       tmp = " execution started:"
       SAY tmp x
       tmp = "   execution ended:"
       SAY tmp x
    END
    RETURN
/* end of SHOW_DURATION ******************************************************/




/* format elapsed seconds into time DURATION */
DURATION: PROCEDURE

    fraction = DATERGF(ARG(1), "SECR")

    IF fraction >= 1 THEN tmp = fraction % 1 "day(s)" DATERGF(DATERGF(ARG(1), "SECR"), "FR")
    ELSE tmp = DATERGF(DATERGF(ARG(1), "SECR"), "FR")

    RETURN tmp
/* end of duration ************************************************************/




/* calculate waiting time, before executing command */
SCHEDULE_IT: PROCEDURE EXPOSE atrgf.
    SELECT
       WHEN atrgf.type = 1 THEN      /* interval */
            DO FOREVER
               IF atrgf.test = 0 THEN
                  atrgf.to_wait_sec = DATERGF(atrgf.next.dat atrgf.next.tim, "-S", DATE("S") TIME("L"))
               ELSE
                  atrgf.to_wait_sec = DATERGF(atrgf.next.dat atrgf.next.tim, "-S", atrgf.last.dat atrgf.last.tim)

               nul = TIME("R")       /* reset timer */

               /* increment next execution until seconds to wait become positive */
               DO WHILE atrgf.to_wait_sec < 0 & atrgf.test = 0
                  tmp = DATERGF(atrgf.next.dat atrgf.next.tim, "+", atrgf.interval.fract)
                  atrgf.next.dat = WORD(tmp, 1)       /* get next date */

                  IF WORDS(tmp) > 1 THEN atrgf.next.tim = SUBSTR(WORD(tmp, 2),1,5) /* get next time */
                  ELSE atrgf.next.tim = "00:00"

                  atrgf.to_wait_sec = DATERGF(atrgf.next.dat atrgf.next.tim, "-S", DATE("S") TIME("L"))
                  nul = TIME("R")       /* reset timer */
               END

               atrgf.to_wait_sec = DATERGF(atrgf.to_wait_sec,"SEC")
               CALL show_sleep_execute

               tmp = DATERGF(atrgf.last.dat atrgf.last.tim, "+", atrgf.interval.fract)
               atrgf.next.dat = WORD(tmp, 1)    /* get date */

               IF WORDS(tmp) > 1 THEN atrgf.next.tim = SUBSTR(WORD(tmp, 2),1,5)  /* get next time */
               ELSE atrgf.next.tim = "00:00"
            END

       WHEN atrgf.type = 2 THEN      /* Next day or date */
            DO
               IF atrgf.test = 0 THEN
               DO
                  atrgf.to_wait_sec = DATERGF(DATERGF(atrgf.next.dat atrgf.next.tim, "-S", DATE("S") TIME("L")), "SEC")
               END
               ELSE
                  atrgf.to_wait_sec = DATERGF(DATERGF(atrgf.next.dat atrgf.next.tim, "-S", atrgf.last.dat atrgf.last.tim), "SEC")

               nul = TIME("R")
               CALL show_sleep_execute
            END

       WHEN atrgf.type = 3 THEN      /* every given day or date */
            DO
               dates_todo = atrgf.next_date_no > 0
               days_todo = atrgf.next_day_no > 0

               atrgf.next.tim = atrgf.tim       /* standard execution time */

               x1 = atrgf.last.dat

x1 = datergf(x1, "-", 1)        /* make sure, that invocation is possible on
                                   same day too */


               DO FOREVER
                  IF dates_todo THEN    /* find first date after present one */
                  DO
                     di = DATERGF(x1, "D")      /* get day-portion of date */

                     /* if already last day of month, set index to last element */
                     IF SUBSTR(DATERGF(x1, "ME"), 7,2) = di THEN
                        tmp = atrgf.next_date_no
                     ELSE
                     DO         /* search for next date to produce */
                        tmp = 1

                        DO FOREVER
                           tmp0 = WORD(atrgf.next_date, tmp)
                           IF tmp0 = '' | tmp0 > di THEN LEAVE
                           tmp = tmp + 1
                        END
                        tmp = tmp - 1
                     END

                     tmp1_date = next_date(tmp, x1)
                  END
                  ELSE tmp1_date = "99991231"

                  IF days_todo THEN     /* find first date after present one */
                  DO
                     di = DATERGF(x1, "DI")
                     tmp = 1

                     DO FOREVER
                        tmp0 = WORD(atrgf.next_day, tmp)
                        IF tmp0 = '' | tmp0 > di THEN LEAVE
                        tmp = tmp + 1
                     END
                     tmp = tmp - 1

                     tmp2_date = next_day(tmp, x1)
                  END
                  ELSE tmp2 = "99991231"

                  IF tmp1_date <= tmp2_date THEN        /* next to schedule: date */
                      atrgf.next.dat = tmp1_date
                  ELSE                                  /* next to schedule: day */
                      atrgf.next.dat = tmp2_date

                  IF atrgf.test = 0 THEN        /* do it for real ? */
                     atrgf.to_wait_sec = DATERGF(atrgf.next.dat atrgf.next.tim, "-S", DATE("S") TIME("L"))
                  ELSE                          /* test ATRGF, show next invocation */
                     atrgf.to_wait_sec = DATERGF(atrgf.next.dat atrgf.next.tim, "-S", atrgf.last.dat atrgf.last.tim)
                  nul = TIME("R")               /* reset timer */

                  IF atrgf.to_wait_sec < 0 THEN /* execution lasted longer than next scheduled date! */
                     x1 = atrgf.next.dat        /* get next date to execute */
                  ELSE
                  DO
                      atrgf.to_wait_sec = DATERGF(atrgf.to_wait_sec, "SEC")
                      CALL show_sleep_execute
                      x1 = atrgf.last.dat
                  END
               END

            END

       OTHERWISE                     /* today or the next day */
            DO
               atrgf.next.tim = atrgf.tim

               IF atrgf.next.tim <= atrgf.last.tim THEN /* execution on next day */
                  atrgf.next.dat = DATERGF(atrgf.start.dat, "+", 1)
               ELSE
                  atrgf.next.dat = atrgf.start.dat      /* execution on same day */

               atrgf.to_wait_sec = DATERGF(DATERGF(atrgf.next.dat atrgf.next.tim, "-S", DATE("S") TIME("L")), "SEC")
               nul = TIME("R")

               CALL show_sleep_execute
            END
    END
    RETURN
/* end of SCHEDULE_IT *********************************************************/




/* show time-table, sleep & execute passed command */
SHOW_SLEEP_EXECUTE: PROCEDURE EXPOSE atrgf.
/* define some colors to demonstrate them */
esc    = '1B'x          /* define ESCape character */
red    = esc||"[31m"    /* ANSI.SYS-control for red foreground */
yellow = esc||"[33m"    /* ANSI.SYS-control for yellow foreground */
cyan   = esc||"[36m"    /* ANSI.SYS-control for cyan foreground */
normal = esc||"[0m"     /* ANSI.SYS-control for resetting attributes to normal */

    SAY
    SAY "           started:" cyan||RIGHT(DATERGF(atrgf.start.dat, "DN")||',',12) DATE2STR(atrgf.start.dat, atrgf.format_date) atrgf.start.tim normal
    IF atrgf.start.dat <> atrgf.last.dat | atrgf.start.tim <> atrgf.last.tim THEN
    DO
       SAY
       SAY "    last execution:" yellow||RIGHT(DATERGF(atrgf.last.dat, "DN")||',',12) DATE2STR(atrgf.last.dat, atrgf.format_date) SUBSTR(atrgf.last.tim,1,5) normal

       IF atrgf.test = 0 THEN
       DO
          tmp = "   execution ended:"
          IF atrgf.last.dat <> atrgf.ended.dat THEN
             tmp2 = RIGHT(DATERGF(atrgf.ended.dat, "DN")||',',12) DATE2STR(atrgf.ended.dat, atrgf.format_date)
          ELSE
             tmp2 = RIGHT('',12) RIGHT('', LENGTH(DATE2STR(atrgf.ended.dat, atrgf.format_date)))

          tmp = tmp yellow||tmp2
          SAY tmp  SUBSTR(atrgf.ended.tim,1,5) normal"(duration:" yellow||atrgf.ended.duration||normal")"
       END
       ELSE
       DO
          x = RIGHT('',12) '*** Test mode ***'
          tmp = " execution started:"
          SAY tmp x
          tmp = "   execution ended:"
          SAY tmp x
       END
    END

    SAY
    SAY "    next execution:" cyan||RIGHT(DATERGF(atrgf.next.dat, "DN")||',',12) DATE2STR(atrgf.next.dat, atrgf.format_date) atrgf.next.tim normal

    tmp = duration(atrgf.to_wait_sec)

    SAY "      time to wait:" RIGHT("",12) cyan||tmp normal
    SAY

    tmp = red
    IF atrgf.type = 2 THEN           /* NEXT-date */
       tmp = tmp || RIGHT("on next",12)
    ELSE                             /* EVERY-date */
       tmp = tmp || RIGHT("on EVERY",12)

    IF atrgf.next_date_no > 0 THEN
    DO
       SAY " execution date(s):" tmp yellow || atrgf.next_date_string normal
    END

    IF atrgf.next_day_no > 0 THEN
    DO
       SAY "  execution day(s):" tmp yellow || atrgf.next_day_string normal
    END

    IF atrgf.interval <> '' THEN
       SAY "execution interval:" red || RIGHT("EVERY",12) || yellow  atrgf.interval normal

    IF atrgf.executions > 0 THEN
       SAY " executions so far:" yellow || atrgf.executions normal"time(s)"

    SAY
    SAY "command to execute:" cyan || atrgf.command normal
    SAY

    IF atrgf.test > 0 THEN      /* testing mode */
    DO
       IF atrgf.type = 1 | atrgf.type = 3 THEN
       DO
          SAY '             ATRGF: *** Test mode ***'
          SAY '                    Hit return to get next invocation date'
          SAY '                    OR '
          SAY '                    Enter EXIT to end testing mode'
          PULL x
          /* looping mode? If so, exit from here */
          IF x = 'EXIT' & (atrgf.type = 1 | atrgf.type = 3) THEN EXIT
       END

       atrgf.last.dat = atrgf.next.dat
       atrgf.last.tim = atrgf.next.tim
    END
    ELSE
    DO
       x = atrgf.to_wait_sec - TIME("R")  /* deduct time needed to arrive at this position */
       if x < 0 THEN x = 0
       x = (x + 0.5) % 1                /* result must be an integer */
       CALL SysSleep x                  /* seconds to sleep */

       SAY

       PARSE VALUE DATE("S") TIME("L") TIME("R") WITH atrgf.last.dat atrgf.last.tim .
       'CALL 'atrgf.command             /* execute command */
    END

    /* get actual date, time and elapsed time */
    PARSE VALUE DATE("S") TIME("L") TIME("R") WITH atrgf.ended.dat atrgf.ended.tim tmp
    atrgf.ended.duration = duration(tmp)
    atrgf.executions = atrgf.executions + 1
    RETURN
/* end of SHOW_SLEEP_EXECUTE *************************************************/




USAGE:
/* get ANSI-color-sequences from ScrColor.CMD */
PARSE VALUE ScrColor() WITH screen_normal screen_inverse text_normal text_info text_highlight text_alarm .


SAY
SAY text_info'ATRGF:'screen_normal'   execute command at specified time'
SAY
SAY
SAY text_alarm'usage:'text_highlight'   ATRGF [/W] [/T] time command'
SAY '         ATRGF [/W] [/T] time /NE:dayordate command'
SAY '         ATRGF [/W] [/T] time /E:dayordate command'
SAY '         ATRGF [/W] [/T] [time] /I:time command'screen_normal
SAY
SAY '         see enclosed Tutorial "RGFSHOW.CMD" and syntax below'
SAY
SAY text_alarm'syntax:'
SAY text_info'   COMMAND'screen_normal' ..... any command as entetext_alarm thru the keyboard to start'
SAY '                 a program'
SAY text_info'   TIME'screen_normal' ........ on input 24hour- (military) or 12hour-format allowed,'
SAY '                 output will be allways in 24hour-format (military, computer)'
SAY text_info'   DAYORDATE'screen_normal' ... 'text_info'DAY[-DAY]|DATE[-DATE][,...]'
SAY '                 DAY'screen_normal' .... 2 letter digit ('text_info'MO'screen_normal', 'text_info'TU'screen_normal',',
    text_info'WE'screen_normal', 'text_info'TH'screen_normal', 'text_info'FR'screen_normal', 'text_info'SA'screen_normal','text_info'SU'screen_normal')'

SAY text_info'                 DATE'screen_normal' ... 1-2 digits ('text_info'1-31'screen_normal')'
SAY '                 more than one day or date must be delimited by a comma'
SAY
SAY text_info'   flags:'
SAY '   /W'screen_normal'  ......... execute ATRGF.CMD in a separate 'text_info'W'screen_normal'indow'
SAY text_info'   /T'screen_normal'  ......... 'text_info'T'screen_normal'est mode'
SAY text_info'   /NE:'screen_normal' ........ 'text_info'ne'screen_normal'xt dayordate'
SAY text_info'   /E:'screen_normal'  ........ 'text_info'e'screen_normal'very dayordate'
SAY text_info'   /I:'screen_normal'  ........ every time-'text_info'i'screen_normal'nterval'
SAY
SAY text_alarm'examples:'
SAY
SAY text_highlight'    ATRGF 00:00 copy *.* a:'screen_normal
SAY '          ... copy all files at midnight to drive A:'
SAY
SAY text_highlight'    ATRGF 17:00 "beep & @echo Hey, time to go home! & PAUSE"'screen_normal
SAY '          ... at 5:00pm beep, show message and wait for keystroke'
SAY
SAY text_highlight'    ATRGF 20:30 /NE:FR back_it_up'screen_normal
SAY '          ... call "BACK_IT_UP" at 8:30pm on 'text_info'ne'screen_normal'xt friday'
SAY
SAY text_highlight'    ATRGF 20:30 /NE:31 back_it_up'screen_normal
SAY '          ... call "BACK_IT_UP" at 8:30pm on the 'text_info'ne'screen_normal'xt last day of month'
SAY
SAY text_highlight'    ATRGF 20:30 /E:1-31 back_it_up'screen_normal
SAY '          ... call "BACK_IT_UP" at 8:30pm on 'text_info'e'screen_normal'very day'
SAY
SAY text_highlight'    ATRGF 20:30 /E:FR,1,15,31 back_it_up'screen_normal
SAY '          ... call "BACK_IT_UP" at 8:30pm on 'text_info'e'screen_normal'very friday, on every'
SAY '              first, 15th and last day in a month'
SAY
SAY text_highlight'    ATRGF 17:00 /E:MO-FR "beep & @echo Hey, time to go home! & PAUSE"'screen_normal
SAY '          ... at 5:00pm beep, show message and wait for keystroke mondays'
SAY '              thru fridays (executing command forever on given DAYORDATE)'
SAY
SAY text_highlight'    ATRGF 00:00 /I:00:05 MOVE_IT.CMD -v'screen_normal
SAY '          ... starting at midnight, execute every 5 minutes ('text_info'i'screen_normal'nterval)'
SAY '              "move_it.cmd" with the parameter "-v"'
SAY
SAY text_highlight'    ATRGF /I:00:05 MOVE_IT.CMD -v'screen_normal
SAY '          ... call every 5 minutes ('text_info'i'screen_normal'nterval) "move_it.cmd" with'
SAY '              the parameter "-v"'
SAY
SAY text_highlight'    ATRGF /W 20:30 /E:FR-MO,15,31-1 back_it_up'screen_normal
SAY '          ... call "BACK_IT_UP" at 8:30pm on 'text_info'e'screen_normal'very friday, saturday,'
SAY '              sunday, monday, on 'text_info'e'screen_normal'very, first, 15th and last day in a month,'
SAY '              execute in a separate 'text_info'w'screen_normal'indow'
SAY
SAY text_highlight'    ATRGF /T 20:30 /E:FR-MO,15,31-1 back_it_up'screen_normal
SAY '          ... 'text_info't'screen_normal'esting of command; show invocation dates'
SAY
SAY text_highlight'    ATRGF /W /T 20:30 /E:FR-MO,15,31-1 back_it_up'screen_normal
SAY '          ... 'text_info't'screen_normal'esting of command; show invocation dates; use a separate'
SAY '              'text_info'w'screen_normal'indow for it'
SAY
EXIT
/***************************************************/

ERROR:
   /* error message on device "STDERR" */
   '@ECHO ATRGF: 'errmsg' >&2'
   EXIT (-1)

HALT:
    SAY
    SAY "User interrupted program."
    EXIT
