;This is a collection of procedures for loading SFF and SFS files. For details,
;see documentation. Most interface information, however, is imbedded in this
;file. The registers to pass pointers to are listed for each procedure. These
;procedures are all near procedures. 

TEXT SEGMENT BYTE PUBLIC
ASSUME CS:TEXT

false equ 0
true equ 1
lines200 equ 0; for screen lines
lines350 equ 1
lines400 equ 2

vseg dw 0b800h ; video segment
linesperchar db 13 ; points - 1
vga db false
ega db false
vedone db false ; is video system initialized

fontheader db '@JLSFF',1 ; header for a font file

cmpegafalse proc near ; checks if DETEGA has been called before using EGA 
                      ; variable
cmp byte ptr vedone,false
jne cef
call detega
cef:
cmp byte ptr ega,false
ret
cmpegafalse endp

cmpvgafalse proc near
cmp byte ptr vedone,false
jne cvf
call detega
cvf:
cmp byte ptr vga,false
ret
cmpvgafalse endp

PUBLIC SEQUENCEFONTS
; Sequencefonts will set up the fonts so that you can load the bit images into
; segment 0A000h. Each character occupies 32 bytes, so character 0 would be
; at A000h:0h, character 1 would be at A000h:0020h, etc. this procedure need
; not be called by programmers in most cases, but if it is, KEEP IT ON AS 
; LITTLE TIME AS POSSIBLE. DESEQUENCE FONTS AS SOON AS POSSIBLE TO KEEP THE
; SCREEN FROM LOOKING "SCREWED UP."
sequencefonts proc near 
call cmpegafalse
je nosequence
push ax
push dx
mov ax,0704h
mov dx,03c4h
out dx,ax
mov dx,03ceh
mov ax,0204h
out dx,ax
mov ax,5
out dx,ax
mov ax,0406h
out dx,ax
mov ax,0402h
mov dx,03c4h
out dx,ax
pop dx
pop ax
nosequence:
ret
sequencefonts endp

PUBLIC DESEQUENCEFONTS
;This will normalize the video system from SEQUENCE FONTS.
desequencefonts proc near
call cmpegafalse
je nodesequence
push ax
push dx
mov dx,03c4h
mov ax,0302h
out dx,ax
mov ax,0304h
out dx,ax
mov dx,03ceh
mov ax,4
out dx,ax
mov ax,01005h
out dx,ax
mov ax,0e06h
cmp vseg,0b000h
jne d1
mov ax,0606h
d1:
out dx,ax
pop dx
pop ax
nodesequence:
ret
desequencefonts endp

PUBLIC SETSCANLINES
;SETSCANLINES sets the scanlines on a VGA monitor. Set AL.
setscanlines proc near ; number of scanlines as parameter
 ; IN AL REGISTER
 ; 0=200 lines  1 = 350 lines  2 = 400 lines
jmp ssl
scnlns db 0
ssl:
push ax
push bx
push cx
mov scnlns,al
cmp al,2
ja nossl
call cmpvgafalse
je nossl
mov al,scnlns
mov ah,012h
mov bx,030h
int 010h
mov ax,083h   ; set mode with no video memory clearing
cmp vseg,0b000h
jne s1
mov ax,087h
s1:
int 010h
mov cx,0c0dh
mov al,scnlns
cmp al,0
jne s2
mov cx,0708h
s2:
mov ax,0100h
int 010h
nossl:
pop cx
pop bx
pop ax
ret
setscanlines endp

; Sets character points according to linesperchar
setlinesperchar proc near
call cmpegafalse
je noslpc
push ax
push bx
push cx
push dx
mov ax,01100h
mov bh,linesperchar
inc bh
xor bl,bl
xor cx,cx
xor dx,dx
int 010h
pop dx
pop cx
pop bx
pop ax
noslpc:
ret
setlinesperchar endp

comparestrings proc near ; compares DS:SI & ES:DI and increments SI & DI
 ; does for CX bytes sets carry flag
cstr:
repe cmpsb
ret
comparestrings endp

PUBLIC READFONT
; READS font in memory. Set DS:SI to buffer
readfont proc near ; FAR pointer to DS:SI
call cmpegafalse
jne rf1
jmp norf
numberofentries db 0
i dw 0
j dw 0
k dw 0
begchar dw 0
endchar dw 0
rf1:
mov di,seg fontheader
mov es,di
mov di,offset fontheader
mov cx,7
call comparestrings
je goon1
jmp norf
goon1:
xor ax,ax
lodsb
push ax
call setscanlines
pop ax
lodsb
mov linesperchar,al
cmp al,16
jb goon2
jmp norf
goon2:
call setlinesperchar
lodsb
mov numberofentries,al
mov i,0
f2:
lodsb
xor ah,ah
mov begchar,ax
lodsb
mov endchar,ax

mov ax,begchar
mov j,ax
f1:
call sequencefonts
mov di,0a000h
mov es,di
mov bx,j
mov di,bx
mov cl,5
shl di,cl
mov cl,linesperchar
inc cl
xor ch,ch
shr cl,1
rep movsw
call desequencefonts
inc j
mov ax,endchar
cmp j,ax
jbe f1
inc i
mov al,numberofentries
xor ah,ah
cmp i,ax
jbe f2
norf:
ret
readfont endp

PUBLIC READSCREEN
; Reads screen or block of one from a memory location in DS:SI
readscreen proc near ; FAR pointer must be passed in DS:SI
jmp rs1
xy db 0 
x1 db 1
y1 db 1
x2 db 80
y2 db 25
rs1:
lodsb
mov x1,al
lodsb
mov y1,al
lodsb
mov x2,al
lodsb
mov y2,al
mov al,y1
mov xy,al
r1:
mov cl,x2
inc cl
mov ch,x1
sub cl,ch
xor ch,ch
shl cx,1
mov ax,0b800h
mov es,ax
mov al,xy
dec al
mov ah,0
mov bl,80
mul bl
mov bl,x1
dec bl
xor bh,bh
add bx,ax
shl bx,1
mov di,bx
r2:
lodsb
stosb
loop r2
inc xy
mov al,y2
cmp xy,al
jbe r1
ret 
readscreen endp

EGAGrfx proc near ; index in al , value in ah
push dx
mov dx,03ceh
out dx,al
inc dx
mov al,ah
out dx,al
pop dx
ret
EGAgrfx endp

detEGA proc near ; sets EGA, VGA, and VSEG variables
mov vedone,true
jmp dega
testmask db 1
BIOSbyte db 0
dega:
xor ax,ax
mov es,ax
mov vseg,0b800h
mov bx,0410h
mov al,es:[bx]
and al,48
cmp al,48
jne deg2
mov vseg,0b000h
deg2:
mov bx,0487h
mov al,es:[bx]
mov biosbyte,al
mov ah,012h
mov bx,0ff10h
int 010h
mov al,biosbyte
and al,060h
mov cl,5
shr al,cl
cmp bl,al
je degcont
cmp bh,0ffh
jne degcont
mov ega,false
jmp degend
degcont:
mov ah,testmask
mov al,8
call EGAGrfx
mov dx,03ceh
mov al,8
out dx,al
mov vga,false
mov dx,03cfh
in al,dx
cmp al,testmask
jne eg1
mov vga,true
eg1:
mov ax,0ff08h
call egagrfx
mov EGA,true
degend:
ret
detega endp

PUBLIC SAVEFONTS
; Saves the state of the fonts
savefonts proc near ; pass on FAR pointer 8192 bytes, ES:DI
call sequencefonts
mov si,0a000h
mov ds,si
xor si,si
mov cx,4096
rep movsw
call desequencefonts
ret
savefonts endp

PUBLIC RESTOREFONTS
; Retrieves the state of the fonts
restorefonts proc near ; pass on FAR pointer - 8192 bytes DS:SI
call sequencefonts
mov di,0a000h
mov es,di
xor di,di
mov cx,4096
rep movsw
call desequencefonts
ret
restorefonts endp

PUBLIC RESETFONTS
; Makes a mode set and resets the scanlines if VGA
resetfonts proc near
push ax
mov ax,083h
int 010h
mov al,2
push ax
call setscanlines
pop ax
pop ax
ret
resetfonts endp 

TEXT ENDS
END
